/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aas.api.communications;

import org.apache.commons.validator.routines.UrlValidator;
import org.eclipse.aas.api.communications.ProtocolKind;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Endpoint {
    private static final Logger logger = LoggerFactory.getLogger(Endpoint.class);
    private String name;
    private ProtocolKind protocol;
    private String address;

    public Endpoint(String name, ProtocolKind protocol, String address) {
        this.name = name;
        this.protocol = protocol;
        String[] schemes = new String[]{"http", "https", "opc.tcp"};
        UrlValidator urlValidator = new UrlValidator(schemes);
        if (urlValidator.isValid(address)) {
            this.address = address;
            logger.info("Endpoint initialised.");
        } else {
            System.err.println("Probable URL-Schema Error Detected. Please check!");
        }
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public ProtocolKind getProtocol() {
        return this.protocol;
    }

    public void setProtocol(ProtocolKind protocol) {
        this.protocol = protocol;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

