/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.iotml.software.artefact.util;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.papyrus.iotml.software.artefact.ArtefactPackage;
import org.eclipse.papyrus.iotml.software.artefact.DigitalArtefact;
import org.eclipse.papyrus.iotml.software.artefact.PropertyAccess;
import org.eclipse.papyrus.iotml.software.artefact.ProvideResource;
import org.eclipse.papyrus.iotml.software.artefact.ProvideService;
import org.eclipse.papyrus.iotml.software.artefact.Service;
import org.eclipse.papyrus.iotml.software.artefact.ServiceDescription;
import org.eclipse.papyrus.iotml.software.artefact.VirtualEntity;

public class ArtefactValidator
extends EObjectValidator {
    public static final ArtefactValidator INSTANCE = new ArtefactValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.papyrus.iotml.software.artefact";
    public static final int PROPERTY_ACCESS__PROPERTY_ACCESS_C1 = 1;
    public static final int PROPERTY_ACCESS__PROPERTY_ACCESS_C2 = 2;
    public static final int PROPERTY_ACCESS__PROPERTY_ACCESS_C3 = 3;
    public static final int PROVIDE_SERVICE__PROVIDE_SERVICE_C2 = 4;
    public static final int PROVIDE_SERVICE__PROVIDE_SERVICE_C1 = 5;
    public static final int PROVIDE_RESOURCE__PROVIDE_RESOURCE_C1 = 6;
    public static final int PROVIDE_RESOURCE__PROVIDE_RESOURCE_C2 = 7;
    public static final int SERVICE__SERVICE_C1 = 8;
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 8;
    protected static final int DIAGNOSTIC_CODE_COUNT = 8;

    protected EPackage getEPackage() {
        return ArtefactPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validatePropertyAccess((PropertyAccess)value, diagnostics, context);
            }
            case 1: {
                return this.validateDigitalArtefact((DigitalArtefact)value, diagnostics, context);
            }
            case 2: {
                return this.validateVirtualEntity((VirtualEntity)value, diagnostics, context);
            }
            case 3: {
                return this.validateProvideService((ProvideService)value, diagnostics, context);
            }
            case 4: {
                return this.validateProvideResource((ProvideResource)value, diagnostics, context);
            }
            case 5: {
                return this.validateServiceDescription((ServiceDescription)value, diagnostics, context);
            }
            case 6: {
                return this.validateService((Service)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validatePropertyAccess(PropertyAccess propertyAccess, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(propertyAccess, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(propertyAccess, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(propertyAccess, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(propertyAccess, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(propertyAccess, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(propertyAccess, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(propertyAccess, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(propertyAccess, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(propertyAccess, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validatePropertyAccess_PropertyAccess_C1(propertyAccess, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validatePropertyAccess_PropertyAccess_C2(propertyAccess, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validatePropertyAccess_propertyAccess_C3(propertyAccess, diagnostics, context);
        }
        return result;
    }

    public boolean validatePropertyAccess_PropertyAccess_C1(PropertyAccess propertyAccess, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return propertyAccess.PropertyAccess_C1(diagnostics, context);
    }

    public boolean validatePropertyAccess_PropertyAccess_C2(PropertyAccess propertyAccess, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return propertyAccess.PropertyAccess_C2(diagnostics, context);
    }

    public boolean validatePropertyAccess_propertyAccess_C3(PropertyAccess propertyAccess, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return propertyAccess.propertyAccess_C3(diagnostics, context);
    }

    public boolean validateDigitalArtefact(DigitalArtefact digitalArtefact, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(digitalArtefact, diagnostics, context);
    }

    public boolean validateVirtualEntity(VirtualEntity virtualEntity, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(virtualEntity, diagnostics, context);
    }

    public boolean validateProvideService(ProvideService provideService, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(provideService, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(provideService, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(provideService, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(provideService, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(provideService, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(provideService, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(provideService, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(provideService, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(provideService, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateProvideService_ProvideService_C2(provideService, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateProvideService_ProvideService_C1(provideService, diagnostics, context);
        }
        return result;
    }

    public boolean validateProvideService_ProvideService_C2(ProvideService provideService, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return provideService.ProvideService_C2(diagnostics, context);
    }

    public boolean validateProvideService_ProvideService_C1(ProvideService provideService, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return provideService.ProvideService_C1(diagnostics, context);
    }

    public boolean validateProvideResource(ProvideResource provideResource, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(provideResource, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(provideResource, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(provideResource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(provideResource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(provideResource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(provideResource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(provideResource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(provideResource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(provideResource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateProvideResource_ProvideResource_C1(provideResource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateProvideResource_ProvideResource_C2(provideResource, diagnostics, context);
        }
        return result;
    }

    public boolean validateProvideResource_ProvideResource_C1(ProvideResource provideResource, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return provideResource.ProvideResource_C1(diagnostics, context);
    }

    public boolean validateProvideResource_ProvideResource_C2(ProvideResource provideResource, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return provideResource.ProvideResource_C2(diagnostics, context);
    }

    public boolean validateServiceDescription(ServiceDescription serviceDescription, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(serviceDescription, diagnostics, context);
    }

    public boolean validateService(Service service, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(service, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(service, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(service, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(service, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(service, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(service, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(service, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(service, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(service, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateService_Service_C1(service, diagnostics, context);
        }
        return result;
    }

    public boolean validateService_Service_C1(Service service, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return service.Service_C1(diagnostics, context);
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

