/*****************************************************************************
 * Copyright (c) 2017 CEA LIST and Others.
 *
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Nicolas FAUVERGUE (CEA LIST) nicolas.fauvergue@cea.fr - Initial API and implementation
 *  
 *****************************************************************************/

package org.eclipse.papyrus.interoperability.sysml14.sysml.wizard;

import org.eclipse.papyrus.interoperability.sysml14.sysml.messages.Messages;
import org.eclipse.papyrus.interoperability.sysml14.sysml.transformations.SysMLImportTransformationLauncher;
import org.eclipse.papyrus.uml.m2m.qvto.common.MigrationParameters.ThreadConfig;
import org.eclipse.papyrus.uml.m2m.qvto.common.transformation.AbstractImportTransformationLauncher;
import org.eclipse.papyrus.uml.m2m.qvto.common.wizard.AbstractTransformationWizard;
import org.eclipse.swt.widgets.Control;

/**
 * The wizard for the SysML Migration.
 */
public class TransformationSysMLWizard extends AbstractTransformationWizard {

	/**
	 * Constructor.
	 */
	public TransformationSysMLWizard() {
		super(Messages.TransformationSysMLWizard_WizardTitle, new TransformationSysMLDialogData());
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see org.eclipse.papyrus.migration.common.wizard.AbstractTransformationWizard#createTransformationLauncher(org.eclipse.papyrus.migration.common.MigrationParameters.Config, org.eclipse.swt.widgets.Control)
	 */
	@Override
	protected AbstractImportTransformationLauncher createTransformationLauncher(final ThreadConfig config, final Control baseControl) {
		return new SysMLImportTransformationLauncher(config, baseControl);
	}

}
