/*****************************************************************************
 * Copyright (c) 2017 CEA LIST and Others.
 *
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Nicolas FAUVERGUE (CEA LIST) nicolas.fauvergue@cea.fr - Initial API and implementation
 *  
 *****************************************************************************/

package org.eclipse.papyrus.interoperability.sysml14.sysml.transformations;

import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.uml.m2m.qvto.common.MigrationParameters.ThreadConfig;
import org.eclipse.papyrus.uml.m2m.qvto.common.transformation.AbstractImportTransformationLauncher;
import org.eclipse.papyrus.uml.m2m.qvto.common.transformation.IDependencyAnalysisHelper;
import org.eclipse.papyrus.uml.m2m.qvto.common.transformation.IImportTransformation;
import org.eclipse.swt.widgets.Control;

/**
 * The launcher of the SysML migration.
 */
public class SysMLImportTransformationLauncher extends AbstractImportTransformationLauncher {

	/**
	 * Constructor.
	 *
	 * @param config
	 *            The thread config.
	 */
	public SysMLImportTransformationLauncher(final ThreadConfig config) {
		super(config, null);
	}

	/**
	 * Constructor.
	 *
	 * @param config
	 *            The thread config.
	 * @param baseControl
	 *            The base control.
	 */
	public SysMLImportTransformationLauncher(final ThreadConfig config, final Control baseControl) {
		super(config, baseControl);
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see org.eclipse.papyrus.migration.common.transformation.AbstractImportTransformationLauncher#createDependencyAnalysisHelper(org.eclipse.papyrus.migration.common.MigrationParameters.ThreadConfig)
	 */
	@Override
	protected IDependencyAnalysisHelper createDependencyAnalysisHelper(final ThreadConfig config) {
		return null;
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see org.eclipse.papyrus.migration.common.transformation.AbstractImportTransformationLauncher#createTransformation(org.eclipse.emf.common.util.URI, org.eclipse.papyrus.migration.common.MigrationParameters.ThreadConfig,
	 *      org.eclipse.papyrus.migration.common.transformation.IDependencyAnalysisHelper)
	 */
	@Override
	protected IImportTransformation createTransformation(final URI transformationURI, final ThreadConfig config, final IDependencyAnalysisHelper analysisHelper) {
		return new SysMLImportTransformation(transformationURI, config, analysisHelper);
	}

}
