/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.interoperability.sysml14.sysml.blackboxes.notation;

import java.util.ArrayList;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Straight;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.m2m.qvt.oml.blackbox.java.Operation;
import org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.linklf.AbsoluteBendpointsConvention;

public class NotationBlackboxHelper {
    @Operation(kind=Operation.Kind.HELPER)
    public void removeFromOwnerView(View parentView, View eObjectToRemove) {
        if (parentView != null && eObjectToRemove instanceof View) {
            if (parentView.getChildren().contains((Object)eObjectToRemove)) {
                parentView.removeChild(eObjectToRemove);
            } else if (parentView instanceof Diagram && eObjectToRemove instanceof Edge && ((Diagram)parentView).getEdges().contains((Object)eObjectToRemove)) {
                ((Diagram)parentView).removeEdge((Edge)eObjectToRemove);
            }
        }
    }

    @Operation(kind=Operation.Kind.HELPER)
    public void createBendpointsForInformationFlow(Connector informationFlowEdge) {
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        Point point = new Point(0, 0);
        points.add(AbsoluteBendpointsConvention.getInstance().createAbsoluteBendpointStoredAsRelative(point));
        points.add(AbsoluteBendpointsConvention.getInstance().createAbsoluteBendpointStoredAsRelative(point));
        bendpoints.setPoints(points);
        informationFlowEdge.setBendpoints((Bendpoints)bendpoints);
    }

    @Operation(kind=Operation.Kind.HELPER)
    public void createBendpointsForAssociation(Connector associationEdge) {
        View sourceView = associationEdge.getSource();
        View targetView = associationEdge.getTarget();
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        if (sourceView instanceof Node && targetView instanceof Node) {
            LayoutConstraint targetLayoutConstraint;
            int sourceX = 0;
            int sourceY = 0;
            int sourceWidth = 0;
            int sourceHeight = 0;
            int targetX = 0;
            int targetY = 0;
            int targetWidth = 0;
            int targetHeight = 0;
            LayoutConstraint sourceLayoutConstraint = ((Node)sourceView).getLayoutConstraint();
            if (sourceLayoutConstraint instanceof Bounds) {
                sourceX = ((Bounds)sourceLayoutConstraint).getX();
                sourceY = ((Bounds)sourceLayoutConstraint).getY();
                sourceWidth = ((Bounds)sourceLayoutConstraint).getWidth();
                if (sourceWidth == 0) {
                    sourceWidth = 1;
                }
                if ((sourceHeight = ((Bounds)sourceLayoutConstraint).getHeight()) == 0) {
                    sourceHeight = 1;
                }
            }
            if ((targetLayoutConstraint = ((Node)targetView).getLayoutConstraint()) instanceof Bounds) {
                targetX = ((Bounds)targetLayoutConstraint).getX();
                targetY = ((Bounds)targetLayoutConstraint).getY();
                targetWidth = ((Bounds)targetLayoutConstraint).getWidth();
                if (targetWidth == 0) {
                    targetWidth = 1;
                }
                if ((targetHeight = ((Bounds)targetLayoutConstraint).getHeight()) == 0) {
                    targetHeight = 1;
                }
            }
            if (sourceView == targetView) {
                Point point = new Point(sourceX + sourceWidth / 2, sourceY + sourceHeight / 2);
                points.add(AbsoluteBendpointsConvention.getInstance().createAbsoluteBendpointStoredAsRelative(point));
                points.add(AbsoluteBendpointsConvention.getInstance().createAbsoluteBendpointStoredAsRelative(point));
            } else {
                Straight centerToCenterStraight = new Straight(new PrecisionPoint(sourceX + sourceWidth / 2, sourceY + sourceHeight / 2), new PrecisionPoint(targetX + targetWidth / 2, targetY + targetHeight / 2));
                PrecisionPoint intersectPointForFirstRectangle = null;
                PrecisionPoint intersectPointForSecondRectangle = null;
                Straight rightFirstRectangleStraight = new Straight(new PrecisionPoint(sourceX + sourceWidth, sourceY), new PrecisionPoint(sourceX + sourceWidth, sourceY + sourceHeight));
                if (rightFirstRectangleStraight.intersects(centerToCenterStraight)) {
                    intersectPointForFirstRectangle = rightFirstRectangleStraight.getIntersection(centerToCenterStraight).toPoint();
                } else {
                    Straight bottomFirstRectangleStraight = new Straight(new PrecisionPoint(sourceX, sourceY + sourceHeight), new PrecisionPoint(sourceX + sourceWidth, sourceY + sourceHeight));
                    if (bottomFirstRectangleStraight.intersects(centerToCenterStraight)) {
                        intersectPointForFirstRectangle = bottomFirstRectangleStraight.getIntersection(centerToCenterStraight).toPoint();
                    } else {
                        Straight leftFirstRectangleStraight = new Straight(new PrecisionPoint(sourceX, sourceY), new PrecisionPoint(sourceX, sourceY + sourceHeight));
                        if (leftFirstRectangleStraight.intersects(centerToCenterStraight)) {
                            intersectPointForFirstRectangle = leftFirstRectangleStraight.getIntersection(centerToCenterStraight).toPoint();
                        } else {
                            Straight topFirstRectangleStraight = new Straight(new PrecisionPoint(sourceX, sourceY), new PrecisionPoint(sourceX + sourceWidth, sourceY));
                            if (topFirstRectangleStraight.intersects(centerToCenterStraight)) {
                                intersectPointForFirstRectangle = topFirstRectangleStraight.getIntersection(centerToCenterStraight).toPoint();
                            }
                        }
                    }
                }
                Straight rightSecondRectangleStraight = new Straight(new PrecisionPoint(sourceX + sourceWidth, sourceY), new PrecisionPoint(sourceX + sourceWidth, sourceY + sourceHeight));
                if (rightSecondRectangleStraight.intersects(centerToCenterStraight)) {
                    intersectPointForSecondRectangle = rightSecondRectangleStraight.getIntersection(centerToCenterStraight).toPoint();
                } else {
                    Straight bottomSecondRectangleStraight = new Straight(new PrecisionPoint(sourceX, sourceY + sourceHeight), new PrecisionPoint(sourceX + sourceWidth, sourceY + sourceHeight));
                    if (bottomSecondRectangleStraight.intersects(centerToCenterStraight)) {
                        intersectPointForSecondRectangle = bottomSecondRectangleStraight.getIntersection(centerToCenterStraight).toPoint();
                    } else {
                        Straight leftSecondRectangleStraight = new Straight(new PrecisionPoint(sourceX, sourceY), new PrecisionPoint(sourceX, sourceY + sourceHeight));
                        if (leftSecondRectangleStraight.intersects(centerToCenterStraight)) {
                            intersectPointForSecondRectangle = leftSecondRectangleStraight.getIntersection(centerToCenterStraight).toPoint();
                        } else {
                            Straight topSecondRectangleStraight = new Straight(new PrecisionPoint(sourceX, sourceY), new PrecisionPoint(sourceX + sourceWidth, sourceY));
                            if (topSecondRectangleStraight.intersects(centerToCenterStraight)) {
                                intersectPointForSecondRectangle = topSecondRectangleStraight.getIntersection(centerToCenterStraight).toPoint();
                            }
                        }
                    }
                }
                if (intersectPointForFirstRectangle != null && intersectPointForSecondRectangle != null) {
                    Point sourcePoint = new Point(sourceX + sourceWidth, targetY + targetHeight / 2);
                    Point targetPoint = new Point(targetX, sourceY + sourceHeight / 2);
                    points.add(AbsoluteBendpointsConvention.getInstance().createAbsoluteBendpointStoredAsRelative(sourcePoint));
                    points.add(AbsoluteBendpointsConvention.getInstance().createAbsoluteBendpointStoredAsRelative(targetPoint));
                }
            }
        }
        if (points.isEmpty()) {
            Point point = new Point(0, 0);
            points.add(AbsoluteBendpointsConvention.getInstance().createAbsoluteBendpointStoredAsRelative(point));
            points.add(AbsoluteBendpointsConvention.getInstance().createAbsoluteBendpointStoredAsRelative(point));
        }
        bendpoints.setPoints(points);
        associationEdge.setBendpoints((Bendpoints)bendpoints);
    }

    @Operation(kind=Operation.Kind.HELPER)
    public void createBendpointsForAssociationTetherEdge(Connector associationTetherEdge) {
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        Point point = new Point(-50, -49);
        points.add(new RelativeBendpoint(point.x, point.y, 0, 0));
        points.add(new RelativeBendpoint(point.x, point.y, 0, 0));
        bendpoints.setPoints(points);
        associationTetherEdge.setBendpoints((Bendpoints)bendpoints);
        IdentityAnchor identityAnchor = NotationFactory.eINSTANCE.createIdentityAnchor();
        identityAnchor.setId("(0.5,0.5)");
        associationTetherEdge.setSourceAnchor((Anchor)identityAnchor);
    }
}

