/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.interoperability.rsa.wizard.pages;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.services.labelprovider.service.impl.LabelProviderServiceImpl;
import org.eclipse.papyrus.infra.widgets.providers.IGraphicalContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.PatternViewerFilter;
import org.eclipse.papyrus.infra.widgets.providers.WorkspaceContentProvider;
import org.eclipse.papyrus.interoperability.rsa.Activator;
import org.eclipse.papyrus.interoperability.rsa.messages.Messages;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PatternFilter;

public abstract class ImportTreeComposite
extends Composite {
    protected TreeViewer treeViewer;
    protected LabelProviderService labelProviderService;
    protected ILabelProvider treeViewerlabelProvider;
    protected WorkspaceContentProvider treeViewercontentProvider;
    protected ISelectionChangedListener treeViewerListener;
    protected final List<String> filterNames;
    protected final List<String> filterExtensions;
    protected Collection<Object> selectedFiles;
    protected Collection<String> systemPaths;
    protected FillLayout layout;
    protected Composite treeViewerComposite;
    protected Composite selectionButtonsComposite;
    protected Collection<Object> foundProjects;

    public ImportTreeComposite(Composite parent, int style, String[] extensions, String[] extensionsNames) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        this.setLayoutData(new GridData(4, 4, true, true));
        this.selectedFiles = new LinkedList<Object>();
        this.filterNames = new LinkedList<String>();
        this.filterExtensions = new LinkedList<String>();
        this.systemPaths = new LinkedList<String>();
        this.foundProjects = new LinkedList<Object>();
        this.createTreeViewerComposite(this, extensions, extensionsNames);
        this.createSelectionButtons(this);
    }

    private void createTreeViewerComposite(Composite parent, String[] extensions, String[] extensionsNames) {
        this.treeViewerComposite = new Composite(parent, 0);
        this.treeViewerComposite.setLayout((Layout)new GridLayout(1, true));
        this.treeViewerComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite beforeTreeComposite = new Composite(this.treeViewerComposite, 0);
        Composite treeComposite = new Composite(this.treeViewerComposite, 0);
        treeComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.layout = new FillLayout();
        this.layout.marginHeight = 0;
        this.layout.marginWidth = 0;
        treeComposite.setLayout((Layout)this.layout);
        this.treeViewer = new TreeViewer(treeComposite, 2818);
        this.treeViewer.setFilters(new ViewerFilter[]{new PatternFilter()});
        this.labelProviderService = new LabelProviderServiceImpl();
        try {
            this.labelProviderService.startService();
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
        }
        this.treeViewerlabelProvider = this.labelProviderService.getLabelProvider();
        this.treeViewercontentProvider = new WorkspaceContentProvider();
        this.setFilters(extensions, extensionsNames);
        this.treeViewercontentProvider.setExtensionFilters(new LinkedHashMap());
        int i = 0;
        while (i < Math.min(this.filterNames.size(), this.filterExtensions.size())) {
            this.treeViewercontentProvider.addExtensionFilter(this.filterExtensions.get(i), this.filterNames.get(i));
            ++i;
        }
        this.treeViewer.setContentProvider((IContentProvider)this.treeViewercontentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.treeViewerlabelProvider);
        this.defaultViewerInput();
        this.treeViewerListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ImportTreeComposite.this.fireTreeSelectionEvent(event);
            }
        };
        this.treeViewer.addSelectionChangedListener(this.treeViewerListener);
        if (this.treeViewercontentProvider instanceof IGraphicalContentProvider) {
            WorkspaceContentProvider graphicalContentProvider = this.treeViewercontentProvider;
            beforeTreeComposite.setLayoutData((Object)new GridData(4, 4, true, false));
            this.layout = new FillLayout();
            this.layout.marginHeight = 0;
            this.layout.marginWidth = 0;
            beforeTreeComposite.setLayout((Layout)this.layout);
            graphicalContentProvider.createBefore(beforeTreeComposite);
            beforeTreeComposite.moveAbove((Control)this.treeViewer.getTree());
            Composite afterTreeComposite = new Composite(this.treeViewerComposite, 0);
            this.layout = new FillLayout();
            this.layout.marginHeight = 0;
            this.layout.marginWidth = 0;
            afterTreeComposite.setLayout((Layout)this.layout);
            afterTreeComposite.setLayoutData((Object)new GridData(4, 4, true, false));
            graphicalContentProvider.createAfter(afterTreeComposite);
        }
    }

    protected void setFilters(String[] filterExtensions, String[] filterNames) {
        if (filterExtensions.length != filterNames.length) {
            Activator.log.warn(Messages.MultipleStringFileEditor_2);
        }
        this.setFilterNames(this.getFilterLabels(filterNames, filterExtensions));
        this.setFilterExtensions(filterExtensions);
    }

    protected String[] getFilterLabels(String[] filterNames, String[] filterExtensions) {
        int size = Math.min(filterNames.length, filterExtensions.length);
        String[] filters = new String[size];
        int i = 0;
        while (i < size) {
            filters[i] = String.valueOf(filterNames[i]) + " (" + filterExtensions[i] + ")";
            ++i;
        }
        return filters;
    }

    protected void setFilterExtensions(String[] filterExtensions) {
        this.filterExtensions.clear();
        this.filterExtensions.addAll(Arrays.asList(filterExtensions));
    }

    protected void setFilterNames(String[] filterNames) {
        this.filterNames.clear();
        this.filterNames.addAll(Arrays.asList(filterNames));
    }

    protected void defaultViewerInput() {
        this.treeViewer.setInput((Object)File.listRoots());
        ISelection workbenchSelection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        this.revealSelection(workbenchSelection);
        this.treeViewer.setSelection(workbenchSelection, true);
    }

    abstract void createSelectionButtons(Composite var1);

    abstract void fireTreeSelectionEvent(SelectionChangedEvent var1);

    protected void revealSelectedFiles(Collection<Object> importedFiles) {
        ArrayList<IFile> ifiles = new ArrayList<IFile>();
        if (importedFiles != null && !importedFiles.isEmpty()) {
            for (Object object : importedFiles) {
                this.treeViewer.refresh();
                if (object instanceof File) {
                    File file = (File)object;
                    IFile ifile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(file.getAbsolutePath()));
                    if (ifile != null) {
                        ifiles.add(ifile);
                        this.revealTreeElement(ifile);
                    }
                }
                if (!(object instanceof IFile)) continue;
                IFile ifile = (IFile)object;
                ifiles.add(ifile);
                this.revealTreeElement(ifile);
            }
        }
        this.treeViewer.setSelection((ISelection)new StructuredSelection(ifiles.toArray()), true);
    }

    protected void revealSelection(ISelection iselection) {
        if (iselection instanceof IStructuredSelection) {
            IStructuredSelection sselection = (IStructuredSelection)iselection;
            this.revealSelectedFiles(Arrays.asList(sselection.toArray()));
        }
    }

    protected void revealTreeElement(Object object) {
        if (object instanceof IFile && !(object instanceof IProject)) {
            IFile ifile = (IFile)object;
            this.treeViewer.setExpandedState((Object)ifile.getParent(), true);
            if (!(ifile.getParent() instanceof IProject)) {
                this.revealTreeElement(ifile.getParent());
            }
        }
        if (object instanceof IFolder && !(object instanceof IProject)) {
            IFolder ifolder = (IFolder)object;
            this.treeViewer.setExpandedState((Object)ifolder.getParent(), true);
            if (!(ifolder.getParent() instanceof IProject)) {
                this.revealTreeElement(ifolder.getParent());
            }
        }
    }

    protected Collection<Object> getProjects(Collection<Object> systemSelection) {
        if (systemSelection != null && !systemSelection.isEmpty()) {
            for (Object object : systemSelection) {
                if (!(object instanceof File)) continue;
                File file = (File)object;
                this.getProject(file);
            }
        }
        return this.foundProjects;
    }

    protected void getProject(File file) {
        File parentFile = file.getParentFile();
        if (parentFile == null) {
            return;
        }
        List<File> parentChildren = Arrays.asList(parentFile.listFiles());
        for (File nestedFile : parentChildren) {
            String fileExtension = this.getFileExtensions(nestedFile);
            if (!fileExtension.equals(".project") || this.foundProjects.contains(nestedFile)) continue;
            this.foundProjects.add(nestedFile);
            return;
        }
        this.getProject(parentFile);
    }

    protected String getFileExtensions(File file) {
        String fileName = file.getName();
        if (fileName.lastIndexOf(".") != -1) {
            return fileName.substring(fileName.lastIndexOf("."));
        }
        return "";
    }

    public void setSelectedFiles(Object[] elements) {
        this.getNestedFiles(elements);
    }

    public Collection<Object> getSelectedFiles() {
        return this.selectedFiles;
    }

    protected void getNestedFiles(Object[] nestedElements) {
        LinkedList<ViewerFilter> projectList = new LinkedList<ViewerFilter>();
        LinkedList<ViewerFilter> folderList = new LinkedList<ViewerFilter>();
        ArrayList<PatternViewerFilter> currentFilters = new ArrayList<PatternViewerFilter>();
        Object[] objectArray = this.treeViewer.getFilters();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter filter = objectArray[n2];
            if (filter instanceof PatternViewerFilter) {
                currentFilters.add((PatternViewerFilter)filter);
            }
            ++n2;
        }
        objectArray = nestedElements;
        n = nestedElements.length;
        n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IProject) {
                projectList.add((ViewerFilter)element);
            }
            if (element instanceof IFolder) {
                folderList.add((ViewerFilter)element);
            }
            if (element instanceof IFile) {
                Boolean isVisible = false;
                IFile selectedFile = (IFile)element;
                String fileExtension = "*." + selectedFile.getFileExtension();
                if (this.filterExtensions.contains(fileExtension) && !this.selectedFiles.contains(selectedFile)) {
                    isVisible = true;
                }
                int index = 0;
                while (index < currentFilters.size() && isVisible.booleanValue()) {
                    isVisible = ((PatternViewerFilter)currentFilters.get(index)).isVisible((Viewer)this.treeViewer, (Object)selectedFile.getParent(), (Object)selectedFile);
                    ++index;
                }
                if (isVisible.booleanValue()) {
                    this.selectedFiles.add(selectedFile);
                }
            }
            ++n2;
        }
        if (projectList.size() > 0) {
            for (Object element : projectList) {
                IProject selectedProject = (IProject)element;
                try {
                    this.getNestedFiles(selectedProject.members());
                }
                catch (CoreException e) {
                    Activator.log.error((Throwable)e);
                }
            }
        }
        if (folderList.size() > 0) {
            for (Object element : folderList) {
                IFolder selectedFolder = (IFolder)element;
                try {
                    this.getNestedFiles(selectedFolder.members());
                }
                catch (CoreException e) {
                    Activator.log.error((Throwable)e);
                }
            }
        }
    }

    public void dispose() {
        if (this.treeViewerListener != null) {
            this.treeViewer.removeSelectionChangedListener(this.treeViewerListener);
        }
        super.dispose();
    }
}

