/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.blockdefinition.helper.advice;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.util.CrossReferencerUtil;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;

public class DeleteViewDuringValueEditHelperAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeSetCommand(SetRequest request) {
        ICommand setCommand = super.getBeforeSetCommand(request);
        HashSet<View> viewsToDestroy = new HashSet<View>();
        EObject modifiedObject = request.getElementToEdit();
        if (modifiedObject != null && modifiedObject instanceof Property && !(modifiedObject instanceof Port)) {
            if (request.getFeature() == UMLPackage.eINSTANCE.getProperty_Aggregation() && request.getValue() != AggregationKind.COMPOSITE_LITERAL) {
                viewsToDestroy.addAll(this.getViewsToDestroy(modifiedObject));
            }
            if (request.getFeature() == UMLPackage.eINSTANCE.getTypedElement_Type() && request.getValue() != modifiedObject.eGet((EStructuralFeature)UMLPackage.eINSTANCE.getTypedElement_Type())) {
                EObject newType;
                EObject eObject = newType = request.getValue() instanceof EObject ? (EObject)request.getValue() : null;
                if (newType == null || !(newType instanceof DataType)) {
                    viewsToDestroy.addAll(this.getViewsToDestroy(modifiedObject));
                }
            }
        }
        if (!viewsToDestroy.isEmpty()) {
            DestroyDependentsRequest ddr = new DestroyDependentsRequest(request.getEditingDomain(), request.getElementToEdit(), false);
            ddr.setClientContext(request.getClientContext());
            ddr.addParameters(request.getParameters());
            ICommand destroyViewsCommand = ddr.getDestroyDependentsCommand(viewsToDestroy);
            setCommand = CompositeCommand.compose((ICommand)setCommand, (ICommand)destroyViewsCommand);
        }
        return setCommand;
    }

    protected Set<View> getViewsToDestroy(EObject modifiedObject) {
        HashSet<View> viewsToDestroy = new HashSet<View>();
        for (View view : CrossReferencerUtil.getCrossReferencingViews((EObject)modifiedObject, (String)"BlockDefinition")) {
            String containerType;
            String string = containerType = ViewUtil.getViewContainer((EObject)view) != null ? ViewUtil.getViewContainer((EObject)view).getType() : null;
            if (!"compartment_sysml_value_as_list".equals(containerType)) continue;
            viewsToDestroy.add(view);
        }
        return viewsToDestroy;
    }
}

