/**
 *   Copyright (c) 2016 CEA LIST and others.
 *   
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *     CEA LIST - Initial API and implementation
 * 
 */
package org.eclipse.papyrus.interoperability.rpy.rpymetamodel;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>CGI Msc Chart</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart#getVLadderMargin <em>VLadder Margin</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart#getM_usingActivationBar <em>Musing Activation Bar</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart#getM_type <em>Mtype</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart#getM_pModelObject <em>MpModel Object</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart#getM_pParent <em>MpParent</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart#getM_name <em>Mname</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart#getM_drawBehavior <em>Mdraw Behavior</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart#getM_bIsPreferencesInitialized <em>MbIs Preferences Initialized</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart#getElementList <em>Element List</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart#getGraphElements <em>Graph Elements</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart#getM_access <em>Maccess</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart#getM_modified <em>Mmodified</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart#getM_fileVersion <em>Mfile Version</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart#getM_nModifyDate <em>MnModify Date</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart#getM_nCreateDate <em>MnCreate Date</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart#getM_creator <em>Mcreator</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart#getM_bScaleWithZoom <em>MbScale With Zoom</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart#getM_arrowStyle <em>Marrow Style</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart#getM_pRoot <em>MpRoot</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart#getM_currentLeftTop <em>Mcurrent Left Top</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart#getM_currentRightBottom <em>Mcurrent Right Bottom</em>}</li>
 * </ul>
 *
 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyPackage#getCGIMscChart()
 * @model
 * @generated
 */
public interface CGIMscChart extends EObject {
	/**
	 * Returns the value of the '<em><b>VLadder Margin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>VLadder Margin</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>VLadder Margin</em>' attribute.
	 * @see #setVLadderMargin(String)
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyPackage#getCGIMscChart_VLadderMargin()
	 * @model
	 * @generated
	 */
	String getVLadderMargin();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart#getVLadderMargin <em>VLadder Margin</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>VLadder Margin</em>' attribute.
	 * @see #getVLadderMargin()
	 * @generated
	 */
	void setVLadderMargin(String value);

	/**
	 * Returns the value of the '<em><b>Musing Activation Bar</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Musing Activation Bar</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Musing Activation Bar</em>' attribute.
	 * @see #setM_usingActivationBar(String)
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyPackage#getCGIMscChart_M_usingActivationBar()
	 * @model
	 * @generated
	 */
	String getM_usingActivationBar();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart#getM_usingActivationBar <em>Musing Activation Bar</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Musing Activation Bar</em>' attribute.
	 * @see #getM_usingActivationBar()
	 * @generated
	 */
	void setM_usingActivationBar(String value);

	/**
	 * Returns the value of the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Id</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Id</em>' attribute.
	 * @see #setId(String)
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyPackage#getCGIMscChart_Id()
	 * @model
	 * @generated
	 */
	String getId();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart#getId <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Id</em>' attribute.
	 * @see #getId()
	 * @generated
	 */
	void setId(String value);

	/**
	 * Returns the value of the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Mtype</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Mtype</em>' attribute.
	 * @see #setM_type(String)
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyPackage#getCGIMscChart_M_type()
	 * @model
	 * @generated
	 */
	String getM_type();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart#getM_type <em>Mtype</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Mtype</em>' attribute.
	 * @see #getM_type()
	 * @generated
	 */
	void setM_type(String value);

	/**
	 * Returns the value of the '<em><b>MpModel Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>MpModel Object</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>MpModel Object</em>' reference.
	 * @see #setM_pModelObject(IMSC)
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyPackage#getCGIMscChart_M_pModelObject()
	 * @model
	 * @generated
	 */
	IMSC getM_pModelObject();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart#getM_pModelObject <em>MpModel Object</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>MpModel Object</em>' reference.
	 * @see #getM_pModelObject()
	 * @generated
	 */
	void setM_pModelObject(IMSC value);

	/**
	 * Returns the value of the '<em><b>MpParent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>MpParent</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>MpParent</em>' attribute.
	 * @see #setM_pParent(String)
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyPackage#getCGIMscChart_M_pParent()
	 * @model
	 * @generated
	 */
	String getM_pParent();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart#getM_pParent <em>MpParent</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>MpParent</em>' attribute.
	 * @see #getM_pParent()
	 * @generated
	 */
	void setM_pParent(String value);

	/**
	 * Returns the value of the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Mname</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Mname</em>' containment reference.
	 * @see #setM_name(CGIText)
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyPackage#getCGIMscChart_M_name()
	 * @model containment="true" resolveProxies="true"
	 * @generated
	 */
	CGIText getM_name();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart#getM_name <em>Mname</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Mname</em>' containment reference.
	 * @see #getM_name()
	 * @generated
	 */
	void setM_name(CGIText value);

	/**
	 * Returns the value of the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Mdraw Behavior</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Mdraw Behavior</em>' attribute.
	 * @see #setM_drawBehavior(String)
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyPackage#getCGIMscChart_M_drawBehavior()
	 * @model
	 * @generated
	 */
	String getM_drawBehavior();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart#getM_drawBehavior <em>Mdraw Behavior</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Mdraw Behavior</em>' attribute.
	 * @see #getM_drawBehavior()
	 * @generated
	 */
	void setM_drawBehavior(String value);

	/**
	 * Returns the value of the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>MbIs Preferences Initialized</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>MbIs Preferences Initialized</em>' attribute.
	 * @see #setM_bIsPreferencesInitialized(String)
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyPackage#getCGIMscChart_M_bIsPreferencesInitialized()
	 * @model
	 * @generated
	 */
	String getM_bIsPreferencesInitialized();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart#getM_bIsPreferencesInitialized <em>MbIs Preferences Initialized</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>MbIs Preferences Initialized</em>' attribute.
	 * @see #getM_bIsPreferencesInitialized()
	 * @generated
	 */
	void setM_bIsPreferencesInitialized(String value);

	/**
	 * Returns the value of the '<em><b>Element List</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Element List</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Element List</em>' attribute.
	 * @see #setElementList(String)
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyPackage#getCGIMscChart_ElementList()
	 * @model
	 * @generated
	 */
	String getElementList();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart#getElementList <em>Element List</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Element List</em>' attribute.
	 * @see #getElementList()
	 * @generated
	 */
	void setElementList(String value);

	/**
	 * Returns the value of the '<em><b>Graph Elements</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.GraphElementsType}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Graph Elements</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Graph Elements</em>' containment reference list.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyPackage#getCGIMscChart_GraphElements()
	 * @model containment="true" resolveProxies="true"
	 * @generated
	 */
	EList<GraphElementsType> getGraphElements();

	/**
	 * Returns the value of the '<em><b>Maccess</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Maccess</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Maccess</em>' attribute.
	 * @see #setM_access(String)
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyPackage#getCGIMscChart_M_access()
	 * @model
	 * @generated
	 */
	String getM_access();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart#getM_access <em>Maccess</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Maccess</em>' attribute.
	 * @see #getM_access()
	 * @generated
	 */
	void setM_access(String value);

	/**
	 * Returns the value of the '<em><b>Mmodified</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Mmodified</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Mmodified</em>' attribute.
	 * @see #setM_modified(String)
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyPackage#getCGIMscChart_M_modified()
	 * @model
	 * @generated
	 */
	String getM_modified();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart#getM_modified <em>Mmodified</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Mmodified</em>' attribute.
	 * @see #getM_modified()
	 * @generated
	 */
	void setM_modified(String value);

	/**
	 * Returns the value of the '<em><b>Mfile Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Mfile Version</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Mfile Version</em>' attribute.
	 * @see #setM_fileVersion(String)
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyPackage#getCGIMscChart_M_fileVersion()
	 * @model
	 * @generated
	 */
	String getM_fileVersion();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart#getM_fileVersion <em>Mfile Version</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Mfile Version</em>' attribute.
	 * @see #getM_fileVersion()
	 * @generated
	 */
	void setM_fileVersion(String value);

	/**
	 * Returns the value of the '<em><b>MnModify Date</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>MnModify Date</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>MnModify Date</em>' attribute.
	 * @see #setM_nModifyDate(String)
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyPackage#getCGIMscChart_M_nModifyDate()
	 * @model
	 * @generated
	 */
	String getM_nModifyDate();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart#getM_nModifyDate <em>MnModify Date</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>MnModify Date</em>' attribute.
	 * @see #getM_nModifyDate()
	 * @generated
	 */
	void setM_nModifyDate(String value);

	/**
	 * Returns the value of the '<em><b>MnCreate Date</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>MnCreate Date</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>MnCreate Date</em>' attribute.
	 * @see #setM_nCreateDate(String)
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyPackage#getCGIMscChart_M_nCreateDate()
	 * @model
	 * @generated
	 */
	String getM_nCreateDate();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart#getM_nCreateDate <em>MnCreate Date</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>MnCreate Date</em>' attribute.
	 * @see #getM_nCreateDate()
	 * @generated
	 */
	void setM_nCreateDate(String value);

	/**
	 * Returns the value of the '<em><b>Mcreator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Mcreator</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Mcreator</em>' attribute.
	 * @see #setM_creator(String)
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyPackage#getCGIMscChart_M_creator()
	 * @model
	 * @generated
	 */
	String getM_creator();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart#getM_creator <em>Mcreator</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Mcreator</em>' attribute.
	 * @see #getM_creator()
	 * @generated
	 */
	void setM_creator(String value);

	/**
	 * Returns the value of the '<em><b>MbScale With Zoom</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>MbScale With Zoom</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>MbScale With Zoom</em>' attribute.
	 * @see #setM_bScaleWithZoom(String)
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyPackage#getCGIMscChart_M_bScaleWithZoom()
	 * @model
	 * @generated
	 */
	String getM_bScaleWithZoom();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart#getM_bScaleWithZoom <em>MbScale With Zoom</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>MbScale With Zoom</em>' attribute.
	 * @see #getM_bScaleWithZoom()
	 * @generated
	 */
	void setM_bScaleWithZoom(String value);

	/**
	 * Returns the value of the '<em><b>Marrow Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Marrow Style</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Marrow Style</em>' attribute.
	 * @see #setM_arrowStyle(String)
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyPackage#getCGIMscChart_M_arrowStyle()
	 * @model
	 * @generated
	 */
	String getM_arrowStyle();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart#getM_arrowStyle <em>Marrow Style</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Marrow Style</em>' attribute.
	 * @see #getM_arrowStyle()
	 * @generated
	 */
	void setM_arrowStyle(String value);

	/**
	 * Returns the value of the '<em><b>MpRoot</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>MpRoot</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>MpRoot</em>' reference.
	 * @see #setM_pRoot(CGIBox)
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyPackage#getCGIMscChart_M_pRoot()
	 * @model
	 * @generated
	 */
	CGIBox getM_pRoot();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart#getM_pRoot <em>MpRoot</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>MpRoot</em>' reference.
	 * @see #getM_pRoot()
	 * @generated
	 */
	void setM_pRoot(CGIBox value);

	/**
	 * Returns the value of the '<em><b>Mcurrent Left Top</b></em>' attribute list.
	 * The list contents are of type {@link java.lang.String}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Mcurrent Left Top</em>' attribute list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Mcurrent Left Top</em>' attribute list.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyPackage#getCGIMscChart_M_currentLeftTop()
	 * @model unique="false"
	 * @generated
	 */
	EList<String> getM_currentLeftTop();

	/**
	 * Returns the value of the '<em><b>Mcurrent Right Bottom</b></em>' attribute list.
	 * The list contents are of type {@link java.lang.String}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Mcurrent Right Bottom</em>' attribute list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Mcurrent Right Bottom</em>' attribute list.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyPackage#getCGIMscChart_M_currentRightBottom()
	 * @model unique="false"
	 * @generated
	 */
	EList<String> getM_currentRightBottom();

} // CGIMscChart
