/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Position implements Enumerator
{
    NORTH(0, "NORTH", "NORTH"),
    SOUTH(1, "SOUTH", "SOUTH"),
    EAST(2, "EAST", "EAST"),
    WEST(3, "WEST", "WEST"),
    NORTH_EAST(4, "NORTH_EAST", "NORTH_EAST"),
    NORTH_WEST(5, "NORTH_WEST", "NORTH_WEST"),
    SOUTH_EAST(6, "SOUTH_EAST", "SOUTH_EAST"),
    SOUTH_WEST(7, "SOUTH_WEST", "SOUTH_WEST");

    public static final int NORTH_VALUE = 0;
    public static final int SOUTH_VALUE = 1;
    public static final int EAST_VALUE = 2;
    public static final int WEST_VALUE = 3;
    public static final int NORTH_EAST_VALUE = 4;
    public static final int NORTH_WEST_VALUE = 5;
    public static final int SOUTH_EAST_VALUE = 6;
    public static final int SOUTH_WEST_VALUE = 7;
    private static final Position[] VALUES_ARRAY;
    public static final List<Position> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Position[]{NORTH, SOUTH, EAST, WEST, NORTH_EAST, NORTH_WEST, SOUTH_EAST, SOUTH_WEST};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Position get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Position result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Position getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Position result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Position get(int value) {
        switch (value) {
            case 0: {
                return NORTH;
            }
            case 1: {
                return SOUTH;
            }
            case 2: {
                return EAST;
            }
            case 3: {
                return WEST;
            }
            case 4: {
                return NORTH_EAST;
            }
            case 5: {
                return NORTH_WEST;
            }
            case 6: {
                return SOUTH_EAST;
            }
            case 7: {
                return SOUTH_WEST;
            }
        }
        return null;
    }

    private Position(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

