/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.ui.commands;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.gmfdiag.css.properties.databinding.RemoveCssClassStyleCommand;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.CSSInstance;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.Layer;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.TypeInstance;

public class DeleteLayersCommand
extends RecordingCommand
implements Command {
    private Collection<Layer> layers;
    private TransactionalEditingDomain domain;

    public DeleteLayersCommand(TransactionalEditingDomain domain, Layer layer) {
        this(domain, Collections.singleton(layer));
    }

    public DeleteLayersCommand(TransactionalEditingDomain domain, Collection<Layer> layers) {
        super(domain);
        this.layers = layers;
        this.domain = domain;
    }

    protected void doExecute() {
        CompoundCommand cc = new CompoundCommand("DeleteLayersCommand");
        for (Layer layer : this.layers) {
            String style = null;
            for (TypeInstance type : layer.getPropertyValues()) {
                if (!(type instanceof CSSInstance)) continue;
                style = ((CSSInstance)type).getStyle();
                cc.append((Command)new RemoveCssClassStyleCommand(this.domain, (Collection)layer.getViews(), style));
            }
        }
        cc.execute();
    }
}

