/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.runtime.commands;

import java.util.List;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.LayersException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.NotFoundException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.AbstractLayer;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersStack;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersStackApplication;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.Property;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.PropertySetter;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.runtime.Activator;

public class ApplyLayerCSSChangedCommand
extends RecordingCommand {
    private List<View> views;
    private LayersStackApplication application;
    private String propertyName;
    private AbstractLayer layer;
    private LayersStack layerStack;

    public ApplyLayerCSSChangedCommand(TransactionalEditingDomain ted, List<View> views, String propertyName, AbstractLayer layer, LayersStackApplication application, LayersStack layerStack, String label) {
        super(ted, label);
        this.views = views;
        this.propertyName = propertyName;
        this.layer = layer;
        this.application = application;
        this.layerStack = layerStack;
    }

    protected void doExecute() {
        try {
            Property property = this.application.getPropertyRegistry().getProperty(this.propertyName);
            PropertySetter setter = this.application.getPropertySetterRegistry().getPropertySetter(property);
            for (View view : this.views) {
                setter.setValue(view, this.layer.getPropertyInstance(this.propertyName));
            }
        }
        catch (NotFoundException e) {
            Activator.log.error("ApplyLayerCSSChangedCommand could not retreive the setter associated to the property", (Throwable)e);
        }
        catch (LayersException e) {
            Activator.log.error("ApplyLayerCSSChangedCommand could not compute the propertyValueCommand", (Throwable)e);
        }
    }
}

