/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.impl.custom;

import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.NotFoundException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersFactory;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersStackApplication;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.NullPropertySetter;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.Property;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.PropertySetter;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.impl.PropertySetterRegistryImpl;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.util.PropertyIndexedList;

public class CustomPropertySetterRegistryImpl
extends PropertySetterRegistryImpl {
    protected CustomPropertySetterRegistryImpl() {
        this.init();
    }

    protected void init() {
        this.addPropertySetter(LayersFactory.eINSTANCE.createCSSPropertySetter());
        this.addPropertySetter(LayersFactory.eINSTANCE.createCSSHidePropertySetter());
    }

    public EList<PropertySetter> getPropertySetters() {
        if (this.propertySetters == null) {
            this.propertySetters = new PropertyIndexedList<NullPropertySetter>(this.getSetterMap(), PropertySetter.class, (InternalEObject)this, 0, 1, LayersFactory.eINSTANCE.createNullPropertySetter());
        }
        return this.propertySetters;
    }

    @Override
    public void setApplication(LayersStackApplication newApplication) {
        if (newApplication != this.eInternalContainer() || this.eContainerFeatureID() != 2 && newApplication != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newApplication)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newApplication != null) {
                msgs = ((InternalEObject)newApplication).eInverseAdd((InternalEObject)this, 5, LayersStackApplication.class, msgs);
            }
            if ((msgs = this.basicSetApplication(newApplication, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)newApplication, (Object)newApplication));
        }
        if (newApplication != null) {
            List<Property> list = newApplication.getPropertyRegistry().getProperties();
            ((PropertyIndexedList)this.getPropertySetters()).setPropertyList(list);
        }
    }

    @Override
    public PropertySetter getPropertySetter(Property property) throws NotFoundException {
        try {
            return (PropertySetter)this.getPropertySetters().get(property.getIndex());
        }
        catch (IndexOutOfBoundsException e) {
            PropertySetter setter = this.getPropertySetter(property.getName());
            if (setter != null) {
                return setter;
            }
            throw new NotFoundException("No setter found for property '" + property.getName() + "'");
        }
    }

    @Override
    public PropertySetter getPropertySetter(String property) throws NotFoundException {
        return this.getSetterMap().get(property);
    }

    @Override
    public void addPropertySetter(PropertySetter setter) {
        String key = setter.getPropertyName();
        if (key == null || key.length() == 0) {
            throw new UnsupportedOperationException("Setter must have a valid name.");
        }
        this.getSetterMap().put(key, setter);
    }
}

