/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.impl.custom;

import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.BadStateException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.LayersException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.command.ComputePropertyValueCommand;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerExpression;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerState;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.Property;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.impl.LayersStackImpl;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.notifier.ILayersTreeEventListener;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.notifier.LayersTreeEventNotifier;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.notifier.LayersTreeEventNotifierFactory;

public class CustomLayersStackImpl
extends LayersStackImpl {
    private ILayersTreeEventListener layersTreeEventListener = new ILayersTreeEventListener(){

        @Override
        public void layerSet(Notification notification) {
            CustomLayersStackImpl.this.layerAdded((LayerExpression)notification.getNewValue());
        }

        @Override
        public void layerRemoved(Notification notification) {
        }

        @Override
        public void layerMoved(Notification notification) {
        }

        @Override
        public void layerAdded(Notification notification) {
            CustomLayersStackImpl.this.layerAdded((LayerExpression)notification.getNewValue());
        }
    };

    protected CustomLayersStackImpl() {
    }

    private void init() {
        LayersTreeEventNotifier layersTreeEventnotifier = LayersTreeEventNotifierFactory.instance.adapt((Notifier)this);
        layersTreeEventnotifier.addLayersModelEventListener(this.layersTreeEventListener);
    }

    @Override
    public ComputePropertyValueCommand getComputePropertyValueCommand(View view, Property property) throws LayersException {
        LayerExpression layers = this.getLayers();
        if (layers == null) {
            throw new BadStateException("Layers should be set first.");
        }
        return layers.getComputePropertyValueCommand(view, property);
    }

    @Override
    @Deprecated
    public void startAfterCreation() {
        if (this.getLayers() != null) {
            this.getLayers().attachToLayersStack(this);
        }
        this.init();
    }

    @Override
    public void attachLayers() throws LayersException {
        if (this.getLayers() != null) {
            this.getLayers().attach();
        }
    }

    @Override
    public void attach() throws LayersException {
        if (this.getState() == LayerState.ATTACHED) {
            return;
        }
        if (this.getDiagram() == null) {
            throw new BadStateException("A required attribute is not set. The Layer can't be attached.[layerName=" + this.getName() + ", diagram=" + (this.getDiagram() == null ? "null" : "ok") + "]");
        }
        this.setState(LayerState.ATTACHED);
        this.enterAttachedState();
        this.attachLayers();
    }

    @Override
    public void detach() throws LayersException {
        this.exitAttachedState();
        this.setState(LayerState.DETACHED);
        if (this.getLayers() != null) {
            this.getLayers().detach();
        }
    }

    @Override
    public void enterAttachedState() throws LayersException {
        this.init();
    }

    @Override
    public List<ComputePropertyValueCommand> getPropertiesComputePropertyValueCommand(View view, List<Property> property) throws LayersException {
        LayerExpression layers = this.getLayers();
        if (layers == null) {
            throw new BadStateException("Layers should be set first.");
        }
        return layers.getPropertiesComputePropertyValueCommand(view, property);
    }

    @Override
    public List<ComputePropertyValueCommand> getViewsComputePropertyValueCommand(List<View> view, Property property) throws LayersException {
        LayerExpression layers = this.getLayers();
        if (layers == null) {
            throw new BadStateException("Layers should be set first.");
        }
        return layers.getViewsComputePropertyValueCommand(view, property);
    }

    protected void layerAdded(LayerExpression addedLayer) {
        if (addedLayer == null) {
            return;
        }
        addedLayer.attachToLayersStack(this);
    }
}

