/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.reconnect;

import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.domain.services.IEditableChecker;
import org.eclipse.papyrus.uml.domain.services.IViewQuerier;
import org.eclipse.papyrus.uml.domain.services.internal.helpers.ConnectorHelper;
import org.eclipse.papyrus.uml.domain.services.internal.helpers.ControlFlowHelper;
import org.eclipse.papyrus.uml.domain.services.internal.helpers.ExtensionHelper;
import org.eclipse.papyrus.uml.domain.services.internal.helpers.ObjectFlowHelper;
import org.eclipse.papyrus.uml.domain.services.reconnect.IDomainBasedEdgeReconnectionSourceChecker;
import org.eclipse.papyrus.uml.domain.services.status.CheckStatus;
import org.eclipse.uml2.uml.Artifact;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.CommunicationPath;
import org.eclipse.uml2.uml.ComponentRealization;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ControlFlow;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.DeployedArtifact;
import org.eclipse.uml2.uml.Deployment;
import org.eclipse.uml2.uml.DeploymentTarget;
import org.eclipse.uml2.uml.Extend;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Include;
import org.eclipse.uml2.uml.InformationFlow;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Manifestation;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.ObjectFlow;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.PackageMerge;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.Substitution;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Usage;
import org.eclipse.uml2.uml.UseCase;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class ElementDomainBasedEdgeReconnectionSourceChecker
implements IDomainBasedEdgeReconnectionSourceChecker {
    private final IEditableChecker editableCheck;
    private final IViewQuerier representationQuery;

    public ElementDomainBasedEdgeReconnectionSourceChecker(IEditableChecker editableCheck, IViewQuerier representationQuery) {
        this.editableCheck = Objects.requireNonNull(editableCheck);
        this.representationQuery = Objects.requireNonNull(representationQuery);
    }

    @Override
    public CheckStatus canReconnect(EObject edgeToReconnect, EObject oldSemanticEdgeSource, EObject newSemanticEdgeSource, Object newSourceView, Object targetView) {
        if (newSemanticEdgeSource == null) {
            return CheckStatus.no("The new semantic edge source must not be null");
        }
        return (CheckStatus)new ElementDomainBasedEdgeReconnectionSourceCheckerSwitch(oldSemanticEdgeSource, newSemanticEdgeSource, newSourceView, targetView, this.editableCheck, this.representationQuery).doSwitch(edgeToReconnect);
    }

    public static class ElementDomainBasedEdgeReconnectionSourceCheckerSwitch
    extends UMLSwitch<CheckStatus> {
        private static final String INVALID_NEW_EDGE_SOURCE = "The new edge source is invalid.";
        private static final String INVALID_USE_CASE_SOURCE = "Invalid Use Case source";
        private static final String INVALID_CONTAINER = "Invalid {0} container for the type {1}";
        private static final String CANNOT_EDIT_NEW_SOURCE = "Can't edit new source.";
        private static final String INVALID_NAMED_ELEMENT_SOURCE = "Invalid Named Element source";
        private final EObject oldSemanticEdgeSource;
        private final EObject newSemanticEdgeSource;
        private final Object newSourceView;
        private final Object targetView;
        private final IEditableChecker editableChecker;
        private final IViewQuerier representationQuery;

        public ElementDomainBasedEdgeReconnectionSourceCheckerSwitch(EObject oldSemanticEdgeSource, EObject newSemanticEdgeSource, Object newSourceView, Object targetView, IEditableChecker editableChecker, IViewQuerier representationQuery) {
            this.oldSemanticEdgeSource = oldSemanticEdgeSource;
            this.newSemanticEdgeSource = newSemanticEdgeSource;
            this.newSourceView = newSourceView;
            this.targetView = targetView;
            this.editableChecker = editableChecker;
            this.representationQuery = representationQuery;
        }

        public CheckStatus caseAssociation(Association association) {
            CheckStatus result;
            Property sourceProperty = (Property)association.getMemberEnds().get(0);
            if (!(this.oldSemanticEdgeSource instanceof Classifier) || !(this.newSemanticEdgeSource instanceof Classifier)) {
                result = CheckStatus.no("Invalid Association source: the new source should be a Classifier");
            } else if (!association.getOwnedEnds().contains((Object)sourceProperty)) {
                boolean cannotContainProperty;
                boolean bl = cannotContainProperty = !(this.newSemanticEdgeSource instanceof Artifact) && !(this.newSemanticEdgeSource instanceof DataType) && !(this.newSemanticEdgeSource instanceof Interface) && !(this.newSemanticEdgeSource instanceof Signal) && !(this.newSemanticEdgeSource instanceof StructuredClassifier);
                result = cannotContainProperty ? CheckStatus.no("Invalid Association source: the new source must be able to contain the SourceProperty attribute") : CheckStatus.YES;
            } else {
                result = CheckStatus.YES;
            }
            return result;
        }

        public CheckStatus caseCommunicationPath(CommunicationPath communicationPath) {
            CheckStatus result = !(this.newSemanticEdgeSource instanceof Classifier) || !(this.newSemanticEdgeSource instanceof DeploymentTarget) ? CheckStatus.no("The source of CommunicationPath should be a DeploymentTarget and a Classifier.") : CheckStatus.YES;
            return result;
        }

        public CheckStatus caseComponentRealization(ComponentRealization componentRealization) {
            CheckStatus result = !(this.newSemanticEdgeSource instanceof Classifier) ? CheckStatus.no("The source of a ComponentRealization should be a Classifier") : (this.newSemanticEdgeSource == componentRealization.getAbstraction() ? CheckStatus.no("The source and target of a ComponentRealization must be different") : CheckStatus.YES);
            return result;
        }

        public CheckStatus caseConnector(Connector connector) {
            ConnectorHelper connectorHelper = new ConnectorHelper();
            return connectorHelper.canCreateConnector(this.representationQuery, this.newSourceView, this.targetView);
        }

        public CheckStatus caseControlFlow(ControlFlow controlFlow) {
            if (new ControlFlowHelper().canCreateControlFlow(this.newSemanticEdgeSource, (EObject)controlFlow.getTarget())) {
                return CheckStatus.YES;
            }
            return CheckStatus.no(INVALID_NEW_EDGE_SOURCE);
        }

        public CheckStatus caseDependency(Dependency object) {
            CheckStatus result = this.newSemanticEdgeSource instanceof NamedElement && this.editableChecker.canEdit(this.newSemanticEdgeSource) ? CheckStatus.YES : CheckStatus.no("Dependency source can only be reconnected to a non null editable NamedElement.");
            return result;
        }

        public CheckStatus caseDeployment(Deployment deployment) {
            CheckStatus result = this.newSemanticEdgeSource instanceof DeployedArtifact ? CheckStatus.YES : CheckStatus.no("Deployment source can only be reconnected to a DeployedArtifact.");
            return result;
        }

        public CheckStatus caseExtend(Extend extend) {
            CheckStatus result = !(this.oldSemanticEdgeSource instanceof UseCase) || !(this.newSemanticEdgeSource instanceof UseCase) ? CheckStatus.no("Invalid Extend source") : (!this.editableChecker.canEdit(this.newSemanticEdgeSource) ? CheckStatus.no(CANNOT_EDIT_NEW_SOURCE) : (!(extend.eContainer() instanceof UseCase) ? CheckStatus.no(MessageFormat.format(INVALID_CONTAINER, UseCase.class.getSimpleName(), Extend.class.getSimpleName())) : (extend.getExtendedCase() == this.newSemanticEdgeSource ? CheckStatus.no("Extend cannot use the same element for source and target.") : CheckStatus.YES)));
            return result;
        }

        public CheckStatus caseExtension(Extension extension) {
            ExtensionHelper extensionHelper = new ExtensionHelper();
            CheckStatus result = extensionHelper.canCreate(this.newSemanticEdgeSource, extension.getMetaclass()) ? CheckStatus.YES : CheckStatus.no("Extension can only be connected between a Stereotype and a Metaclass.");
            return result;
        }

        public CheckStatus caseGeneralization(Generalization generalization) {
            CheckStatus result = !(this.oldSemanticEdgeSource instanceof Classifier) || !(this.newSemanticEdgeSource instanceof Classifier) ? CheckStatus.no("Invalid Classifier source") : (!this.editableChecker.canEdit(this.newSemanticEdgeSource) ? CheckStatus.no(CANNOT_EDIT_NEW_SOURCE) : (generalization.getGeneral() == this.newSemanticEdgeSource ? CheckStatus.no("Generalization cannot use the same element for source and target.") : CheckStatus.YES));
            return result;
        }

        public CheckStatus caseInclude(Include include) {
            CheckStatus result = !(this.oldSemanticEdgeSource instanceof UseCase) || !(this.newSemanticEdgeSource instanceof UseCase) ? CheckStatus.no(INVALID_USE_CASE_SOURCE) : (!this.editableChecker.canEdit(this.newSemanticEdgeSource) ? CheckStatus.no(CANNOT_EDIT_NEW_SOURCE) : (include.getAddition() == this.newSemanticEdgeSource ? CheckStatus.no("Include cannot use the same element for source and target.") : CheckStatus.YES));
            return result;
        }

        public CheckStatus caseInformationFlow(InformationFlow informationFlow) {
            CheckStatus result = !(this.newSemanticEdgeSource instanceof NamedElement) ? CheckStatus.no(INVALID_NAMED_ELEMENT_SOURCE) : (!(informationFlow.eContainer() instanceof Package) ? CheckStatus.no(MessageFormat.format(INVALID_CONTAINER, Package.class.getSimpleName(), InformationFlow.class.getSimpleName())) : CheckStatus.YES);
            return result;
        }

        public CheckStatus caseInterfaceRealization(InterfaceRealization object) {
            CheckStatus result = !(this.newSemanticEdgeSource instanceof BehavioredClassifier) ? CheckStatus.no("The source of an InterfaceRealization should be a BehavioredClassifier") : CheckStatus.YES;
            return result;
        }

        public CheckStatus caseManifestation(Manifestation manifestation) {
            CheckStatus result = !(this.newSemanticEdgeSource instanceof NamedElement) ? CheckStatus.no(INVALID_NAMED_ELEMENT_SOURCE) : (manifestation.getClients().contains((Object)this.newSemanticEdgeSource) ? CheckStatus.no("Manifestation cannot use the same element for source and target.") : CheckStatus.YES);
            return result;
        }

        public CheckStatus caseMessage(Message message) {
            CheckStatus result = !(this.newSemanticEdgeSource instanceof Lifeline) ? CheckStatus.no(INVALID_NAMED_ELEMENT_SOURCE) : CheckStatus.YES;
            return result;
        }

        public CheckStatus caseObjectFlow(ObjectFlow objectFlow) {
            if (new ObjectFlowHelper().canCreateObjectFlow(this.newSemanticEdgeSource, (EObject)objectFlow.getTarget())) {
                return CheckStatus.YES;
            }
            return CheckStatus.no(INVALID_NEW_EDGE_SOURCE);
        }

        public CheckStatus casePackageImport(PackageImport packImport) {
            CheckStatus result = !(this.oldSemanticEdgeSource instanceof Namespace) || !(this.newSemanticEdgeSource instanceof Namespace) ? CheckStatus.no("Invalid Namespace source") : (!this.editableChecker.canEdit(this.newSemanticEdgeSource) ? CheckStatus.no(CANNOT_EDIT_NEW_SOURCE) : (!(packImport.eContainer() instanceof Namespace) ? CheckStatus.no(MessageFormat.format(INVALID_CONTAINER, Namespace.class.getSimpleName(), PackageImport.class.getSimpleName())) : CheckStatus.YES));
            return result;
        }

        public CheckStatus casePackageMerge(PackageMerge packMerge) {
            CheckStatus result = !(this.oldSemanticEdgeSource instanceof Package) || !(this.newSemanticEdgeSource instanceof Package) ? CheckStatus.no("Invalid PackageMerge source") : (!this.editableChecker.canEdit(this.newSemanticEdgeSource) ? CheckStatus.no(CANNOT_EDIT_NEW_SOURCE) : (!(packMerge.eContainer() instanceof Package) ? CheckStatus.no(MessageFormat.format(INVALID_CONTAINER, Package.class.getSimpleName(), PackageMerge.class.getSimpleName())) : CheckStatus.YES));
            return result;
        }

        public CheckStatus caseSubstitution(Substitution substitution) {
            CheckStatus result = !(this.newSemanticEdgeSource instanceof Classifier) ? CheckStatus.no("Invalid Classifier source") : (!this.editableChecker.canEdit(this.newSemanticEdgeSource) ? CheckStatus.no(CANNOT_EDIT_NEW_SOURCE) : (substitution.getContract() == this.newSemanticEdgeSource ? CheckStatus.no("Substitution cannot use the same element for source and target.") : CheckStatus.YES));
            return result;
        }

        public CheckStatus caseTransition(Transition transition) {
            CheckStatus result = !this.editableChecker.canEdit((EObject)transition) ? CheckStatus.no("Can't edit the Transition.") : (!(this.oldSemanticEdgeSource instanceof Vertex) || !(this.newSemanticEdgeSource instanceof Vertex) ? CheckStatus.no("Invalid semantic source") : CheckStatus.YES);
            return result;
        }

        public CheckStatus caseUsage(Usage usage) {
            CheckStatus result = !(this.oldSemanticEdgeSource instanceof NamedElement) || !(this.newSemanticEdgeSource instanceof NamedElement) ? CheckStatus.no(INVALID_NAMED_ELEMENT_SOURCE) : CheckStatus.YES;
            return result;
        }

        public CheckStatus defaultCase(EObject object) {
            return CheckStatus.YES;
        }
    }
}

