/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.labels.domains;

import org.eclipse.papyrus.uml.domain.services.labels.INamedElementNameProvider;
import org.eclipse.papyrus.uml.domain.services.labels.LabelUtils;
import org.eclipse.papyrus.uml.domain.services.labels.UMLCharacters;
import org.eclipse.papyrus.uml.domain.services.labels.domains.MultiplicityLabelHelper;
import org.eclipse.papyrus.uml.domain.services.labels.domains.ValueSpecificationLabelHelper;
import org.eclipse.papyrus.uml.domain.services.labels.domains.VisibilityLabelHelper;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;

public class PropertyLabelHelper {
    public static final String UNDEFINED_TYPE_NAME = "<Undefined>";
    private ValueSpecificationLabelHelper valueSpecificationLabelHelper;
    private MultiplicityLabelHelper multiplicityLabelHelper;
    private INamedElementNameProvider namedElementNameProvider;
    private final boolean displayModifier;
    private final boolean displayDefaultValue;
    private VisibilityLabelHelper visibilityLabelHelper;

    public PropertyLabelHelper(boolean displayModifier, boolean displayDefaultValue, INamedElementNameProvider namedElementNameProvider, VisibilityLabelHelper visibilityLabelHelper) {
        this.displayModifier = displayModifier;
        this.displayDefaultValue = displayDefaultValue;
        this.namedElementNameProvider = namedElementNameProvider;
        this.valueSpecificationLabelHelper = new ValueSpecificationLabelHelper(namedElementNameProvider);
        this.multiplicityLabelHelper = new MultiplicityLabelHelper(namedElementNameProvider);
        this.visibilityLabelHelper = visibilityLabelHelper;
    }

    public String getLabel(Property property) {
        String modifiers;
        StringBuffer buffer = new StringBuffer();
        buffer.append(LabelUtils.getNonNullString(this.visibilityLabelHelper.getVisibilityAsSign((NamedElement)property)));
        if (property.isDerived()) {
            buffer.append("/");
        }
        buffer.append(" ");
        buffer.append(LabelUtils.getNonNullString(this.namedElementNameProvider.getName((NamedElement)property)));
        buffer.append(": ");
        if (property instanceof Port && ((Port)property).isConjugated()) {
            buffer.append("~");
        }
        if (property.getType() != null) {
            buffer.append(this.namedElementNameProvider.getName((NamedElement)property.getType()));
        } else {
            buffer.append(UNDEFINED_TYPE_NAME);
        }
        String multiplicity = LabelUtils.getNonNullString(this.multiplicityLabelHelper.formatMultiplicity((MultiplicityElement)property));
        if (!multiplicity.isBlank()) {
            buffer.append(" ");
            buffer.append(multiplicity);
        }
        if (this.displayDefaultValue && property.getDefaultValue() != null) {
            buffer.append(" = ");
            buffer.append(LabelUtils.getNonNullString(this.valueSpecificationLabelHelper.getSpecificationValue(property.getDefaultValue(), true)));
        }
        if (this.displayModifier && !(modifiers = LabelUtils.getNonNullString(this.getModifiersAsString(property, false))).equals("")) {
            if (!buffer.toString().endsWith(" ")) {
                buffer.append(" ");
            }
            buffer.append(modifiers);
        }
        return buffer.toString();
    }

    private String getModifiersAsString(Property property, boolean multiLine) {
        String NL;
        StringBuffer buffer = new StringBuffer();
        boolean needsComma = false;
        String string = NL = multiLine ? UMLCharacters.EOL : " ";
        if (property.isReadOnly()) {
            buffer.append("readOnly");
            needsComma = true;
        }
        if (property.isDerivedUnion()) {
            needsComma = PropertyLabelHelper.updateModifiersString(buffer, needsComma, NL, "union");
        }
        if (property.isOrdered()) {
            needsComma = PropertyLabelHelper.updateModifiersString(buffer, needsComma, NL, "ordered");
        }
        if (property.isUnique()) {
            needsComma = PropertyLabelHelper.updateModifiersString(buffer, needsComma, NL, "unique");
        }
        for (Property current : property.getRedefinedProperties()) {
            needsComma = PropertyLabelHelper.updateModifiersString(buffer, needsComma, NL, "redefines ");
            buffer.append(this.namedElementNameProvider.getName((NamedElement)current));
        }
        for (Property current : property.getSubsettedProperties()) {
            needsComma = PropertyLabelHelper.updateModifiersString(buffer, needsComma, NL, "subsets ");
            buffer.append(this.namedElementNameProvider.getName((NamedElement)current));
        }
        if (!buffer.toString().equals("")) {
            buffer.insert(0, "{");
            buffer.append("}");
        }
        return buffer.toString();
    }

    private static boolean updateModifiersString(StringBuffer buffer, boolean needsComma, String nl, String message) {
        if (needsComma) {
            buffer.append(",");
            buffer.append(nl);
        }
        buffer.append(message);
        return true;
    }
}

