/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.labels.domains;

import org.eclipse.papyrus.uml.domain.services.labels.INamedElementNameProvider;
import org.eclipse.papyrus.uml.domain.services.labels.LabelUtils;
import org.eclipse.papyrus.uml.domain.services.labels.UMLCharacters;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Parameter;

public class ParameterLabelHelper {
    public static final String UNDEFINED_TYPE_NAME = "<Undefined>";
    private INamedElementNameProvider namedElementNameProvider;
    private final boolean displayModifier;
    private final boolean displayDefaultValue;

    public ParameterLabelHelper(boolean displayModifier, boolean displayDefaultValue, INamedElementNameProvider namedElementNameProvider) {
        this.displayModifier = displayModifier;
        this.displayDefaultValue = displayDefaultValue;
        this.namedElementNameProvider = namedElementNameProvider;
    }

    public String getLabel(Parameter parameter) {
        String modifiers;
        StringBuffer buffer = new StringBuffer();
        buffer.append(parameter.getDirection().getLiteral());
        buffer.append(" ");
        buffer.append(LabelUtils.getNonNullString(this.namedElementNameProvider.getName((NamedElement)parameter)));
        buffer.append(": ");
        if (parameter.getType() != null) {
            buffer.append(this.namedElementNameProvider.getName((NamedElement)parameter.getType()));
        } else {
            buffer.append(UNDEFINED_TYPE_NAME);
        }
        if (this.displayDefaultValue && parameter.getDefaultValue() != null) {
            buffer.append(" = ");
            buffer.append(parameter.getDefault());
        }
        if (this.displayModifier && !(modifiers = LabelUtils.getNonNullString(this.getModifiersAsString(parameter, false))).equals("")) {
            if (!buffer.toString().endsWith(" ")) {
                buffer.append(" ");
            }
            buffer.append(modifiers);
        }
        return buffer.toString();
    }

    private String getModifiersAsString(Parameter parameter, boolean multiLine) {
        String NL;
        StringBuffer buffer = new StringBuffer();
        boolean needsComma = false;
        String string = NL = multiLine ? UMLCharacters.EOL : " ";
        if (parameter.isOrdered()) {
            needsComma = ParameterLabelHelper.updateModifiersString(buffer, needsComma, NL, "ordered");
        }
        if (parameter.isUnique()) {
            needsComma = ParameterLabelHelper.updateModifiersString(buffer, needsComma, NL, "unique");
        }
        if (parameter.isException()) {
            needsComma = ParameterLabelHelper.updateModifiersString(buffer, needsComma, NL, "exception");
        }
        if (parameter.isStream()) {
            needsComma = ParameterLabelHelper.updateModifiersString(buffer, needsComma, NL, "stream");
        }
        if (!buffer.toString().equals("")) {
            buffer.insert(0, "{");
            buffer.append("}");
        }
        return buffer.toString();
    }

    private static boolean updateModifiersString(StringBuffer buffer, boolean needsComma, String nl, String message) {
        if (needsComma) {
            buffer.append(",");
            buffer.append(nl);
        }
        buffer.append(message);
        return true;
    }
}

