/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.create;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.domain.services.create.IElementConfigurer;
import org.eclipse.papyrus.uml.domain.services.labels.ElementDefaultNameProvider;
import org.eclipse.uml2.uml.AcceptCallAction;
import org.eclipse.uml2.uml.Action;
import org.eclipse.uml2.uml.ActionExecutionSpecification;
import org.eclipse.uml2.uml.AddStructuralFeatureValueAction;
import org.eclipse.uml2.uml.AddVariableValueAction;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.CallOperationAction;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ClearAssociationAction;
import org.eclipse.uml2.uml.ClearStructuralFeatureAction;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.CreateLinkAction;
import org.eclipse.uml2.uml.CreateLinkObjectAction;
import org.eclipse.uml2.uml.CreateObjectAction;
import org.eclipse.uml2.uml.DestroyLinkAction;
import org.eclipse.uml2.uml.DestroyObjectAction;
import org.eclipse.uml2.uml.Duration;
import org.eclipse.uml2.uml.DurationConstraint;
import org.eclipse.uml2.uml.DurationInterval;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionOccurrenceSpecification;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.ExtensionEnd;
import org.eclipse.uml2.uml.InputPin;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.Interval;
import org.eclipse.uml2.uml.IntervalConstraint;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.OutputPin;
import org.eclipse.uml2.uml.Pin;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.ReadExtentAction;
import org.eclipse.uml2.uml.ReadIsClassifiedObjectAction;
import org.eclipse.uml2.uml.ReadLinkAction;
import org.eclipse.uml2.uml.ReadSelfAction;
import org.eclipse.uml2.uml.ReadStructuralFeatureAction;
import org.eclipse.uml2.uml.ReadVariableAction;
import org.eclipse.uml2.uml.ReclassifyObjectAction;
import org.eclipse.uml2.uml.ReduceAction;
import org.eclipse.uml2.uml.SendObjectAction;
import org.eclipse.uml2.uml.SendSignalAction;
import org.eclipse.uml2.uml.StartClassifierBehaviorAction;
import org.eclipse.uml2.uml.StartObjectBehaviorAction;
import org.eclipse.uml2.uml.TestIdentityAction;
import org.eclipse.uml2.uml.TimeConstraint;
import org.eclipse.uml2.uml.TimeExpression;
import org.eclipse.uml2.uml.TimeInterval;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UnmarshallAction;
import org.eclipse.uml2.uml.UseCase;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.ValueSpecificationAction;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class ElementConfigurer
implements IElementConfigurer {
    @Override
    public EObject configure(EObject toInit, EObject parent) {
        if (toInit == null) {
            return null;
        }
        new ElementInitializerImpl(parent).doSwitch(toInit);
        return toInit;
    }

    static class ElementInitializerImpl
    extends UMLSwitch<Void> {
        private static final String TARGET_ELEMENT_NAME = "target";
        private static final String INSERT_AT_ELEMENT_NAME = "insertAt";
        private static final String VALUE_ELEMENT_NAME = "value";
        private static final String RESULT_ELEMENT_NAME = "result";
        private static final String OBJECT_ELEMENT_NAME = "object";
        private final EObject parent;

        ElementInitializerImpl(EObject parent) {
            this.parent = parent;
        }

        public Void caseAcceptCallAction(AcceptCallAction acceptCallAction) {
            OutputPin returnInformation = UMLFactory.eINSTANCE.createOutputPin();
            returnInformation.setName("return information");
            acceptCallAction.setReturnInformation(returnInformation);
            return (Void)super.caseAcceptCallAction(acceptCallAction);
        }

        public Void caseAddStructuralFeatureValueAction(AddStructuralFeatureValueAction addStructuralFeatureValueAction) {
            InputPin object = UMLFactory.eINSTANCE.createInputPin();
            InputPin value = UMLFactory.eINSTANCE.createInputPin();
            InputPin insertAt = UMLFactory.eINSTANCE.createInputPin();
            OutputPin result = UMLFactory.eINSTANCE.createOutputPin();
            object.setName(OBJECT_ELEMENT_NAME);
            value.setName(VALUE_ELEMENT_NAME);
            insertAt.setName(INSERT_AT_ELEMENT_NAME);
            result.setName(RESULT_ELEMENT_NAME);
            addStructuralFeatureValueAction.setObject(object);
            addStructuralFeatureValueAction.setValue(value);
            addStructuralFeatureValueAction.setInsertAt(insertAt);
            addStructuralFeatureValueAction.setResult(result);
            return (Void)super.caseAddStructuralFeatureValueAction(addStructuralFeatureValueAction);
        }

        public Void caseAddVariableValueAction(AddVariableValueAction addVariableValueAction) {
            InputPin value = UMLFactory.eINSTANCE.createInputPin();
            InputPin insertAt = UMLFactory.eINSTANCE.createInputPin();
            value.setName(VALUE_ELEMENT_NAME);
            insertAt.setName(INSERT_AT_ELEMENT_NAME);
            addVariableValueAction.setValue(value);
            addVariableValueAction.setInsertAt(insertAt);
            return (Void)super.caseAddVariableValueAction(addVariableValueAction);
        }

        public Void caseCallOperationAction(CallOperationAction callOperationAction) {
            InputPin target = UMLFactory.eINSTANCE.createInputPin();
            target.setName(TARGET_ELEMENT_NAME);
            callOperationAction.setTarget(target);
            return (Void)super.caseCallOperationAction(callOperationAction);
        }

        public Void caseConstraint(Constraint constraint) {
            if (constraint.getSpecification() == null) {
                OpaqueExpression spec = UMLFactory.eINSTANCE.createOpaqueExpression();
                spec.setName("constraintSpec");
                spec.getLanguages().add((Object)"OCL");
                spec.getBodies().add((Object)"true");
                constraint.setSpecification((ValueSpecification)spec);
            }
            return (Void)super.caseConstraint(constraint);
        }

        public Void caseClearAssociationAction(ClearAssociationAction clearAssociationAction) {
            InputPin object = UMLFactory.eINSTANCE.createInputPin();
            object.setName(OBJECT_ELEMENT_NAME);
            clearAssociationAction.setObject(object);
            return (Void)super.caseClearAssociationAction(clearAssociationAction);
        }

        public Void caseClearStructuralFeatureAction(ClearStructuralFeatureAction clearStructuralFeatureAction) {
            InputPin object = UMLFactory.eINSTANCE.createInputPin();
            OutputPin result = UMLFactory.eINSTANCE.createOutputPin();
            object.setName(OBJECT_ELEMENT_NAME);
            result.setName(RESULT_ELEMENT_NAME);
            clearStructuralFeatureAction.setObject(object);
            clearStructuralFeatureAction.setResult(result);
            return (Void)super.caseClearStructuralFeatureAction(clearStructuralFeatureAction);
        }

        public Void caseCreateLinkAction(CreateLinkAction createLinkAction) {
            InputPin inputValue = UMLFactory.eINSTANCE.createInputPin();
            inputValue.setName(new ElementDefaultNameProvider().getDefaultName((NamedElement)inputValue, (EObject)createLinkAction));
            createLinkAction.getInputValues().add((Object)inputValue);
            return (Void)super.caseCreateLinkAction(createLinkAction);
        }

        public Void caseCreateLinkObjectAction(CreateLinkObjectAction createLinkObjectAction) {
            InputPin inputValue = UMLFactory.eINSTANCE.createInputPin();
            OutputPin result = UMLFactory.eINSTANCE.createOutputPin();
            inputValue.setName(new ElementDefaultNameProvider().getDefaultName((NamedElement)inputValue, (EObject)createLinkObjectAction));
            result.setName(RESULT_ELEMENT_NAME);
            createLinkObjectAction.getInputValues().add((Object)inputValue);
            createLinkObjectAction.setResult(result);
            return (Void)super.caseCreateLinkObjectAction(createLinkObjectAction);
        }

        public Void caseCreateObjectAction(CreateObjectAction createObjectAction) {
            OutputPin result = UMLFactory.eINSTANCE.createOutputPin();
            result.setName(RESULT_ELEMENT_NAME);
            createObjectAction.setResult(result);
            return (Void)super.caseCreateObjectAction(createObjectAction);
        }

        public Void caseDestroyLinkAction(DestroyLinkAction destroyLinkAction) {
            InputPin inputValue = UMLFactory.eINSTANCE.createInputPin();
            inputValue.setName(new ElementDefaultNameProvider().getDefaultName((NamedElement)inputValue, (EObject)destroyLinkAction));
            destroyLinkAction.getInputValues().add((Object)inputValue);
            return (Void)super.caseDestroyLinkAction(destroyLinkAction);
        }

        public Void caseDestroyObjectAction(DestroyObjectAction destroyObjectAction) {
            InputPin target = UMLFactory.eINSTANCE.createInputPin();
            target.setName(TARGET_ELEMENT_NAME);
            destroyObjectAction.setTarget(target);
            return (Void)super.caseDestroyObjectAction(destroyObjectAction);
        }

        public Void caseDurationConstraint(DurationConstraint durationConstraint) {
            if (this.parent instanceof Element) {
                durationConstraint.getConstrainedElements().clear();
                durationConstraint.getConstrainedElements().add((Object)((Element)this.parent));
            }
            DurationInterval durationInterval = UMLFactory.eINSTANCE.createDurationInterval();
            Model minMaxContainer = durationConstraint.getModel();
            if (minMaxContainer != null) {
                Duration durationMin = (Duration)minMaxContainer.createPackagedElement("d1", UMLPackage.eINSTANCE.getDuration());
                Duration durationMax = (Duration)minMaxContainer.createPackagedElement("d2", UMLPackage.eINSTANCE.getDuration());
                LiteralInteger integerMin = UMLFactory.eINSTANCE.createLiteralInteger();
                LiteralInteger integerMax = UMLFactory.eINSTANCE.createLiteralInteger();
                durationMin.setExpr((ValueSpecification)integerMin);
                durationMax.setExpr((ValueSpecification)integerMax);
                durationInterval.setMin((ValueSpecification)durationMin);
                durationInterval.setMax((ValueSpecification)durationMax);
            }
            durationConstraint.setSpecification((ValueSpecification)durationInterval);
            return (Void)super.caseDurationConstraint(durationConstraint);
        }

        public Void caseIntervalConstraint(IntervalConstraint intervalConstraint) {
            if (intervalConstraint.getSpecification() == null) {
                Interval interval = UMLFactory.eINSTANCE.createInterval();
                Model minMaxContainer = intervalConstraint.getModel();
                if (minMaxContainer != null) {
                    LiteralInteger literalIntegerMin = (LiteralInteger)minMaxContainer.createPackagedElement("i1", UMLPackage.eINSTANCE.getLiteralInteger());
                    LiteralInteger literalIntegerMax = (LiteralInteger)minMaxContainer.createPackagedElement("i2", UMLPackage.eINSTANCE.getLiteralInteger());
                    interval.setMin((ValueSpecification)literalIntegerMin);
                    interval.setMax((ValueSpecification)literalIntegerMax);
                }
                intervalConstraint.setSpecification((ValueSpecification)interval);
            }
            return (Void)super.caseIntervalConstraint(intervalConstraint);
        }

        public Void caseReadExtentAction(ReadExtentAction readExtentAction) {
            OutputPin result = UMLFactory.eINSTANCE.createOutputPin();
            result.setName(RESULT_ELEMENT_NAME);
            readExtentAction.setResult(result);
            return (Void)super.caseReadExtentAction(readExtentAction);
        }

        public Void caseReadIsClassifiedObjectAction(ReadIsClassifiedObjectAction readIsClassifiedObjectAction) {
            OutputPin result = UMLFactory.eINSTANCE.createOutputPin();
            InputPin object = UMLFactory.eINSTANCE.createInputPin();
            result.setName(RESULT_ELEMENT_NAME);
            object.setName(OBJECT_ELEMENT_NAME);
            readIsClassifiedObjectAction.setResult(result);
            readIsClassifiedObjectAction.setObject(object);
            return (Void)super.caseReadIsClassifiedObjectAction(readIsClassifiedObjectAction);
        }

        public Void caseReadLinkAction(ReadLinkAction readLinkAction) {
            OutputPin result = UMLFactory.eINSTANCE.createOutputPin();
            InputPin inputValue = UMLFactory.eINSTANCE.createInputPin();
            result.setName(RESULT_ELEMENT_NAME);
            inputValue.setName(new ElementDefaultNameProvider().getDefaultName((NamedElement)inputValue, (EObject)readLinkAction));
            readLinkAction.setResult(result);
            readLinkAction.getInputValues().add((Object)inputValue);
            return (Void)super.caseReadLinkAction(readLinkAction);
        }

        public Void caseReadSelfAction(ReadSelfAction readSelfAction) {
            OutputPin result = UMLFactory.eINSTANCE.createOutputPin();
            result.setName(RESULT_ELEMENT_NAME);
            readSelfAction.setResult(result);
            return (Void)super.caseReadSelfAction(readSelfAction);
        }

        public Void caseReadStructuralFeatureAction(ReadStructuralFeatureAction readStructuralFeatureAction) {
            OutputPin result = UMLFactory.eINSTANCE.createOutputPin();
            InputPin object = UMLFactory.eINSTANCE.createInputPin();
            result.setName(RESULT_ELEMENT_NAME);
            object.setName(OBJECT_ELEMENT_NAME);
            readStructuralFeatureAction.setResult(result);
            readStructuralFeatureAction.setObject(object);
            return (Void)super.caseReadStructuralFeatureAction(readStructuralFeatureAction);
        }

        public Void caseReadVariableAction(ReadVariableAction readVariableAction) {
            OutputPin result = UMLFactory.eINSTANCE.createOutputPin();
            result.setName(RESULT_ELEMENT_NAME);
            readVariableAction.setResult(result);
            return (Void)super.caseReadVariableAction(readVariableAction);
        }

        public Void caseReclassifyObjectAction(ReclassifyObjectAction reclassifyObjectAction) {
            InputPin object = UMLFactory.eINSTANCE.createInputPin();
            object.setName(OBJECT_ELEMENT_NAME);
            reclassifyObjectAction.setObject(object);
            return (Void)super.caseReclassifyObjectAction(reclassifyObjectAction);
        }

        public Void caseReduceAction(ReduceAction reduceAction) {
            OutputPin result = UMLFactory.eINSTANCE.createOutputPin();
            InputPin collection = UMLFactory.eINSTANCE.createInputPin();
            result.setName(RESULT_ELEMENT_NAME);
            collection.setName("collection");
            reduceAction.setResult(result);
            reduceAction.setCollection(collection);
            return (Void)super.caseReduceAction(reduceAction);
        }

        public Void caseSendObjectAction(SendObjectAction sendObjectAction) {
            InputPin request = UMLFactory.eINSTANCE.createInputPin();
            InputPin target = UMLFactory.eINSTANCE.createInputPin();
            request.setName("request");
            target.setName(TARGET_ELEMENT_NAME);
            sendObjectAction.setRequest(request);
            sendObjectAction.setTarget(target);
            return (Void)super.caseSendObjectAction(sendObjectAction);
        }

        public Void caseSendSignalAction(SendSignalAction sendSignalAction) {
            InputPin target = UMLFactory.eINSTANCE.createInputPin();
            target.setName(TARGET_ELEMENT_NAME);
            sendSignalAction.setTarget(target);
            return (Void)super.caseSendSignalAction(sendSignalAction);
        }

        public Void caseStartClassifierBehaviorAction(StartClassifierBehaviorAction startClassifierBehaviorAction) {
            InputPin object = UMLFactory.eINSTANCE.createInputPin();
            object.setName(OBJECT_ELEMENT_NAME);
            startClassifierBehaviorAction.setObject(object);
            return (Void)super.caseStartClassifierBehaviorAction(startClassifierBehaviorAction);
        }

        public Void caseStartObjectBehaviorAction(StartObjectBehaviorAction startObjectBehaviorAction) {
            InputPin object = UMLFactory.eINSTANCE.createInputPin();
            object.setName(OBJECT_ELEMENT_NAME);
            startObjectBehaviorAction.setObject(object);
            return (Void)super.caseStartObjectBehaviorAction(startObjectBehaviorAction);
        }

        public Void caseTestIdentityAction(TestIdentityAction testIdentityAction) {
            InputPin first = UMLFactory.eINSTANCE.createInputPin();
            InputPin second = UMLFactory.eINSTANCE.createInputPin();
            OutputPin result = UMLFactory.eINSTANCE.createOutputPin();
            first.setName("first");
            second.setName("second");
            result.setName(RESULT_ELEMENT_NAME);
            testIdentityAction.setFirst(first);
            testIdentityAction.setSecond(second);
            testIdentityAction.setResult(result);
            return (Void)super.caseTestIdentityAction(testIdentityAction);
        }

        public Void caseUnmarshallAction(UnmarshallAction unmarshallAction) {
            OutputPin result = UMLFactory.eINSTANCE.createOutputPin();
            InputPin object = UMLFactory.eINSTANCE.createInputPin();
            result.setName(new ElementDefaultNameProvider().getDefaultName((NamedElement)result, (EObject)unmarshallAction));
            object.setName(OBJECT_ELEMENT_NAME);
            unmarshallAction.getResults().add((Object)result);
            unmarshallAction.setObject(object);
            return (Void)super.caseUnmarshallAction(unmarshallAction);
        }

        public Void caseTimeConstraint(TimeConstraint timeConstraint) {
            if (this.parent instanceof Element) {
                timeConstraint.getConstrainedElements().clear();
                timeConstraint.getConstrainedElements().add((Object)((Element)this.parent));
            }
            TimeInterval timeInterval = UMLFactory.eINSTANCE.createTimeInterval();
            Model minMaxContainer = timeConstraint.getModel();
            if (minMaxContainer != null) {
                TimeExpression timeExpressionMin = (TimeExpression)minMaxContainer.createPackagedElement("t1", UMLPackage.eINSTANCE.getTimeExpression());
                TimeExpression timeExpressionMax = (TimeExpression)minMaxContainer.createPackagedElement("t2", UMLPackage.eINSTANCE.getTimeExpression());
                LiteralInteger literalIntegerMin = UMLFactory.eINSTANCE.createLiteralInteger();
                LiteralInteger literalIntegerMax = UMLFactory.eINSTANCE.createLiteralInteger();
                timeExpressionMin.setExpr((ValueSpecification)literalIntegerMin);
                timeExpressionMax.setExpr((ValueSpecification)literalIntegerMax);
                timeInterval.setMin((ValueSpecification)timeExpressionMin);
                timeInterval.setMax((ValueSpecification)timeExpressionMax);
            }
            timeConstraint.setSpecification((ValueSpecification)timeInterval);
            return (Void)super.caseTimeConstraint(timeConstraint);
        }

        public Void caseValueSpecificationAction(ValueSpecificationAction valueSpecificationAction) {
            OutputPin result = UMLFactory.eINSTANCE.createOutputPin();
            result.setName(RESULT_ELEMENT_NAME);
            valueSpecificationAction.setResult(result);
            return (Void)super.caseValueSpecificationAction(valueSpecificationAction);
        }

        public Void caseActionExecutionSpecification(ActionExecutionSpecification actionExecutionSpecification) {
            if (actionExecutionSpecification.getOwner() instanceof Interaction) {
                String executionName = new ElementDefaultNameProvider().getDefaultName((NamedElement)actionExecutionSpecification, this.parent);
                Interaction interaction = (Interaction)actionExecutionSpecification.getOwner();
                ExecutionOccurrenceSpecification start = UMLFactory.eINSTANCE.createExecutionOccurrenceSpecification();
                interaction.getFragments().add((Object)start);
                start.setName(executionName + "Start");
                start.setExecution((ExecutionSpecification)actionExecutionSpecification);
                actionExecutionSpecification.setStart((OccurrenceSpecification)start);
                ExecutionOccurrenceSpecification finish = UMLFactory.eINSTANCE.createExecutionOccurrenceSpecification();
                interaction.getFragments().add((Object)finish);
                finish.setName(executionName + "Finish");
                finish.setExecution((ExecutionSpecification)actionExecutionSpecification);
                actionExecutionSpecification.setFinish((OccurrenceSpecification)finish);
            }
            return (Void)super.caseExecutionSpecification((ExecutionSpecification)actionExecutionSpecification);
        }

        public Void caseExtensionEnd(ExtensionEnd extensionEnd) {
            extensionEnd.setAggregation(AggregationKind.COMPOSITE_LITERAL);
            return (Void)super.caseExtensionEnd(extensionEnd);
        }

        public Void caseInteractionOperand(InteractionOperand interactionOperand) {
            interactionOperand.createGuard("guard");
            return (Void)super.caseInteractionOperand(interactionOperand);
        }

        /*
         * WARNING - void declaration
         */
        public Void casePin(Pin pin) {
            EObject eObject = this.parent;
            if (eObject instanceof Action) {
                void action;
                Action action2 = (Action)eObject;
                Action cfr_ignored_0 = (Action)eObject;
                pin.getInPartitions().addAll((Collection)action.getInPartitions());
            }
            return (Void)super.casePin(pin);
        }

        public Void casePort(Port port) {
            port.setAggregation(AggregationKind.COMPOSITE_LITERAL);
            return (Void)super.casePort(port);
        }

        public Void caseUseCase(UseCase useCase) {
            Element owner = useCase.getOwner();
            if (owner instanceof Classifier) {
                ((Classifier)owner).getUseCases().add((Object)useCase);
            }
            return (Void)super.caseUseCase(useCase);
        }

        public Void caseProperty(Property property) {
            Element owner = property.getOwner();
            if (owner instanceof Collaboration) {
                ((Collaboration)owner).getCollaborationRoles().add((Object)property);
            }
            return (Void)super.caseProperty(property);
        }

        public Void caseNamedElement(NamedElement namedElement) {
            namedElement.setName(new ElementDefaultNameProvider().getDefaultName(namedElement, this.parent));
            return (Void)super.caseNamedElement(namedElement);
        }
    }
}

