/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.labels.domains;

import org.eclipse.papyrus.uml.domain.services.labels.INamedElementNameProvider;
import org.eclipse.papyrus.uml.domain.services.labels.domains.ValueSpecificationLabelHelper;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.ValueSpecification;

public class MultiplicityLabelHelper {
    private ValueSpecificationLabelHelper valueSpecificationHelper;

    public MultiplicityLabelHelper(INamedElementNameProvider namedElementNameProvider) {
        this.valueSpecificationHelper = new ValueSpecificationLabelHelper(namedElementNameProvider);
    }

    public String formatMultiplicity(MultiplicityElement element) {
        return this.formatMultiplicity(element, false);
    }

    private String formatMultiplicity(MultiplicityElement element, boolean isEdition) {
        String multiplicityStr = this.formatMultiplicityNoBrackets(element, isEdition);
        if (multiplicityStr == null || multiplicityStr.isEmpty()) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        buffer.append(multiplicityStr);
        buffer.append("]");
        return buffer.toString();
    }

    public String formatMultiplicityNoBrackets(MultiplicityElement element, boolean isEdition) {
        ValueSpecification lowerSpecification = element.getLowerValue();
        ValueSpecification upperSpecification = element.getUpperValue();
        if (lowerSpecification == null && upperSpecification == null) {
            return this.setupMultiplicityAsInteger(element.getLower(), element.getUpper());
        }
        if (lowerSpecification == null && upperSpecification instanceof LiteralUnlimitedNatural) {
            return this.setupMultiplicityAsInteger(element.getLower(), ((LiteralUnlimitedNatural)upperSpecification).unlimitedValue());
        }
        if (lowerSpecification instanceof LiteralInteger && upperSpecification == null) {
            return this.setupMultiplicityAsInteger(((LiteralInteger)lowerSpecification).integerValue(), element.getUpper());
        }
        if (lowerSpecification instanceof LiteralInteger && upperSpecification instanceof LiteralUnlimitedNatural) {
            return this.setupMultiplicityAsInteger(((LiteralInteger)lowerSpecification).integerValue(), ((LiteralUnlimitedNatural)upperSpecification).unlimitedValue());
        }
        return this.setupMultiplicityAsString(element, lowerSpecification, upperSpecification, isEdition);
    }

    private String setupMultiplicityAsInteger(int lower, int upper) {
        if (lower == upper) {
            return String.valueOf(lower);
        }
        if (lower == 0 && upper == -1) {
            return "*";
        }
        if (upper == -1) {
            return lower + "..*";
        }
        return lower + ".." + upper;
    }

    private String setupMultiplicityAsString(MultiplicityElement element, ValueSpecification lower, ValueSpecification upper, boolean isEdition) {
        String lowerStr = this.getStringSpecificationValue(lower, isEdition);
        if ("*".equals(lowerStr)) {
            return "";
        }
        String upperStr = this.getStringSpecificationValue(upper, isEdition);
        if (lowerStr != null && !lowerStr.isEmpty() && lowerStr.equalsIgnoreCase(upperStr)) {
            return lowerStr;
        }
        StringBuffer result = new StringBuffer();
        result.append(lowerStr == null || lowerStr.isEmpty() ? Integer.valueOf(element.getLower()) : lowerStr);
        result.append("..");
        result.append(upperStr == null || upperStr.isEmpty() ? this.getUpper(element) : upperStr);
        return result.toString();
    }

    private String getUpper(MultiplicityElement element) {
        return element.getUpper() == -1 ? "" : String.valueOf(element.getUpper());
    }

    private String getStringSpecificationValue(ValueSpecification valueSpecification, boolean isEdition) {
        String boundStr = this.valueSpecificationHelper.getSpecificationValue(valueSpecification, true);
        if (isEdition && valueSpecification instanceof LiteralString) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("\"");
            buffer.append(boundStr);
            buffer.append("\"");
            boundStr = buffer.toString();
        }
        return boundStr;
    }
}

