/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.labels;

import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.domain.services.labels.INamedElementNameProvider;
import org.eclipse.papyrus.uml.domain.services.labels.IViewLabelProvider;
import org.eclipse.papyrus.uml.domain.services.labels.KeywordLabelProvider;
import org.eclipse.papyrus.uml.domain.services.labels.StereotypeLabelPrefixProvider;
import org.eclipse.papyrus.uml.domain.services.labels.UMLCharacters;
import org.eclipse.papyrus.uml.domain.services.labels.domains.CollaborationUseLabelHelper;
import org.eclipse.papyrus.uml.domain.services.labels.domains.DefaultNamedElementNameProvider;
import org.eclipse.papyrus.uml.domain.services.labels.domains.OperationLabelHelper;
import org.eclipse.papyrus.uml.domain.services.labels.domains.ParameterLabelHelper;
import org.eclipse.papyrus.uml.domain.services.labels.domains.PropertyLabelHelper;
import org.eclipse.papyrus.uml.domain.services.labels.domains.TransitionPropertiesParser;
import org.eclipse.papyrus.uml.domain.services.labels.domains.ValueSpecificationLabelHelper;
import org.eclipse.papyrus.uml.domain.services.labels.domains.VisibilityLabelHelper;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityPartition;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.CollaborationUse;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.CommunicationPath;
import org.eclipse.uml2.uml.ConditionalNode;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Duration;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExpansionKind;
import org.eclipse.uml2.uml.ExpansionRegion;
import org.eclipse.uml2.uml.Expression;
import org.eclipse.uml2.uml.InformationFlow;
import org.eclipse.uml2.uml.JoinNode;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.LiteralSpecification;
import org.eclipse.uml2.uml.LoopNode;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.SequenceNode;
import org.eclipse.uml2.uml.StructuredActivityNode;
import org.eclipse.uml2.uml.TimeExpression;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLSwitch;

public final class ElementLabelProvider
implements IViewLabelProvider {
    private ElementLabelProviderSwitch nameRenderer;
    private final Function<EObject, String> prefixLabelProvider;
    private final Function<EObject, String> keywordLabelProvider;
    private final String prefixSeparator;
    private final String keywordSeparator;

    private ElementLabelProvider(Builder builder) {
        this.prefixLabelProvider = builder.prefixLabelProvider != null ? builder.prefixLabelProvider : e -> null;
        this.keywordLabelProvider = builder.keywordLabelProvider != null ? builder.keywordLabelProvider : e -> null;
        INamedElementNameProvider nameProvider = builder.nameProvider == null ? new DefaultNamedElementNameProvider() : builder.nameProvider;
        this.nameRenderer = new ElementLabelProviderSwitch(nameProvider);
        this.prefixSeparator = builder.prefixSeparator;
        this.keywordSeparator = builder.keywordSeparator;
    }

    public static ElementLabelProvider buildDefault() {
        return ElementLabelProvider.builder().withKeywordLabelProvider(new KeywordLabelProvider()).withNameProvider(new DefaultNamedElementNameProvider()).withPrefixLabelProvider(new StereotypeLabelPrefixProvider()).build();
    }

    @Override
    public String getLabel(EObject element) {
        String baseLabel;
        String prefix;
        if (element == null) {
            return "";
        }
        StringBuilder label = new StringBuilder();
        String keyword = this.keywordLabelProvider.apply(element);
        if (keyword != null && !keyword.isBlank()) {
            label.append(keyword);
        }
        if ((prefix = this.prefixLabelProvider.apply(element)) != null && !prefix.isBlank()) {
            if (label.length() > 0) {
                label.append(this.keywordSeparator);
            }
            label.append(prefix);
        }
        if ((baseLabel = (String)this.nameRenderer.doSwitch(element)) != null && !baseLabel.isBlank()) {
            if (label.length() > 0) {
                label.append(this.prefixSeparator);
            }
            label.append(baseLabel);
        }
        return label.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private INamedElementNameProvider nameProvider;
        private Function<EObject, String> prefixLabelProvider;
        private Function<EObject, String> keywordLabelProvider;
        private String prefixSeparator = UMLCharacters.EOL;
        private String keywordSeparator = UMLCharacters.EOL;

        private Builder() {
        }

        public Builder withNameProvider(INamedElementNameProvider aNameProvider) {
            this.nameProvider = aNameProvider;
            return this;
        }

        public Builder withPrefixLabelProvider(Function<EObject, String> aPrefixLabelProvider) {
            this.prefixLabelProvider = aPrefixLabelProvider;
            return this;
        }

        public Builder withKeywordLabelProvider(Function<EObject, String> aKeywordLabelProvider) {
            this.keywordLabelProvider = aKeywordLabelProvider;
            return this;
        }

        public Builder withPrefixSeparator(String aPrefixSeparator) {
            this.prefixSeparator = aPrefixSeparator;
            return this;
        }

        public Builder withKeywordSeparator(String aKeywordSeparator) {
            this.keywordSeparator = aKeywordSeparator;
            return this;
        }

        public ElementLabelProvider build() {
            return new ElementLabelProvider(this);
        }
    }

    static final class ElementLabelProviderSwitch
    extends UMLSwitch<String> {
        private static final String WEIGHT = "weight";
        private static final String CONDITIONAL = "conditional";
        private static final String SEQUENCE = "sequence";
        private static final String LOOP_NODE = "loop node";
        private static final String STRUCTURED = "structured";
        private static final String JOIN_SPEC = "joinSpec";
        private static final String NATURAL = "NATURAL";
        private static final String NULL_CONSTRAINT = "<NULL Constraint>";
        private CollaborationUseLabelHelper collaborationUseLabelHelper;
        private PropertyLabelHelper propertyLabelHelper;
        private ParameterLabelHelper parameterLabelHelper;
        private INamedElementNameProvider namedElementNameProvider;
        private VisibilityLabelHelper visibilityLabelHelper;
        private ValueSpecificationLabelHelper valueSpecificationHelper;
        private final OperationLabelHelper operationLabelHelper;

        ElementLabelProviderSwitch() {
            this(null);
        }

        ElementLabelProviderSwitch(INamedElementNameProvider namedElementNameProvider) {
            this.namedElementNameProvider = namedElementNameProvider;
            this.visibilityLabelHelper = new VisibilityLabelHelper();
            this.collaborationUseLabelHelper = new CollaborationUseLabelHelper(namedElementNameProvider, this.visibilityLabelHelper);
            this.propertyLabelHelper = new PropertyLabelHelper(false, true, namedElementNameProvider, this.visibilityLabelHelper);
            this.parameterLabelHelper = new ParameterLabelHelper(false, true, namedElementNameProvider);
            this.valueSpecificationHelper = new ValueSpecificationLabelHelper(namedElementNameProvider);
            this.operationLabelHelper = new OperationLabelHelper(this.parameterLabelHelper, this.visibilityLabelHelper, this.namedElementNameProvider);
        }

        public String caseCollaborationUse(CollaborationUse collaborationUse) {
            return this.collaborationUseLabelHelper.getLabel(collaborationUse);
        }

        public String caseComment(Comment comment) {
            return comment.getBody();
        }

        public String caseCommunicationPath(CommunicationPath communicationPath) {
            Object result = "";
            String name = this.namedElementNameProvider.getName((NamedElement)communicationPath);
            if (communicationPath.isDerived()) {
                result = (String)result + "/";
            }
            result = (String)result + name;
            return result;
        }

        public String caseInformationFlow(InformationFlow flow) {
            Object result = "";
            if (flow != null) {
                result = this.getConveyeds((EList<Classifier>)flow.getConveyeds());
                String flowName = this.namedElementNameProvider.getName((NamedElement)flow);
                if (flowName != null && !flowName.isBlank()) {
                    if (!((String)result).isBlank()) {
                        result = (String)result + UMLCharacters.EOL;
                    }
                    result = (String)result + flowName;
                }
            }
            return result;
        }

        private String getConveyeds(EList<Classifier> conveyeds) {
            Object result = "";
            if (!conveyeds.isEmpty()) {
                result = (String)result + conveyeds.stream().map(NamedElement::getName).collect(Collectors.joining(", "));
            }
            return result;
        }

        public String caseNamedElement(NamedElement object) {
            return this.namedElementNameProvider.getName(object);
        }

        public String caseRegion(Region object) {
            return "";
        }

        public String caseProperty(Property property) {
            return this.propertyLabelHelper.getLabel(property);
        }

        public String caseParameter(Parameter parameter) {
            return this.parameterLabelHelper.getLabel(parameter);
        }

        public String caseConstraint(Constraint constraint) {
            StringBuilder constLabel = new StringBuilder();
            String body = "";
            String lang = "";
            ValueSpecification valueSpec = constraint.getSpecification();
            constLabel.append(constraint.getName());
            constLabel.append(UMLCharacters.EOL);
            constLabel.append("{");
            if (valueSpec == null) {
                constLabel.append(NULL_CONSTRAINT);
            } else if (valueSpec instanceof OpaqueExpression) {
                OpaqueExpression opaqueEsp = (OpaqueExpression)valueSpec;
                if (!opaqueEsp.getBodies().isEmpty() && !opaqueEsp.getLanguages().isEmpty()) {
                    body = (String)opaqueEsp.getBodies().get(0);
                    lang = (String)opaqueEsp.getLanguages().get(0);
                    constLabel.append("{");
                    constLabel.append(lang);
                    constLabel.append("}");
                    constLabel.append(" ");
                    constLabel.append(body);
                } else {
                    constLabel.append("{");
                    constLabel.append(NATURAL);
                    constLabel.append("}");
                    constLabel.append(" ");
                }
            }
            constLabel.append("}");
            return constLabel.toString();
        }

        public String caseOperation(Operation operation) {
            return this.operationLabelHelper.getLabel(operation);
        }

        public String caseTimeExpression(TimeExpression timeExpression) {
            StringBuilder constLabel = new StringBuilder();
            constLabel.append(this.namedElementNameProvider.getName((NamedElement)timeExpression));
            ValueSpecification expr = timeExpression.getExpr();
            if (expr != null) {
                constLabel.append("=");
                constLabel.append(this.valueSpecificationHelper.getSpecificationValue(expr, true));
            }
            return constLabel.toString();
        }

        public String caseDuration(Duration duration) {
            StringBuilder constLabel = new StringBuilder();
            constLabel.append(this.namedElementNameProvider.getName((NamedElement)duration));
            ValueSpecification expr = duration.getExpr();
            if (expr != null) {
                constLabel.append("=");
                constLabel.append(this.valueSpecificationHelper.getSpecificationValue(expr, true));
            }
            return constLabel.toString();
        }

        public String caseActivityPartition(ActivityPartition activityPartition) {
            Element representedElement = activityPartition.getRepresents();
            String label = representedElement instanceof NamedElement ? this.namedElementNameProvider.getName((NamedElement)representedElement) : (String)super.caseActivityPartition(activityPartition);
            return label;
        }

        public String caseTransition(Transition transition) {
            return new TransitionPropertiesParser(this.namedElementNameProvider).getValueString(transition);
        }

        public String caseExpansionRegion(ExpansionRegion expansionRegion) {
            ExpansionKind mode = expansionRegion.getMode();
            return "\u00ab" + mode.getName() + "\u00bb";
        }

        public String caseJoinNode(JoinNode joinNode) {
            StringBuilder constLabel = new StringBuilder();
            ValueSpecification joinSpec = joinNode.getJoinSpec();
            if (joinSpec != null) {
                constLabel.append("{");
                constLabel.append(JOIN_SPEC);
                constLabel.append(" = ");
                constLabel.append(this.valueSpecificationHelper.getSpecificationValue(joinSpec, true));
                constLabel.append("}");
                constLabel.append(UMLCharacters.EOL);
            }
            constLabel.append(this.namedElementNameProvider.getName((NamedElement)joinNode));
            return constLabel.toString();
        }

        public String caseStructuredActivityNode(StructuredActivityNode structuredActivityNode) {
            return "\u00abstructured\u00bb";
        }

        public String caseLoopNode(LoopNode loopNode) {
            return "\u00abloop node\u00bb";
        }

        public String caseSequenceNode(SequenceNode sequenceNode) {
            return "\u00absequence\u00bb";
        }

        public String caseConditionalNode(ConditionalNode conditionalNode) {
            return "\u00abconditional\u00bb";
        }

        public String caseLifeline(Lifeline lifeline) {
            StringBuilder lifelineLabel = new StringBuilder();
            ConnectableElement connectableElement = lifeline.getRepresents();
            ValueSpecification selector = lifeline.getSelector();
            if (connectableElement == null) {
                String lifelineName;
                if (!(selector instanceof LiteralSpecification || selector instanceof Expression || selector instanceof OpaqueExpression || selector instanceof TimeExpression || (lifelineName = this.namedElementNameProvider.getName((NamedElement)lifeline)) == null)) {
                    lifelineLabel.append(lifelineName);
                }
            } else {
                Type type;
                String connectableElementName = this.namedElementNameProvider.getName((NamedElement)connectableElement);
                if (connectableElement != null) {
                    lifelineLabel.append(connectableElementName);
                }
                if (selector != null && selector instanceof LiteralSpecification) {
                    lifelineLabel.append("[");
                    lifelineLabel.append(this.valueSpecificationHelper.getSpecificationValue(selector, true));
                    lifelineLabel.append("]");
                }
                if ((type = connectableElement.getType()) != null && type.getName() != null && type.getName().length() > 0) {
                    lifelineLabel.append(" ");
                    lifelineLabel.append(":");
                    lifelineLabel.append(" ");
                    lifelineLabel.append(this.namedElementNameProvider.getName((NamedElement)type));
                }
            }
            return lifelineLabel.toString();
        }

        public String caseActivityEdge(ActivityEdge activityEdge) {
            StringBuilder objectFlowStringBuilder = new StringBuilder();
            ValueSpecification weight = activityEdge.getWeight();
            ValueSpecification guard = activityEdge.getGuard();
            objectFlowStringBuilder.append(this.namedElementNameProvider.getName((NamedElement)activityEdge));
            if (weight != null) {
                if (!objectFlowStringBuilder.isEmpty()) {
                    objectFlowStringBuilder.append(UMLCharacters.EOL);
                }
                objectFlowStringBuilder.append("{");
                objectFlowStringBuilder.append("weight=");
                objectFlowStringBuilder.append(this.valueSpecificationHelper.getSpecificationValue(weight, true));
                objectFlowStringBuilder.append("}");
            }
            if (guard != null) {
                if (!objectFlowStringBuilder.isEmpty()) {
                    objectFlowStringBuilder.append(UMLCharacters.EOL);
                }
                objectFlowStringBuilder.append("[");
                objectFlowStringBuilder.append(this.valueSpecificationHelper.getSpecificationValue(guard, true));
                objectFlowStringBuilder.append("]");
            }
            return objectFlowStringBuilder.toString();
        }
    }
}

