/**
 * Copyright (c) 2022 CEA LIST.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.papyrus.designer.transformation.library.xtend;

import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.uml.tools.utils.OperationUtils;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class StructBasedMarshalling {
  public static CharSequence marshall(final Operation operation) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("struct ParamData {");
    _builder.newLine();
    {
      EList<Parameter> _parametersInInout = OperationUtils.parametersInInout(operation);
      for(final Parameter parameter : _parametersInInout) {
        _builder.append("\t");
        CharSequence _cppType = CppUtils.cppType(parameter.getType());
        _builder.append(_cppType, "\t");
        _builder.append(" ");
        String _name = parameter.getName();
        _builder.append(_name, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("};");
    _builder.newLine();
    _builder.append("Event event;");
    _builder.newLine();
    _builder.append("event.ID = [operation.name/];");
    _builder.newLine();
    _builder.append("event.kind = CallEvent;");
    _builder.newLine();
    _builder.append("ParamData * data = &event.params;");
    _builder.newLine();
    {
      EList<Parameter> _parametersInInout_1 = OperationUtils.parametersInInout(operation);
      for(final Parameter parameter_1 : _parametersInInout_1) {
        _builder.append("data->[parameter.name/] = [parameter.name/];");
        _builder.newLine();
      }
    }
    _builder.append("out->dispatch(event);");
    _builder.newLine();
    return _builder;
  }
}
