/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.realtime.pycpa.ui.json;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.json.provisonnal.com.eclipsesource.json.JsonObject;
import org.eclipse.json.provisonnal.com.eclipsesource.json.JsonValue;
import org.eclipse.papyrus.MARTE.MARTE_AnalysisModel.SAM.SaStep;
import org.eclipse.papyrus.designer.realtime.pycpa.ui.Activator;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityPartition;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.util.UMLUtil;

public class JsonBackpropagation {
    public static void backpropagateResult(IFile jsonResultsFile, Activity marteActivity) {
        try {
            FileReader jsonReader = new FileReader(jsonResultsFile.getRawLocation().makeAbsolute().toFile());
            JsonObject jsonResult = JsonObject.readFrom((Reader)jsonReader);
            for (JsonValue jsonTask : jsonResult.get("task").asArray()) {
                String jsonTaskName = jsonTask.asObject().getString("name", "");
                final int jsonWcrt = jsonTask.asObject().getInt("wcrt", 0);
                final int jsonBcrt = jsonTask.asObject().getInt("bcrt", 0);
                if (jsonTaskName.isEmpty()) continue;
                for (final Element activityOwnedElement : marteActivity.allOwnedElements()) {
                    SaStep saStep;
                    if (!(activityOwnedElement instanceof ActivityPartition) || !((ActivityPartition)activityOwnedElement).getName().equals(jsonTaskName) || (saStep = (SaStep)UMLUtil.getStereotypeApplication((Element)activityOwnedElement, SaStep.class)) == null) continue;
                    final ConfigureRequest configureRequest = new ConfigureRequest((EObject)activityOwnedElement, (IElementType)UMLElementTypes.ACTIVITY_PARTITION);
                    ConfigureElementCommand configureCommand = new ConfigureElementCommand(configureRequest){

                        protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                            ActivityPartition activityPartition = (ActivityPartition)configureRequest.getElementToConfigure();
                            SaStep saStep = (SaStep)UMLUtil.getStereotypeApplication((Element)activityOwnedElement, SaStep.class);
                            saStep.getRespT().clear();
                            saStep.getRespT().add((Object)("wcrt=" + jsonWcrt));
                            saStep.getRespT().add((Object)("bcrt=" + jsonBcrt));
                            return CommandResult.newOKCommandResult((Object)activityPartition);
                        }
                    };
                    try {
                        configureCommand.execute(null, null);
                    }
                    catch (ExecutionException e) {
                        Activator.log.error((Throwable)e);
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            Activator.log.error((Throwable)e);
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
        catch (UnsupportedOperationException e) {
            Activator.log.error((Throwable)e);
        }
    }
}

