/**
 * Copyright (c) 2006 - 2016 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Shuai Li (CEA LIST) <shuai.li@cea.fr> - initial API and implementation
 */
package org.eclipse.papyrus.designer.languages.java.codegen.xtend;

import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.java.profile.PapyrusJava.Import;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class JavaImportUtil {
  public static String importDirective(final String path) {
    if (((path != null) && (path.length() > 0))) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("import ");
      String _plus = (_builder.toString() + path);
      return (_plus + ";");
    }
    return null;
  }

  public static String javaImport(final NamedElement ne) {
    boolean _hasStereotype = GenUtils.hasStereotype(ne, Import.class);
    if (_hasStereotype) {
      final Import import_ = UMLUtil.<Import>getStereotypeApplication(ne, Import.class);
      String header = import_.getManualImports();
      if (((header != null) && (header.length() > 0))) {
        CharSequence _constImportStart = JavaImportUtil.constImportStart();
        String _cleanCR = GenUtils.cleanCR(header);
        String _plus = (_constImportStart + _cleanCR);
        String _plus_1 = (_plus + "\n");
        CharSequence _constImportEnd = JavaImportUtil.constImportEnd();
        String includeHeader = (_plus_1 + _constImportEnd);
        return includeHeader;
      }
    }
    return null;
  }

  public static CharSequence constImportStart() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("// Manual imports");
    _builder.newLine();
    return _builder;
  }

  public static CharSequence constImportEnd() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("// End of manual imports");
    _builder.newLine();
    return _builder;
  }
}
