/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.codegen.utils;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.papyrus.designer.infra.base.ScopedPreferences;
import org.eclipse.papyrus.designer.languages.common.base.AutoLanguageProjectSupport;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.ILangProjectSupport;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.Project;
import org.eclipse.papyrus.designer.uml.tools.utils.PackageUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.util.UMLUtil;

public class LocateCppProject {
    public static IProject getTargetProject(PackageableElement pe, boolean createIfMissing) {
        IProject modelProject;
        Package rootPkg = PackageUtil.getRootPackage((Element)pe);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        ScopedPreferences prefs = new ScopedPreferences("org.eclipse.papyrus.designer.languages.cpp.codegen");
        String prefix = prefs != null ? prefs.get("projectPrefix", "org.eclipse.papyrus.cppgen.") : "bad preferences.";
        Project projectStereo = (Project)UMLUtil.getStereotypeApplication((Element)rootPkg, Project.class);
        Object projectName = null;
        if (projectStereo != null) {
            projectName = projectStereo.getProjectName();
        }
        if (projectName == null) {
            projectName = prefix + rootPkg.getName();
        }
        if (!(modelProject = root.getProject((String)projectName)).exists()) {
            String languageName = "C++";
            if (createIfMissing) {
                ILangProjectSupport langSupport = AutoLanguageProjectSupport.getProjectSupport((String)languageName);
                if (langSupport != null) {
                    modelProject = langSupport.createProject((String)projectName);
                    langSupport.setSettings(modelProject, langSupport.initialConfigurationData());
                    if (modelProject == null) {
                        return null;
                    }
                } else {
                    return null;
                }
            }
        }
        if (!modelProject.isOpen()) {
            try {
                modelProject.open(null);
            }
            catch (CoreException e) {
                return null;
            }
        }
        return modelProject;
    }
}

