/*******************************************************************************
 * Copyright (c) 2020 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * Contributors:
 *     CEA LIST - initial API and implementation
 *******************************************************************************/

package org.eclipse.papyrus.designer.languages.c.codegen.lib

import java.io.File
import org.eclipse.papyrus.designer.languages.common.base.GenUtils
import org.eclipse.uml2.uml.Class
import org.eclipse.uml2.uml.Comment
import org.eclipse.uml2.uml.Element
import org.eclipse.uml2.uml.Feature
import org.eclipse.uml2.uml.NamedElement
import org.eclipse.uml2.uml.Operation
import org.eclipse.uml2.uml.PackageImport
import org.eclipse.uml2.uml.RedefinableElement
import org.eclipse.uml2.uml.VisibilityKind
import org.eclipse.uml2.uml.profile.standard.ModelLibrary

import static extension org.eclipse.papyrus.designer.languages.common.base.GenUtils.*

class CommonScript {
	def static genHeading(NamedElement namedElement) '''
		/* 
		 * File generated from the «namedElement.qualifiedName» uml class
		 * Generated by the Papyrus C Generator (CEA LIST) 
		 *
		 */
	'''
	//* $ Date : «namedElement.getShortDate» «namedElement.getTime()» («namedElement.getLongDate()») $

	def static packagePath(NamedElement element) '''
		«element.qualifiedName.replace('.', File.separator)»
	'''


	def static genComment(Element element) {
		var commentText = ""; //$NON-NLS-1$
		for (Comment comment : element.ownedComments) {
			// remove eventual CRs (avoid confusion in Acceleo template which adds " *" after line breaks)
			commentText += GenUtils.cleanCR(comment.getBody());
		}
		
		'''
		/**
		 * «commentText.replaceAll('\n', '\n * ')»
		 */
		'''
	}


	def static genAbstract(Class clazz) '''
		«IF (clazz.isAbstract)»abstract «ENDIF»
	'''


	def static genAbstract(Operation operation) '''
		«IF (operation.isAbstract)»abstract «ENDIF»
	'''


	def static genFinal(RedefinableElement redefinableElement) '''
		«IF (redefinableElement.isLeaf)»final «ENDIF»
	'''


	def static genStatic(Feature feature) '''
		«IF (feature.isStatic)»static «ENDIF»
	'''


	def static HeaderPackageImportTemplate(PackageImport packageImport) '''
		«IF (packageImport.importedPackage.hasStereotype(ModelLibrary))»
			#include <«packageImport.importedPackage.name».h> 
		«ELSE»
			#include «packageImport.importedPackage.name».h
		«ENDIF»
	'''


	def static genName(NamedElement namedElement) '''
		«namedElement.genVisibility»«namedElement.genCoreName()»'''


	def static genCoreName(NamedElement namedElement) {
		'''«namedElement.name.replaceAll("/|\\.|~", "_")»'''
	}


	def static genVisibility(NamedElement namedElement) {
		'''«IF (namedElement.visibility == VisibilityKind.PRIVATE_LITERAL)»
			/* private */
		«ELSEIF (namedElement.visibility == VisibilityKind.PROTECTED_LITERAL)»
			/* protected */
		«ENDIF»'''.toString.trim
	}


	def static genIncludeSelf(NamedElement namedElement) '''
		/* include header file*/
		#include "«namedElement.genName».h"
	'''
}
