/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.components.transformation.commands;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.designer.transformation.base.utils.LibraryUtils;
import org.eclipse.papyrus.designer.transformation.base.utils.StdModelLibs;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;

public class AddStdModelLibs
extends RecordingCommand {
    public static final String CMD_LABEL = "Add Designer CORE libraries";
    protected EList<PackageImport> importList;
    protected EList<PackageImport> availableImportPackages;
    protected Package selectedPkg;

    public AddStdModelLibs(Package pkg, TransactionalEditingDomain domain) {
        super(domain, CMD_LABEL);
        this.selectedPkg = pkg;
        this.availableImportPackages = null;
        this.importList = null;
    }

    boolean isAlreadyImported(Package selectedPkg, PackageImport pi) {
        for (PackageImport existingPI : selectedPkg.getPackageImports()) {
            if (existingPI.getImportedPackage() == null || pi.getImportedPackage() == null || existingPI.getImportedPackage().getName() == null || pi.getImportedPackage().getName() == null || !existingPI.getImportedPackage().getName().equals(pi.getImportedPackage().getName())) continue;
            return true;
        }
        return false;
    }

    public EList<PackageImport> getAvailableImportPackages() {
        if (this.availableImportPackages != null) {
            return this.availableImportPackages;
        }
        ResourceSet resourceSet = this.selectedPkg.eResource().getResourceSet();
        this.availableImportPackages = new BasicEList();
        PackageImport pi = LibraryUtils.getModelLibraryImportFromURI((URI)StdModelLibs.DESIGNER_TRAFOLIB_URI, (ResourceSet)resourceSet);
        if (pi != null) {
            this.availableImportPackages.add((Object)pi);
        }
        if ((pi = LibraryUtils.getModelLibraryImportFromURI((URI)StdModelLibs.DESIGNER_MARTE_CALLS_URI, (ResourceSet)resourceSet)) != null) {
            this.availableImportPackages.add((Object)pi);
        }
        return this.availableImportPackages;
    }

    public EList<PackageImport> getAlreadyImportedPackages() {
        EList<PackageImport> availablePackages = this.getAvailableImportPackages();
        BasicEList selection = new BasicEList();
        for (PackageImport pi : availablePackages) {
            if (!this.isAlreadyImported(this.selectedPkg, pi)) continue;
            selection.add((Object)pi);
        }
        return selection;
    }

    public void setImportList(EList<PackageImport> importList) {
        this.importList = importList;
    }

    public void setImportList(Object[] importArray) {
        this.importList = new BasicEList();
        Object[] objectArray = importArray;
        int n = importArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object importPkg = objectArray[n2];
            if (importPkg instanceof PackageImport) {
                this.importList.add((Object)((PackageImport)importPkg));
            }
            ++n2;
        }
    }

    protected void doExecute() {
        for (PackageImport pi : this.importList) {
            if (this.isAlreadyImported(this.selectedPkg, pi)) continue;
            this.selectedPkg.getPackageImports().add((Object)pi);
        }
    }
}

