/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.components.transformation.cpp.xtend;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.components.transformation.PortInfo;
import org.eclipse.papyrus.designer.components.transformation.PortUtils;
import org.eclipse.papyrus.designer.components.transformation.component.PrefixConstants;
import org.eclipse.papyrus.designer.components.transformation.cpp.Messages;
import org.eclipse.papyrus.designer.components.transformation.cpp.xtend.CppUtils;
import org.eclipse.papyrus.designer.components.transformation.extensions.IOOTrafo;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Ptr;
import org.eclipse.papyrus.designer.transformation.base.utils.CopyUtils;
import org.eclipse.papyrus.designer.transformation.base.utils.PartsUtil;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.transformations.LazyCopier;
import org.eclipse.papyrus.designer.uml.tools.utils.ConnectorUtil;
import org.eclipse.papyrus.designer.uml.tools.utils.ElementUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EncapsulatedClassifier;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.xtend2.lib.StringConcatenation;

public class DynamicCppToOO
implements IOOTrafo {
    protected LazyCopier copier;
    private static final String PART_MANAGER = "services::PartManager";
    private static final String INIT_PARTS = "initParts";
    private static final String PARTS = "parts";
    private static final String progLang = "C/C++";
    protected Class bootloader;

    public void init(LazyCopier copier, Class bootloader) {
        PrefixConstants.init((PrefixConstants.CIFvariant)PrefixConstants.CIFvariant.UML);
        this.copier = copier;
        this.bootloader = bootloader;
    }

    public void addPortOperations(Class implementation) {
        this.addGetPortOperation(implementation);
        DynamicCppToOO.addConnectPortOperation(implementation);
    }

    public void addGetPortOperation(Class implementation) {
        EList _flattenExtendedPorts = PortUtils.flattenExtendedPorts((EList)PortUtils.getAllPorts2((EncapsulatedClassifier)implementation));
        for (PortInfo portInfo : _flattenExtendedPorts) {
            Interface providedIntf = portInfo.getProvided();
            if (providedIntf == null) continue;
            String _name = portInfo.getName();
            String opName = PrefixConstants.getP_Prefix + _name;
            Operation op = implementation.getOwnedOperation(opName, null, null);
            if (op != null) {
                boolean _notEquals;
                Type _type = op.getType();
                boolean bl = _notEquals = !Objects.equals(_type, providedIntf);
                if (!_notEquals) continue;
                op.createOwnedParameter("ret", (Type)providedIntf);
                continue;
            }
            op = implementation.createOwnedOperation(opName, null, null, (Type)providedIntf);
            Parameter retParam = (Parameter)op.getOwnedParameters().get(0);
            retParam.setName("ret");
            StereotypeUtil.apply((Element)retParam, Ptr.class);
            Behavior _createOwnedBehavior = implementation.createOwnedBehavior(opName, UMLPackage.eINSTANCE.getOpaqueBehavior());
            OpaqueBehavior behavior = (OpaqueBehavior)_createOwnedBehavior;
            op.getMethods().add((Object)behavior);
            ConnectorEnd ce = ConnectorUtil.getDelegation((Class)implementation, (Port)portInfo.getModelPort());
            Object body = null;
            if (ce != null) {
                Property part = ce.getPartWithPort();
                ConnectableElement role = ce.getRole();
                body = "return ";
                if (role instanceof Port) {
                    String _body = body;
                    StringConcatenation _builder = new StringConcatenation();
                    String _nameRef = CppUtils.nameRef(part);
                    _builder.append(_nameRef);
                    _builder.append(PrefixConstants.getP_Prefix);
                    String _name_1 = ((Port)role).getName();
                    _builder.append(_name_1);
                    _builder.append("();");
                    body = _body + String.valueOf(_builder);
                } else {
                    String _body_1 = body;
                    String _name_2 = role.getName();
                    body = _body_1 + _name_2;
                }
            } else {
                boolean implementsIntf;
                InterfaceRealization _interfaceRealization = implementation.getInterfaceRealization(null, providedIntf);
                boolean bl = implementsIntf = _interfaceRealization != null;
                if (!implementsIntf) {
                    boolean _tripleNotEquals;
                    Interface providedIntfInCopy = (Interface)this.copier.getCopy((Element)providedIntf);
                    InterfaceRealization _interfaceRealization_1 = implementation.getInterfaceRealization(null, providedIntfInCopy);
                    implementsIntf = _tripleNotEquals = _interfaceRealization_1 != null;
                }
                if (implementsIntf) {
                    body = "return this;";
                } else {
                    String _format = String.format(Messages.CompImplTrafos_IntfNotImplemented, providedIntf.getName(), portInfo.getPort().getName(), implementation.getName());
                    throw new RuntimeException(_format);
                }
            }
            behavior.getLanguages().add((Object)progLang);
            behavior.getBodies().add(body);
        }
    }

    public static void addConnectPortOperation(Class implementation) {
        EList _flattenExtendedPorts = PortUtils.flattenExtendedPorts((EList)PortUtils.getAllPorts2((EncapsulatedClassifier)implementation));
        for (PortInfo portInfo : _flattenExtendedPorts) {
            boolean _tripleNotEquals;
            Interface requiredIntf = portInfo.getRequired();
            if (requiredIntf == null) continue;
            String _name = portInfo.getName();
            String opName = PrefixConstants.connectQ_Prefix + _name;
            Operation _ownedOperation = implementation.getOwnedOperation(opName, null, null);
            boolean bl = _tripleNotEquals = _ownedOperation != null;
            if (_tripleNotEquals) continue;
            Operation op = implementation.createOwnedOperation(opName, null, null);
            Parameter refParam = op.createOwnedParameter("ref", (Type)requiredIntf);
            StereotypeUtil.apply((Element)refParam, Ptr.class);
            Comment comment = refParam.createOwnedComment();
            comment.setBody("Reference to provided port");
            Behavior _createOwnedBehavior = implementation.createOwnedBehavior(opName, UMLPackage.eINSTANCE.getOpaqueBehavior());
            OpaqueBehavior behavior = (OpaqueBehavior)_createOwnedBehavior;
            op.getMethods().add((Object)behavior);
            ConnectorEnd ce = ConnectorUtil.getDelegation((Class)implementation, (Port)portInfo.getModelPort());
            Object body = null;
            if (ce != null) {
                Property part = ce.getPartWithPort();
                body = part.getName();
                ConnectableElement role = ce.getRole();
                if (role instanceof Port) {
                    String _name_1 = ((Port)role).getName();
                    String targetOpName = PrefixConstants.connectQ_Prefix + _name_1;
                    StringConcatenation _builder = new StringConcatenation();
                    String _nameRef = CppUtils.nameRef(part);
                    _builder.append(_nameRef);
                    _builder.append(targetOpName);
                    _builder.append("(ref)");
                    body = _builder.toString();
                } else {
                    String _body = body;
                    StringConcatenation _builder_1 = new StringConcatenation();
                    String _name_2 = part.getName();
                    _builder_1.append(_name_2);
                    _builder_1.append(";");
                    body = _body + String.valueOf(_builder_1);
                }
            } else {
                String _name_3 = portInfo.getName();
                String attributeName = PrefixConstants.attributePrefix + _name_3;
                Property attr = implementation.getOwnedAttribute(attributeName, null);
                if (attr == null || attr instanceof Port) {
                    attr = implementation.createOwnedAttribute(attributeName, (Type)requiredIntf);
                    CopyUtils.copyMultElemModifiers((MultiplicityElement)portInfo.getPort(), (MultiplicityElement)attr);
                    attr.setAggregation(AggregationKind.SHARED_LITERAL);
                }
                Object _body_1 = body = attributeName;
                body = (String)_body_1 + " = ref;";
            }
            behavior.getLanguages().add((Object)progLang);
            behavior.getBodies().add(body);
            if (PrefixConstants.getConnQ_Prefix.length() <= 0 || ce == null) continue;
            String _name_4 = portInfo.getName();
            String getConnOpName = PrefixConstants.getConnQ_Prefix + _name_4;
            Operation getConnOp = implementation.getOwnedOperation(getConnOpName, null, null);
            if (getConnOp == null) {
                getConnOp = implementation.createOwnedOperation(getConnOpName, null, null, (Type)requiredIntf);
                Parameter retParam = (Parameter)op.getOwnedParameters().get(0);
                retParam.setName("ret");
                StereotypeUtil.apply((Element)retParam, Ptr.class);
            }
            Behavior _createOwnedBehavior_1 = implementation.createOwnedBehavior(getConnOpName, UMLPackage.eINSTANCE.getOpaqueBehavior());
            OpaqueBehavior getConnBehavior = (OpaqueBehavior)_createOwnedBehavior_1;
            getConnOp.getMethods().add((Object)getConnBehavior);
            String _name_5 = portInfo.getName();
            String name = PrefixConstants.attributePrefix + _name_5;
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("return ");
            _builder_2.append(name);
            _builder_2.append(";");
            body = _builder_2.toString();
            behavior.getLanguages().add((Object)progLang);
            behavior.getBodies().add(body);
        }
    }

    public void addConnectionOperation(Class compositeImplementation) throws TransformationException {
        boolean _greaterThan;
        Object createConnBody = "";
        HashMap<ConnectorEnd, Integer> indexMap = new HashMap<ConnectorEnd, Integer>();
        EList _ownedConnectors = compositeImplementation.getOwnedConnectors();
        for (Connector connector : _ownedConnectors) {
            boolean _notEquals;
            boolean _isAssembly = ConnectorUtil.isAssembly((Connector)connector);
            if (!_isAssembly) continue;
            int _size = connector.getEnds().size();
            boolean bl = _notEquals = _size != 2;
            if (_notEquals) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Connector <");
                String _name = connector.getName();
                _builder.append(_name);
                _builder.append("> does not have two ends. This is currently not supported");
                throw new TransformationException(_builder.toString());
            }
            ConnectorEnd end1 = (ConnectorEnd)connector.getEnds().get(0);
            ConnectorEnd end2 = (ConnectorEnd)connector.getEnds().get(1);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("// realization of connector <");
            String _name_1 = connector.getName();
            _builder_1.append(_name_1);
            _builder_1.append(">\\n");
            Object cmd = _builder_1.toString();
            if (end1.getRole() instanceof Port && PortUtils.isExtendedPort((Port)((Port)end1.getRole()))) {
                ConnectableElement _role = end1.getRole();
                Port port = (Port)_role;
                EList subPorts = PortUtils.flattenExtendedPort((Port)port);
                for (PortInfo subPort : subPorts) {
                    Object _cmd = cmd;
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("  ");
                    _builder_2.append("// realization of connection for sub-port ");
                    String _name_2 = subPort.getPort().getName();
                    _builder_2.append(_name_2, "  ");
                    _builder_2.append("\\n");
                    Object _cmd_1 = cmd = (String)_cmd + String.valueOf(_builder_2);
                    String _connectPorts = DynamicCppToOO.connectPorts(indexMap, connector, end1, end2, subPort.getPort());
                    Object _cmd_2 = cmd = (String)_cmd_1 + _connectPorts;
                    String _connectPorts_1 = DynamicCppToOO.connectPorts(indexMap, connector, end2, end1, subPort.getPort());
                    cmd = (String)_cmd_2 + _connectPorts_1;
                }
            } else {
                String _cmd = cmd;
                String _connectPorts = DynamicCppToOO.connectPorts(indexMap, connector, end1, end2, null);
                Object _cmd_1 = cmd = _cmd + _connectPorts;
                String _connectPorts_1 = DynamicCppToOO.connectPorts(indexMap, connector, end2, end1, null);
                cmd = (String)_cmd_1 + _connectPorts_1;
            }
            String _createConnBody = createConnBody;
            createConnBody = _createConnBody + (String)cmd + "\n";
        }
        int _length = ((String)createConnBody).length();
        boolean bl = _greaterThan = _length > 0;
        if (_greaterThan) {
            Operation operation = compositeImplementation.createOwnedOperation("createConnections", null, null);
            Behavior _createOwnedBehavior = compositeImplementation.createOwnedBehavior(operation.getName(), UMLPackage.eINSTANCE.getOpaqueBehavior());
            OpaqueBehavior behavior = (OpaqueBehavior)_createOwnedBehavior;
            behavior.getLanguages().add((Object)progLang);
            behavior.getBodies().add(createConnBody);
            behavior.setSpecification((BehavioralFeature)operation);
        }
    }

    public static String connectPorts(Map<ConnectorEnd, Integer> indexMap, Connector connector, ConnectorEnd receptacleEnd, ConnectorEnd facetEnd, Port subPort) throws TransformationException {
        Association association = connector.getType();
        if (receptacleEnd.getRole() instanceof Port && facetEnd.getRole() instanceof Port) {
            ConnectableElement _role = facetEnd.getRole();
            Port facetPort = (Port)_role;
            ConnectableElement _role_1 = receptacleEnd.getRole();
            Port receptaclePort = (Port)_role_1;
            PortInfo facetPI = PortInfo.fromSubPort((Port)facetPort, (Port)subPort);
            PortInfo receptaclePI = PortInfo.fromSubPort((Port)receptaclePort, (Port)subPort);
            if (facetPI.getProvided() != null && receptaclePI.getRequired() != null) {
                Property facetPart = facetEnd.getPartWithPort();
                Property receptaclePart = receptacleEnd.getPartWithPort();
                Object subPortName = "";
                if (subPort != null) {
                    String _subPortName = subPortName;
                    String _name = subPort.getName();
                    String _plus = "_" + _name;
                    subPortName = _subPortName + _plus;
                }
                String indexName = DynamicCppToOO.getIndexName(indexMap, receptaclePort, receptacleEnd);
                StringConcatenation _builder = new StringConcatenation();
                String _nameRef = CppUtils.nameRef(receptaclePart);
                _builder.append(_nameRef);
                _builder.append("connect_");
                String _name_1 = receptaclePort.getName();
                _builder.append(_name_1);
                _builder.append(" ");
                _builder.append((String)subPortName);
                _builder.append(";");
                String setter = _builder.toString();
                StringConcatenation _builder_1 = new StringConcatenation();
                String _nameRef_1 = CppUtils.nameRef(facetPart);
                _builder_1.append(_nameRef_1);
                _builder_1.append("get_");
                String _name_2 = facetPort.getName();
                _builder_1.append(_name_2);
                _builder_1.append(" ");
                _builder_1.append((String)subPortName);
                _builder_1.append("()");
                String getter = _builder_1.toString();
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append(setter);
                _builder_2.append("(");
                _builder_2.append(indexName);
                _builder_2.append(getter);
                _builder_2.append(");\\n");
                return _builder_2.toString();
            }
        } else {
            ConnectableElement _role_2 = receptacleEnd.getRole();
            if (_role_2 instanceof Port) {
                boolean _tripleNotEquals;
                ConnectableElement _role_3 = receptacleEnd.getRole();
                Port receptaclePort_1 = (Port)_role_3;
                Interface _required = PortUtils.getRequired((Port)receptaclePort_1);
                boolean bl = _tripleNotEquals = _required != null;
                if (_tripleNotEquals) {
                    ConnectableElement _role_4 = facetEnd.getRole();
                    Property facetPart_1 = (Property)_role_4;
                    Property receptaclePart_1 = facetEnd.getPartWithPort();
                    String indexName_1 = DynamicCppToOO.getIndexName(indexMap, receptaclePort_1, receptacleEnd);
                    StringConcatenation _builder_3 = new StringConcatenation();
                    String _nameRef_2 = CppUtils.nameRef(receptaclePart_1);
                    _builder_3.append(_nameRef_2);
                    _builder_3.append("connect_");
                    String _name_3 = receptaclePort_1.getName();
                    _builder_3.append(_name_3);
                    String setter_1 = _builder_3.toString();
                    StringConcatenation _builder_4 = new StringConcatenation();
                    _builder_4.append("&");
                    String _name_4 = facetPart_1.getName();
                    _builder_4.append(_name_4);
                    String getter_1 = _builder_4.toString();
                    StringConcatenation _builder_5 = new StringConcatenation();
                    _builder_5.append(setter_1);
                    _builder_5.append("(");
                    _builder_5.append(indexName_1);
                    _builder_5.append(getter_1);
                    _builder_5.append(");\\n");
                    return _builder_5.toString();
                }
            } else {
                ConnectableElement _role_5 = facetEnd.getRole();
                if (_role_5 instanceof Port) {
                    boolean _tripleNotEquals_1;
                    ConnectableElement _role_6 = facetEnd.getRole();
                    Port facetPort_1 = (Port)_role_6;
                    Interface _provided = PortUtils.getProvided((Port)facetPort_1);
                    boolean bl = _tripleNotEquals_1 = _provided != null;
                    if (_tripleNotEquals_1) {
                        Property facetPart_2 = facetEnd.getPartWithPort();
                        ConnectableElement _role_7 = facetEnd.getRole();
                        Property receptaclePart_2 = (Property)_role_7;
                        String setter_2 = receptaclePart_2.getName();
                        StringConcatenation _builder_6 = new StringConcatenation();
                        String _nameRef_3 = CppUtils.nameRef(facetPart_2);
                        _builder_6.append(_nameRef_3);
                        _builder_6.append("get_");
                        String _name_5 = facetPort_1.getName();
                        _builder_6.append(_name_5);
                        _builder_6.append("();");
                        String getter_2 = _builder_6.toString();
                        StringConcatenation _builder_7 = new StringConcatenation();
                        _builder_7.append(setter_2);
                        _builder_7.append(" = ");
                        _builder_7.append(getter_2);
                        _builder_7.append(";\\n");
                        return _builder_7.toString();
                    }
                } else if (association != null) {
                    ConnectableElement _role_8 = facetEnd.getRole();
                    Property facetPart_3 = (Property)_role_8;
                    ConnectableElement _role_9 = receptacleEnd.getRole();
                    Property receptaclePart_3 = (Property)_role_9;
                    Property assocProp1 = association.getMemberEnd(null, facetPart_3.getType());
                    if (assocProp1 != null && assocProp1.isNavigable()) {
                        StringConcatenation _builder_8 = new StringConcatenation();
                        String _nameRef_4 = CppUtils.nameRef(receptaclePart_3);
                        _builder_8.append(_nameRef_4);
                        String _name_6 = assocProp1.getName();
                        _builder_8.append(_name_6);
                        String setter_3 = _builder_8.toString();
                        StringConcatenation _builder_9 = new StringConcatenation();
                        _builder_9.append("&");
                        String _name_7 = facetPart_3.getName();
                        _builder_9.append(_name_7);
                        String getter_3 = _builder_9.toString();
                        StringConcatenation _builder_10 = new StringConcatenation();
                        _builder_10.append(setter_3);
                        _builder_10.append(" = ");
                        _builder_10.append(getter_3);
                        _builder_10.append(";\\n");
                        return _builder_10.toString();
                    }
                } else {
                    String _name_8 = connector.getName();
                    String _plus_1 = "Connector <" + _name_8;
                    String _plus_2 = _plus_1 + "> does not use ports, but it is not typed (only connectors between ports should not be typed)";
                    throw new TransformationException(_plus_2);
                }
            }
        }
        return "";
    }

    public static String getIndexName(Map<ConnectorEnd, Integer> indexMap, Port port, ConnectorEnd end) {
        if (port.getUpper() > 1 || port.getUpper() == -1) {
            Integer indexValue = indexMap.get(end);
            if (indexValue == null) {
                indexValue = 0;
                indexMap.put(end, indexValue);
            }
            String index = String.valueOf(indexValue) + ", ";
            indexValue = indexValue + 1;
            indexMap.put(end, indexValue);
            return index;
        }
        return "";
    }

    public void transformParts(Class compositeImplementation) {
        Object initPartsBody = "";
        EList _parts = PartsUtil.getParts((Class)compositeImplementation);
        for (Property attribute : _parts) {
            Type type = attribute.getType();
            if (!(type instanceof Class)) continue;
            String _initPartsBody = initPartsBody;
            String _initPartBody = this.initPartBody(attribute);
            initPartsBody = _initPartsBody + _initPartBody;
            attribute.destroy();
        }
        NamedElement partManager = ElementUtils.getQualifiedElementFromRS((Element)compositeImplementation, (String)PART_MANAGER);
        if (partManager instanceof Type) {
            compositeImplementation.createOwnedAttribute(PARTS, (Type)partManager);
        }
        Operation operation = compositeImplementation.createOwnedOperation(INIT_PARTS, null, null);
        String _name = operation.getName();
        String _plus = "b:" + _name;
        Behavior _createOwnedBehavior = compositeImplementation.createOwnedBehavior(_plus, UMLPackage.eINSTANCE.getOpaqueBehavior());
        OpaqueBehavior behavior = (OpaqueBehavior)_createOwnedBehavior;
        behavior.getLanguages().add((Object)progLang);
        behavior.getBodies().add(initPartsBody);
    }

    public String initPartBody(Property part) {
        String _name = part.getName();
        String _plus = "parts.add(" + _name;
        String _plus_1 = _plus + ", ";
        Type _type = part.getType();
        String _plus_2 = _plus_1 + String.valueOf(_type);
        return _plus_2 + ")";
    }
}

