/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.components.modellibs.marte.transformations;

import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.m2minterfaces.IM2MTrafoElem;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.M2MTrafo;
import org.eclipse.papyrus.designer.uml.tools.utils.ElementUtils;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;

public class MapNfp
implements IM2MTrafoElem {
    private static Map<String, String> map = Map.ofEntries(Map.entry("MARTE_Library::BasicNFP_Types::NFP_Real", "PrimitiveTypes::Real"), Map.entry("MARTE_Library::BasicNFP_Types::NFP_Integer", "PrimitiveTypes::Integer"), Map.entry("MARTE_Library::BasicNFP_Types::NFP_Boolean", "PrimitiveTypes::Boolean"), Map.entry("MARTE_Library::BasicNFP_Types::NFP_UnlimitedNatural", "PrimitiveTypes::UnlimitedNatural"), Map.entry("MARTE_Library::BasicNFP_Types::NFP_String", "PrimitiveTypes::String"), Map.entry("MARTE_Library::BasicNFP_Types::NFP_Duration", "PrimitiveTypes::Real"), Map.entry("MARTE_Library::MARTE_PrimitivesTypes::Real", "PrimitiveTypes::Real"), Map.entry("MARTE_Library::MARTE_PrimitivesTypes::Integer", "PrimitiveTypes::Integer"), Map.entry("MARTE_Library::MARTE_PrimitivesTypes::Boolean", "PrimitiveTypes::Boolean"), Map.entry("MARTE_Library::MARTE_PrimitivesTypes::UnlimitedNatural", "PrimitiveTypes::UnlimitedNatural"), Map.entry("MARTE_Library::MARTE_PrimitivesTypes::String", "PrimitiveTypes::String"), Map.entry("MARTE_Library::TimeLibrary::TimedValueType", "PrimitiveTypes::Real"));

    public void transformTypedElem(TypedElement typedElem) {
        String qn;
        Type type = typedElem.getType();
        if (type != null && (qn = type.getQualifiedName()) != null) {
            for (String key : map.keySet()) {
                if (!qn.equals(key)) continue;
                NamedElement mappedObj = ElementUtils.getQualifiedElementFromRS((Element)typedElem, (URI)URI.createURI((String)"pathmap://UML_LIBRARIES/UMLPrimitiveTypes.library.uml"), (String)map.get(key));
                if (!(mappedObj instanceof Type)) break;
                typedElem.setType((Type)mappedObj);
                break;
            }
        }
    }

    public void transformElement(M2MTrafo trafo, Element element) throws TransformationException {
        if (element instanceof Classifier) {
            TreeIterator i = element.eAllContents();
            while (i.hasNext()) {
                EObject eObj = (EObject)i.next();
                if (!(eObj instanceof TypedElement)) continue;
                this.transformTypedElem((TypedElement)eObj);
            }
        }
    }
}

