/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.tracing.barectf.library;

import com.google.common.base.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Typedef;
import org.eclipse.papyrus.designer.transformation.library.xtend.CppUtils;
import org.eclipse.papyrus.designer.transformation.tracing.barectf.library.BareCTFconfig;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;

public class CTFTypeUtils {
    public static CharSequence ctfType(Type type) {
        StringConcatenation _builder = new StringConcatenation();
        if (Objects.equal((Object)type.getQualifiedName(), (Object)"CORBA::String") || Objects.equal((Object)type.getQualifiedName(), (Object)"PrimitiveTypes::String") || Objects.equal((Object)type.getQualifiedName(), (Object)"UMLPrimitiveTypes::String")) {
            _builder.append("string");
            _builder.newLine();
        } else if (Objects.equal((Object)type.getQualifiedName(), (Object)"CORBA::Float") || Objects.equal((Object)type.getQualifiedName(), (Object)"CORBA::Double") || Objects.equal((Object)type.getQualifiedName(), (Object)"AnsiCLibrary::float") || Objects.equal((Object)type.getQualifiedName(), (Object)"AnsiCLibrary::double")) {
            _builder.append("float");
            _builder.newLine();
        } else if (Objects.equal((Object)type.getQualifiedName(), (Object)"UMLPrimitiveTypes::Boolean") || Objects.equal((Object)type.getQualifiedName(), (Object)"PrimitiveTypes::Boolean") || Objects.equal((Object)type.getQualifiedName(), (Object)"CORBA::Boolean")) {
            _builder.append("/* bool */ uint8");
            _builder.newLine();
        } else if (type instanceof PrimitiveType) {
            String _primitiveType = CTFTypeUtils.primitiveType((PrimitiveType)type);
            _builder.append(_primitiveType);
            _builder.newLineIfNotEmpty();
        } else if (type instanceof Enumeration) {
            String _enumType = CTFTypeUtils.enumType((Enumeration)type);
            _builder.append(_enumType);
            _builder.newLineIfNotEmpty();
        } else if (type instanceof DataType) {
            _builder.append("// should not happen due to flattening");
            _builder.newLine();
        } else {
            CharSequence _cppType = CppUtils.cppType((Type)type);
            _builder.append((Object)_cppType);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public static String primitiveType(PrimitiveType pt) {
        Typedef typedef = (Typedef)UMLUtil.getStereotypeApplication((Element)pt, Typedef.class);
        String name = pt.getName();
        if (typedef != null) {
            name = typedef.getDefinition();
        }
        if (Objects.equal((Object)name, (Object)"int") || Objects.equal((Object)name, (Object)"Integer") || Objects.equal((Object)name, (Object)"long")) {
            return "int32";
        }
        if (Objects.equal((Object)name, (Object)"unsigned int") || Objects.equal((Object)name, (Object)"unsigned long")) {
            return "uint32";
        }
        boolean _equals = Objects.equal((Object)name, (Object)"short");
        if (_equals) {
            return "int16";
        }
        boolean _equals_1 = Objects.equal((Object)name, (Object)"unsigned short");
        if (_equals_1) {
            return "uint16";
        }
        boolean _equals_2 = Objects.equal((Object)name, (Object)"char");
        if (_equals_2) {
            return "uint16";
        }
        boolean _equals_3 = Objects.equal((Object)name, (Object)"bool");
        if (_equals_3) {
            return "uint8";
        }
        boolean _equals_4 = Objects.equal((Object)name, (Object)"std::string");
        if (_equals_4) {
            return "string";
        }
        return name;
    }

    public static String enumType(Enumeration enumT) {
        boolean _not;
        boolean _containsKey = BareCTFconfig.types.containsKey(enumT);
        boolean bl = _not = !_containsKey;
        if (_not) {
            BareCTFconfig.types.put((Type)enumT, true);
            String _name = enumT.getName();
            String _plus = String.valueOf(_name) + ".yaml";
            BareCTFconfig.writeFile(_plus, CTFTypeUtils.enumTypeContents(enumT));
        }
        return enumT.getName();
    }

    public static String enumTypeContents(Enumeration enumT) {
        StringConcatenation _builder = new StringConcatenation();
        int i = 0;
        _builder.newLineIfNotEmpty();
        _builder.append("$field-type-aliases:");
        _builder.newLine();
        _builder.append("\t");
        String _name = enumT.getName();
        _builder.append(_name, "\t");
        _builder.append(":");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("class: unsigned-enum");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("size: 8");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("alignment: 8");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("mappings:");
        _builder.newLine();
        EList _ownedLiterals = enumT.getOwnedLiterals();
        for (EnumerationLiteral literal : _ownedLiterals) {
            boolean _tripleNotEquals;
            _builder.append("\t\t\t");
            ValueSpecification _specification = literal.getSpecification();
            boolean bl = _tripleNotEquals = _specification != null;
            if (_tripleNotEquals) {
                i = Integer.parseInt(literal.getSpecification().stringValue());
                _builder.append((Object)i, "\t\t\t");
            }
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            String _escapeLitName = CTFTypeUtils.escapeLitName(literal);
            _builder.append(_escapeLitName, "\t\t\t");
            _builder.append(" : [");
            int _plusPlus = i++;
            _builder.append((Object)_plusPlus, "\t\t\t");
            _builder.append("]");
            _builder.newLineIfNotEmpty();
        }
        return _builder.toString();
    }

    public static String escapeLitName(EnumerationLiteral literal) {
        String name = literal.getName();
        String lcName = literal.getName().toLowerCase();
        if (Objects.equal((Object)lcName, (Object)"true") || Objects.equal((Object)lcName, (Object)"false")) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(name);
            _builder.append("_");
            return _builder.toString();
        }
        return name;
    }

    public static String confTabs(CharSequence seq) {
        return seq.toString().replaceAll("\t", "  ");
    }
}

