/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.library.transformations;

import java.util.HashMap;
import org.eclipse.papyrus.designer.transformation.base.utils.ModelManagement;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.Messages;
import org.eclipse.papyrus.designer.transformation.core.m2minterfaces.IM2MTrafoCDP;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.M2MTrafo;
import org.eclipse.uml2.uml.Package;

public class WriteModels
implements IM2MTrafoCDP {
    public static final String MODEL = "model";
    public static final String TEMP_MODEL_FOLDER = "tmpModel";
    public static final String TEMP_EXT = ".temp.uml";

    public void applyTrafo(M2MTrafo trafo, Package deploymentPlan) throws TransformationException {
        TransformationContext tc = TransformationContext.current;
        boolean intermediateModel = tc.copier.source == TransformationContext.initialSourceRoot;
        String originalURI = tc.mm.getModel().eResource().getURI().toString();
        if (intermediateModel) {
            tc.mm.setURI(tc.project, TEMP_MODEL_FOLDER, TEMP_EXT);
        } else {
            tc.mm.setURI(tc.project, MODEL, null);
        }
        tc.mm.save();
        tc.mm.setURI(originalURI);
        HashMap<String, Boolean> pathes = new HashMap<String, Boolean>();
        for (ModelManagement mm : tc.copier.getAdditionalRootPkgs()) {
            String originalAdditionalURI = tc.mm.getModel().eResource().getURI().toString();
            String pathAdditionalRoot = intermediateModel ? mm.getPath(tc.project, TEMP_MODEL_FOLDER, TEMP_EXT) : mm.getPath(tc.project, MODEL, null);
            mm.setURI(pathAdditionalRoot);
            if (pathes.containsKey(pathAdditionalRoot)) {
                throw new TransformationException(String.format(Messages.ExecuteTransformation_ROOT_EXISTS_TWICE, pathAdditionalRoot));
            }
            pathes.put(pathAdditionalRoot, true);
            mm.save();
            mm.setURI(originalAdditionalURI);
        }
    }
}

