/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.base.utils;

import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.DerivedElement;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageMerge;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.TemplateSignature;
import org.eclipse.uml2.uml.TemplateableElement;
import org.eclipse.uml2.uml.Type;

public class MapUtil {
    private static final String DERIVED_TYPES = "derivedTypes";

    public static Type getOrCreateDerivedType(Element element, String format, Type type, ECreateKind createKind) {
        PackageableElement pe;
        PackageableElement portKinds;
        String typeName = String.format(format, type.getName());
        Package baseModelOfPort = MapUtil.getTop(element);
        Package derivedTypes = MapUtil.getAndCreate(baseModelOfPort, DERIVED_TYPES, createKind != ECreateKind.NONE);
        if (derivedTypes != null) {
            Package owner = MapUtil.getAndCreate(derivedTypes, (EList<Namespace>)type.allNamespaces(), createKind != ECreateKind.NONE);
            Interface intf = null;
            PackageableElement pe2 = owner.getPackagedElement(typeName);
            if (pe2 instanceof Type) {
                return (Type)pe2;
            }
            if (createKind == ECreateKind.INTERFACE) {
                intf = owner.createOwnedInterface(typeName);
                DerivedElement de = MapUtil.applyDE((Element)intf);
                if (de != null) {
                    de.setSource((Element)type);
                }
                return intf;
            }
            if (createKind == ECreateKind.CLASS) {
                Class newType = owner.createOwnedClass(typeName, false);
                DerivedElement de = MapUtil.applyDE((Element)newType);
                if (de != null) {
                    de.setSource((Element)type);
                }
                return newType;
            }
        }
        if ((portKinds = baseModelOfPort.getImportedMember("PortKinds")) instanceof Package && (pe = ((Package)portKinds).getPackagedElement("Please update derived elements")) instanceof Interface) {
            return (Interface)pe;
        }
        return null;
    }

    public static TemplateSignature getSignature(TemplateableElement template) {
        for (Element element : template.getOwnedElements()) {
            if (!(element instanceof TemplateSignature)) continue;
            return (TemplateSignature)element;
        }
        if (template instanceof Package) {
            Package pkg = (Package)template;
            for (PackageMerge pkgMerge : pkg.getPackageMerges()) {
                Package mergedPackage = pkgMerge.getMergedPackage();
                if (mergedPackage == pkg) continue;
                return MapUtil.getSignature((TemplateableElement)mergedPackage);
            }
        }
        return null;
    }

    public static Package getTop(Element element) {
        while (element != null) {
            Element owner = element.getOwner();
            if (owner == null && element instanceof Package) {
                return (Package)element;
            }
            if (element instanceof Package && MapUtil.getSignature((TemplateableElement)((Package)element)) != null) {
                return (Package)element;
            }
            element = owner;
        }
        return null;
    }

    public static DerivedElement applyDE(Element element) {
        return (DerivedElement)StereotypeUtil.applyApp((Element)element, DerivedElement.class);
    }

    public static Package getAndCreate(Package root, EList<Namespace> list, boolean createOnDemand) {
        int i = list.size() - 1;
        while (i >= 0) {
            Namespace ns = (Namespace)list.get(i);
            NamedElement pkg = root.getOwnedMember(ns.getName());
            if (pkg == null && createOnDemand) {
                pkg = root.createNestedPackage(ns.getName());
            }
            if (!(pkg instanceof Package)) break;
            root = (Package)pkg;
            --i;
        }
        return root;
    }

    public static Package getAndCreate(Package root, String name, boolean createOnDemand) {
        NamedElement pkg = root.getOwnedMember(name);
        if (pkg == null && createOnDemand) {
            pkg = root.createNestedPackage(name);
        }
        return (Package)pkg;
    }

    public static enum ECreateKind {
        CLASS,
        INTERFACE,
        NONE;

    }
}

