/*******************************************************************************
 * Copyright (c) 2018 CEA LIST.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Shuai Li (CEA LIST) <shuai.li@cea.fr> - initial API and implementation
 *******************************************************************************/

package org.eclipse.papyrus.designer.monitoring.sm.preferences;

import java.util.regex.Pattern;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.designer.monitoring.sm.Activator;

/**
 * Utility class that returns the preference values
 */
public class MonitoringPreferencesUtil {
	protected static IPreferenceStore preferenceStore = null;

	public static void initPreferenceStore() {
		if (preferenceStore == null) {
			preferenceStore = Activator.getDefault().getPreferenceStore();
		}
	}
	
	public static String getIpAddress() {
		initPreferenceStore();
		String ip = preferenceStore.getString(MonitoringPreferencesConstants.P_IP_ADDRESS);
		if (!validate(ip)) {
			ip = MonitoringPreferencesConstants.P_DEFAULT_IP_ADDRESS;
		}
		return ip;
	}

	public static int getPort() {
		initPreferenceStore();
		int port = preferenceStore.getInt(MonitoringPreferencesConstants.P_PORT);
		if (port <= 0) {
			port = MonitoringPreferencesConstants.P_DEFAULT_PORT;
		}
		return port;
	}
	
	public static boolean getEnabled() {
		initPreferenceStore();
		return preferenceStore.getBoolean(MonitoringPreferencesConstants.P_ENABLED);
	}
	
	private static final Pattern IP_PATTERN = Pattern.compile(
	        "^(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])$"); //$NON-NLS-1$

	private static boolean validate(final String ip) {
	    return IP_PATTERN.matcher(ip).matches();
	}
}
