/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.reverse.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.papyrus.designer.infra.base.CommandSupport;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ModelManagement {
    public static ResourceSet resourceSet = null;
    private List<Model> models = new ArrayList<Model>();
    private List<Resource> resources = new ArrayList<Resource>();

    public void createOrgetModel(final String name, final String uri, final boolean create, final boolean reset) {
        this.getResourceSet();
        CommandSupport.exec((TransactionalEditingDomain)TransactionUtil.getEditingDomain((ResourceSet)resourceSet), (String)"create or get model", (Runnable)new Runnable(){

            @Override
            public void run() {
                Resource resource = null;
                if (create) {
                    resource = resourceSet.createResource(URI.createURI((String)uri));
                } else {
                    try {
                        resource = resourceSet.getResource(URI.createURI((String)uri), true);
                        if (reset) {
                            resource.delete(null);
                            resource = resourceSet.createResource(URI.createURI((String)uri));
                        }
                    }
                    catch (Exception e) {
                        resource = resourceSet.createResource(URI.createURI((String)uri));
                    }
                }
                if (!ModelManagement.this.resources.contains(resource)) {
                    ModelManagement.this.resources.add(resource);
                }
                Model model = null;
                if (create) {
                    model = UMLFactory.eINSTANCE.createModel();
                    resource.getContents().add((Object)model);
                } else {
                    model = (Model)UMLUtil.load((ResourceSet)resourceSet, (URI)resource.getURI(), (EClass)UMLPackage.Literals.MODEL);
                    if (model == null) {
                        model = UMLFactory.eINSTANCE.createModel();
                        resource.getContents().add((Object)model);
                    }
                }
                model.setName(name);
                ModelManagement.this.models.add(model);
            }
        });
    }

    public void dispose() {
        for (Model model : this.models) {
            if (model == null) continue;
            model.destroy();
            model = null;
        }
        for (Resource resource : this.resources) {
            resource.unload();
        }
        resourceSet.getResources().removeAll(this.resources);
        this.resources.clear();
    }

    public List<Model> getModels() {
        return this.models;
    }

    public static Map<Object, Object> getDefaultSaveOptions() {
        HashMap<Object, Object> saveOptions = new HashMap<Object, Object>();
        saveOptions.put("DECLARE_XML", Boolean.TRUE);
        saveOptions.put("PROCESS_DANGLING_HREF", "DISCARD");
        saveOptions.put("SCHEMA_LOCATION", Boolean.TRUE);
        saveOptions.put("USE_XMI_TYPE", Boolean.TRUE);
        saveOptions.put("SAVE_TYPE_INFORMATION", Boolean.TRUE);
        saveOptions.put("SKIP_ESCAPE_URI", Boolean.FALSE);
        saveOptions.put("ENCODING", "UTF-8");
        saveOptions.put("USE_FILE_BUFFER", true);
        saveOptions.put("FLUSH_THRESHOLD", 0x400000);
        saveOptions.put("URI_HANDLER", new URIHandlerImpl.PlatformSchemeAware());
        return saveOptions;
    }

    public void saveModel(List<String> paths) {
        try {
            int i = 0;
            while (i < paths.size()) {
                URI uri = URI.createURI((String)paths.get(i));
                this.resources.get(i).setURI(uri);
                EList contents = this.resources.get(i).getContents();
                TreeIterator allContents = UML2Util.getAllContents((EObject)((EObject)this.models.get(i)), (boolean)true, (boolean)false);
                while (allContents.hasNext()) {
                    EObject eObject = (EObject)allContents.next();
                    if (!(eObject instanceof Element)) continue;
                    contents.addAll((Collection)((Element)eObject).getStereotypeApplications());
                }
                this.resources.get(i).save(ModelManagement.getDefaultSaveOptions());
                ++i;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getPath(IProject project, String subFolder, String filename) {
        IFile file;
        if (filename == null) {
            filename = String.valueOf(this.models.get(0).getName()) + ".uml";
        }
        if (subFolder != null) {
            IFolder ifolder = project.getFolder(subFolder);
            if (!ifolder.exists()) {
                try {
                    ifolder.create(false, true, null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            file = ifolder.getFile(filename);
        } else {
            file = project.getFile(filename);
        }
        return file.getFullPath().toString();
    }

    public ResourceSet getResourceSet() {
        if (resourceSet == null) {
            resourceSet = new ResourceSetImpl();
        }
        return resourceSet;
    }
}

