/**
 * Copyright (c) 2015 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * Contributors:
 *     CEA LIST - initial API and implementation
 */
package org.eclipse.papyrus.designer.languages.c.codegen.lib;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Const;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Ptr;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.StorageClass;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.FinalState;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class variableScript {
  public static CharSequence genVariableDeclaration(final Property property) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<Comment> _ownedComments = property.getOwnedComments();
      for(final Comment comment : _ownedComments) {
        CharSequence _genComment = CommonScript.genComment(comment);
        _builder.append(_genComment);
        _builder.newLineIfNotEmpty();
      }
    }
    CharSequence _genDeclarator = variableScript.genDeclarator(property);
    _builder.append(_genDeclarator);
    String _genType = variableScript.genType(property);
    _builder.append(_genType);
    CharSequence _genPointer = variableScript.genPointer(property);
    _builder.append(_genPointer);
    _builder.append(" ");
    CharSequence _genName = CommonScript.genName(property);
    _builder.append(_genName);
    CharSequence _genMultiplicity = MultiplicityScript.genMultiplicity(property);
    _builder.append(_genMultiplicity);
    {
      if (((property.getDefaultValue() != null) && property.isStatic())) {
        _builder.append(" ");
        CharSequence _genDefaultValue = variableScript.genDefaultValue(property);
        _builder.append(_genDefaultValue);
        _builder.append(" ");
      }
    }
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public static CharSequence genStateVariableDeclaration(final org.eclipse.uml2.uml.Class clazz) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    _builder.append("enum StateIDEnum activeStateID;");
    _builder.newLine();
    return _builder;
  }

  public static CharSequence genStateArrayDeclaration(final StateMachine sm) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    _builder.append("State_t states[");
    final Function1<State, Boolean> _function = new Function1<State, Boolean>() {
      @Override
      public Boolean apply(final State it) {
        return Boolean.valueOf((!(it instanceof FinalState)));
      }
    };
    int _size = IterableExtensions.size(IterableExtensions.<State>filter(Iterables.<State>filter(IterableExtensions.<Region>head(sm.getRegions()).getSubvertices(), State.class), _function));
    _builder.append(_size);
    _builder.append("];");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public static CharSequence genDefaultValue(final Property property) {
    StringConcatenation _builder = new StringConcatenation();
    {
      ValueSpecification _defaultValue = property.getDefaultValue();
      boolean _tripleNotEquals = (_defaultValue != null);
      if (_tripleNotEquals) {
        _builder.append("= ");
        {
          int _upper = property.getUpper();
          boolean _notEquals = (_upper != 1);
          if (_notEquals) {
            _builder.append("{ ");
            CharSequence _ValueSpecificationTemplate = ValueSpecificationScript.ValueSpecificationTemplate(property.getDefaultValue());
            _builder.append(_ValueSpecificationTemplate);
            _builder.append(" }");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
          } else {
            CharSequence _ValueSpecificationTemplate_1 = ValueSpecificationScript.ValueSpecificationTemplate(property.getDefaultValue());
            _builder.append(_ValueSpecificationTemplate_1);
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    return _builder;
  }

  public static String genType(final TypedElement typedElement) {
    StringConcatenation _builder = new StringConcatenation();
    {
      Type _type = typedElement.getType();
      boolean _tripleEquals = (_type == null);
      if (_tripleEquals) {
        _builder.append("void *");
        _builder.newLine();
      } else {
        CharSequence _genCTypeName = variableScript.genCTypeName(typedElement.getType());
        _builder.append(_genCTypeName);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder.toString().trim();
  }

  public static CharSequence genCTypeName(final Type type) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if (((type == null) || (type.getName() == null))) {
        _builder.append("undefined");
        _builder.newLine();
      } else {
        if ((Objects.equal(type.getName().toLowerCase(), "boolean") || Objects.equal(type.getName().toLowerCase(), "bool"))) {
          CharSequence _genBooleanType = TypeScript.genBooleanType(type);
          _builder.append(_genBooleanType);
          _builder.newLineIfNotEmpty();
        } else {
          String _lowerCase = type.getName().toLowerCase();
          boolean _equals = Objects.equal(_lowerCase, "integer");
          if (_equals) {
            CharSequence _genIntegerType = TypeScript.genIntegerType(type);
            _builder.append(_genIntegerType);
            _builder.newLineIfNotEmpty();
          } else {
            String _lowerCase_1 = type.getName().toLowerCase();
            boolean _equals_1 = Objects.equal(_lowerCase_1, "string");
            if (_equals_1) {
              CharSequence _genStringType = TypeScript.genStringType(type);
              _builder.append(_genStringType);
              _builder.newLineIfNotEmpty();
            } else {
              String _name = type.getName();
              _builder.append(_name);
              _builder.newLineIfNotEmpty();
              _builder.append("\t\t");
            }
          }
        }
      }
    }
    return _builder;
  }

  public static CharSequence genDeclarator(final TypedElement typedElement) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _genStorageClass = variableScript.genStorageClass(typedElement);
    _builder.append(_genStorageClass);
    _builder.append(" ");
    CharSequence _genConstant = variableScript.genConstant(typedElement);
    _builder.append(_genConstant);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public static CharSequence genStorageClass(final TypedElement typedElement) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _hasStereotype = GenUtils.hasStereotype(typedElement, StorageClass.class);
      if (_hasStereotype) {
        String _string = UMLUtil.<StorageClass>getStereotypeApplication(typedElement, StorageClass.class).getStorageClass().toString();
        _builder.append(_string);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    return _builder;
  }

  public static CharSequence genConstant(final TypedElement typedElement) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _hasStereotype = GenUtils.hasStereotype(typedElement, Const.class);
      if (_hasStereotype) {
        _builder.append("const ");
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public static CharSequence genPointer(final TypedElement typedElement) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _hasStereotype = GenUtils.hasStereotype(typedElement, Ptr.class);
      if (_hasStereotype) {
        _builder.append("* ");
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public static CharSequence genInitDefaultValue(final Property property) {
    StringConcatenation _builder = new StringConcatenation();
    {
      int _upper = property.getUpper();
      boolean _equals = (_upper == 1);
      if (_equals) {
        _builder.append("self->");
        CharSequence _genName = CommonScript.genName(property);
        _builder.append(_genName);
        _builder.append(" ");
        CharSequence _genDefaultValue = variableScript.genDefaultValue(property);
        _builder.append(_genDefaultValue);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
      } else {
        String _genType = variableScript.genType(property);
        _builder.append(_genType);
        _builder.append(" tmp_");
        CharSequence _genName_1 = CommonScript.genName(property);
        _builder.append(_genName_1);
        CharSequence _genMultiplicity = MultiplicityScript.genMultiplicity(property);
        _builder.append(_genMultiplicity);
        _builder.append(" ");
        CharSequence _genDefaultValue_1 = variableScript.genDefaultValue(property);
        _builder.append(_genDefaultValue_1);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("self->");
        CharSequence _genName_2 = CommonScript.genName(property);
        _builder.append(_genName_2);
        _builder.append("«");
        _builder.append("0");
        _builder.append("»");
        _builder.append(" = tmp_");
        CharSequence _genName_3 = CommonScript.genName(property);
        _builder.append(_genName_3);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
}
