/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.codegen.xtend;

import com.google.common.base.Objects;
import java.util.List;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.java.codegen.utils.JavaGenUtils;
import org.eclipse.papyrus.designer.languages.java.codegen.xtend.JavaClassAttributesDeclaration;
import org.eclipse.papyrus.designer.languages.java.codegen.xtend.JavaClassImportClassDeclaration;
import org.eclipse.papyrus.designer.languages.java.codegen.xtend.JavaClassInheritedDeclarations;
import org.eclipse.papyrus.designer.languages.java.codegen.xtend.JavaClassOperationsDeclaration;
import org.eclipse.papyrus.designer.languages.java.codegen.xtend.JavaClassTypeAndEnum;
import org.eclipse.papyrus.designer.languages.java.codegen.xtend.JavaDocumentation;
import org.eclipse.papyrus.designer.languages.java.codegen.xtend.JavaEnumerations;
import org.eclipse.papyrus.designer.languages.java.codegen.xtend.JavaImportUtil;
import org.eclipse.papyrus.designer.languages.java.codegen.xtend.JavaTemplates;
import org.eclipse.papyrus.designer.languages.java.profile.PapyrusJava.StaticClassifier;
import org.eclipse.papyrus.designer.languages.java.profile.PapyrusJava.Strictfp;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class JavaClassifierGenerator {
    public static List<String> getSortedIncludePathList(Classifier classifier, String prefix) {
        Iterable<String> _javaClassAllImports = JavaClassImportClassDeclaration.javaClassAllImports(classifier, prefix);
        List importPathList = IterableExtensions.sort(_javaClassAllImports);
        return importPathList;
    }

    public static CharSequence generateClassCode(Classifier classifier, String prefix) {
        StringConcatenation _builder = new StringConcatenation();
        String _packageDeclaration = JavaClassifierGenerator.packageDeclaration(classifier, prefix);
        _builder.append(_packageDeclaration, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        List<String> _sortedIncludePathList = JavaClassifierGenerator.getSortedIncludePathList(classifier, prefix);
        for (String path : _sortedIncludePathList) {
            String _importDirective = JavaImportUtil.importDirective(path);
            _builder.append(_importDirective, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        String _javaImport = JavaImportUtil.javaImport((NamedElement)classifier);
        _builder.append(_javaImport, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        JavaGenUtils.openNS((NamedElement)classifier);
        _builder.newLineIfNotEmpty();
        _builder.append("/************************************************************/");
        _builder.newLine();
        CharSequence _javaElementDoc = JavaDocumentation.javaElementDoc((Element)classifier);
        _builder.append((Object)_javaElementDoc, "");
        _builder.newLineIfNotEmpty();
        String _classVisibility = JavaClassifierGenerator.classVisibility(classifier);
        _builder.append(_classVisibility, "");
        _builder.append(" ");
        String _classModifiers = JavaClassifierGenerator.classModifiers(classifier);
        _builder.append(_classModifiers, "");
        String _classifierType = JavaClassifierGenerator.classifierType(classifier);
        _builder.append(_classifierType, "");
        _builder.append(" ");
        String _name = classifier.getName();
        _builder.append(_name, "");
        CharSequence _templateSignature = JavaTemplates.templateSignature(classifier);
        _builder.append((Object)_templateSignature, "");
        CharSequence _javaClassInheritedDeclarations = JavaClassInheritedDeclarations.javaClassInheritedDeclarations(classifier);
        _builder.append((Object)_javaClassInheritedDeclarations, "");
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        if (classifier instanceof Enumeration) {
            CharSequence _javaEnumerationLiterals = JavaEnumerations.javaEnumerationLiterals((Enumeration)classifier);
            _builder.append((Object)_javaEnumerationLiterals, "\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        Object _javaClassTypeAndEnum = JavaClassTypeAndEnum.javaClassTypeAndEnum(classifier);
        _builder.append(_javaClassTypeAndEnum, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        CharSequence _javaClassAttributesDeclaration = JavaClassAttributesDeclaration.javaClassAttributesDeclaration(classifier);
        _builder.append((Object)_javaClassAttributesDeclaration, "\t\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _javaClassOperationsDeclaration = JavaClassOperationsDeclaration.javaClassOperationsDeclaration(classifier);
        _builder.append((Object)_javaClassOperationsDeclaration, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        return _builder;
    }

    public static String classifierType(Classifier classifier) {
        if (classifier instanceof Interface) {
            return "interface";
        }
        if (classifier instanceof Enumeration) {
            return "enum";
        }
        return "class";
    }

    public static String classVisibility(Classifier classifier) {
        Element _owner = classifier.getOwner();
        if (_owner instanceof Classifier) {
            VisibilityKind _visibility = classifier.getVisibility();
            String _string = _visibility.toString();
            return _string.toLowerCase();
        }
        VisibilityKind _visibility_1 = classifier.getVisibility();
        boolean _equals = Objects.equal((Object)_visibility_1, (Object)VisibilityKind.PUBLIC_LITERAL);
        if (_equals) {
            return "public";
        }
        return "";
    }

    public static String classModifiers(Classifier classifier) {
        Strictfp _stereotypeApplication_1;
        boolean _notEquals_1;
        Element _owner;
        String result = "";
        if (!(classifier instanceof Enumeration) && !(classifier instanceof Interface)) {
            boolean _isAbstract = classifier.isAbstract();
            if (_isAbstract) {
                String _result = result;
                result = String.valueOf(_result) + "abstract ";
            } else {
                boolean _isLeaf = classifier.isLeaf();
                if (_isLeaf) {
                    String _result_1 = result;
                    result = String.valueOf(_result_1) + "final ";
                }
            }
        }
        if ((_owner = classifier.getOwner()) instanceof Classifier) {
            boolean _notEquals;
            StaticClassifier _stereotypeApplication = (StaticClassifier)UMLUtil.getStereotypeApplication((Element)classifier, StaticClassifier.class);
            boolean bl = _notEquals = !Objects.equal((Object)_stereotypeApplication, null);
            if (_notEquals) {
                String _result_2 = result;
                result = String.valueOf(_result_2) + "static ";
            }
        }
        boolean bl = _notEquals_1 = !Objects.equal((Object)(_stereotypeApplication_1 = (Strictfp)UMLUtil.getStereotypeApplication((Element)classifier, Strictfp.class)), null);
        if (_notEquals_1) {
            String _result_3 = result;
            result = String.valueOf(_result_3) + "strictfp ";
        }
        return result;
    }

    public static String packageDeclaration(Classifier classifier, String prefix) {
        boolean _isEmpty;
        Package _package = classifier.getPackage();
        String _fullPath = GenUtils.getFullPath((Package)_package, (String)".", (boolean)false);
        String qName = String.valueOf(prefix) + _fullPath;
        boolean _endsWith = qName.endsWith(".");
        if (_endsWith) {
            String _substring;
            int _length = qName.length();
            int _minus = _length - 1;
            qName = _substring = qName.substring(0, _minus);
        }
        if (_isEmpty = qName.isEmpty()) {
            return "";
        }
        return "package " + qName + ";";
    }
}

