/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.reverse.reverse;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorChainInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexManager;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IDeclaration;
import org.eclipse.cdt.core.model.IEnumeration;
import org.eclipse.cdt.core.model.IEnumerator;
import org.eclipse.cdt.core.model.IField;
import org.eclipse.cdt.core.model.IFunction;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.IMacro;
import org.eclipse.cdt.core.model.IMethod;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.model.IMethodTemplateDeclaration;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.model.IStructureDeclaration;
import org.eclipse.cdt.core.model.IStructureTemplate;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.ITypeDef;
import org.eclipse.cdt.core.model.IUsing;
import org.eclipse.cdt.core.model.IVariableDeclaration;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Array;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Const;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.ConstInit;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.External;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Friend;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Include;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Inline;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Ptr;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Ref;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Template;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Typedef;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Virtual;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Visibility;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Volatile;
import org.eclipse.papyrus.designer.languages.cpp.reverse.reverse.BatchReverseFunctionBody;
import org.eclipse.papyrus.designer.languages.cpp.reverse.reverse.DependencyAnalysis;
import org.eclipse.papyrus.designer.languages.cpp.reverse.reverse.ReverseUtils;
import org.eclipse.papyrus.designer.languages.cpp.reverse.reverse.change.CElementChange;
import org.eclipse.papyrus.designer.languages.cpp.reverse.reverse.change.ChangeMapStore;
import org.eclipse.papyrus.designer.languages.cpp.reverse.reverse.change.CppChangeObject;
import org.eclipse.papyrus.designer.languages.cpp.reverse.reverse.change.ModelChangeObject;
import org.eclipse.papyrus.designer.languages.cpp.reverse.utils.FileWatcher;
import org.eclipse.papyrus.designer.languages.cpp.reverse.utils.ModelManagement;
import org.eclipse.papyrus.designer.languages.cpp.reverse.utils.RoundtripCppUtils;
import org.eclipse.papyrus.designer.languages.cpp.reverse.utils.TypeOperationsEnhanced;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ClassifierTemplateParameter;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.RedefinableTemplateSignature;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.TemplateSignature;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.uml2.uml.profile.standard.Create;
import org.eclipse.uml2.uml.profile.standard.Destroy;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ReverseCpp2Uml {
    private ConflictResolutionMode conflictResolveMode = ConflictResolutionMode.FROM_CODE;
    public static String C_LangID = "C";
    public static String Cpp_LangID = "C++";
    private String langID = "C++";
    private Map<ICElement, EObject> map = new HashMap<ICElement, EObject>();
    private static final String TEMPLATE_PARAMETER_SIGNATURE_NAME = "template_paremeter_signature";
    private static final String REVERSE_FOLDER = "reversed_models";
    private static final String MODEL_POSTFIX = ".uml";
    private ITranslationUnit unit;
    private ICProject m_project;
    private List<Model> m_models;
    private static final Logger LOGGER = Logger.getLogger(ReverseCpp2Uml.class.getName());
    private IIndex index;
    private IProgressMonitor m_monitor;
    private String path;
    private ReverseUtils reverse_utils = ReverseUtils.getInstance();
    private static long timestamp = 0L;
    private ReverseMode reverseMode = ReverseMode.BATCH;
    private Map<ITranslationUnit, IASTTranslationUnit> translationUnitToASTTranslationUnitMap;
    private Map<String, List<IInclude>> excludedIncludesMap;
    private List<CppChangeObject> changeList = new ArrayList<CppChangeObject>();
    private static List<ModelChangeObject> modelChangeList = new ArrayList<ModelChangeObject>();
    private List<ICContainer> containers = new UniqueEList();
    private static String projectPrefix = "org.eclipse.papyrus.cppgen";

    public static boolean addModelChange(ModelChangeObject change) {
        return modelChangeList.add(change);
    }

    public static void clearModelChange() {
        modelChangeList.clear();
    }

    public ReverseCpp2Uml(ITranslationUnit unit, IProgressMonitor monitor, String langID) {
        try {
            IIndex _index;
            ICProject _cProject;
            this.unit = unit;
            this.m_project = _cProject = unit.getCProject();
            IIndexManager _indexManager = CCorePlugin.getIndexManager();
            this.index = _index = _indexManager.getIndex(this.m_project);
            HashMap<ITranslationUnit, IASTTranslationUnit> _hashMap = new HashMap<ITranslationUnit, IASTTranslationUnit>();
            this.translationUnitToASTTranslationUnitMap = _hashMap;
            HashMap<String, List<IInclude>> _hashMap_1 = new HashMap<String, List<IInclude>>();
            this.excludedIncludesMap = _hashMap_1;
            this.m_monitor = monitor;
            this.langID = langID;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public ReverseCpp2Uml(ITranslationUnit unit, IProgressMonitor monitor) {
        try {
            IIndex _index;
            ICProject _cProject;
            this.unit = unit;
            this.m_project = _cProject = unit.getCProject();
            IIndexManager _indexManager = CCorePlugin.getIndexManager();
            this.index = _index = _indexManager.getIndex(this.m_project);
            HashMap<ITranslationUnit, IASTTranslationUnit> _hashMap = new HashMap<ITranslationUnit, IASTTranslationUnit>();
            this.translationUnitToASTTranslationUnitMap = _hashMap;
            HashMap<String, List<IInclude>> _hashMap_1 = new HashMap<String, List<IInclude>>();
            this.excludedIncludesMap = _hashMap_1;
            this.m_monitor = monitor;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public ReverseCpp2Uml(ICProject project, IProgressMonitor monitor, String langID) {
        try {
            IIndex _index;
            this.m_project = project;
            IIndexManager _indexManager = CCorePlugin.getIndexManager();
            this.index = _index = _indexManager.getIndex(this.m_project);
            HashMap<ITranslationUnit, IASTTranslationUnit> _hashMap = new HashMap<ITranslationUnit, IASTTranslationUnit>();
            this.translationUnitToASTTranslationUnitMap = _hashMap;
            HashMap<String, List<IInclude>> _hashMap_1 = new HashMap<String, List<IInclude>>();
            this.excludedIncludesMap = _hashMap_1;
            this.m_monitor = monitor;
            this.langID = langID;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public ReverseCpp2Uml(ICProject project, IProgressMonitor monitor) {
        try {
            IIndex _index;
            this.m_project = project;
            IIndexManager _indexManager = CCorePlugin.getIndexManager();
            this.index = _index = _indexManager.getIndex(this.m_project);
            HashMap<ITranslationUnit, IASTTranslationUnit> _hashMap = new HashMap<ITranslationUnit, IASTTranslationUnit>();
            this.translationUnitToASTTranslationUnitMap = _hashMap;
            HashMap<String, List<IInclude>> _hashMap_1 = new HashMap<String, List<IInclude>>();
            this.excludedIncludesMap = _hashMap_1;
            this.m_monitor = monitor;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public ReverseCpp2Uml(ICProject project, IProgressMonitor monitor, String langID, String path) {
        try {
            IIndex _index;
            this.m_project = project;
            IIndexManager _indexManager = CCorePlugin.getIndexManager();
            this.index = _index = _indexManager.getIndex(this.m_project);
            HashMap<ITranslationUnit, IASTTranslationUnit> _hashMap = new HashMap<ITranslationUnit, IASTTranslationUnit>();
            this.translationUnitToASTTranslationUnitMap = _hashMap;
            HashMap<String, List<IInclude>> _hashMap_1 = new HashMap<String, List<IInclude>>();
            this.excludedIncludesMap = _hashMap_1;
            this.m_monitor = monitor;
            this.langID = langID;
            this.path = path;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void reverse() {
        try {
            ICProject _cProject = this.unit.getCProject();
            String projectName = _cProject.getElementName();
            BatchReverseFunctionBody iSync = new BatchReverseFunctionBody(this.unit, projectName, this);
            iSync.run();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isSourceFolder(ICContainer container) {
        try {
            ICElement[] _children;
            ICElement[] iCElementArray = _children = container.getChildren();
            int n = _children.length;
            int n2 = 0;
            while (true) {
                boolean _isSourceFolder;
                if (n2 >= n) {
                    return false;
                }
                ICElement child = iCElementArray[n2];
                if (child instanceof ITranslationUnit) {
                    return true;
                }
                if (child instanceof ICContainer && (_isSourceFolder = this.isSourceFolder((ICContainer)child))) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Object reverseProject(boolean reset) {
        try {
            long _divide;
            boolean _equals_1;
            boolean _notEquals;
            boolean _lessThan;
            ISourceRoot[] _sourceRoots = this.m_project.getSourceRoots();
            Functions.Function1<ISourceRoot, Boolean> _function = new Functions.Function1<ISourceRoot, Boolean>(){

                public Boolean apply(ISourceRoot it) {
                    return ReverseCpp2Uml.this.isSourceFolder((ICContainer)it);
                }
            };
            Iterable sourceRoots = IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_sourceRoots)), (Functions.Function1)_function);
            int _size = IterableExtensions.size((Iterable)sourceRoots);
            boolean bl = _lessThan = _size < 1;
            if (_lessThan) {
                throw new Exception("No source folder");
            }
            this.containers.clear();
            Functions.Function1<ISourceRoot, Boolean> _function_1 = new Functions.Function1<ISourceRoot, Boolean>(){

                public Boolean apply(ISourceRoot it) {
                    String _elementName = it.getElementName();
                    return _elementName.contains(projectPrefix);
                }
            };
            Iterable _filter = IterableExtensions.filter((Iterable)sourceRoots, (Functions.Function1)_function_1);
            ISourceRoot sourceRootGenerated = (ISourceRoot)IterableExtensions.head((Iterable)_filter);
            boolean bl2 = _notEquals = !Objects.equal((Object)sourceRootGenerated, null);
            if (_notEquals) {
                ICElement[] _children = sourceRootGenerated.getChildren();
                Iterable _filter_1 = Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_children)), ICContainer.class);
                Functions.Function1<ICContainer, Boolean> _function_2 = new Functions.Function1<ICContainer, Boolean>(){

                    public Boolean apply(ICContainer it) {
                        return ReverseCpp2Uml.this.isSourceFolder(it);
                    }
                };
                Iterable _filter_2 = IterableExtensions.filter((Iterable)_filter_1, (Functions.Function1)_function_2);
                Iterables.addAll(this.containers, (Iterable)_filter_2);
            } else {
                Iterables.addAll(this.containers, (Iterable)sourceRoots);
            }
            ModelManagement modelManager = new ModelManagement();
            String umlFilePath = null;
            boolean _or = false;
            boolean _equals = Objects.equal((Object)this.path, null);
            _or = _equals ? true : (_equals_1 = this.path.equals(""));
            if (_or) {
                String _path;
                IProject _project = this.m_project.getProject();
                String _elementName = this.m_project.getElementName();
                String _plus = String.valueOf(_elementName) + MODEL_POSTFIX;
                umlFilePath = _path = modelManager.getPath(_project, REVERSE_FOLDER, _plus);
            } else {
                umlFilePath = this.path;
            }
            String _elementName_1 = this.m_project.getElementName();
            modelManager.createOrgetModel(_elementName_1, umlFilePath, !reset, reset);
            List<Model> _models = modelManager.getModels();
            this.m_models = _models;
            Consumer<Model> _function_3 = new Consumer<Model>(){

                @Override
                public void accept(Model it) {
                    RoundtripCppUtils.applyProfile(it, RoundtripCppUtils.cppProfileUri);
                    RoundtripCppUtils.applyProfile(it, RoundtripCppUtils.umlStandardProfileUri);
                }
            };
            this.m_models.forEach(_function_3);
            Consumer<ICContainer> _function_4 = new Consumer<ICContainer>(){

                @Override
                public void accept(ICContainer it) {
                    ReverseCpp2Uml.this.reverseProject((IParent)it);
                }
            };
            this.containers.forEach(_function_4);
            Set<String> _singleton = Collections.singleton(umlFilePath);
            List _list = IterableExtensions.toList(_singleton);
            modelManager.saveModel(_list);
            Model _last = (Model)IterableExtensions.last(this.m_models);
            Resource _eResource = _last.eResource();
            long _timeStamp = _eResource.getTimeStamp();
            timestamp = _divide = _timeStamp / 1000L;
            this.clearRawChangeList();
            modelManager.dispose();
            return null;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void syncIncrementalProject() {
        try {
            List<CElementChange> _rawChangeList_1;
            int _size_1;
            boolean _equals_3;
            boolean _equals_1;
            boolean _notEquals;
            boolean _lessThan;
            this.reverseMode = ReverseMode.INCREMENTAL;
            ISourceRoot[] _sourceRoots = this.m_project.getSourceRoots();
            Functions.Function1<ISourceRoot, Boolean> _function = new Functions.Function1<ISourceRoot, Boolean>(){

                public Boolean apply(ISourceRoot it) {
                    return ReverseCpp2Uml.this.isSourceFolder((ICContainer)it);
                }
            };
            Iterable sourceRoots = IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_sourceRoots)), (Functions.Function1)_function);
            int _size = IterableExtensions.size((Iterable)sourceRoots);
            boolean bl = _lessThan = _size < 1;
            if (_lessThan) {
                throw new Exception("No source folder");
            }
            this.containers.clear();
            Functions.Function1<ISourceRoot, Boolean> _function_1 = new Functions.Function1<ISourceRoot, Boolean>(){

                public Boolean apply(ISourceRoot it) {
                    String _elementName = it.getElementName();
                    return _elementName.contains(projectPrefix);
                }
            };
            Iterable _filter = IterableExtensions.filter((Iterable)sourceRoots, (Functions.Function1)_function_1);
            ISourceRoot sourceRootGenerated = (ISourceRoot)IterableExtensions.head((Iterable)_filter);
            boolean bl2 = _notEquals = !Objects.equal((Object)sourceRootGenerated, null);
            if (_notEquals) {
                ICElement[] _children = sourceRootGenerated.getChildren();
                Iterable _filter_1 = Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_children)), ICContainer.class);
                Functions.Function1<ICContainer, Boolean> _function_2 = new Functions.Function1<ICContainer, Boolean>(){

                    public Boolean apply(ICContainer it) {
                        return ReverseCpp2Uml.this.isSourceFolder(it);
                    }
                };
                Iterable _filter_2 = IterableExtensions.filter((Iterable)_filter_1, (Functions.Function1)_function_2);
                Iterables.addAll(this.containers, (Iterable)_filter_2);
            } else {
                Iterables.addAll(this.containers, (Iterable)sourceRoots);
            }
            ModelManagement modelManager = new ModelManagement();
            String umlFilePath = null;
            boolean _or = false;
            boolean _equals = Objects.equal((Object)this.path, null);
            _or = _equals ? true : (_equals_1 = this.path.equals(""));
            if (_or) {
                String _path;
                IProject _project = this.m_project.getProject();
                String _elementName = this.m_project.getElementName();
                String _plus = String.valueOf(_elementName) + MODEL_POSTFIX;
                umlFilePath = _path = modelManager.getPath(_project, REVERSE_FOLDER, _plus);
            } else {
                umlFilePath = this.path;
            }
            String _elementName_1 = this.m_project.getElementName();
            modelManager.createOrgetModel(_elementName_1, umlFilePath, false, false);
            List<Model> _models = modelManager.getModels();
            this.m_models = _models;
            Consumer<Model> _function_3 = new Consumer<Model>(){

                @Override
                public void accept(Model it) {
                    RoundtripCppUtils.applyProfile(it, RoundtripCppUtils.cppProfileUri);
                    RoundtripCppUtils.applyProfile(it, RoundtripCppUtils.umlStandardProfileUri);
                }
            };
            this.m_models.forEach(_function_3);
            boolean _or_1 = false;
            List<CElementChange> _rawChangeList = this.getRawChangeList();
            boolean _equals_2 = Objects.equal(_rawChangeList, null);
            _or_1 = _equals_2 ? true : (_equals_3 = (_size_1 = (_rawChangeList_1 = this.getRawChangeList()).size()) == 0);
            if (_or_1) {
                long _divide;
                FileWatcher fileWatcher = new FileWatcher(this.m_project, timestamp);
                List<ITranslationUnit> modifiedItus = fileWatcher.getModifiledTranslationUnits((IParent)this.m_project);
                for (ITranslationUnit modified : modifiedItus) {
                    this.syncTranslationUnit(modified);
                }
                Set<String> _singleton = Collections.singleton(umlFilePath);
                List _list = IterableExtensions.toList(_singleton);
                modelManager.saveModel(_list);
                Model _last = (Model)IterableExtensions.last(this.m_models);
                Resource _eResource = _last.eResource();
                long _timeStamp = _eResource.getTimeStamp();
                timestamp = _divide = _timeStamp / 1000L;
            } else {
                this.reverseIncrementalChanges();
                Set<String> _singleton_1 = Collections.singleton(umlFilePath);
                List _list_1 = IterableExtensions.toList(_singleton_1);
                modelManager.saveModel(_list_1);
            }
            modelManager.dispose();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void reverseProject(IParent parent) {
        try {
            if (!(parent instanceof ITranslationUnit)) {
                ICElement[] _children = parent.getChildren();
                Iterable _filter = Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_children)), ITranslationUnit.class);
                Consumer<ITranslationUnit> _function = new Consumer<ITranslationUnit>(){

                    @Override
                    public void accept(ITranslationUnit it) {
                        String _elementName = it.getElementName();
                        String _plus = "Parsing types in " + _elementName;
                        ReverseCpp2Uml.this.m_monitor.subTask(_plus);
                        ReverseCpp2Uml.this.reverseHeader(it);
                    }
                };
                _filter.forEach(_function);
                ICElement[] _children_1 = parent.getChildren();
                Iterable _filter_1 = Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_children_1)), IParent.class);
                Consumer<IParent> _function_1 = new Consumer<IParent>(){

                    @Override
                    public void accept(IParent it) {
                        ReverseCpp2Uml.this.reverseProject(it);
                    }
                };
                _filter_1.forEach(_function_1);
                ICElement[] _children_2 = parent.getChildren();
                Iterable _filter_2 = Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_children_2)), ITranslationUnit.class);
                Functions.Function1<ITranslationUnit, Boolean> _function_2 = new Functions.Function1<ITranslationUnit, Boolean>(){

                    public Boolean apply(ITranslationUnit it) {
                        boolean _isHeaderUnit = it.isHeaderUnit();
                        return !_isHeaderUnit;
                    }
                };
                Iterable _filter_3 = IterableExtensions.filter((Iterable)_filter_2, (Functions.Function1)_function_2);
                Consumer<ITranslationUnit> _function_3 = new Consumer<ITranslationUnit>(){

                    @Override
                    public void accept(ITranslationUnit it) {
                        String _elementName = it.getElementName();
                        String _plus = "Parsing method implementations in " + _elementName;
                        ReverseCpp2Uml.this.m_monitor.subTask(_plus);
                        ReverseCpp2Uml.this.reverseSource(it);
                    }
                };
                _filter_3.forEach(_function_3);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private Model getCorrespondingModel(ITranslationUnit unit) {
        Model ret = null;
        for (Model model : this.m_models) {
            String _name;
            IPath _path = unit.getPath();
            String _string = _path.toString();
            boolean _contains = _string.contains(_name = model.getName());
            if (!_contains) continue;
            ret = model;
        }
        return ret;
    }

    private void reverseSource(ITranslationUnit unit) {
        String _elementName = this.m_project.getElementName();
        Model _correspondingModel = this.getCorrespondingModel(unit);
        BatchReverseFunctionBody sync = new BatchReverseFunctionBody(unit, _elementName, _correspondingModel, this);
        try {
            sync.run();
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                e.printStackTrace();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    private List<Type> reverseHeader(ITranslationUnit headerUnit) {
        try {
            Model _correspondingModel = this.getCorrespondingModel(headerUnit);
            return this.getOrCreateClassifier(_correspondingModel, (IParent)headerUnit);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private List<Type> getOrCreateClassifier(Model model, IParent parent) throws Exception {
        UniqueEList ret = new UniqueEList();
        ICElement[] childrend = parent.getChildren();
        int i = 0;
        while (i < childrend.length) {
            ICElement child = childrend[i];
            boolean _matched = false;
            if (!_matched) {
                if (child instanceof IStructure) {
                    _matched = true;
                }
                if (!_matched && child instanceof IEnumeration) {
                    _matched = true;
                }
                if (_matched) {
                    boolean _not;
                    String _elementName = ((IDeclaration)child).getElementName();
                    boolean _equals = _elementName.equals("");
                    boolean bl = _not = !_equals;
                    if (_not) {
                        List<Type> _orcreateTypes = this.getOrcreateTypes((IDeclaration)child, parent, model);
                        ret.addAll(_orcreateTypes);
                    }
                }
            }
            if (!_matched && child instanceof IMethod) {
                ICElement _parent;
                boolean _not_1;
                _matched = true;
                boolean _and = false;
                ITranslationUnit _translationUnit = ((IMethod)child).getTranslationUnit();
                boolean _isHeaderUnit = _translationUnit.isHeaderUnit();
                _and = !_isHeaderUnit ? false : (_not_1 = !((_parent = child.getParent()) instanceof IStructure));
                if (_and) {
                    boolean _greaterThan;
                    List<String> _contextNamespaces;
                    IMethod method = (IMethod)child;
                    ITranslationUnit _translationUnit_1 = method.getTranslationUnit();
                    UniqueEList<Classifier> types = this.getTypeByQualifiedName((ICElement)method, _translationUnit_1, _contextNamespaces = this.getContextNamespaces((ICElement)method));
                    int _size = types.size();
                    boolean bl = _greaterThan = _size > 0;
                    if (_greaterThan) {
                        Classifier type = (Classifier)types.get(0);
                        ITranslationUnit _translationUnit_2 = method.getTranslationUnit();
                        ICProject _cProject = method.getCProject();
                        String _elementName_1 = _cProject.getElementName();
                        BatchReverseFunctionBody batchReverser = new BatchReverseFunctionBody(_translationUnit_2, _elementName_1, this, type);
                        String name = method.getElementName();
                        IASTNode node = this.findEnclosingNode((ISourceReference)method);
                        if (node instanceof IASTFunctionDefinition) {
                            boolean _notEquals;
                            IASTFunctionDefinition definition = (IASTFunctionDefinition)node;
                            IASTFunctionDeclarator declarator = definition.getDeclarator();
                            String body = this.getBody((IMethodDeclaration)method);
                            Operation operation = batchReverser.updateMethod((IFunctionDeclaration)method, node, 0, parent, name, body, declarator);
                            boolean bl2 = _notEquals = !Objects.equal((Object)operation, null);
                            if (_notEquals) {
                                ITranslationUnit _translationUnit_3 = method.getTranslationUnit();
                                DependencyAnalysis _dependencyAnalysis = new DependencyAnalysis(operation, definition, _translationUnit_3, this);
                                _dependencyAnalysis.analyzeDependencies();
                            }
                        }
                    }
                }
            }
            if (!_matched && child instanceof IFunction) {
                _matched = true;
            }
            if (!_matched && child instanceof IParent) {
                _matched = true;
                List<Type> _orCreateClassifier = this.getOrCreateClassifier(model, (IParent)child);
                ret.addAll(_orCreateClassifier);
            }
            if (!_matched && child instanceof ITypeDef) {
                _matched = true;
                ITranslationUnit _translationUnit_4 = ((ITypeDef)child).getTranslationUnit();
                Package parentPack = this.getContainerPackage(_translationUnit_4);
                Classifier tempType = null;
                ICElement _parent_1 = child.getParent();
                if (_parent_1 instanceof IStructure) {
                    String _elementName_3;
                    List<String> _contextNamespaces_1;
                    ITranslationUnit _translationUnit_5;
                    ICElement _parent_2 = child.getParent();
                    String _elementName_2 = _parent_2.getElementName();
                    Type _uMLType = this.getUMLType(_elementName_2, _translationUnit_5 = ((ITypeDef)child).getTranslationUnit(), _contextNamespaces_1 = this.getContextNamespaces(child));
                    Classifier parentClass = (Classifier)_uMLType;
                    NamedElement _ownedMember = parentClass.getOwnedMember(_elementName_3 = child.getElementName());
                    boolean _equals_1 = Objects.equal((Object)_ownedMember, null);
                    if (_equals_1) {
                        this.createOrgetClassifier((PackageableElement)parentClass, child, true);
                    }
                    String _elementName_4 = child.getElementName();
                    NamedElement _ownedMember_1 = parentClass.getOwnedMember(_elementName_4);
                    tempType = (Classifier)_ownedMember_1;
                } else {
                    String _elementName_5 = child.getElementName();
                    Type _ownedType = parentPack.getOwnedType(_elementName_5);
                    boolean _equals_2 = Objects.equal((Object)_ownedType, null);
                    if (_equals_2) {
                        this.createOrgetClassifier((PackageableElement)parentPack, child, true);
                    }
                    String _elementName_6 = child.getElementName();
                    NamedElement _ownedMember_2 = parentPack.getOwnedMember(_elementName_6);
                    tempType = (Classifier)_ownedMember_2;
                }
                ret.add(tempType);
            }
            ++i;
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Type> getOrcreateTypes(IDeclaration iStructure, IParent parent, Model model) {
        try {
            ICElement[] _children_2;
            Include _stereotypeApplication;
            boolean _isApplied;
            boolean _not;
            int _size_1;
            boolean _notEquals;
            UniqueEList ret = new UniqueEList();
            String _elementName = iStructure.getElementName();
            String _plus = "Parsing type " + _elementName;
            this.m_monitor.subTask(_plus);
            Classifier tempType = null;
            IDeclaration istructure = iStructure;
            String elementName = istructure.getElementName();
            ITranslationUnit _translationUnit = istructure.getTranslationUnit();
            Package parentPack = this.getContainerPackage(_translationUnit);
            Classifier parentClass = null;
            ICElement _parent = istructure.getParent();
            if (_parent instanceof IStructure) {
                List<String> _contextNamespaces;
                ITranslationUnit _translationUnit_1;
                ICElement _parent_1 = istructure.getParent();
                String _elementName_1 = _parent_1.getElementName();
                Type _uMLType = this.getUMLType(_elementName_1, _translationUnit_1 = istructure.getTranslationUnit(), _contextNamespaces = this.getContextNamespaces((ICElement)istructure));
                parentClass = (Classifier)_uMLType;
                NamedElement _ownedMember = parentClass.getOwnedMember(elementName);
                boolean _equals = Objects.equal((Object)_ownedMember, null);
                if (_equals) {
                    this.createOrgetClassifier((PackageableElement)parentClass, (ICElement)istructure, true);
                }
                NamedElement _ownedMember_1 = parentClass.getOwnedMember(elementName);
                tempType = (Classifier)_ownedMember_1;
            } else {
                Type _ownedType = parentPack.getOwnedType(elementName);
                boolean _equals_1 = Objects.equal((Object)_ownedType, null);
                if (_equals_1) {
                    this.createOrgetClassifier((PackageableElement)parentPack, (ICElement)istructure, true);
                }
                NamedElement _ownedMember_2 = parentPack.getOwnedMember(elementName);
                tempType = (Classifier)_ownedMember_2;
            }
            boolean bl = _notEquals = !Objects.equal((Object)tempType, null);
            if (_notEquals) {
                ret.add(tempType);
                if (istructure instanceof IParent) {
                    UniqueEList nestedStructures = new UniqueEList();
                    ICElement[] _children = ((IParent)istructure).getChildren();
                    Iterable _filter = Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_children)), IDeclaration.class);
                    Iterables.addAll((Collection)nestedStructures, (Iterable)_filter);
                    ICElement[] _children_1 = ((IParent)istructure).getChildren();
                    Iterable _filter_1 = Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_children_1)), ITypeDef.class);
                    Iterables.addAll((Collection)nestedStructures, (Iterable)_filter_1);
                    int _size = nestedStructures.size();
                    ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size, true);
                    for (Integer i : _doubleDotLessThan) {
                        EObject _createOrgetClassifier_1;
                        Type t_1;
                        boolean _notEquals_2;
                        boolean isAnonEnumInstance;
                        ICElement ns;
                        block37: {
                            boolean _not2;
                            ns = (ICElement)nestedStructures.get(i);
                            String _elementName_2 = ns.getElementName();
                            String _trim = _elementName_2.trim();
                            boolean _isEmpty = _trim.isEmpty();
                            boolean bl2 = _not2 = !_isEmpty;
                            if (_not2) {
                                EObject _createOrgetClassifier = this.createOrgetClassifier((PackageableElement)tempType, ns, true);
                                Type t = (Type)_createOrgetClassifier;
                                boolean _notEquals_1 = !Objects.equal((Object)t, null);
                                if (!_notEquals_1) continue;
                                ret.add(t);
                                continue;
                            }
                            if (!(ns instanceof IEnumeration)) continue;
                            isAnonEnumInstance = false;
                            try {
                                ICElement nextNs;
                                boolean _lessThan;
                                int _size_12 = nestedStructures.size();
                                boolean bl3 = _lessThan = i + 1 < _size_12;
                                if (!_lessThan || !((nextNs = (ICElement)nestedStructures.get(i + 1)) instanceof IField)) break block37;
                                IASTNode _findEnclosingNode = this.findEnclosingNode((ISourceReference)ns);
                                String nsRaw = _findEnclosingNode.getRawSignature();
                                IASTNode _findEnclosingNode_1 = this.findEnclosingNode((ISourceReference)nextNs);
                                String nextNsRaw = _findEnclosingNode_1.getRawSignature();
                                boolean _contains = nextNsRaw.contains(nsRaw);
                                if (_contains) {
                                    isAnonEnumInstance = true;
                                }
                            }
                            catch (Throwable _t) {
                                if (!(_t instanceof Exception)) throw Exceptions.sneakyThrow((Throwable)_t);
                                Exception e = (Exception)_t;
                                e.printStackTrace();
                            }
                        }
                        if (isAnonEnumInstance || !(_notEquals_2 = !Objects.equal((Object)(t_1 = (Type)(_createOrgetClassifier_1 = this.createOrgetClassifier((PackageableElement)tempType, ns, true))), null))) continue;
                        ret.add(t_1);
                    }
                }
            }
            if (istructure instanceof IStructureTemplate) {
                IStructureTemplate istructureTemplate = (IStructureTemplate)istructure;
                int ti = 0;
                while (ti < ((List)Conversions.doWrapArray((Object)istructureTemplate.getTemplateParameterTypes())).size()) {
                    String[] _templateParameterTypes = istructureTemplate.getTemplateParameterTypes();
                    String _get = _templateParameterTypes[ti];
                    this.createOrgetTemplateParameter((NamedElement)tempType, _get, "class");
                    ++ti;
                }
            }
            boolean _greaterThan = (_size_1 = ret.size()) > 0;
            if (!_greaterThan) return ret;
            if (tempType instanceof Enumeration) return ret;
            if (tempType instanceof PrimitiveType) return ret;
            ITranslationUnit structureItu = istructure.getTranslationUnit();
            IParent file = parent;
            List<IInclude> excludedIncludes = null;
            if (structureItu instanceof IParent) {
                List<IInclude> _get;
                file = structureItu;
                String key = this.getExcludedIncludesMapKey(structureItu, (Element)tempType);
                excludedIncludes = _get = this.excludedIncludesMap.get(key);
            }
            boolean bl4 = _not = !(_isApplied = StereotypeUtil.isApplied((Element)tempType, Include.class));
            if (_not) {
                StereotypeUtil.apply((Element)tempType, Include.class);
            }
            boolean _notEquals_1 = !Objects.equal((Object)(_stereotypeApplication = (Include)UMLUtil.getStereotypeApplication((Element)tempType, Include.class)), null);
            if (!_notEquals_1) return ret;
            Include _stereotypeApplication_1 = (Include)UMLUtil.getStereotypeApplication((Element)tempType, Include.class);
            String header = _stereotypeApplication_1.getHeader();
            String escape = "";
            ICElement[] t_1 = _children_2 = file.getChildren();
            int _createOrgetClassifier_1 = _children_2.length;
            int isAnonEnumInstance = 0;
            while (true) {
                block38: {
                    ICElement j;
                    block39: {
                        String _elementName_2;
                        boolean _contains_1;
                        boolean _not_1;
                        boolean _notEquals_2;
                        if (isAnonEnumInstance >= _createOrgetClassifier_1) {
                            Include _stereotypeApplication_2 = (Include)UMLUtil.getStereotypeApplication((Element)tempType, Include.class);
                            _stereotypeApplication_2.setHeader(header);
                            if (!(file instanceof ITranslationUnit)) return ret;
                            try {
                                IPath _path = ((ITranslationUnit)file).getPath();
                                IPath _removeFileExtension = _path.removeFileExtension();
                                IPath sourcePath = _removeFileExtension.addFileExtension("cpp");
                                ICProject _cProject = ((ITranslationUnit)file).getCProject();
                                ICElement sourceFile = _cProject.findElement(sourcePath);
                                if (!(sourceFile instanceof ITranslationUnit)) return ret;
                                BatchReverseFunctionBody.updateCppInclude((ITranslationUnit)sourceFile, tempType);
                                return ret;
                            }
                            catch (Throwable _t_1) {
                                if (!(_t_1 instanceof Exception)) throw Exceptions.sneakyThrow((Throwable)_t_1);
                                Exception exception = (Exception)_t_1;
                                return ret;
                            }
                        }
                        j = t_1[isAnonEnumInstance];
                        if (!(j instanceof IInclude)) break block39;
                        boolean excluded = false;
                        boolean bl5 = _notEquals_2 = !Objects.equal(excludedIncludes, null);
                        if (_notEquals_2) {
                            boolean _contains;
                            excluded = _contains = excludedIncludes.contains(j);
                        }
                        boolean _and = false;
                        _and = excluded ? false : (_not_1 = !(_contains_1 = header.contains(_elementName_2 = ((IInclude)j).getElementName())));
                        if (_and) {
                            String _elementName_3 = ((IInclude)j).getElementName();
                            boolean _contains_2 = _elementName_3.contains("Pkg_");
                            if (_contains_2) {
                                try {
                                    boolean _not_2;
                                    String _elementName_4 = ((IInclude)j).getElementName();
                                    String[] includeTokens = _elementName_4.split("/");
                                    String includeTrimmed = "";
                                    int _length = includeTokens.length;
                                    int _minus = _length - 1;
                                    ExclusiveRange _doubleDotLessThan_1 = new ExclusiveRange(0, _minus, true);
                                    for (Integer i_1 : _doubleDotLessThan_1) {
                                        String _includeTrimmed = includeTrimmed;
                                        String _get_1 = includeTokens[i_1];
                                        includeTrimmed = String.valueOf(_includeTrimmed) + _get_1;
                                    }
                                    String _qualifiedName = tempType.getQualifiedName();
                                    String[] typeQualifiedNameTokens = _qualifiedName.split("::");
                                    String typeQualifiedNameTrimmed = "";
                                    int _length_1 = typeQualifiedNameTokens.length;
                                    int _minus_1 = _length_1 - 1;
                                    ExclusiveRange _doubleDotLessThan_2 = new ExclusiveRange(1, _minus_1, true);
                                    Iterator iterator = _doubleDotLessThan_2.iterator();
                                    while (true) {
                                        if (!iterator.hasNext()) {
                                            boolean _equals_2 = includeTrimmed.equals(typeQualifiedNameTrimmed);
                                            boolean bl6 = _not_2 = !_equals_2;
                                        }
                                        Integer i_2 = (Integer)iterator.next();
                                        String _typeQualifiedNameTrimmed = typeQualifiedNameTrimmed;
                                        String _get_2 = typeQualifiedNameTokens[i_2];
                                        typeQualifiedNameTrimmed = String.valueOf(_typeQualifiedNameTrimmed) + _get_2;
                                    }
                                    if (_not_2) {
                                        String _plus_2;
                                        String _elementName_5 = ((IInclude)j).getElementName();
                                        String _plus_1 = String.valueOf(header) + escape + "#include " + "\"" + _elementName_5;
                                        header = _plus_2 = String.valueOf(_plus_1) + "\"";
                                        escape = "\n";
                                    }
                                    break block38;
                                }
                                catch (Throwable _t) {
                                    String _plus_4;
                                    if (!(_t instanceof Exception)) throw Exceptions.sneakyThrow((Throwable)_t);
                                    Exception e = (Exception)_t;
                                    e.printStackTrace();
                                    String _elementName_6 = ((IInclude)j).getElementName();
                                    String _plus_3 = String.valueOf(header) + escape + "#include " + "\"" + _elementName_6;
                                    header = _plus_4 = String.valueOf(_plus_3) + "\"";
                                    escape = "\n";
                                }
                                break block38;
                            } else {
                                String _plus_6;
                                String _elementName_7 = ((IInclude)j).getElementName();
                                String _plus_5 = String.valueOf(header) + escape + "#include " + "\"" + _elementName_7;
                                header = _plus_6 = String.valueOf(_plus_5) + "\"";
                                escape = "\n";
                            }
                        }
                        break block38;
                    }
                    if (j instanceof IMacro) {
                        boolean _not_3;
                        String _elementName_8 = ((IMacro)j).getElementName();
                        boolean _contains_3 = header.contains(_elementName_8);
                        boolean bl7 = _not_3 = !_contains_3;
                        if (_not_3) {
                            boolean _notEquals_3;
                            IASTNode node = this.findEnclosingNode((ISourceReference)j);
                            boolean bl8 = _notEquals_3 = !Objects.equal((Object)node, null);
                            if (_notEquals_3) {
                                boolean _equals_4;
                                String nodeString = node.toString();
                                int _indexOf = nodeString.indexOf("=");
                                int _plus_7 = _indexOf + 1;
                                String value = nodeString.substring(_plus_7);
                                boolean _or = false;
                                boolean _equals_3 = Objects.equal((Object)value, null);
                                _or = _equals_3 ? true : (_equals_4 = value.equals(""));
                                if (_or) {
                                    boolean _not_4;
                                    String _name;
                                    String _replaceAll;
                                    String _upperCase;
                                    String _elementName_9 = ((IMacro)j).getElementName();
                                    boolean _contains_4 = _elementName_9.contains(_upperCase = (_replaceAll = (_name = tempType.getName()).replaceAll(" ", "")).toUpperCase());
                                    boolean bl9 = _not_4 = !_contains_4;
                                    if (_not_4) {
                                        String _plus_10;
                                        String _elementName_10 = ((IMacro)j).getElementName();
                                        String _plus_8 = String.valueOf(header) + escape + "#define " + _elementName_10;
                                        String _plus_9 = String.valueOf(_plus_8) + " ";
                                        header = _plus_10 = String.valueOf(_plus_9) + value;
                                        escape = "\n";
                                    }
                                } else {
                                    String _plus_13;
                                    String _elementName_11 = ((IMacro)j).getElementName();
                                    String _plus_11 = String.valueOf(header) + escape + "#define " + _elementName_11;
                                    String _plus_12 = String.valueOf(_plus_11) + " ";
                                    header = _plus_13 = String.valueOf(_plus_12) + value;
                                    escape = "\n";
                                }
                            }
                        }
                    }
                }
                ++isAnonEnumInstance;
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private Object checkICElementInModelChanges(ICElement icElement) {
        return null;
    }

    private void syncTranslationUnit(ITranslationUnit itu) {
        try {
            List<ICElement> _allIStructures = this.reverse_utils.getAllIStructures((IParent)itu, false, true, this.m_project);
            Iterable structures = Iterables.filter(_allIStructures, IStructure.class);
            for (IStructure structure : structures) {
                String _elementName;
                Model _correspondingModel = this.getCorrespondingModel(itu);
                Type classifier = this.getClassifier(_correspondingModel, (ICElement)structure, _elementName = structure.getElementName(), itu);
                if (!(classifier instanceof Classifier)) continue;
                this.syncIStructureToModel((Classifier)classifier, structure);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private Object syncIStructureToModel(Classifier classifier, IStructure istructure) {
        try {
            Object _xblockexpression = null;
            ICElement[] _children = istructure.getChildren();
            Iterable _filter = Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_children)), IField.class);
            List fields = IterableExtensions.toList((Iterable)_filter);
            EList _ownedElements = classifier.getOwnedElements();
            Iterable _filter_1 = Iterables.filter((Iterable)_ownedElements, Property.class);
            List attributes = IterableExtensions.toList((Iterable)_filter_1);
            this.mergeAttributes(classifier, attributes, fields);
            ICElement[] _children_1 = istructure.getChildren();
            Iterable _filter_2 = Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_children_1)), IMethodDeclaration.class);
            List methods = IterableExtensions.toList((Iterable)_filter_2);
            EList _ownedElements_1 = classifier.getOwnedElements();
            Iterable _filter_3 = Iterables.filter((Iterable)_ownedElements_1, Operation.class);
            List operations = IterableExtensions.toList((Iterable)_filter_3);
            this.mergeOperations(classifier, operations, methods);
            ICElement[] _children_2 = istructure.getChildren();
            Iterable _filter_4 = Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_children_2)), IDeclaration.class);
            List declarations = IterableExtensions.toList((Iterable)_filter_4);
            EList _ownedElements_2 = classifier.getOwnedElements();
            Iterable _filter_5 = Iterables.filter((Iterable)_ownedElements_2, Type.class);
            List nestedTypes = IterableExtensions.toList((Iterable)_filter_5);
            _xblockexpression = this.mergeNestedTypes(classifier, nestedTypes, declarations);
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void mergeAttributes(Classifier parent, List<Property> attributes, List<IField> fields) {
        try {
            Iterable _filter_1;
            Object _function_1;
            UniqueEList foundFieldList = new UniqueEList();
            UniqueEList notFoundFieldList = new UniqueEList();
            UniqueEList foundAttrList = new UniqueEList();
            UniqueEList notFoundAttrList = new UniqueEList();
            for (final IField field : fields) {
                boolean isModelObjectChanged;
                Functions.Function1<Property, Boolean> _function = new Functions.Function1<Property, Boolean>(){

                    public Boolean apply(Property it) {
                        String _name = it.getName();
                        String _elementName = field.getElementName();
                        return _name.equals(_elementName);
                    }
                };
                Iterable _filter = IterableExtensions.filter(attributes, (Functions.Function1)_function);
                final Property attrFound = (Property)IterableExtensions.head((Iterable)_filter);
                boolean _equals = Objects.equal((Object)attrFound, null);
                if (_equals) {
                    notFoundFieldList.add((Object)field);
                    continue;
                }
                foundAttrList.add((Object)attrFound);
                foundFieldList.add((Object)field);
                _function_1 = new Functions.Function1<ModelChangeObject, Boolean>(){

                    public Boolean apply(ModelChangeObject it) {
                        return Objects.equal((Object)it.eObject, (Object)attrFound);
                    }
                };
                _filter_1 = IterableExtensions.filter(modelChangeList, (Functions.Function1)_function_1);
                ModelChangeObject _head = (ModelChangeObject)IterableExtensions.head((Iterable)_filter_1);
                boolean bl = isModelObjectChanged = !Objects.equal((Object)_head, null);
                if (isModelObjectChanged) {
                    this.syncAttributeWithMode(parent, attrFound, field, this.conflictResolveMode);
                    continue;
                }
                this.syncAttributeWithMode(parent, attrFound, field, ConflictResolutionMode.FROM_CODE);
            }
            for (Property attr : attributes) {
                boolean _not;
                boolean _contains = foundAttrList.contains((Object)attr);
                boolean bl = _not = !_contains;
                if (!_not) continue;
                notFoundAttrList.add((Object)attr);
            }
            Functions.Function1<ModelChangeObject, Boolean> _function = new Functions.Function1<ModelChangeObject, Boolean>(){

                public Boolean apply(ModelChangeObject it) {
                    return it.eventType == 3;
                }
            };
            Iterable _filter = IterableExtensions.filter(modelChangeList, (Functions.Function1)_function);
            List addChanges = IterableExtensions.toList((Iterable)_filter);
            UniqueEList tobeRemovedsInNotFound = new UniqueEList();
            for (final Property attr_1 : notFoundAttrList) {
                boolean _notEquals;
                _function_1 = new Functions.Function1<ModelChangeObject, Boolean>(){

                    public Boolean apply(ModelChangeObject it) {
                        return Objects.equal((Object)it.eObject, (Object)attr_1);
                    }
                };
                _filter_1 = IterableExtensions.filter((Iterable)addChanges, (Functions.Function1)_function_1);
                ModelChangeObject modelChangeObj = (ModelChangeObject)IterableExtensions.head((Iterable)_filter_1);
                boolean bl = _notEquals = !Objects.equal((Object)modelChangeObj, null);
                if (!_notEquals) continue;
                tobeRemovedsInNotFound.add((Object)attr_1);
            }
            for (Property i : tobeRemovedsInNotFound) {
                notFoundAttrList.remove((Object)i);
            }
            UniqueEList processedFields = new UniqueEList();
            UniqueEList remainingFields = new UniqueEList();
            UniqueEList remainingAttributes = new UniqueEList();
            for (IField notFoundField : notFoundFieldList) {
                boolean _lessThan;
                boolean _not_1;
                boolean _contains_1 = processedFields.contains((Object)notFoundField);
                boolean bl = _not_1 = !_contains_1;
                if (!_not_1) continue;
                List<String> _contextNamespaces = this.getContextNamespaces((ICElement)notFoundField);
                final Type umlType = this.getUMLType((IVariableDeclaration)notFoundField, _contextNamespaces);
                String _typeName = notFoundField.getTypeName();
                final String typeName = this.getCppTypeName(_typeName);
                Functions.Function1<IField, Boolean> _function_12 = new Functions.Function1<IField, Boolean>(){

                    public Boolean apply(IField it) {
                        try {
                            String _typeName = it.getTypeName();
                            String _cppTypeName = ReverseCpp2Uml.this.getCppTypeName(_typeName);
                            return _cppTypeName.equals(typeName);
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                };
                Iterable _filter_12 = IterableExtensions.filter((Iterable)notFoundFieldList, (Functions.Function1)_function_12);
                List sameTypeNameFields = IterableExtensions.toList((Iterable)_filter_12);
                Functions.Function1<Property, Boolean> _function_2 = new Functions.Function1<Property, Boolean>(){

                    public Boolean apply(Property it) {
                        Type _type = it.getType();
                        String _name = _type.getName();
                        String _name_1 = umlType.getName();
                        return _name.equals(_name_1);
                    }
                };
                Iterable _filter_2 = IterableExtensions.filter((Iterable)notFoundAttrList, (Functions.Function1)_function_2);
                List sameTypeAttrs = IterableExtensions.toList((Iterable)_filter_2);
                int i_1 = 0;
                i_1 = 0;
                while (i_1 < sameTypeNameFields.size()) {
                    boolean _greaterEqualsThan;
                    int _size = sameTypeAttrs.size();
                    boolean bl2 = _greaterEqualsThan = i_1 >= _size;
                    if (_greaterEqualsThan) {
                        IField _get = (IField)sameTypeNameFields.get(i_1);
                        remainingFields.add((Object)_get);
                    } else {
                        boolean isModelObjectChanged;
                        IField tobeProcessedField = (IField)sameTypeNameFields.get(i_1);
                        final Property tobeProcessedAttr = (Property)sameTypeAttrs.get(i_1);
                        Functions.Function1<ModelChangeObject, Boolean> _function_3 = new Functions.Function1<ModelChangeObject, Boolean>(){

                            public Boolean apply(ModelChangeObject it) {
                                return Objects.equal((Object)it.eObject, (Object)tobeProcessedAttr);
                            }
                        };
                        Iterable _filter_3 = IterableExtensions.filter(modelChangeList, (Functions.Function1)_function_3);
                        ModelChangeObject _head = (ModelChangeObject)IterableExtensions.head((Iterable)_filter_3);
                        boolean bl3 = isModelObjectChanged = !Objects.equal((Object)_head, null);
                        if (isModelObjectChanged) {
                            this.syncAttributeWithMode(parent, tobeProcessedAttr, tobeProcessedField, ConflictResolutionMode.FROM_MODEL);
                        } else {
                            this.syncAttributeWithMode(parent, tobeProcessedAttr, tobeProcessedField, ConflictResolutionMode.FROM_CODE);
                        }
                        processedFields.add((Object)tobeProcessedField);
                        notFoundAttrList.remove((Object)tobeProcessedAttr);
                    }
                    ++i_1;
                }
                List _converted_sameTypeAttrs = sameTypeAttrs;
                int _length = ((Object[])Conversions.unwrapArray((Object)_converted_sameTypeAttrs, Object.class)).length;
                boolean bl4 = _lessThan = i_1 < _length;
                if (!_lessThan) continue;
                int j = i_1;
                while (j < ((Object[])Conversions.unwrapArray((Object)sameTypeAttrs, Object.class)).length) {
                    Property _get = (Property)sameTypeAttrs.get(j);
                    remainingAttributes.add((Object)_get);
                    ++j;
                }
            }
            for (Property notFoundAttr : notFoundAttrList) {
                boolean _not_2;
                boolean _contains_2 = remainingAttributes.contains((Object)notFoundAttr);
                boolean bl = _not_2 = !_contains_2;
                if (!_not_2) continue;
                remainingAttributes.add((Object)notFoundAttr);
            }
            for (IField remaining : remainingFields) {
                this.createProperty(remaining, parent);
            }
            Functions.Function1<ModelChangeObject, Boolean> _function_3 = new Functions.Function1<ModelChangeObject, Boolean>(){

                public Boolean apply(ModelChangeObject it) {
                    return it.eventType == 3 || it.eventType == 1;
                }
            };
            Iterable _filter_3 = IterableExtensions.filter(modelChangeList, (Functions.Function1)_function_3);
            List remainingChanges = IterableExtensions.toList((Iterable)_filter_3);
            for (final Property remaining_1 : remainingAttributes) {
                Functions.Function1<ModelChangeObject, Boolean> _function_4 = new Functions.Function1<ModelChangeObject, Boolean>(){

                    public Boolean apply(ModelChangeObject it) {
                        return Objects.equal((Object)it.eObject, (Object)remaining_1);
                    }
                };
                Iterable _filter_4 = IterableExtensions.filter((Iterable)remainingChanges, (Functions.Function1)_function_4);
                boolean _isEmpty = IterableExtensions.isEmpty((Iterable)_filter_4);
                if (!_isEmpty) continue;
                if (parent instanceof Class) {
                    EList _ownedAttributes = ((Class)parent).getOwnedAttributes();
                    _ownedAttributes.remove((Object)remaining_1);
                    continue;
                }
                if (!(parent instanceof DataType)) continue;
                EList _ownedAttributes_1 = ((DataType)parent).getOwnedAttributes();
                _ownedAttributes_1.remove((Object)remaining_1);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private Boolean syncAttributeWithMode(Classifier parent, final Property attribute, IField field, ConflictResolutionMode resolveMode) {
        Boolean _switchResult = null;
        if (resolveMode != null) {
            switch (resolveMode) {
                case FROM_MODEL: {
                    _switchResult = null;
                    break;
                }
                case FROM_CODE: {
                    boolean _notEquals;
                    boolean _xblockexpression = false;
                    List<String> _contextNamespaces = this.getContextNamespaces((ICElement)field);
                    Type type = this.getUMLType((IVariableDeclaration)field, _contextNamespaces);
                    attribute.setType(type);
                    String _elementName = field.getElementName();
                    attribute.setName(_elementName);
                    this.updateProperty(field, attribute);
                    Functions.Function1<ModelChangeObject, Boolean> _function = new Functions.Function1<ModelChangeObject, Boolean>(){

                        public Boolean apply(ModelChangeObject it) {
                            return Objects.equal((Object)it.eObject, (Object)attribute);
                        }
                    };
                    Iterable _filter = IterableExtensions.filter(modelChangeList, (Functions.Function1)_function);
                    ModelChangeObject changeObj = (ModelChangeObject)IterableExtensions.head((Iterable)_filter);
                    boolean _xifexpression = false;
                    boolean bl = _notEquals = !Objects.equal((Object)changeObj, null);
                    if (_notEquals) {
                        _xifexpression = modelChangeList.remove(changeObj);
                    }
                    _xblockexpression = _xifexpression;
                    _switchResult = _xblockexpression;
                    break;
                }
                case UI_INTERACTION: {
                    _switchResult = null;
                    break;
                }
            }
        }
        return _switchResult;
    }

    private Boolean syncOperationWithMode(Classifier parent, final Operation op, IMethodDeclaration method, ConflictResolutionMode resolveMode) {
        Boolean _switchResult = null;
        if (resolveMode != null) {
            switch (resolveMode) {
                case FROM_MODEL: {
                    _switchResult = null;
                    break;
                }
                case FROM_CODE: {
                    boolean _notEquals;
                    boolean _xblockexpression = false;
                    String _elementName = method.getElementName();
                    op.setName(_elementName);
                    this.updateMethod((Class)parent, op, method);
                    Functions.Function1<ModelChangeObject, Boolean> _function = new Functions.Function1<ModelChangeObject, Boolean>(){

                        public Boolean apply(ModelChangeObject it) {
                            return Objects.equal((Object)it.eObject, (Object)op);
                        }
                    };
                    Iterable _filter = IterableExtensions.filter(modelChangeList, (Functions.Function1)_function);
                    ModelChangeObject changeObj = (ModelChangeObject)IterableExtensions.head((Iterable)_filter);
                    boolean _xifexpression = false;
                    boolean bl = _notEquals = !Objects.equal((Object)changeObj, null);
                    if (_notEquals) {
                        _xifexpression = modelChangeList.remove(changeObj);
                    }
                    _xblockexpression = _xifexpression;
                    _switchResult = _xblockexpression;
                    break;
                }
                case UI_INTERACTION: {
                    _switchResult = null;
                    break;
                }
            }
        }
        return _switchResult;
    }

    private boolean isSameOperation(Operation op, IMethodDeclaration method) {
        boolean _isSameSignature;
        String _elementName;
        boolean ret = true;
        String _name = op.getName();
        boolean _equals = _name.equals(_elementName = method.getElementName());
        boolean _not = !_equals;
        ret = _not ? false : (_isSameSignature = this.isSameSignature(op, method));
        return ret;
    }

    private boolean isSameSignature(Operation op, IMethodDeclaration method) {
        int _size;
        boolean _notEquals;
        boolean ret = true;
        EList _ownedParameters = op.getOwnedParameters();
        Functions.Function1<Parameter, Boolean> _function = new Functions.Function1<Parameter, Boolean>(){

            public Boolean apply(Parameter it) {
                ParameterDirectionKind _direction = it.getDirection();
                return !Objects.equal((Object)_direction, (Object)ParameterDirectionKind.RETURN_LITERAL);
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_ownedParameters, (Functions.Function1)_function);
        List params = IterableExtensions.toList((Iterable)_filter);
        int _numberOfParameters = method.getNumberOfParameters();
        boolean bl = _notEquals = _numberOfParameters != (_size = params.size());
        if (_notEquals) {
            ret = false;
        } else {
            boolean _not;
            int i = 0;
            while (i < method.getNumberOfParameters()) {
                Parameter _get_1;
                Type _type;
                String _name;
                String[] _parameterTypes = method.getParameterTypes();
                String _get = _parameterTypes[i];
                String _cppTypeName = this.getCppTypeName(_get);
                boolean _equals = _cppTypeName.equals(_name = (_type = (_get_1 = (Parameter)params.get(i)).getType()).getName());
                boolean bl2 = _not = !_equals;
                if (_not) {
                    ret = false;
                }
                ++i;
            }
            if (ret) {
                Functions.Function1<Parameter, Boolean> _function_1;
                EList _ownedParameters_1 = op.getOwnedParameters();
                Iterable _filter_1 = IterableExtensions.filter((Iterable)_ownedParameters_1, (Functions.Function1)(_function_1 = new Functions.Function1<Parameter, Boolean>(){

                    public Boolean apply(Parameter it) {
                        ParameterDirectionKind _direction = it.getDirection();
                        return Objects.equal((Object)_direction, (Object)ParameterDirectionKind.RETURN_LITERAL);
                    }
                }));
                Parameter returnParam = (Parameter)IterableExtensions.head((Iterable)_filter_1);
                boolean _equals = Objects.equal((Object)returnParam, null);
                if (_equals) {
                    String _returnType = method.getReturnType();
                    String _cppTypeName = this.getCppTypeName(_returnType);
                    boolean _equals_1 = _cppTypeName.equals("void");
                    boolean bl3 = _not = !_equals_1;
                    if (_not) {
                        ret = false;
                    }
                } else {
                    Type _type_1;
                    String _name;
                    String _returnType_1;
                    String _cppTypeName_1;
                    boolean _equals_2;
                    boolean _not_1;
                    boolean _notEquals_1;
                    boolean _and = false;
                    Type _type = returnParam.getType();
                    boolean bl4 = _notEquals_1 = !Objects.equal((Object)_type, null);
                    _and = !_notEquals_1 ? false : (_not_1 = !(_equals_2 = (_cppTypeName_1 = this.getCppTypeName(_returnType_1 = method.getReturnType())).equals(_name = (_type_1 = returnParam.getType()).getName())));
                    if (_and) {
                        ret = false;
                    }
                }
            }
        }
        return ret;
    }

    private boolean isSameMethodDeclaration(IMethodDeclaration method1, IMethodDeclaration method2) {
        try {
            int _numberOfParameters_1;
            int _numberOfParameters;
            boolean _equals_11;
            String _returnType_3;
            boolean _notEquals_3;
            boolean _notEquals_2;
            boolean _isDestructor_1;
            boolean _isDestructor;
            boolean _equals_9;
            boolean _isConstructor_1;
            boolean _isConstructor;
            boolean _equals_8;
            boolean _isVolatile_1;
            boolean _isVolatile;
            boolean _equals_7;
            boolean _isFriend_1;
            boolean _isFriend;
            boolean _equals_6;
            boolean _isInline_1;
            boolean _isInline;
            boolean _equals_5;
            boolean _isVirtual_3;
            boolean _isVirtual_2;
            boolean _equals_4;
            boolean _isVirtual_1;
            boolean _isVirtual;
            boolean _equals_3;
            boolean _isStatic_1;
            boolean _isStatic;
            boolean _equals_2;
            boolean result = true;
            boolean _and = false;
            if (!result) {
                _and = false;
            } else {
                boolean _equals;
                String _signature = method1.getSignature();
                String _signature_1 = method2.getSignature();
                _and = _equals = _signature.equals(_signature_1);
            }
            result = _and;
            boolean _and_1 = false;
            if (!result) {
                _and_1 = false;
            } else {
                boolean _equals_1;
                ASTAccessVisibility _visibility = method1.getVisibility();
                VisibilityKind _convertVisibility = this.convertVisibility(_visibility);
                ASTAccessVisibility _visibility_1 = method2.getVisibility();
                VisibilityKind _convertVisibility_1 = this.convertVisibility(_visibility_1);
                _and_1 = _equals_1 = Objects.equal((Object)_convertVisibility, (Object)_convertVisibility_1);
            }
            result = _and_1;
            boolean _and_2 = false;
            _and_2 = !result ? false : (_equals_2 = (_isStatic = method1.isStatic()) == (_isStatic_1 = method2.isStatic()));
            result = _and_2;
            boolean _and_3 = false;
            _and_3 = !result ? false : (_equals_3 = (_isVirtual = method1.isVirtual()) == (_isVirtual_1 = method2.isVirtual()));
            result = _and_3;
            boolean _and_4 = false;
            _and_4 = !result ? false : (_equals_4 = (_isVirtual_2 = method1.isVirtual()) == (_isVirtual_3 = method2.isVirtual()));
            result = _and_4;
            boolean _and_5 = false;
            _and_5 = !result ? false : (_equals_5 = (_isInline = method1.isInline()) == (_isInline_1 = method2.isInline()));
            result = _and_5;
            boolean _and_6 = false;
            _and_6 = !result ? false : (_equals_6 = (_isFriend = method1.isFriend()) == (_isFriend_1 = method2.isFriend()));
            result = _and_6;
            boolean _and_7 = false;
            _and_7 = !result ? false : (_equals_7 = (_isVolatile = method1.isVolatile()) == (_isVolatile_1 = method2.isVolatile()));
            result = _and_7;
            boolean _and_8 = false;
            _and_8 = !result ? false : (_equals_8 = (_isConstructor = method1.isConstructor()) == (_isConstructor_1 = method2.isConstructor()));
            result = _and_8;
            boolean _and_9 = false;
            _and_9 = !result ? false : (_equals_9 = (_isDestructor = method1.isDestructor()) == (_isDestructor_1 = method2.isDestructor()));
            result = _and_9;
            boolean _and_10 = false;
            if (!result) {
                _and_10 = false;
            } else {
                String _returnType_1;
                boolean _notEquals_1;
                boolean _notEquals;
                boolean _and_11 = false;
                String _returnType = method1.getReturnType();
                boolean bl = _notEquals = !Objects.equal((Object)_returnType, null);
                _and_11 = !_notEquals ? false : (_notEquals_1 = !Objects.equal((Object)(_returnType_1 = method2.getReturnType()), null));
                _and_10 = _and_11;
            }
            result = _and_10;
            boolean _and_12 = false;
            String _returnType_2 = method1.getReturnType();
            boolean bl = _notEquals_2 = !Objects.equal((Object)_returnType_2, null);
            _and_12 = !_notEquals_2 ? false : (_notEquals_3 = !Objects.equal((Object)(_returnType_3 = method2.getReturnType()), null));
            if (_and_12) {
                boolean _and_13 = false;
                if (!result) {
                    _and_13 = false;
                } else {
                    boolean _equals_10;
                    String _returnType_4 = method1.getReturnType();
                    String _returnType_5 = method2.getReturnType();
                    _and_13 = _equals_10 = _returnType_4.equals(_returnType_5);
                }
                result = _and_13;
            }
            boolean _and_14 = false;
            _and_14 = !result ? false : (_equals_11 = (_numberOfParameters = method1.getNumberOfParameters()) == (_numberOfParameters_1 = method2.getNumberOfParameters()));
            if (!(result = _and_14)) {
                return result;
            }
            try {
                IASTFunctionDeclarator declarator1 = this.getDeclarator(method1);
                IASTFunctionDeclarator declarator2 = this.getDeclarator(method2);
                boolean _and_15 = false;
                if (!result) {
                    _and_15 = false;
                } else {
                    boolean _equals_12;
                    String _rawSignature = declarator1.getRawSignature();
                    String _rawSignature_1 = declarator2.getRawSignature();
                    _and_15 = _equals_12 = _rawSignature.equals(_rawSignature_1);
                }
                result = _and_15;
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    e.printStackTrace();
                    return result;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            return result;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private int getNumberOfSameParameters(Operation op, IMethodDeclaration method) {
        int ret = 0;
        EList _ownedParameters = op.getOwnedParameters();
        Functions.Function1<Parameter, Boolean> _function = new Functions.Function1<Parameter, Boolean>(){

            public Boolean apply(Parameter it) {
                ParameterDirectionKind _direction = it.getDirection();
                return !Objects.equal((Object)_direction, (Object)ParameterDirectionKind.RETURN_LITERAL);
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_ownedParameters, (Functions.Function1)_function);
        List params = IterableExtensions.toList((Iterable)_filter);
        int i = 0;
        while (i < method.getNumberOfParameters()) {
            boolean _lessEqualsThan;
            int _size = params.size();
            boolean bl = _lessEqualsThan = i <= _size;
            if (_lessEqualsThan) {
                boolean _notEquals;
                boolean _and = false;
                Parameter _get = (Parameter)params.get(i);
                Type _type = _get.getType();
                boolean bl2 = _notEquals = !Objects.equal((Object)_type, null);
                if (!_notEquals) {
                    _and = false;
                } else {
                    boolean _equals;
                    String[] _parameterTypes = method.getParameterTypes();
                    String _get_1 = _parameterTypes[i];
                    String _cppTypeName = this.getCppTypeName(_get_1);
                    Parameter _get_2 = (Parameter)params.get(i);
                    Type _type_1 = _get_2.getType();
                    String _name = _type_1.getName();
                    _and = _equals = _cppTypeName.equals(_name);
                }
                if (_and) {
                    ++ret;
                }
            }
            ++i;
        }
        return ret;
    }

    private Operation findMostSameOperation(List<Operation> ops, IMethodDeclaration method) {
        boolean _isEmpty = ops.isEmpty();
        if (_isEmpty) {
            return null;
        }
        Operation ret = (Operation)IterableExtensions.head(ops);
        for (Operation op : ops) {
            int _numberOfSameParameters_1;
            boolean _greaterThan;
            boolean _notEquals;
            boolean bl = _notEquals = !Objects.equal((Object)ret, (Object)op);
            if (!_notEquals) continue;
            int _numberOfSameParameters = this.getNumberOfSameParameters(op, method);
            boolean bl2 = _greaterThan = _numberOfSameParameters > (_numberOfSameParameters_1 = this.getNumberOfSameParameters(ret, method));
            if (!_greaterThan) continue;
            ret = op;
        }
        return ret;
    }

    private void mergeOperations(Classifier parent, List<Operation> operations, List<IMethodDeclaration> methods) {
        Iterable _filter_1;
        Object _function_1;
        UniqueEList foundMethodList = new UniqueEList();
        UniqueEList notFoundMethodList = new UniqueEList();
        UniqueEList foundOperationList = new UniqueEList();
        UniqueEList notFoundOperationList = new UniqueEList();
        for (final IMethodDeclaration method : methods) {
            boolean bl;
            Functions.Function1<Operation, Boolean> _function = new Functions.Function1<Operation, Boolean>(){

                public Boolean apply(Operation it) {
                    return ReverseCpp2Uml.this.isSameOperation(it, method);
                }
            };
            Iterable _filter = IterableExtensions.filter(operations, (Functions.Function1)_function);
            final Operation opFound = (Operation)IterableExtensions.head((Iterable)_filter);
            boolean _equals = Objects.equal((Object)opFound, null);
            if (_equals) {
                notFoundMethodList.add((Object)method);
                continue;
            }
            foundOperationList.add((Object)opFound);
            foundMethodList.add((Object)method);
            _function_1 = new Functions.Function1<ModelChangeObject, Boolean>(){

                public Boolean apply(ModelChangeObject it) {
                    return Objects.equal((Object)it.eObject, (Object)opFound);
                }
            };
            _filter_1 = IterableExtensions.filter(modelChangeList, (Functions.Function1)_function_1);
            ModelChangeObject _head = (ModelChangeObject)IterableExtensions.head((Iterable)_filter_1);
            boolean bl2 = bl = !Objects.equal((Object)_head, null);
        }
        for (Operation op : operations) {
            boolean _not;
            boolean _contains = foundOperationList.contains((Object)op);
            boolean bl = _not = !_contains;
            if (!_not) continue;
            notFoundOperationList.add((Object)op);
        }
        Functions.Function1<ModelChangeObject, Boolean> _function = new Functions.Function1<ModelChangeObject, Boolean>(){

            public Boolean apply(ModelChangeObject it) {
                return it.eventType == 3;
            }
        };
        Iterable _filter = IterableExtensions.filter(modelChangeList, (Functions.Function1)_function);
        List addChanges = IterableExtensions.toList((Iterable)_filter);
        UniqueEList tobeRemovedsInNotFound = new UniqueEList();
        for (final Operation op_1 : notFoundOperationList) {
            boolean _notEquals;
            _function_1 = new Functions.Function1<ModelChangeObject, Boolean>(){

                public Boolean apply(ModelChangeObject it) {
                    return Objects.equal((Object)it.eObject, (Object)op_1);
                }
            };
            _filter_1 = IterableExtensions.filter((Iterable)addChanges, (Functions.Function1)_function_1);
            ModelChangeObject modelChangeObj = (ModelChangeObject)IterableExtensions.head((Iterable)_filter_1);
            boolean bl = _notEquals = !Objects.equal((Object)modelChangeObj, null);
            if (!_notEquals) continue;
            tobeRemovedsInNotFound.add((Object)op_1);
        }
        for (Operation i : tobeRemovedsInNotFound) {
            notFoundOperationList.remove((Object)i);
        }
        UniqueEList processedMethods = new UniqueEList();
        UniqueEList remainingMethods = new UniqueEList();
        UniqueEList remainingOperations = new UniqueEList();
        for (final IMethodDeclaration notFoundMethod : notFoundMethodList) {
            boolean isModelObjectChanged_1;
            boolean _notEquals_1;
            boolean _greaterThan;
            boolean _notEquals;
            boolean _not_1;
            boolean _contains_1 = processedMethods.contains((Object)notFoundMethod);
            boolean bl = _not_1 = !_contains_1;
            if (!_not_1) continue;
            String _elementName = notFoundMethod.getElementName();
            String[] _split = _elementName.split("::");
            final String functionName = (String)IterableExtensions.last((Iterable)((Iterable)Conversions.doWrapArray((Object)_split)));
            Functions.Function1<Operation, Boolean> _function_12 = new Functions.Function1<Operation, Boolean>(){

                public Boolean apply(Operation it) {
                    return ReverseCpp2Uml.this.isSameSignature(it, notFoundMethod);
                }
            };
            Iterable _filter_12 = IterableExtensions.filter((Iterable)notFoundOperationList, (Functions.Function1)_function_12);
            final Operation sameSignatureOperation = (Operation)IterableExtensions.head((Iterable)_filter_12);
            boolean bl3 = _notEquals = !Objects.equal((Object)sameSignatureOperation, null);
            if (_notEquals) {
                boolean isModelObjectChanged;
                Functions.Function1<ModelChangeObject, Boolean> _function_2 = new Functions.Function1<ModelChangeObject, Boolean>(){

                    public Boolean apply(ModelChangeObject it) {
                        return Objects.equal((Object)it.eObject, (Object)sameSignatureOperation);
                    }
                };
                Iterable _filter_2 = IterableExtensions.filter(modelChangeList, (Functions.Function1)_function_2);
                ModelChangeObject _head = (ModelChangeObject)IterableExtensions.head((Iterable)_filter_2);
                boolean bl4 = isModelObjectChanged = !Objects.equal((Object)_head, null);
                if (isModelObjectChanged) {
                    this.syncOperationWithMode(parent, sameSignatureOperation, notFoundMethod, ConflictResolutionMode.FROM_MODEL);
                } else {
                    this.syncOperationWithMode(parent, sameSignatureOperation, notFoundMethod, ConflictResolutionMode.FROM_CODE);
                }
                notFoundOperationList.remove((Object)sameSignatureOperation);
                processedMethods.add((Object)notFoundMethod);
                continue;
            }
            Functions.Function1<IMethodDeclaration, Boolean> _function_3 = new Functions.Function1<IMethodDeclaration, Boolean>(){

                public Boolean apply(IMethodDeclaration it) {
                    String _elementName = it.getElementName();
                    return _elementName.equals(functionName);
                }
            };
            Iterable _filter_3 = IterableExtensions.filter((Iterable)notFoundMethodList, (Functions.Function1)_function_3);
            List sameNameMethods = IterableExtensions.toList((Iterable)_filter_3);
            Functions.Function1<Operation, Boolean> _function_4 = new Functions.Function1<Operation, Boolean>(){

                public Boolean apply(Operation it) {
                    String _name = it.getName();
                    return _name.equals(functionName);
                }
            };
            Iterable _filter_4 = IterableExtensions.filter((Iterable)notFoundOperationList, (Functions.Function1)_function_4);
            List sameNameOperations = IterableExtensions.toList((Iterable)_filter_4);
            int _size = sameNameOperations.size();
            boolean bl5 = _greaterThan = _size > 0;
            if (_greaterThan) {
                boolean _lessThan;
                int i_1 = 0;
                i_1 = 0;
                while (i_1 < sameNameMethods.size()) {
                    boolean _greaterEqualsThan;
                    int _size_1 = sameNameOperations.size();
                    boolean bl6 = _greaterEqualsThan = i_1 >= _size_1;
                    if (_greaterEqualsThan) {
                        IMethodDeclaration _get = (IMethodDeclaration)sameNameMethods.get(i_1);
                        remainingMethods.add((Object)_get);
                    } else {
                        boolean isModelObjectChanged_12;
                        IMethodDeclaration tobeProcessedMethod = (IMethodDeclaration)sameNameMethods.get(i_1);
                        final Operation tobeProcessedOp = (Operation)sameNameOperations.get(i_1);
                        Functions.Function1<ModelChangeObject, Boolean> _function_5 = new Functions.Function1<ModelChangeObject, Boolean>(){

                            public Boolean apply(ModelChangeObject it) {
                                return Objects.equal((Object)it.eObject, (Object)tobeProcessedOp);
                            }
                        };
                        Iterable _filter_5 = IterableExtensions.filter(modelChangeList, (Functions.Function1)_function_5);
                        ModelChangeObject _head_1 = (ModelChangeObject)IterableExtensions.head((Iterable)_filter_5);
                        boolean bl7 = isModelObjectChanged_12 = !Objects.equal((Object)_head_1, null);
                        if (isModelObjectChanged_12) {
                            this.syncOperationWithMode(parent, tobeProcessedOp, tobeProcessedMethod, ConflictResolutionMode.FROM_MODEL);
                        } else {
                            this.syncOperationWithMode(parent, tobeProcessedOp, tobeProcessedMethod, ConflictResolutionMode.FROM_CODE);
                        }
                        processedMethods.add((Object)tobeProcessedMethod);
                        notFoundOperationList.remove((Object)tobeProcessedOp);
                    }
                    ++i_1;
                }
                int _length = ((Object[])Conversions.unwrapArray((Object)sameNameOperations, Object.class)).length;
                boolean bl8 = _lessThan = i_1 < _length;
                if (!_lessThan) continue;
                int j = i_1;
                while (j < ((Object[])Conversions.unwrapArray((Object)sameNameOperations, Object.class)).length) {
                    Operation _get = (Operation)sameNameOperations.get(j);
                    remainingOperations.add((Object)_get);
                    ++j;
                }
                continue;
            }
            final Operation mostSameOp = this.findMostSameOperation((List<Operation>)notFoundOperationList, notFoundMethod);
            boolean bl9 = _notEquals_1 = !Objects.equal((Object)mostSameOp, null);
            if (!_notEquals_1) continue;
            Functions.Function1<ModelChangeObject, Boolean> _function_5 = new Functions.Function1<ModelChangeObject, Boolean>(){

                public Boolean apply(ModelChangeObject it) {
                    return Objects.equal((Object)it.eObject, (Object)mostSameOp);
                }
            };
            Iterable _filter_5 = IterableExtensions.filter(modelChangeList, (Functions.Function1)_function_5);
            ModelChangeObject _head_1 = (ModelChangeObject)IterableExtensions.head((Iterable)_filter_5);
            boolean bl10 = isModelObjectChanged_1 = !Objects.equal((Object)_head_1, null);
            if (isModelObjectChanged_1) {
                this.syncOperationWithMode(parent, mostSameOp, notFoundMethod, ConflictResolutionMode.FROM_MODEL);
            } else {
                this.syncOperationWithMode(parent, mostSameOp, notFoundMethod, ConflictResolutionMode.FROM_CODE);
            }
            processedMethods.add((Object)notFoundMethod);
            notFoundOperationList.remove((Object)mostSameOp);
        }
        for (Operation notFoundOp : notFoundOperationList) {
            boolean _not_2;
            boolean _contains_2 = remainingOperations.contains((Object)notFoundOp);
            boolean bl = _not_2 = !_contains_2;
            if (!_not_2) continue;
            remainingOperations.add((Object)notFoundOp);
        }
        for (IMethodDeclaration remaining : remainingMethods) {
            this.createMethod(remaining, (Class)parent);
        }
        Functions.Function1<ModelChangeObject, Boolean> _function_6 = new Functions.Function1<ModelChangeObject, Boolean>(){

            public Boolean apply(ModelChangeObject it) {
                return it.eventType == 3 || it.eventType == 1;
            }
        };
        Iterable _filter_6 = IterableExtensions.filter(modelChangeList, (Functions.Function1)_function_6);
        List remainingChanges = IterableExtensions.toList((Iterable)_filter_6);
        for (final Operation remaining_1 : remainingOperations) {
            Functions.Function1<ModelChangeObject, Boolean> _function_7 = new Functions.Function1<ModelChangeObject, Boolean>(){

                public Boolean apply(ModelChangeObject it) {
                    return Objects.equal((Object)it.eObject, (Object)remaining_1);
                }
            };
            Iterable _filter_7 = IterableExtensions.filter((Iterable)remainingChanges, (Functions.Function1)_function_7);
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)_filter_7);
            if (!_isEmpty) continue;
            if (parent instanceof Class) {
                EList _ownedOperations = ((Class)parent).getOwnedOperations();
                _ownedOperations.remove((Object)remaining_1);
                continue;
            }
            if (!(parent instanceof DataType)) continue;
            EList _ownedOperations_1 = ((DataType)parent).getOwnedOperations();
            _ownedOperations_1.remove((Object)remaining_1);
        }
    }

    private Object mergeNestedTypes(Classifier parent, List<Type> nestedTypes, List<IDeclaration> declarations) {
        return null;
    }

    private void reverseIncrementalChanges() {
        this.changeList.clear();
        this.optimizeChangeList();
        for (CppChangeObject change : this.changeList) {
            int _switchValue = change.changeKind;
            switch (_switchValue) {
                case 1: {
                    this.addToModel(change);
                    break;
                }
                case 4: {
                    this.updateToModel(change);
                    break;
                }
                case 2: {
                    this.removeFromModel(change);
                }
            }
        }
        this.changeList.clear();
    }

    private List<CElementChange> getRawChangeList() {
        String _elementName_1;
        List<CElementChange> _get_1;
        int _size;
        boolean _greaterThan;
        String _elementName;
        List<CElementChange> _get;
        boolean _notEquals_1;
        boolean _notEquals;
        boolean _and = false;
        boolean _and_1 = false;
        boolean bl = _notEquals = !Objects.equal(ChangeMapStore.changesMap, null);
        _and_1 = !_notEquals ? false : (_notEquals_1 = !Objects.equal(_get = ChangeMapStore.changesMap.get(_elementName = this.m_project.getElementName()), null));
        _and = !_and_1 ? false : (_greaterThan = (_size = (_get_1 = ChangeMapStore.changesMap.get(_elementName_1 = this.m_project.getElementName())).size()) > 0);
        if (_and) {
            String _elementName_2 = this.m_project.getElementName();
            return ChangeMapStore.changesMap.get(_elementName_2);
        }
        return null;
    }

    private void clearRawChangeList() {
        String _elementName;
        List<CElementChange> _get;
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        boolean _and = false;
        boolean _and_1 = false;
        boolean bl = _notEquals = !Objects.equal(ChangeMapStore.changesMap, null);
        _and_1 = !_notEquals ? false : (_notEquals_1 = !Objects.equal((Object)this.m_project, null));
        _and = !_and_1 ? false : (_notEquals_2 = !Objects.equal(_get = ChangeMapStore.changesMap.get(_elementName = this.m_project.getElementName()), null));
        if (_and) {
            String _elementName_1 = this.m_project.getElementName();
            List<CElementChange> _get_1 = ChangeMapStore.changesMap.get(_elementName_1);
            _get_1.clear();
        }
    }

    private void optimizeChangeList() {
        List<CElementChange> rawChangeList = this.getRawChangeList();
        this.changeList.clear();
        UniqueEList processedList = new UniqueEList();
        UniqueEList remainList = new UniqueEList();
        int i = 0;
        while (i < rawChangeList.size()) {
            CElementChange change = rawChangeList.get(i);
            ICElement _element = change.getElement();
            boolean _isInSourceContainers = this.isInSourceContainers(_element);
            if (_isInSourceContainers) {
                boolean _contains_1;
                boolean _not_1;
                boolean _not;
                boolean _contains = processedList.contains(change);
                boolean bl = _not = !_contains;
                if (_not) {
                    int _changeKind = change.getChangeKind();
                    switch (_changeKind) {
                        case 1: {
                            boolean _greaterThan;
                            List<CElementChange> inter = this.findIntermediateEvent(rawChangeList, i, change);
                            int _size = inter.size();
                            boolean bl2 = _greaterThan = _size > 0;
                            if (!_greaterThan) break;
                            processedList.add(change);
                            processedList.addAll(inter);
                            break;
                        }
                        case 4: {
                            boolean _greaterThan_1;
                            List<CElementChange> inter_1 = this.findIntermediateEvent(rawChangeList, i, change);
                            int _size_1 = inter_1.size();
                            boolean bl3 = _greaterThan_1 = _size_1 > 0;
                            if (!_greaterThan_1) break;
                            processedList.addAll(inter_1);
                            break;
                        }
                        case 2: {
                            break;
                        }
                        default: {
                            processedList.add(change);
                        }
                    }
                }
                boolean bl4 = _not_1 = !(_contains_1 = processedList.contains(change));
                if (_not_1) {
                    remainList.add(change);
                }
            }
            ++i;
        }
        HashMap doubtChangeListMap = new HashMap();
        int i2 = 0;
        while (i2 < remainList.size()) {
            boolean _notEquals;
            CElementChange change = (CElementChange)remainList.get(i2);
            CppChangeObject cppChangeObject = null;
            int _changeKind = change.getChangeKind();
            switch (_changeKind) {
                case 1: {
                    CppChangeObject _cppChangeObject;
                    boolean found = false;
                    int j = i2 + 1;
                    while (j < remainList.size() && !found) {
                        CElementChange _get_1;
                        ICElement _element_1;
                        int _elementType_1;
                        ICElement _element;
                        int _elementType;
                        boolean _equals_1;
                        boolean _equals;
                        boolean _and = false;
                        boolean _and_1 = false;
                        CElementChange _get = (CElementChange)remainList.get(j);
                        int _changeKind_1 = _get.getChangeKind();
                        boolean bl = _equals = _changeKind_1 == 2;
                        _and_1 = !_equals ? false : (_equals_1 = (_elementType = (_element = change.getElement()).getElementType()) == (_elementType_1 = (_element_1 = (_get_1 = (CElementChange)remainList.get(j)).getElement()).getElementType()));
                        if (!_and_1) {
                            _and = false;
                        } else {
                            boolean _equals_2;
                            CElementChange _get_2 = (CElementChange)remainList.get(j);
                            ICElement _parent = _get_2.getParent();
                            ICElement _parent_1 = change.getParent();
                            _and = _equals_2 = Objects.equal((Object)_parent, (Object)_parent_1);
                        }
                        if (_and) {
                            CppChangeObject _cppChangeObject2;
                            CElementChange _get_3 = (CElementChange)remainList.get(j);
                            ICElement _element_2 = _get_3.getElement();
                            ICElement _element_3 = change.getElement();
                            ICElement _element_4 = change.getElement();
                            ITranslationUnit _translationUnitFromElement = this.reverse_utils.getTranslationUnitFromElement(_element_4);
                            ICElement _parent_2 = change.getParent();
                            cppChangeObject = _cppChangeObject2 = new CppChangeObject(_element_2, _element_3, _translationUnitFromElement, _parent_2, 4);
                            ICElement _parent_3 = change.getParent();
                            List _get_4 = (List)doubtChangeListMap.get(_parent_3);
                            boolean _equals_3 = Objects.equal((Object)_get_4, null);
                            if (_equals_3) {
                                ICElement _parent_4 = change.getParent();
                                ArrayList _arrayList = new ArrayList();
                                doubtChangeListMap.put(_parent_4, _arrayList);
                            }
                            boolean _or = false;
                            boolean _or_1 = false;
                            ICElement _element_5 = change.getElement();
                            if (_element_5 instanceof IField) {
                                _or_1 = true;
                            } else {
                                ICElement _element_6 = change.getElement();
                                _or_1 = _element_6 instanceof IMethodDeclaration;
                            }
                            if (_or_1) {
                                _or = true;
                            } else {
                                ICElement _element_7 = change.getElement();
                                _or = _element_7 instanceof IEnumerator;
                            }
                            if (_or) {
                                ICElement _parent_5 = change.getParent();
                                List _get_5 = (List)doubtChangeListMap.get(_parent_5);
                                _get_5.add(cppChangeObject);
                            }
                            remainList.remove(j);
                            --j;
                            found = true;
                        }
                        ++j;
                    }
                    if (found) break;
                    ICElement _element = change.getElement();
                    ICElement _element_1 = change.getElement();
                    ITranslationUnit _translationUnitFromElement = this.reverse_utils.getTranslationUnitFromElement(_element_1);
                    ICElement _parent = change.getParent();
                    cppChangeObject = _cppChangeObject = new CppChangeObject(null, _element, _translationUnitFromElement, _parent, 1);
                    break;
                }
                case 4: {
                    CppChangeObject _cppChangeObject_1;
                    CElementChange _get = (CElementChange)remainList.get(i2);
                    ICElement _element_2 = _get.getElement();
                    ICElement _element_3 = change.getElement();
                    ICElement _element_4 = change.getElement();
                    ITranslationUnit _translationUnitFromElement_1 = this.reverse_utils.getTranslationUnitFromElement(_element_4);
                    ICElement _parent_1 = change.getParent();
                    cppChangeObject = _cppChangeObject_1 = new CppChangeObject(_element_2, _element_3, _translationUnitFromElement_1, _parent_1, 4);
                    break;
                }
                case 2: {
                    CppChangeObject _cppChangeObject_2;
                    boolean found_1 = false;
                    int j_1 = i2 + 1;
                    while (j_1 < remainList.size() && !found_1) {
                        CElementChange _get_2;
                        ICElement _element_6;
                        int _elementType_1;
                        ICElement _element_5;
                        int _elementType;
                        boolean _equals_1;
                        boolean _equals;
                        boolean _and = false;
                        CElementChange _get_1 = (CElementChange)remainList.get(j_1);
                        int _changeKind_1 = _get_1.getChangeKind();
                        boolean bl = _equals = _changeKind_1 == 1;
                        _and = !_equals ? false : (_equals_1 = (_elementType = (_element_5 = change.getElement()).getElementType()) == (_elementType_1 = (_element_6 = (_get_2 = (CElementChange)remainList.get(j_1)).getElement()).getElementType()));
                        if (_and) {
                            CppChangeObject _cppChangeObject_22;
                            ICElement _element_7 = change.getElement();
                            CElementChange _get_3 = (CElementChange)remainList.get(j_1);
                            ICElement _element_8 = _get_3.getElement();
                            ICElement _element_9 = change.getElement();
                            ITranslationUnit _translationUnitFromElement_2 = this.reverse_utils.getTranslationUnitFromElement(_element_9);
                            ICElement _parent_2 = change.getParent();
                            cppChangeObject = _cppChangeObject_22 = new CppChangeObject(_element_7, _element_8, _translationUnitFromElement_2, _parent_2, 4);
                            ICElement _parent_3 = change.getParent();
                            List _get_4 = (List)doubtChangeListMap.get(_parent_3);
                            boolean _equals_2 = Objects.equal((Object)_get_4, null);
                            if (_equals_2) {
                                ICElement _parent_4 = change.getParent();
                                ArrayList _arrayList = new ArrayList();
                                doubtChangeListMap.put(_parent_4, _arrayList);
                            }
                            boolean _or = false;
                            boolean _or_1 = false;
                            ICElement _element_10 = change.getElement();
                            if (_element_10 instanceof IField) {
                                _or_1 = true;
                            } else {
                                ICElement _element_11 = change.getElement();
                                _or_1 = _element_11 instanceof IMethodDeclaration;
                            }
                            if (_or_1) {
                                _or = true;
                            } else {
                                ICElement _element_12 = change.getElement();
                                _or = _element_12 instanceof IEnumerator;
                            }
                            if (_or) {
                                ICElement _parent_5 = change.getParent();
                                List _get_5 = (List)doubtChangeListMap.get(_parent_5);
                                _get_5.add(cppChangeObject);
                            }
                            remainList.remove(j_1);
                            --j_1;
                            found_1 = true;
                        }
                        ++j_1;
                    }
                    if (found_1) break;
                    ICElement _element_5 = change.getElement();
                    ICElement _element_6 = change.getElement();
                    ITranslationUnit _translationUnitFromElement_2 = this.reverse_utils.getTranslationUnitFromElement(_element_6);
                    ICElement _parent_2 = change.getParent();
                    cppChangeObject = _cppChangeObject_2 = new CppChangeObject(null, _element_5, _translationUnitFromElement_2, _parent_2, 2);
                }
            }
            boolean bl = _notEquals = !Objects.equal(cppChangeObject, null);
            if (_notEquals) {
                this.changeList.add(cppChangeObject);
            }
            ++i2;
        }
        Set _entrySet = doubtChangeListMap.entrySet();
        for (Map.Entry doubtMap : _entrySet) {
            boolean _greaterThan;
            List _value = (List)doubtMap.getValue();
            int _size = _value.size();
            boolean bl = _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            ICElement _key = (ICElement)doubtMap.getKey();
            List _value_1 = (List)doubtMap.getValue();
            this.alignChangedElements(_key, _value_1);
        }
        this.clearRawChangeList();
    }

    private void alignChangedElements(ICElement parent, final List<CppChangeObject> changes) {
        try {
            int _size_1;
            int _size;
            boolean _equals;
            final ArrayList oldNamedElementsList = new ArrayList();
            final HashMap oldNamedElementToChangeMap = new HashMap();
            Consumer<CppChangeObject> _function = new Consumer<CppChangeObject>(){

                @Override
                public void accept(CppChangeObject it) {
                    NamedElement oldNamedElement = ReverseCpp2Uml.this.getNamedElement(it.parent, it.oldElement);
                    oldNamedElementToChangeMap.put(oldNamedElement, it);
                    oldNamedElementsList.add(oldNamedElement);
                }
            };
            changes.forEach(_function);
            NamedElement _head = (NamedElement)IterableExtensions.head(oldNamedElementsList);
            EObject namedElementParent = _head.eContainer();
            final ArrayList alignedOldNamedElements = new ArrayList();
            EList _eContents = namedElementParent.eContents();
            Iterable _filter = Iterables.filter((Iterable)_eContents, NamedElement.class);
            Consumer<NamedElement> _function_1 = new Consumer<NamedElement>(){

                @Override
                public void accept(NamedElement it) {
                    boolean _contains = oldNamedElementsList.contains(it);
                    if (_contains) {
                        alignedOldNamedElements.add(it);
                    }
                }
            };
            _filter.forEach(_function_1);
            final ArrayList newICElements = new ArrayList();
            if (parent instanceof IParent) {
                ICElement[] _children = ((IParent)parent).getChildren();
                Consumer<ICElement> _function_2 = new Consumer<ICElement>(){

                    @Override
                    public void accept(ICElement it) {
                        boolean _notEquals;
                        final ICElement childInParent = it;
                        Functions.Function1<CppChangeObject, Boolean> _function = new Functions.Function1<CppChangeObject, Boolean>(){

                            public Boolean apply(CppChangeObject it) {
                                return Objects.equal((Object)it.newElement, (Object)childInParent);
                            }
                        };
                        Iterable _filter = IterableExtensions.filter((Iterable)changes, (Functions.Function1)_function);
                        CppChangeObject founded = (CppChangeObject)IterableExtensions.head((Iterable)_filter);
                        boolean bl = _notEquals = !Objects.equal((Object)founded, null);
                        if (_notEquals) {
                            newICElements.add(founded.newElement);
                        }
                    }
                };
                ((List)Conversions.doWrapArray((Object)_children)).forEach(_function_2);
            }
            boolean bl = _equals = (_size = alignedOldNamedElements.size()) == (_size_1 = newICElements.size());
            if (_equals) {
                int i = 0;
                while (i < alignedOldNamedElements.size()) {
                    boolean _notEquals;
                    NamedElement _get = (NamedElement)alignedOldNamedElements.get(i);
                    CppChangeObject change = (CppChangeObject)oldNamedElementToChangeMap.get(_get);
                    ICElement _get_1 = (ICElement)newICElements.get(i);
                    boolean bl2 = _notEquals = !Objects.equal((Object)change.newElement, (Object)_get_1);
                    if (_notEquals) {
                        boolean _and = false;
                        if (!(change.newElement instanceof IField)) {
                            _and = false;
                        } else {
                            ICElement _get_2 = (ICElement)newICElements.get(i);
                            _and = _get_2 instanceof IField;
                        }
                        boolean sameElementType = _and;
                        boolean _or = false;
                        if (sameElementType) {
                            _or = true;
                        } else {
                            boolean _and_1 = false;
                            if (!(change.newElement instanceof IMethodDeclaration)) {
                                _and_1 = false;
                            } else {
                                ICElement _get_3 = (ICElement)newICElements.get(i);
                                _and_1 = _get_3 instanceof IMethodDeclaration;
                            }
                            _or = _and_1;
                        }
                        sameElementType = _or;
                        boolean _or_1 = false;
                        if (sameElementType) {
                            _or_1 = true;
                        } else {
                            boolean _and_2 = false;
                            if (!(change.newElement instanceof IEnumerator)) {
                                _and_2 = false;
                            } else {
                                ICElement _get_4 = (ICElement)newICElements.get(i);
                                _and_2 = _get_4 instanceof IEnumerator;
                            }
                            _or_1 = _and_2;
                        }
                        sameElementType = _or_1;
                        if (sameElementType) {
                            ICElement _get_5;
                            change.newElement = _get_5 = (ICElement)newICElements.get(i);
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private NamedElement getNamedElement(ICElement parent, final ICElement child) {
        try {
            Property ret = null;
            boolean _matched = false;
            if (!_matched && child instanceof IField) {
                _matched = true;
                if (parent instanceof IStructure) {
                    String _elementName_1;
                    boolean _isExist;
                    boolean _notEquals;
                    ITranslationUnit _translationUnit_1;
                    String _elementName;
                    IStructure parentStructure = (IStructure)parent;
                    ITranslationUnit _translationUnit = parentStructure.getTranslationUnit();
                    Model _correspondingModel = this.getCorrespondingModel(_translationUnit);
                    Type classifier = this.getClassifier(_correspondingModel, (ICElement)parentStructure, _elementName = parentStructure.getElementName(), _translationUnit_1 = parentStructure.getTranslationUnit());
                    boolean bl = _notEquals = !Objects.equal((Object)classifier, null);
                    if (_notEquals && (_isExist = this.isExist((NamedElement)classifier, _elementName_1 = child.getElementName()))) {
                        Property prop;
                        EList _ownedElements = classifier.getOwnedElements();
                        Iterable _filter = Iterables.filter((Iterable)_ownedElements, Property.class);
                        Functions.Function1<Property, Boolean> _function = new Functions.Function1<Property, Boolean>(){

                            public Boolean apply(Property it) {
                                String _name = it.getName();
                                String _elementName = child.getElementName();
                                return _name.equals(_elementName);
                            }
                        };
                        Iterable _filter_1 = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function);
                        ret = prop = (Property)IterableExtensions.head((Iterable)_filter_1);
                    }
                }
            }
            if (!_matched && child instanceof IMethodDeclaration) {
                _matched = true;
                if (parent instanceof IStructure) {
                    String _elementName_3;
                    boolean _isExist_1;
                    boolean _notEquals_1;
                    ITranslationUnit _translationUnit_3;
                    String _elementName_2;
                    IStructure parentStructure_1 = (IStructure)parent;
                    ITranslationUnit _translationUnit_2 = parentStructure_1.getTranslationUnit();
                    Model _correspondingModel_1 = this.getCorrespondingModel(_translationUnit_2);
                    Type classifier_1 = this.getClassifier(_correspondingModel_1, (ICElement)parentStructure_1, _elementName_2 = parentStructure_1.getElementName(), _translationUnit_3 = parentStructure_1.getTranslationUnit());
                    boolean bl = _notEquals_1 = !Objects.equal((Object)classifier_1, null);
                    if (_notEquals_1 && (_isExist_1 = this.isExist((NamedElement)classifier_1, _elementName_3 = child.getElementName()))) {
                        boolean _notEquals_2;
                        IMethodDeclaration oldMethod;
                        Functions.Function1<Operation, Boolean> _function_2;
                        Functions.Function1<Operation, Boolean> _function_1;
                        EList _ownedElements_1 = classifier_1.getOwnedElements();
                        Iterable _filter_2 = Iterables.filter((Iterable)_ownedElements_1, Operation.class);
                        Iterable _filter_3 = IterableExtensions.filter((Iterable)_filter_2, (Functions.Function1)(_function_1 = new Functions.Function1<Operation, Boolean>(){

                            public Boolean apply(Operation it) {
                                String _name = it.getName();
                                String _elementName = child.getElementName();
                                return _name.equals(_elementName);
                            }
                        }));
                        List samenames = IterableExtensions.toList((Iterable)_filter_3);
                        Iterable _filter_4 = IterableExtensions.filter((Iterable)samenames, (Functions.Function1)(_function_2 = new Functions.Function1<Operation, Boolean>(oldMethod = (IMethodDeclaration)child){
                            private final /* synthetic */ IMethodDeclaration val$oldMethod;
                            {
                                this.val$oldMethod = iMethodDeclaration;
                            }

                            public Boolean apply(Operation it) {
                                return ReverseCpp2Uml.this.isSameSignature(it, this.val$oldMethod);
                            }
                        }));
                        Operation op = (Operation)IterableExtensions.head((Iterable)_filter_4);
                        boolean bl2 = _notEquals_2 = !Objects.equal((Object)op, null);
                        if (_notEquals_2) {
                            ret = op;
                        }
                    }
                }
            }
            if (!_matched && child instanceof IEnumerator) {
                _matched = true;
                IEnumeration cppEnumeration = (IEnumeration)parent;
                ITranslationUnit _translationUnit_4 = cppEnumeration.getTranslationUnit();
                Model _correspondingModel_2 = this.getCorrespondingModel(_translationUnit_4);
                String _elementName_4 = cppEnumeration.getElementName();
                ITranslationUnit _translationUnit_5 = cppEnumeration.getTranslationUnit();
                Type enumeration = this.getClassifier(_correspondingModel_2, (ICElement)cppEnumeration, _elementName_4, _translationUnit_5);
                boolean _and = false;
                boolean _notEquals_3 = !Objects.equal((Object)enumeration, null);
                _and = !_notEquals_3 ? false : enumeration instanceof Enumeration;
                if (_and) {
                    boolean _notEquals_4;
                    Functions.Function1<EnumerationLiteral, Boolean> _function_3;
                    EList _ownedLiterals = ((Enumeration)enumeration).getOwnedLiterals();
                    Iterable _filter_5 = Iterables.filter((Iterable)_ownedLiterals, EnumerationLiteral.class);
                    Iterable _filter_6 = IterableExtensions.filter((Iterable)_filter_5, (Functions.Function1)(_function_3 = new Functions.Function1<EnumerationLiteral, Boolean>(){

                        public Boolean apply(EnumerationLiteral it) {
                            String _name = it.getName();
                            String _elementName = child.getElementName();
                            return Objects.equal((Object)_name, (Object)_elementName);
                        }
                    }));
                    EnumerationLiteral enumerator = (EnumerationLiteral)IterableExtensions.head((Iterable)_filter_6);
                    boolean bl = _notEquals_4 = !Objects.equal((Object)enumerator, null);
                    if (_notEquals_4) {
                        ret = enumerator;
                    }
                }
            }
            return ret;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private boolean isInSourceContainers(ICElement element) {
        boolean _contains;
        boolean _equals = Objects.equal((Object)element, null);
        if (_equals) {
            return false;
        }
        boolean _and = false;
        _and = !(element instanceof ICContainer) ? false : (_contains = this.containers.contains(element));
        if (_and) {
            return true;
        }
        ICElement _parent = element.getParent();
        return this.isInSourceContainers(_parent);
    }

    private List<CElementChange> findIntermediateEvent(List<CElementChange> list, int position, CElementChange change) {
        boolean _greaterThan;
        UniqueEList ret = new UniqueEList();
        int i = position + 1;
        while (i < list.size()) {
            CElementChange _get;
            int _changeKind_1;
            boolean _equals_1;
            boolean _equals;
            boolean _and = false;
            boolean _and_1 = false;
            int _changeKind = change.getChangeKind();
            boolean bl = _equals = _changeKind == 1;
            _and_1 = !_equals ? false : (_equals_1 = (_changeKind_1 = (_get = list.get(i)).getChangeKind()) == 2);
            if (!_and_1) {
                _and = false;
            } else {
                boolean _isSameICElement;
                ICElement _element = change.getElement();
                CElementChange _get_1 = list.get(i);
                ICElement _element_1 = _get_1.getElement();
                _and = _isSameICElement = this.isSameICElement(_element, _element_1);
            }
            if (_and) {
                boolean _and_2 = false;
                ICElement _element_2 = change.getElement();
                if (!(_element_2 instanceof IMethodDeclaration)) {
                    _and_2 = false;
                } else {
                    CElementChange _get_2 = list.get(i);
                    ICElement _element_3 = _get_2.getElement();
                    _and_2 = _element_3 instanceof IMethodDeclaration;
                }
                if (_and_2) {
                    CElementChange _get_3;
                    ICElement _element_5;
                    ICElement _element_4 = change.getElement();
                    IMethodDeclaration method = (IMethodDeclaration)_element_4;
                    boolean _isSameMethodDeclaration = this.isSameMethodDeclaration(method, (IMethodDeclaration)(_element_5 = (_get_3 = list.get(i)).getElement()));
                    if (_isSameMethodDeclaration) {
                        CElementChange _get_4 = list.get(i);
                        ret.add(_get_4);
                    }
                } else {
                    CElementChange _get_5 = list.get(i);
                    ret.add(_get_5);
                }
            } else {
                boolean _equals_2;
                boolean _and_3 = false;
                int _changeKind_2 = change.getChangeKind();
                boolean bl2 = _equals_2 = _changeKind_2 == 4;
                if (!_equals_2) {
                    _and_3 = false;
                } else {
                    boolean _isSameICElement_1;
                    ICElement _element_6 = change.getElement();
                    CElementChange _get_6 = list.get(i);
                    ICElement _element_7 = _get_6.getElement();
                    _and_3 = _isSameICElement_1 = this.isSameICElement(_element_6, _element_7);
                }
                if (_and_3) {
                    CElementChange _get_7 = list.get(i);
                    ret.add(_get_7);
                }
            }
            ++i;
        }
        Functions.Function1<CElementChange, Boolean> _function = new Functions.Function1<CElementChange, Boolean>(){

            public Boolean apply(CElementChange it) {
                int _changeKind = it.getChangeKind();
                return _changeKind == 4;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)ret, (Functions.Function1)_function);
        List changed = IterableExtensions.toList((Iterable)_filter);
        int _size = changed.size();
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            CElementChange _last = (CElementChange)IterableExtensions.last((Iterable)changed);
            ret.remove(_last);
        }
        return ret;
    }

    private ICElement getSameICelement(ICElement element, int fromPos, int changeKind) {
        boolean _greaterEqualsThan;
        List<CElementChange> _rawChangeList = this.getRawChangeList();
        int _size = _rawChangeList.size();
        boolean bl = _greaterEqualsThan = fromPos >= _size;
        if (_greaterEqualsThan) {
            return null;
        }
        ICElement ret = null;
        int i = fromPos;
        while (i < this.getRawChangeList().size()) {
            List<CElementChange> _rawChangeList_1 = this.getRawChangeList();
            CElementChange change = _rawChangeList_1.get(i);
            boolean _equals = Objects.equal(ret, null);
            if (_equals) {
                if (changeKind == 1) {
                    boolean _equals_1;
                    boolean _and = false;
                    int _changeKind = change.getChangeKind();
                    boolean bl2 = _equals_1 = _changeKind == 2;
                    if (!_equals_1) {
                        _and = false;
                    } else {
                        boolean _isSameICElement;
                        ICElement _element = change.getElement();
                        _and = _isSameICElement = this.isSameICElement(element, _element);
                    }
                    if (_and) {
                        ICElement _element_1;
                        ret = _element_1 = change.getElement();
                    }
                } else if (changeKind == 2) {
                    boolean _equals_2;
                    boolean _and_1 = false;
                    int _changeKind_1 = change.getChangeKind();
                    boolean bl3 = _equals_2 = _changeKind_1 == 1;
                    if (!_equals_2) {
                        _and_1 = false;
                    } else {
                        boolean _isSameICElement_1;
                        ICElement _element_2 = change.getElement();
                        _and_1 = _isSameICElement_1 = this.isSameICElement(element, _element_2);
                    }
                    if (_and_1) {
                        ICElement _element_3;
                        ret = _element_3 = change.getElement();
                    }
                } else if (changeKind == 4) {
                    boolean _equals_3;
                    boolean _and_2 = false;
                    int _changeKind_2 = change.getChangeKind();
                    boolean bl4 = _equals_3 = _changeKind_2 == 4;
                    if (!_equals_3) {
                        _and_2 = false;
                    } else {
                        boolean _isSameICElement_2;
                        ICElement _element_4 = change.getElement();
                        _and_2 = _isSameICElement_2 = this.isSameICElement(element, _element_4);
                    }
                    if (_and_2) {
                        ICElement _element_5;
                        ret = _element_5 = change.getElement();
                    }
                }
            }
            ++i;
        }
        return ret;
    }

    private boolean isSameICElement(ICElement e1, ICElement e2) {
        int _elementType_1;
        int _elementType;
        boolean _equals_1;
        String _elementName_1;
        boolean ret = false;
        boolean _and = false;
        boolean _and_1 = false;
        String _elementName = e1.getElementName();
        boolean _equals = _elementName.equals(_elementName_1 = e2.getElementName());
        _and_1 = !_equals ? false : (_equals_1 = (_elementType = e1.getElementType()) == (_elementType_1 = e2.getElementType()));
        if (!_and_1) {
            _and = false;
        } else {
            boolean _equals_2;
            ICElement _parent = e1.getParent();
            String _elementName_2 = _parent.getElementName();
            ICElement _parent_1 = e2.getParent();
            String _elementName_3 = _parent_1.getElementName();
            _and = _equals_2 = _elementName_2.equals(_elementName_3);
        }
        if (_and) {
            ret = true;
        }
        return ret;
    }

    private boolean isExist(NamedElement parent, final String childName) {
        Functions.Function1<NamedElement, Boolean> _function;
        EList _ownedElements = parent.getOwnedElements();
        Iterable _filter = Iterables.filter((Iterable)_ownedElements, NamedElement.class);
        Iterable _filter_1 = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)(_function = new Functions.Function1<NamedElement, Boolean>(){

            public Boolean apply(NamedElement it) {
                String _name = it.getName();
                return _name.equals(childName);
            }
        }));
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)_filter_1);
        return !_isEmpty;
    }

    private Object addToModel(CppChangeObject change) {
        try {
            ICElement _parent_2;
            EObject _xifexpression;
            EObject _switchResult = null;
            ICElement _switchValue = change.newElement;
            boolean _matched = false;
            if (!_matched && change.newElement instanceof IField) {
                _matched = true;
                IField field = (IField)change.newElement;
                ICElement _parent = field.getParent();
                if (_parent instanceof IStructure) {
                    boolean _notEquals;
                    ITranslationUnit _translationUnit_1;
                    String _elementName;
                    ICElement _parent_1 = field.getParent();
                    IStructure parentStructure = (IStructure)_parent_1;
                    ITranslationUnit _translationUnit = parentStructure.getTranslationUnit();
                    Model _correspondingModel = this.getCorrespondingModel(_translationUnit);
                    Type classifier = this.getClassifier(_correspondingModel, (ICElement)parentStructure, _elementName = parentStructure.getElementName(), _translationUnit_1 = parentStructure.getTranslationUnit());
                    boolean bl = _notEquals = !Objects.equal((Object)classifier, null);
                    if (_notEquals) {
                        boolean _not;
                        String _elementName_1 = field.getElementName();
                        boolean _isExist = this.isExist((NamedElement)classifier, _elementName_1);
                        boolean bl2 = _not = !_isExist;
                        if (_not) {
                            this.createProperty(field, (Classifier)classifier);
                        }
                    }
                }
            }
            if (!_matched && change.newElement instanceof IMethodDeclaration) {
                _matched = true;
                EObject _xblockexpression = null;
                final IMethodDeclaration method = (IMethodDeclaration)change.newElement;
                _xifexpression = null;
                _parent_2 = method.getParent();
                if (_parent_2 instanceof IStructure) {
                    Functions.Function1<Operation, Boolean> _function_1;
                    Functions.Function1<Operation, Boolean> _function;
                    EList _ownedElements;
                    Iterable _filter;
                    Iterable _filter_1;
                    List samenames;
                    Iterable _filter_2;
                    boolean _isEmpty;
                    boolean _notEquals_1;
                    ITranslationUnit _translationUnit_3;
                    String _elementName_2;
                    ICElement _parent_3 = method.getParent();
                    IStructure parentStructure_1 = (IStructure)_parent_3;
                    ITranslationUnit _translationUnit_2 = parentStructure_1.getTranslationUnit();
                    Model _correspondingModel_1 = this.getCorrespondingModel(_translationUnit_2);
                    Type classifier_1 = this.getClassifier(_correspondingModel_1, (ICElement)parentStructure_1, _elementName_2 = parentStructure_1.getElementName(), _translationUnit_3 = parentStructure_1.getTranslationUnit());
                    boolean bl = _notEquals_1 = !Objects.equal((Object)classifier_1, null);
                    if (_notEquals_1 && (_isEmpty = IterableExtensions.isEmpty((Iterable)(_filter_2 = IterableExtensions.filter((Iterable)(samenames = IterableExtensions.toList((Iterable)(_filter_1 = IterableExtensions.filter((Iterable)(_filter = Iterables.filter((Iterable)(_ownedElements = classifier_1.getOwnedElements()), Operation.class)), (Functions.Function1)(_function = new Functions.Function1<Operation, Boolean>(){

                        public Boolean apply(Operation it) {
                            String _name = it.getName();
                            String _elementName = method.getElementName();
                            return _name.equals(_elementName);
                        }
                    }))))), (Functions.Function1)(_function_1 = new Functions.Function1<Operation, Boolean>(){

                        public Boolean apply(Operation it) {
                            return ReverseCpp2Uml.this.isSameSignature(it, method);
                        }
                    })))))) {
                        this.createMethod(method, (Class)classifier_1);
                    }
                } else {
                    EObject _xifexpression_1 = null;
                    ICElement _parent_4 = method.getParent();
                    if (_parent_4 instanceof ITranslationUnit) {
                        _xifexpression_1 = null;
                    }
                    _xifexpression = _xifexpression_1;
                }
                _switchResult = _xblockexpression = _xifexpression;
            }
            if (!_matched) {
                if (change.newElement instanceof IStructure) {
                    _matched = true;
                }
                if (!_matched && change.newElement instanceof IEnumeration) {
                    _matched = true;
                }
                if (!_matched && change.newElement instanceof ITypeDef) {
                    _matched = true;
                }
                if (_matched) {
                    EObject _xblockexpression_1 = null;
                    IDeclaration declaration = (IDeclaration)change.newElement;
                    _xifexpression = null;
                    _parent_2 = declaration.getParent();
                    if (_parent_2 instanceof IStructure) {
                        EObject _xblockexpression_2 = null;
                        ICElement _parent_3 = declaration.getParent();
                        IStructure parentStructure_1 = (IStructure)_parent_3;
                        ITranslationUnit _translationUnit_2 = parentStructure_1.getTranslationUnit();
                        Model _correspondingModel_1 = this.getCorrespondingModel(_translationUnit_2);
                        String _elementName_2 = parentStructure_1.getElementName();
                        ITranslationUnit _translationUnit_3 = parentStructure_1.getTranslationUnit();
                        Type parentClassifier = this.getClassifier(_correspondingModel_1, (ICElement)parentStructure_1, _elementName_2, _translationUnit_3);
                        _xifexpression = _xblockexpression_2 = this.createOrgetClassifier((PackageableElement)parentClassifier, (ICElement)declaration, true);
                    } else {
                        EObject _xblockexpression_3 = null;
                        ITranslationUnit _translationUnit_2 = declaration.getTranslationUnit();
                        Package containerPackage = this.getContainerPackage(_translationUnit_2);
                        _xifexpression = _xblockexpression_3 = this.createOrgetClassifier((PackageableElement)containerPackage, (ICElement)declaration, true);
                    }
                    _switchResult = _xblockexpression_1 = _xifexpression;
                }
            }
            if (!_matched && change.newElement instanceof IEnumerator) {
                _matched = true;
                EnumerationLiteral _xblockexpression_2 = null;
                IEnumerator enumerator = (IEnumerator)change.newElement;
                IPath _path = enumerator.getPath();
                IEnumeration cppEnumeration = (IEnumeration)_path;
                ITranslationUnit _translationUnit_2 = cppEnumeration.getTranslationUnit();
                Model _correspondingModel_1 = this.getCorrespondingModel(_translationUnit_2);
                String _elementName_2 = cppEnumeration.getElementName();
                ITranslationUnit _translationUnit_3 = cppEnumeration.getTranslationUnit();
                Type enumeration = this.getClassifier(_correspondingModel_1, (ICElement)cppEnumeration, _elementName_2, _translationUnit_3);
                EnumerationLiteral _xifexpression2 = null;
                if (enumeration instanceof Enumeration) {
                    String _elementName_3 = enumerator.getElementName();
                    _xifexpression2 = ((Enumeration)enumeration).createOwnedLiteral(_elementName_3);
                }
                _xblockexpression_2 = _xifexpression2;
                _switchResult = _xblockexpression_2;
            }
            if (!_matched && change.newElement instanceof ITranslationUnit) {
                _matched = true;
                EObject _xblockexpression_3 = null;
                ITranslationUnit itu = (ITranslationUnit)change.newElement;
                Model _correspondingModel_1 = this.getCorrespondingModel(itu);
                _switchResult = _xblockexpression_3 = this.getOrCreateClassifier(_correspondingModel_1, (IParent)itu);
            }
            return _switchResult;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private List<Type> updateToModel(final CppChangeObject change) {
        try {
            List<Type> _switchResult = null;
            ICElement _switchValue = change.newElement;
            boolean _matched = false;
            if (!_matched && change.oldElement instanceof IField) {
                _matched = true;
                IField field = (IField)change.newElement;
                ICElement _parent = field.getParent();
                if (_parent instanceof IStructure) {
                    String _elementName_1;
                    boolean _isExist;
                    boolean _notEquals;
                    ITranslationUnit _translationUnit_1;
                    String _elementName;
                    ICElement _parent_1 = field.getParent();
                    IStructure parentStructure = (IStructure)_parent_1;
                    ITranslationUnit _translationUnit = parentStructure.getTranslationUnit();
                    Model _correspondingModel = this.getCorrespondingModel(_translationUnit);
                    Type classifier = this.getClassifier(_correspondingModel, (ICElement)parentStructure, _elementName = parentStructure.getElementName(), _translationUnit_1 = parentStructure.getTranslationUnit());
                    boolean bl = _notEquals = !Objects.equal((Object)classifier, null);
                    if (_notEquals && (_isExist = this.isExist((NamedElement)classifier, _elementName_1 = change.oldElement.getElementName()))) {
                        boolean _notEquals_1;
                        Functions.Function1<Property, Boolean> _function;
                        EList _ownedElements = classifier.getOwnedElements();
                        Iterable _filter = Iterables.filter((Iterable)_ownedElements, Property.class);
                        Iterable _filter_1 = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)(_function = new Functions.Function1<Property, Boolean>(){

                            public Boolean apply(Property it) {
                                String _name = it.getName();
                                String _elementName = change.oldElement.getElementName();
                                return _name.equals(_elementName);
                            }
                        }));
                        Property prop = (Property)IterableExtensions.head((Iterable)_filter_1);
                        boolean bl2 = _notEquals_1 = !Objects.equal((Object)prop, null);
                        if (_notEquals_1) {
                            this.updateProperty((IField)change.newElement, prop);
                        }
                    }
                }
            }
            if (!_matched && change.oldElement instanceof IMethodDeclaration) {
                _matched = true;
                IMethodDeclaration method = (IMethodDeclaration)change.newElement;
                ICElement _parent_2 = method.getParent();
                if (_parent_2 instanceof IStructure) {
                    String _elementName_3;
                    boolean _isExist_1;
                    boolean _notEquals_2;
                    ITranslationUnit _translationUnit_3;
                    String _elementName_2;
                    ICElement _parent_3 = method.getParent();
                    IStructure parentStructure_1 = (IStructure)_parent_3;
                    ITranslationUnit _translationUnit_2 = parentStructure_1.getTranslationUnit();
                    Model _correspondingModel_1 = this.getCorrespondingModel(_translationUnit_2);
                    Type classifier_1 = this.getClassifier(_correspondingModel_1, (ICElement)parentStructure_1, _elementName_2 = parentStructure_1.getElementName(), _translationUnit_3 = parentStructure_1.getTranslationUnit());
                    boolean bl = _notEquals_2 = !Objects.equal((Object)classifier_1, null);
                    if (_notEquals_2 && (_isExist_1 = this.isExist((NamedElement)classifier_1, _elementName_3 = change.oldElement.getElementName()))) {
                        boolean _notEquals_3;
                        IMethodDeclaration oldMethod;
                        Functions.Function1<Operation, Boolean> _function_2;
                        Functions.Function1<Operation, Boolean> _function_1;
                        EList _ownedElements_1 = classifier_1.getOwnedElements();
                        Iterable _filter_2 = Iterables.filter((Iterable)_ownedElements_1, Operation.class);
                        Iterable _filter_3 = IterableExtensions.filter((Iterable)_filter_2, (Functions.Function1)(_function_1 = new Functions.Function1<Operation, Boolean>(){

                            public Boolean apply(Operation it) {
                                String _name = it.getName();
                                String _elementName = change.oldElement.getElementName();
                                return _name.equals(_elementName);
                            }
                        }));
                        List samenames = IterableExtensions.toList((Iterable)_filter_3);
                        Iterable _filter_4 = IterableExtensions.filter((Iterable)samenames, (Functions.Function1)(_function_2 = new Functions.Function1<Operation, Boolean>(oldMethod = (IMethodDeclaration)change.oldElement){
                            private final /* synthetic */ IMethodDeclaration val$oldMethod;
                            {
                                this.val$oldMethod = iMethodDeclaration;
                            }

                            public Boolean apply(Operation it) {
                                return ReverseCpp2Uml.this.isSameSignature(it, this.val$oldMethod);
                            }
                        }));
                        Operation op = (Operation)IterableExtensions.head((Iterable)_filter_4);
                        boolean bl3 = _notEquals_3 = !Objects.equal((Object)op, null);
                        if (_notEquals_3) {
                            this.updateMethod((Class)classifier_1, op, (IMethodDeclaration)change.newElement);
                        }
                    }
                } else {
                    ICElement _parent_4 = method.getParent();
                    if (_parent_4 instanceof ITranslationUnit) {
                        ICElement _parent_5 = method.getParent();
                        this.reverseSource((ITranslationUnit)_parent_5);
                    }
                }
            }
            if (!_matched) {
                if (change.oldElement instanceof IStructure) {
                    _matched = true;
                }
                if (!_matched && change.oldElement instanceof IEnumeration) {
                    _matched = true;
                }
                if (!_matched && change.oldElement instanceof ITypeDef) {
                    _matched = true;
                }
                if (_matched) {
                    boolean _notEquals_4;
                    ITranslationUnit _translationUnit_5;
                    String _elementName_4;
                    IDeclaration declaration = (IDeclaration)change.newElement;
                    ITranslationUnit _translationUnit_4 = declaration.getTranslationUnit();
                    Model _correspondingModel_2 = this.getCorrespondingModel(_translationUnit_4);
                    Type umlClassifier = this.getClassifier(_correspondingModel_2, (ICElement)((IDeclaration)change.oldElement), _elementName_4 = change.oldElement.getElementName(), _translationUnit_5 = declaration.getTranslationUnit());
                    boolean bl = _notEquals_4 = !Objects.equal((Object)umlClassifier, null);
                    if (_notEquals_4) {
                        String _elementName_5 = declaration.getElementName();
                        umlClassifier.setName(_elementName_5);
                    }
                }
            }
            if (!_matched && change.oldElement instanceof IEnumerator) {
                _matched = true;
                IEnumerator cppEnumerator = (IEnumerator)change.newElement;
                ICElement _parent_6 = cppEnumerator.getParent();
                IEnumeration cppEnumeration = (IEnumeration)_parent_6;
                ITranslationUnit _translationUnit_6 = cppEnumeration.getTranslationUnit();
                Model _correspondingModel_3 = this.getCorrespondingModel(_translationUnit_6);
                String _elementName_6 = cppEnumeration.getElementName();
                ITranslationUnit _translationUnit_7 = cppEnumeration.getTranslationUnit();
                Type enumeration = this.getClassifier(_correspondingModel_3, (ICElement)cppEnumeration, _elementName_6, _translationUnit_7);
                boolean _and = false;
                boolean _notEquals_5 = !Objects.equal((Object)enumeration, null);
                _and = !_notEquals_5 ? false : enumeration instanceof Enumeration;
                if (_and) {
                    boolean _notEquals_6;
                    Functions.Function1<EnumerationLiteral, Boolean> _function_3;
                    EList _ownedLiterals = ((Enumeration)enumeration).getOwnedLiterals();
                    Iterable _filter_5 = Iterables.filter((Iterable)_ownedLiterals, EnumerationLiteral.class);
                    Iterable _filter_6 = IterableExtensions.filter((Iterable)_filter_5, (Functions.Function1)(_function_3 = new Functions.Function1<EnumerationLiteral, Boolean>(){

                        public Boolean apply(EnumerationLiteral it) {
                            String _name = it.getName();
                            String _elementName = change.oldElement.getElementName();
                            return Objects.equal((Object)_name, (Object)_elementName);
                        }
                    }));
                    EnumerationLiteral enumerator = (EnumerationLiteral)IterableExtensions.head((Iterable)_filter_6);
                    boolean bl = _notEquals_6 = !Objects.equal((Object)enumerator, null);
                    if (_notEquals_6) {
                        String _elementName_7 = cppEnumerator.getElementName();
                        enumerator.setName(_elementName_7);
                    }
                }
            }
            if (!_matched && change.oldElement instanceof ITranslationUnit) {
                _matched = true;
                List<Type> _xblockexpression = null;
                ITranslationUnit itu = (ITranslationUnit)change.newElement;
                List<Type> _xifexpression = null;
                boolean _isSourceUnit = itu.isSourceUnit();
                if (_isSourceUnit) {
                    this.reverseSource(itu);
                } else {
                    List<Type> _xifexpression_1 = null;
                    boolean _isHeaderUnit = itu.isHeaderUnit();
                    if (_isHeaderUnit) {
                        _xifexpression_1 = this.reverseHeader(itu);
                    }
                    _xifexpression = _xifexpression_1;
                }
                _switchResult = _xblockexpression = _xifexpression;
            }
            return _switchResult;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private Object removeFromModel(final CppChangeObject change) {
        try {
            Iterable _filter_1;
            Object _function;
            Iterable _filter;
            EList _ownedElements;
            boolean _isExist;
            String _elementName_1;
            boolean _xifexpression_2;
            boolean _notEquals;
            boolean _xifexpression_1;
            Type classifier;
            ITranslationUnit _translationUnit_1;
            String _elementName;
            Model _correspondingModel;
            ITranslationUnit _translationUnit;
            IStructure parentStructure;
            ICElement _parent_1;
            ICElement _parent;
            boolean _xifexpression;
            Object _switchResult = null;
            ICElement _switchValue = change.oldElement;
            boolean _matched = false;
            if (!_matched && change.oldElement instanceof IField) {
                _matched = true;
                boolean _xblockexpression = false;
                IField field = (IField)change.oldElement;
                _xifexpression = false;
                _parent = field.getParent();
                if (_parent instanceof IStructure) {
                    boolean _xblockexpression_1 = false;
                    _parent_1 = field.getParent();
                    parentStructure = (IStructure)_parent_1;
                    _translationUnit = parentStructure.getTranslationUnit();
                    _correspondingModel = this.getCorrespondingModel(_translationUnit);
                    _elementName = parentStructure.getElementName();
                    _translationUnit_1 = parentStructure.getTranslationUnit();
                    classifier = this.getClassifier(_correspondingModel, (ICElement)parentStructure, _elementName, _translationUnit_1);
                    _xifexpression_1 = false;
                    boolean bl = _notEquals = !Objects.equal((Object)classifier, null);
                    if (_notEquals) {
                        _xifexpression_2 = false;
                        _elementName_1 = change.oldElement.getElementName();
                        _isExist = this.isExist((NamedElement)classifier, _elementName_1);
                        if (_isExist) {
                            boolean _notEquals_1;
                            boolean _xblockexpression_2 = false;
                            _ownedElements = classifier.getOwnedElements();
                            _filter = Iterables.filter((Iterable)_ownedElements, Property.class);
                            _function = new Functions.Function1<Property, Boolean>(){

                                public Boolean apply(Property it) {
                                    String _name = it.getName();
                                    String _elementName = change.oldElement.getElementName();
                                    return _name.equals(_elementName);
                                }
                            };
                            _filter_1 = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function);
                            Property prop = (Property)IterableExtensions.head((Iterable)_filter_1);
                            boolean _xifexpression_3 = false;
                            boolean bl2 = _notEquals_1 = !Objects.equal((Object)prop, null);
                            if (_notEquals_1) {
                                boolean _xifexpression_4 = false;
                                if (classifier instanceof Class) {
                                    EList _ownedAttributes = ((Class)classifier).getOwnedAttributes();
                                    _xifexpression_4 = _ownedAttributes.remove((Object)prop);
                                } else {
                                    boolean _xifexpression_5 = false;
                                    if (classifier instanceof DataType) {
                                        EList _ownedAttributes_1 = ((DataType)classifier).getOwnedAttributes();
                                        _xifexpression_5 = _ownedAttributes_1.remove((Object)prop);
                                    }
                                    _xifexpression_4 = _xifexpression_5;
                                }
                                _xifexpression_3 = _xifexpression_4;
                            }
                            _xifexpression_2 = _xblockexpression_2 = _xifexpression_3;
                        }
                        _xifexpression_1 = _xifexpression_2;
                    }
                    _xifexpression = _xblockexpression_1 = _xifexpression_1;
                }
                _xblockexpression = _xifexpression;
                _switchResult = _xblockexpression;
            }
            if (!_matched && change.oldElement instanceof IMethodDeclaration) {
                _matched = true;
                boolean _xblockexpression_1 = false;
                final IMethodDeclaration method = (IMethodDeclaration)change.oldElement;
                _xifexpression = false;
                _parent = method.getParent();
                if (_parent instanceof IStructure) {
                    boolean _xblockexpression_2 = false;
                    _parent_1 = method.getParent();
                    parentStructure = (IStructure)_parent_1;
                    _translationUnit = parentStructure.getTranslationUnit();
                    _correspondingModel = this.getCorrespondingModel(_translationUnit);
                    _elementName = parentStructure.getElementName();
                    _translationUnit_1 = parentStructure.getTranslationUnit();
                    classifier = this.getClassifier(_correspondingModel, (ICElement)parentStructure, _elementName, _translationUnit_1);
                    _xifexpression_1 = false;
                    boolean bl = _notEquals = !Objects.equal((Object)classifier, null);
                    if (_notEquals) {
                        _xifexpression_2 = false;
                        _elementName_1 = change.oldElement.getElementName();
                        _isExist = this.isExist((NamedElement)classifier, _elementName_1);
                        if (_isExist) {
                            boolean _notEquals_1;
                            boolean _xblockexpression_3 = false;
                            _ownedElements = classifier.getOwnedElements();
                            _filter = Iterables.filter((Iterable)_ownedElements, Operation.class);
                            _function = new Functions.Function1<Operation, Boolean>(){

                                public Boolean apply(Operation it) {
                                    String _name = it.getName();
                                    String _elementName = method.getElementName();
                                    return _name.equals(_elementName);
                                }
                            };
                            _filter_1 = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function);
                            List samenames = IterableExtensions.toList((Iterable)_filter_1);
                            Functions.Function1<Operation, Boolean> _function_1 = new Functions.Function1<Operation, Boolean>(){

                                public Boolean apply(Operation it) {
                                    return ReverseCpp2Uml.this.isSameSignature(it, method);
                                }
                            };
                            Iterable _filter_2 = IterableExtensions.filter((Iterable)samenames, (Functions.Function1)_function_1);
                            Operation op = (Operation)IterableExtensions.head((Iterable)_filter_2);
                            boolean _xifexpression_3 = false;
                            boolean bl3 = _notEquals_1 = !Objects.equal((Object)op, null);
                            if (_notEquals_1) {
                                boolean _xifexpression_4 = false;
                                if (classifier instanceof Class) {
                                    EList _ownedOperations = ((Class)classifier).getOwnedOperations();
                                    _xifexpression_4 = _ownedOperations.remove((Object)op);
                                }
                                _xifexpression_3 = _xifexpression_4;
                            }
                            _xifexpression_2 = _xblockexpression_3 = _xifexpression_3;
                        }
                        _xifexpression_1 = _xifexpression_2;
                    }
                    _xifexpression = _xblockexpression_2 = _xifexpression_1;
                }
                _xblockexpression_1 = _xifexpression;
                _switchResult = _xblockexpression_1;
            }
            if (!_matched) {
                if (change.oldElement instanceof IStructure) {
                    _matched = true;
                }
                if (!_matched && change.oldElement instanceof IEnumeration) {
                    _matched = true;
                }
                if (!_matched && change.oldElement instanceof ITypeDef) {
                    _matched = true;
                }
                if (_matched) {
                    boolean _xblockexpression_2 = false;
                    final IDeclaration declaration = (IDeclaration)change.oldElement;
                    _xifexpression = false;
                    if (change.parent instanceof IStructure) {
                        boolean _xblockexpression_3 = false;
                        IStructure parentStructure2 = (IStructure)change.parent;
                        ITranslationUnit _translationUnit2 = parentStructure2.getTranslationUnit();
                        Model _correspondingModel2 = this.getCorrespondingModel(_translationUnit2);
                        String _elementName2 = parentStructure2.getElementName();
                        ITranslationUnit _translationUnit_12 = parentStructure2.getTranslationUnit();
                        Type parentClassifier = this.getClassifier(_correspondingModel2, (ICElement)parentStructure2, _elementName2, _translationUnit_12);
                        EList _ownedElements2 = parentClassifier.getOwnedElements();
                        Iterable _filter2 = Iterables.filter((Iterable)_ownedElements2, Type.class);
                        Functions.Function1<Type, Boolean> _function2 = new Functions.Function1<Type, Boolean>(){

                            public Boolean apply(Type it) {
                                String _name = it.getName();
                                String _elementName = declaration.getElementName();
                                return Objects.equal((Object)_name, (Object)_elementName);
                            }
                        };
                        Iterable _filter_12 = IterableExtensions.filter((Iterable)_filter2, (Functions.Function1)_function2);
                        Type childClassifier = (Type)IterableExtensions.head((Iterable)_filter_12);
                        boolean _xifexpression_12 = false;
                        boolean _and = false;
                        boolean _notEquals2 = !Objects.equal((Object)childClassifier, null);
                        _and = !_notEquals2 ? false : parentClassifier instanceof Class;
                        if (_and) {
                            EList _nestedClassifiers = ((Class)parentClassifier).getNestedClassifiers();
                            _xifexpression_12 = _nestedClassifiers.remove((Object)((Classifier)childClassifier));
                        }
                        _xifexpression = _xblockexpression_3 = _xifexpression_12;
                    } else {
                        boolean _xblockexpression_4 = false;
                        ITranslationUnit _translationUnit3 = declaration.getTranslationUnit();
                        Package containerPackage = this.getContainerPackage(_translationUnit3);
                        EList _ownedElements3 = containerPackage.getOwnedElements();
                        Iterable _filter3 = Iterables.filter((Iterable)_ownedElements3, Type.class);
                        Functions.Function1<Type, Boolean> _function3 = new Functions.Function1<Type, Boolean>(){

                            public Boolean apply(Type it) {
                                String _name = it.getName();
                                String _elementName = declaration.getElementName();
                                return Objects.equal((Object)_name, (Object)_elementName);
                            }
                        };
                        Iterable _filter_13 = IterableExtensions.filter((Iterable)_filter3, (Functions.Function1)_function3);
                        Type childClassifier = (Type)IterableExtensions.head((Iterable)_filter_13);
                        EList _ownedTypes = containerPackage.getOwnedTypes();
                        _xifexpression = _xblockexpression_4 = _ownedTypes.remove((Object)childClassifier);
                    }
                    _xblockexpression_2 = _xifexpression;
                    _switchResult = _xblockexpression_2;
                }
            }
            if (!_matched && change.oldElement instanceof IEnumerator) {
                _matched = true;
                boolean _xblockexpression_3 = false;
                IEnumerator cppEnumerator = (IEnumerator)change.oldElement;
                IPath _path = cppEnumerator.getPath();
                IEnumeration cppEnumeration = (IEnumeration)_path;
                ITranslationUnit _translationUnit4 = cppEnumeration.getTranslationUnit();
                Model _correspondingModel3 = this.getCorrespondingModel(_translationUnit4);
                String _elementName3 = cppEnumeration.getElementName();
                ITranslationUnit _translationUnit_13 = cppEnumeration.getTranslationUnit();
                Type enumeration = this.getClassifier(_correspondingModel3, (ICElement)cppEnumeration, _elementName3, _translationUnit_13);
                boolean _xifexpression2 = false;
                boolean _and = false;
                boolean _notEquals3 = !Objects.equal((Object)enumeration, null);
                _and = !_notEquals3 ? false : enumeration instanceof Enumeration;
                if (_and) {
                    boolean _notEquals_1;
                    boolean _xblockexpression_4 = false;
                    String _elementName_12 = change.oldElement.getElementName();
                    EnumerationLiteral enumerator = ((Enumeration)enumeration).getOwnedLiteral(_elementName_12);
                    boolean _xifexpression_13 = false;
                    boolean bl = _notEquals_1 = !Objects.equal((Object)enumerator, null);
                    if (_notEquals_1) {
                        EList _ownedLiterals = ((Enumeration)enumeration).getOwnedLiterals();
                        _xifexpression_13 = _ownedLiterals.remove((Object)enumerator);
                    }
                    _xifexpression2 = _xblockexpression_4 = _xifexpression_13;
                }
                _xblockexpression_3 = _xifexpression2;
                _switchResult = _xblockexpression_3;
            }
            if (!_matched && change.oldElement instanceof ITranslationUnit) {
                _matched = true;
                List<Type> _xblockexpression_4 = null;
                ITranslationUnit itu = (ITranslationUnit)change.newElement;
                Model _correspondingModel4 = this.getCorrespondingModel(itu);
                _xblockexpression_4 = this.getOrCreateClassifier(_correspondingModel4, (IParent)itu);
                _switchResult = _xblockexpression_4;
            }
            return _switchResult;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private Object compareUml2Cpp(Element umlElement, ICElement icElement) {
        Object _xifexpression = null;
        boolean _and = false;
        _and = !(umlElement instanceof Package) ? false : icElement instanceof ICContainer;
        if (_and) {
            _xifexpression = null;
        }
        return _xifexpression;
    }

    private Object comparePackage(Package pack, ICContainer container) {
        try {
            boolean _notEquals;
            Object _xblockexpression = null;
            ICElement[] _children = container.getChildren();
            Iterable _filter = Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_children)), ICContainer.class);
            List containerChildren = IterableExtensions.toList((Iterable)_filter);
            Object _xifexpression = null;
            EList _nestedPackages = pack.getNestedPackages();
            int _size = _nestedPackages.size();
            int _size_1 = containerChildren.size();
            boolean bl = _notEquals = _size != _size_1;
            if (_notEquals) {
                _xifexpression = null;
            } else {
                Iterator iterator = containerChildren.iterator();
                EList _nestedPackages_1 = pack.getNestedPackages();
                for (Package child : _nestedPackages_1) {
                    ICContainer _next = (ICContainer)iterator.next();
                    this.syncName((NamedElement)child, (ICElement)_next);
                }
            }
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void syncName(NamedElement umlElement, ICElement icElement) {
        boolean _not;
        String _name;
        String _elementName = icElement.getElementName();
        boolean _equals = _elementName.equals(_name = umlElement.getName());
        boolean bl = _not = !_equals;
        if (_not) {
            String _elementName_1 = icElement.getElementName();
            umlElement.setName(_elementName_1);
        }
    }

    private void comparePackageableElement(PackageableElement umlElement, IParent parent) {
        int _size_1;
        if (!(umlElement instanceof Package) || !(umlElement instanceof Classifier)) {
            return;
        }
        EList _ownedElements = umlElement.getOwnedElements();
        Iterable typeChildren = Iterables.filter((Iterable)_ownedElements, Type.class);
        List<ICElement> structureChildren = this.reverse_utils.getAllIStructures(parent, false, false, this.m_project);
        int _size = IterableExtensions.size((Iterable)typeChildren);
        boolean _notEquals = _size != (_size_1 = structureChildren.size());
    }

    private Package getContainerPackage(ITranslationUnit unit) {
        boolean _equals_1;
        Model _xblockexpression = null;
        Model model = this.getCorrespondingModel(unit);
        IFile _file = unit.getFile();
        IPath _projectRelativePath = _file.getProjectRelativePath();
        String unitPath = _projectRelativePath.toString();
        boolean _or = false;
        boolean _equals = Objects.equal((Object)unitPath, null);
        _or = _equals ? true : (_equals_1 = unitPath.equals(""));
        if (_or) {
            String _string;
            IPath _location = unit.getLocation();
            unitPath = _string = _location.toString();
        }
        String _name = model.getName();
        String _plus = "/" + _name;
        String _plus_1 = String.valueOf(_plus) + "/";
        String[] _split = unitPath.split(_plus_1);
        String _last = (String)IterableExtensions.last((Iterable)((Iterable)Conversions.doWrapArray((Object)_split)));
        String[] arrayNames = _last.split("/");
        final ArrayList names = new ArrayList();
        Consumer<String> _function = new Consumer<String>(){

            @Override
            public void accept(String it) {
                names.add(it);
            }
        };
        ((List)Conversions.doWrapArray((Object)arrayNames)).forEach(_function);
        Model parentPack = model;
        for (String name : names) {
            boolean _not;
            String _elementName;
            boolean _equals_2 = name.equals(_elementName = unit.getElementName());
            boolean bl = _not = !_equals_2;
            if (!_not) continue;
            Package _nestedPackage = parentPack.getNestedPackage(name);
            boolean _equals_3 = Objects.equal((Object)_nestedPackage, null);
            if (_equals_3) {
                parentPack.createNestedPackage(name);
            }
            Package _nestedPackage_1 = parentPack.getNestedPackage(name);
            parentPack = _nestedPackage_1;
        }
        _xblockexpression = parentPack;
        return _xblockexpression;
    }

    private Type getClassifier(Model model, ICElement declaration, String name, ITranslationUnit unit) throws Exception {
        boolean _notEquals;
        boolean _and = false;
        EObject _get = this.map.get(declaration);
        boolean bl = _notEquals = !Objects.equal((Object)_get, null);
        if (!_notEquals) {
            _and = false;
        } else {
            EObject _get_1 = this.map.get(declaration);
            _and = _get_1 instanceof Type;
        }
        if (_and) {
            EObject _get_2 = this.map.get(declaration);
            return (Type)_get_2;
        }
        Type ret = null;
        Package parentPack = this.getContainerPackage(unit);
        Classifier parentClass = null;
        ICElement _parent = declaration.getParent();
        if (_parent instanceof IStructure) {
            ICElement _parent_1 = declaration.getParent();
            String _elementName = _parent_1.getElementName();
            List<String> _contextNamespaces = this.getContextNamespaces(declaration);
            Type _uMLType = this.getUMLType(_elementName, unit, _contextNamespaces);
            parentClass = (Classifier)_uMLType;
            EObject _createOrgetClassifier = this.createOrgetClassifier((PackageableElement)parentClass, declaration, false);
            ret = (Type)_createOrgetClassifier;
        } else {
            EObject _createOrgetClassifier_1 = this.createOrgetClassifier((PackageableElement)parentPack, declaration, false);
            ret = (Type)_createOrgetClassifier_1;
        }
        return ret;
    }

    private EObject createOrgetClassifier(PackageableElement packagebleElement, final ICElement ideclaration, boolean createContent) {
        Type existing;
        PackageableElement packageble;
        EObject _xblockexpression;
        block52: {
            block51: {
                int _elementType_4;
                boolean _notEquals_4;
                int _elementType_3;
                boolean _notEquals_3;
                int _elementType_2;
                boolean _notEquals_2;
                int _elementType_1;
                boolean _notEquals_1;
                boolean _notEquals;
                _xblockexpression = null;
                packageble = packagebleElement;
                boolean _and = false;
                boolean _and_1 = false;
                boolean _and_2 = false;
                boolean _and_3 = false;
                boolean _and_4 = false;
                int _elementType = ideclaration.getElementType();
                boolean bl = _notEquals = _elementType != 65;
                _and_4 = !_notEquals ? false : (_notEquals_1 = (_elementType_1 = ideclaration.getElementType()) != 83);
                _and_3 = !_and_4 ? false : (_notEquals_2 = (_elementType_2 = ideclaration.getElementType()) != 63);
                _and_2 = !_and_3 ? false : (_notEquals_3 = (_elementType_3 = ideclaration.getElementType()) != 67);
                _and_1 = !_and_2 ? false : (_notEquals_4 = (_elementType_4 = ideclaration.getElementType()) != 69);
                if (!_and_1) {
                    _and = false;
                } else {
                    boolean bl2 = _and = !(ideclaration instanceof ITypeDef);
                }
                if (!_and) break block51;
                return null;
            }
            existing = null;
            if (packageble instanceof Package || packageble instanceof Class) break block52;
            boolean _and_5 = false;
            _and_5 = !(packageble instanceof DataType) ? false : ideclaration instanceof ITypeDef;
            if (_and_5) {
                Package _nearestPackage = packagebleElement.getNearestPackage();
                packageble = _nearestPackage;
                break block52;
            }
            return null;
        }
        try {
            boolean _equals_10;
            int _elementType_8;
            boolean _equals_8;
            boolean _equals_7;
            int _elementType_6;
            boolean _equals_6;
            boolean _equals_5;
            boolean _notEquals_6;
            boolean _equals;
            boolean _notEquals_5;
            boolean _and_6 = false;
            EObject _get = this.map.get(ideclaration);
            boolean bl = _notEquals_5 = !Objects.equal((Object)_get, null);
            if (!_notEquals_5) {
                _and_6 = false;
            } else {
                EObject _get_1 = this.map.get(ideclaration);
                _and_6 = _get_1 instanceof Type;
            }
            if (_and_6) {
                EObject _get_2 = this.map.get(ideclaration);
                existing = (Type)_get_2;
            }
            if (_equals = Objects.equal(existing, null)) {
                boolean _not;
                Functions.Function1<Type, Boolean> _function;
                EList _ownedElements = packageble.getOwnedElements();
                Iterable _filter = Iterables.filter((Iterable)_ownedElements, Type.class);
                Iterable namedElements = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)(_function = new Functions.Function1<Type, Boolean>(){

                    public Boolean apply(Type it) {
                        String _name = it.getName();
                        String _elementName = ideclaration.getElementName();
                        return _name.equals(_elementName);
                    }
                }));
                boolean _isEmpty = IterableExtensions.isEmpty((Iterable)namedElements);
                boolean bl3 = _not = !_isEmpty;
                if (_not) {
                    Type _head;
                    existing = _head = (Type)IterableExtensions.head((Iterable)namedElements);
                }
            }
            boolean bl4 = _notEquals_6 = !Objects.equal((Object)existing, null);
            if (_notEquals_6) {
                return existing;
            }
            String _elementName = ideclaration.getElementName();
            String _plus = "Creating type " + _elementName;
            this.m_monitor.subTask(_plus);
            if (ideclaration instanceof ITypeDef) {
                boolean _notEquals_7;
                boolean bl5 = _notEquals_7 = !Objects.equal((Object)existing, null);
                if (_notEquals_7) {
                    return existing;
                }
                final ITypeDef typedef = (ITypeDef)ideclaration;
                PrimitiveType _createPrimitiveType = UMLFactory.eINSTANCE.createPrimitiveType();
                Procedures.Procedure1<PrimitiveType> _function_1 = new Procedures.Procedure1<PrimitiveType>(){

                    public void apply(PrimitiveType it) {
                        String _elementName = typedef.getElementName();
                        it.setName(_elementName);
                    }
                };
                PrimitiveType prinmitiveType = (PrimitiveType)ObjectExtensions.operator_doubleArrow((Object)_createPrimitiveType, (Procedures.Procedure1)_function_1);
                if (packageble instanceof Package) {
                    EList _ownedTypes = ((Package)packageble).getOwnedTypes();
                    _ownedTypes.add((Object)prinmitiveType);
                } else {
                    EList _nestedClassifiers = ((Class)packageble).getNestedClassifiers();
                    _nestedClassifiers.add((Object)prinmitiveType);
                }
                StereotypeUtil.apply((Element)prinmitiveType, Typedef.class);
                boolean _or = false;
                boolean _or_1 = false;
                String _typeName = typedef.getTypeName();
                boolean _equals_1 = Objects.equal((Object)_typeName, (Object)"struct");
                if (_equals_1) {
                    _or_1 = true;
                } else {
                    boolean _equals_2;
                    String _typeName_1 = typedef.getTypeName();
                    _or_1 = _equals_2 = Objects.equal((Object)_typeName_1, (Object)"class");
                }
                if (_or_1) {
                    _or = true;
                } else {
                    boolean _equals_3;
                    String _typeName_2 = typedef.getTypeName();
                    _or = _equals_3 = Objects.equal((Object)_typeName_2, (Object)"enum");
                }
                if (_or) {
                    ICElement _parent = typedef.getParent();
                    ICElement[] _children = ((IParent)_parent).getChildren();
                    int pos = ((List)Conversions.doWrapArray((Object)_children)).indexOf(typedef);
                    if (pos > 0) {
                        ICElement _parent_1 = typedef.getParent();
                        ICElement[] _children_1 = ((IParent)_parent_1).getChildren();
                        ICElement childStruct = _children_1[pos - 1];
                        boolean _and_7 = false;
                        boolean _or_2 = false;
                        _or_2 = childStruct instanceof IStructure ? true : childStruct instanceof IEnumeration;
                        if (!_or_2) {
                            _and_7 = false;
                        } else {
                            boolean _equals_4;
                            String _elementName_1 = childStruct.getElementName();
                            _and_7 = _equals_4 = Objects.equal((Object)_elementName_1, (Object)"");
                        }
                        if (_and_7) {
                            String source = ((ISourceReference)childStruct).getSource();
                            Typedef _stereotypeApplication = (Typedef)UMLUtil.getStereotypeApplication((Element)prinmitiveType, Typedef.class);
                            String _replace = source.replace("typedef", "");
                            String _plus_1 = String.valueOf(_replace) + " typeName";
                            _stereotypeApplication.setDefinition(_plus_1);
                        }
                    }
                } else {
                    IASTNode typedefNode = this.findEnclosingNode((ISourceReference)typedef);
                    String _rawSignature = typedefNode.getRawSignature();
                    String _replaceAll = _rawSignature.replaceAll("\\n", "");
                    String _replaceAll_1 = _replaceAll.replaceAll("\\r", "");
                    String _replaceAll_2 = _replaceAll_1.replaceAll(";", "");
                    String _replaceAll_3 = _replaceAll_2.replaceAll("\\s+", " ");
                    String rawSignature = _replaceAll_3.trim();
                    Pattern pattern = Pattern.compile("(\\()(\\s*)(\\*)(.*)(\\))(\\s*)(\\()(.*)(\\))");
                    Matcher matcher = pattern.matcher(rawSignature);
                    boolean _find = matcher.find();
                    if (_find) {
                        String _elementName_2 = typedef.getElementName();
                        String _quote = Pattern.quote(_elementName_2);
                        String typeName = rawSignature.replaceFirst(_quote, "typeName");
                        Typedef _stereotypeApplication_1 = (Typedef)UMLUtil.getStereotypeApplication((Element)prinmitiveType, Typedef.class);
                        _stereotypeApplication_1.setDefinition(typeName);
                    } else {
                        Typedef _stereotypeApplication_2 = (Typedef)UMLUtil.getStereotypeApplication((Element)prinmitiveType, Typedef.class);
                        String _typeName_3 = typedef.getTypeName();
                        _stereotypeApplication_2.setDefinition(_typeName_3);
                    }
                }
                this.map.put(ideclaration, (EObject)prinmitiveType);
                return prinmitiveType;
            }
            boolean structIsClassLike = false;
            boolean _or_3 = false;
            int _elementType_5 = ideclaration.getElementType();
            boolean bl6 = _equals_5 = _elementType_5 == 67;
            _or_3 = _equals_5 ? true : (_equals_6 = (_elementType_6 = ideclaration.getElementType()) == 69);
            if (_or_3) {
                IStructure iStructure = (IStructure)ideclaration;
                int i = 0;
                while (!structIsClassLike && i < ((List)Conversions.doWrapArray((Object)iStructure.getChildren())).size()) {
                    ICElement[] _children_2 = iStructure.getChildren();
                    ICElement child = _children_2[i];
                    boolean _or_4 = false;
                    _or_4 = child instanceof IMethodDeclaration ? true : child instanceof IStructure;
                    if (_or_4) {
                        structIsClassLike = true;
                    }
                    ++i;
                }
            }
            EObject _xifexpression = null;
            boolean _or_4 = false;
            boolean _or_5 = false;
            int _elementType_7 = ideclaration.getElementType();
            boolean bl7 = _equals_7 = _elementType_7 == 65;
            _or_5 = _equals_7 ? true : (_equals_8 = (_elementType_8 = ideclaration.getElementType()) == 83);
            _or_4 = _or_5 ? true : structIsClassLike;
            if (_or_4) {
                boolean _equals_9;
                boolean _notEquals_8;
                final IStructure iStructure_1 = (IStructure)ideclaration;
                Class temp = null;
                boolean bl8 = _notEquals_8 = !Objects.equal((Object)existing, null);
                if (_notEquals_8) {
                    temp = (Class)existing;
                } else if (packageble instanceof Package) {
                    Class _createOwnedClass;
                    String _elementName_3 = iStructure_1.getElementName();
                    boolean _isAbstract = iStructure_1.isAbstract();
                    temp = _createOwnedClass = ((Package)packageble).createOwnedClass(_elementName_3, _isAbstract);
                } else {
                    String _elementName_4 = iStructure_1.getElementName();
                    Classifier _createNestedClassifier = ((Class)packageble).createNestedClassifier(_elementName_4, UMLPackage.Literals.CLASS);
                    temp = (Class)_createNestedClassifier;
                    boolean _isAbstract_1 = iStructure_1.isAbstract();
                    temp.setIsAbstract(_isAbstract_1);
                }
                final Class classifier = temp;
                ICElement[] _children_2 = iStructure_1.getChildren();
                Consumer<ICElement> _function_2 = new Consumer<ICElement>(){

                    @Override
                    public void accept(ICElement it) {
                        boolean _equals;
                        int _elementType = it.getElementType();
                        boolean bl = _equals = _elementType == 72;
                        if (_equals) {
                            ReverseCpp2Uml.this.createProperty((IField)it, (Classifier)classifier);
                        } else if (it instanceof IMethodDeclaration) {
                            ReverseCpp2Uml.this.createMethod((IMethodDeclaration)it, classifier);
                        }
                    }
                };
                ((List)Conversions.doWrapArray((Object)_children_2)).forEach(_function_2);
                String[] _superClassesNames = iStructure_1.getSuperClassesNames();
                Functions.Function1<String, Type> _function_3 = new Functions.Function1<String, Type>(){

                    public Type apply(String it) {
                        ITranslationUnit _translationUnit = iStructure_1.getTranslationUnit();
                        List<String> _contextNamespaces = ReverseCpp2Uml.this.getContextNamespaces((ICElement)iStructure_1);
                        return ReverseCpp2Uml.this.getUMLType(it, _translationUnit, _contextNamespaces);
                    }
                };
                List superTypes = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)_superClassesNames)), (Functions.Function1)_function_3);
                Consumer<Type> _function_4 = new Consumer<Type>(){

                    @Override
                    public void accept(Type it) {
                        boolean _and = false;
                        boolean _notEquals = !Objects.equal((Object)it, null);
                        _and = !_notEquals ? false : it instanceof Classifier;
                        if (_and) {
                            String _name;
                            ASTAccessVisibility visibility;
                            boolean _notEquals_1;
                            Generalization generalization = classifier.createGeneralization((Classifier)it);
                            Visibility visibilitySt = (Visibility)UMLUtil.getStereotypeApplication((Element)generalization, Visibility.class);
                            boolean _equals = Objects.equal((Object)visibilitySt, null);
                            if (_equals) {
                                Visibility _stereotypeApplication;
                                StereotypeUtil.apply((Element)generalization, Visibility.class);
                                visibilitySt = _stereotypeApplication = (Visibility)UMLUtil.getStereotypeApplication((Element)generalization, Visibility.class);
                            }
                            boolean bl = _notEquals_1 = !Objects.equal((Object)(visibility = iStructure_1.getSuperClassAccess(_name = it.getName())), null);
                            if (_notEquals_1) {
                                String _name_1 = visibility.name();
                                String _lowerCase = _name_1.toLowerCase();
                                visibilitySt.setValue(_lowerCase);
                            }
                        }
                    }
                };
                superTypes.forEach(_function_4);
                this.map.put(ideclaration, (EObject)classifier);
                int _elementType_9 = iStructure_1.getElementType();
                boolean bl9 = _equals_9 = _elementType_9 == 83;
                if (_equals_9) {
                    IStructureTemplate istructureTemplate = (IStructureTemplate)iStructure_1;
                    StereotypeUtil.apply((Element)classifier, Template.class);
                    Template _stereotypeApplication_3 = (Template)UMLUtil.getStereotypeApplication((Element)classifier, Template.class);
                    String _templateSignature = istructureTemplate.getTemplateSignature();
                    _stereotypeApplication_3.setDeclaration(_templateSignature);
                }
                return classifier;
            }
            EObject _xifexpression_1 = null;
            int _elementType_10 = ideclaration.getElementType();
            boolean bl10 = _equals_10 = _elementType_10 == 63;
            if (_equals_10) {
                boolean _notEquals_9;
                EObject _xblockexpression_1 = null;
                Enumeration temp_1 = null;
                IEnumeration iStructure_2 = (IEnumeration)ideclaration;
                boolean bl11 = _notEquals_9 = !Objects.equal((Object)existing, null);
                if (_notEquals_9) {
                    temp_1 = (Enumeration)existing;
                } else if (packageble instanceof Package) {
                    Enumeration _createOwnedEnumeration;
                    String _elementName_5 = iStructure_2.getElementName();
                    temp_1 = _createOwnedEnumeration = ((Package)packageble).createOwnedEnumeration(_elementName_5);
                } else {
                    String _elementName_6 = iStructure_2.getElementName();
                    Classifier _createNestedClassifier_1 = ((Class)packageble).createNestedClassifier(_elementName_6, UMLPackage.Literals.ENUMERATION);
                    temp_1 = (Enumeration)_createNestedClassifier_1;
                }
                final Enumeration enumeration = temp_1;
                ICElement[] _children_3 = iStructure_2.getChildren();
                Consumer<ICElement> _function_5 = new Consumer<ICElement>(){

                    @Override
                    public void accept(ICElement it) {
                        if (it instanceof IEnumerator) {
                            boolean _notEquals;
                            String _elementName = ((IEnumerator)it).getElementName();
                            EnumerationLiteral literal = enumeration.createOwnedLiteral(_elementName);
                            String _constantExpression = ((IEnumerator)it).getConstantExpression();
                            boolean bl = _notEquals = !Objects.equal((Object)_constantExpression, null);
                            if (_notEquals) {
                                Enumeration _enumeration;
                                ValueSpecification valueSpecification;
                                String _constantExpression_2;
                                boolean _equals_1;
                                boolean _not;
                                boolean _notEquals_1;
                                EList _ownedElements = literal.getOwnedElements();
                                for (Element element : _ownedElements) {
                                    String _name;
                                    boolean _equals;
                                    if (!(element instanceof ValueSpecification) || !(_equals = (_name = ((ValueSpecification)element).getName()).equals("defaultValue"))) continue;
                                    ((ValueSpecification)element).destroy();
                                }
                                boolean _and = false;
                                String _constantExpression_1 = ((IEnumerator)it).getConstantExpression();
                                boolean bl2 = _notEquals_1 = !Objects.equal((Object)_constantExpression_1, null);
                                _and = !_notEquals_1 ? false : (_not = !(_equals_1 = (_constantExpression_2 = ((IEnumerator)it).getConstantExpression()).equals("")));
                                if (_and && (valueSpecification = literal.createSpecification("defaultValue", (Type)(_enumeration = literal.getEnumeration()), UMLPackage.Literals.OPAQUE_EXPRESSION)) instanceof OpaqueExpression) {
                                    OpaqueExpression opaqueExpression = (OpaqueExpression)valueSpecification;
                                    EList _languages = opaqueExpression.getLanguages();
                                    _languages.add((Object)Cpp_LangID);
                                    EList _bodies = opaqueExpression.getBodies();
                                    String _constantExpression_3 = ((IEnumerator)it).getConstantExpression();
                                    _bodies.add((Object)_constantExpression_3);
                                }
                            }
                        }
                    }
                };
                ((List)Conversions.doWrapArray((Object)_children_3)).forEach(_function_5);
                _xifexpression_1 = _xblockexpression_1 = this.map.put(ideclaration, (EObject)enumeration);
            } else {
                EObject _xifexpression_2 = null;
                boolean _and_8 = false;
                if (structIsClassLike) {
                    _and_8 = false;
                } else {
                    int _elementType_12;
                    boolean _equals_12;
                    boolean _equals_11;
                    boolean _or_6 = false;
                    int _elementType_11 = ideclaration.getElementType();
                    boolean bl12 = _equals_11 = _elementType_11 == 67;
                    _or_6 = _equals_11 ? true : (_equals_12 = (_elementType_12 = ideclaration.getElementType()) == 69);
                    _and_8 = _or_6;
                }
                if (_and_8) {
                    boolean _notEquals_9;
                    EObject _xblockexpression_2 = null;
                    DataType temp_1 = null;
                    final IStructure iStructure_2 = (IStructure)ideclaration;
                    boolean bl13 = _notEquals_9 = !Objects.equal((Object)existing, null);
                    if (_notEquals_9) {
                        temp_1 = (DataType)existing;
                    } else if (packageble instanceof Package) {
                        String _elementName_5 = iStructure_2.getElementName();
                        Type _createOwnedType = ((Package)packageble).createOwnedType(_elementName_5, UMLPackage.Literals.DATA_TYPE);
                        temp_1 = (DataType)_createOwnedType;
                    } else {
                        String _elementName_6 = iStructure_2.getElementName();
                        Classifier _createNestedClassifier_1 = ((Class)packageble).createNestedClassifier(_elementName_6, UMLPackage.Literals.DATA_TYPE);
                        temp_1 = (DataType)_createNestedClassifier_1;
                    }
                    final DataType dataType = temp_1;
                    ICElement[] _children_3 = iStructure_2.getChildren();
                    Consumer<ICElement> _function_5 = new Consumer<ICElement>(){

                        @Override
                        public void accept(ICElement it) {
                            boolean _equals;
                            int _elementType = it.getElementType();
                            boolean bl = _equals = _elementType == 72;
                            if (_equals) {
                                ReverseCpp2Uml.this.createProperty((IField)it, (Classifier)dataType);
                            }
                        }
                    };
                    ((List)Conversions.doWrapArray((Object)_children_3)).forEach(_function_5);
                    String[] _superClassesNames_1 = iStructure_2.getSuperClassesNames();
                    Functions.Function1<String, Type> _function_6 = new Functions.Function1<String, Type>(){

                        public Type apply(String it) {
                            ITranslationUnit _translationUnit = iStructure_2.getTranslationUnit();
                            List<String> _contextNamespaces = ReverseCpp2Uml.this.getContextNamespaces((ICElement)iStructure_2);
                            return ReverseCpp2Uml.this.getUMLType(it, _translationUnit, _contextNamespaces);
                        }
                    };
                    List superTypes_1 = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)_superClassesNames_1)), (Functions.Function1)_function_6);
                    Consumer<Type> _function_7 = new Consumer<Type>(){

                        @Override
                        public void accept(Type it) {
                            boolean _and = false;
                            boolean _notEquals = !Objects.equal((Object)it, null);
                            _and = !_notEquals ? false : it instanceof Classifier;
                            if (_and) {
                                String _name;
                                ASTAccessVisibility visibility;
                                boolean _notEquals_1;
                                Generalization generalization = dataType.createGeneralization((Classifier)it);
                                Visibility visibilitySt = (Visibility)UMLUtil.getStereotypeApplication((Element)generalization, Visibility.class);
                                boolean _equals = Objects.equal((Object)visibilitySt, null);
                                if (_equals) {
                                    Visibility _stereotypeApplication;
                                    StereotypeUtil.apply((Element)generalization, Visibility.class);
                                    visibilitySt = _stereotypeApplication = (Visibility)UMLUtil.getStereotypeApplication((Element)generalization, Visibility.class);
                                }
                                boolean bl = _notEquals_1 = !Objects.equal((Object)(visibility = iStructure_2.getSuperClassAccess(_name = it.getName())), null);
                                if (_notEquals_1) {
                                    String _name_1 = visibility.name();
                                    String _lowerCase = _name_1.toLowerCase();
                                    visibilitySt.setValue(_lowerCase);
                                }
                            }
                        }
                    };
                    superTypes_1.forEach(_function_7);
                    _xifexpression_2 = _xblockexpression_2 = this.map.put(ideclaration, (EObject)dataType);
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xblockexpression = _xifexpression = _xifexpression_1;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private Classifier createOrgetTemplateParameter(NamedElement element, final String parameterTypeName, String keyWord) {
        Classifier _head;
        Classifier ret = null;
        RedefinableTemplateSignature templateSignature = null;
        if (element instanceof Classifier) {
            TemplateSignature _ownedTemplateSignature_1;
            boolean _not;
            Classifier classifier = (Classifier)element;
            boolean _or = false;
            TemplateSignature _ownedTemplateSignature = classifier.getOwnedTemplateSignature();
            boolean _equals = Objects.equal((Object)_ownedTemplateSignature, null);
            _or = _equals ? true : (_not = !((_ownedTemplateSignature_1 = classifier.getOwnedTemplateSignature()) instanceof RedefinableTemplateSignature));
            if (_or) {
                TemplateSignature _createOwnedTemplateSignature = classifier.createOwnedTemplateSignature(UMLPackage.Literals.REDEFINABLE_TEMPLATE_SIGNATURE);
                templateSignature = (RedefinableTemplateSignature)_createOwnedTemplateSignature;
                templateSignature.setName(TEMPLATE_PARAMETER_SIGNATURE_NAME);
            }
            TemplateSignature _ownedTemplateSignature_2 = classifier.getOwnedTemplateSignature();
            templateSignature = (RedefinableTemplateSignature)_ownedTemplateSignature_2;
        } else if (element instanceof Operation) {
            TemplateSignature _ownedTemplateSignature_4;
            boolean _not_1;
            Operation operation = (Operation)element;
            boolean _or_1 = false;
            TemplateSignature _ownedTemplateSignature_3 = operation.getOwnedTemplateSignature();
            boolean _equals_1 = Objects.equal((Object)_ownedTemplateSignature_3, null);
            _or_1 = _equals_1 ? true : (_not_1 = !((_ownedTemplateSignature_4 = operation.getOwnedTemplateSignature()) instanceof TemplateSignature));
            if (_or_1) {
                TemplateSignature _createOwnedTemplateSignature_1 = operation.createOwnedTemplateSignature(UMLPackage.Literals.TEMPLATE_SIGNATURE);
                templateSignature = _createOwnedTemplateSignature_1;
            }
            TemplateSignature _ownedTemplateSignature_5 = operation.getOwnedTemplateSignature();
            templateSignature = _ownedTemplateSignature_5;
        } else {
            return null;
        }
        EList _ownedParameters = templateSignature.getOwnedParameters();
        Iterable classifierTemplates = Iterables.filter((Iterable)_ownedParameters, ClassifierTemplateParameter.class);
        Functions.Function1<ClassifierTemplateParameter, Boolean> _function = new Functions.Function1<ClassifierTemplateParameter, Boolean>(){

            public Boolean apply(ClassifierTemplateParameter it) {
                ParameterableElement _ownedParameteredElement = it.getOwnedParameteredElement();
                return _ownedParameteredElement instanceof Classifier;
            }
        };
        Iterable classifierTemplatesContainClassifier = IterableExtensions.filter((Iterable)classifierTemplates, (Functions.Function1)_function);
        Functions.Function1<ClassifierTemplateParameter, ParameterableElement> _function_1 = new Functions.Function1<ClassifierTemplateParameter, ParameterableElement>(){

            public ParameterableElement apply(ClassifierTemplateParameter it) {
                return it.getOwnedParameteredElement();
            }
        };
        Iterable containedClassifiers = IterableExtensions.map((Iterable)classifierTemplatesContainClassifier, (Functions.Function1)_function_1);
        Iterable _filter = Iterables.filter((Iterable)containedClassifiers, Classifier.class);
        Functions.Function1<Classifier, Boolean> _function_2 = new Functions.Function1<Classifier, Boolean>(){

            public Boolean apply(Classifier it) {
                String _name = it.getName();
                return _name.equals(parameterTypeName);
            }
        };
        Iterable _filter_1 = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function_2);
        ret = _head = (Classifier)IterableExtensions.head((Iterable)_filter_1);
        boolean _equals_2 = Objects.equal((Object)ret, null);
        if (_equals_2) {
            TemplateParameter _createOwnedParameter = templateSignature.createOwnedParameter(UMLPackage.Literals.CLASSIFIER_TEMPLATE_PARAMETER);
            ClassifierTemplateParameter classifierTemplate = (ClassifierTemplateParameter)_createOwnedParameter;
            ParameterableElement _createOwnedParameteredElement = classifierTemplate.createOwnedParameteredElement(UMLPackage.Literals.CLASS);
            ret = (Classifier)_createOwnedParameteredElement;
            ret.setName(parameterTypeName);
            classifierTemplate.addKeyword(keyWord);
        }
        return ret;
    }

    private IASTNodeSelector getSelector(ITranslationUnit unit) {
        try {
            boolean _notEquals;
            IASTTranslationUnit ast = null;
            boolean bl = _notEquals = !Objects.equal((Object)unit, null);
            if (_notEquals) {
                boolean _notEquals_2;
                boolean _notEquals_1;
                IASTTranslationUnit _get = this.translationUnitToASTTranslationUnitMap.get(unit);
                boolean bl2 = _notEquals_1 = !Objects.equal((Object)_get, null);
                if (_notEquals_1) {
                    IASTTranslationUnit _get_1 = this.translationUnitToASTTranslationUnitMap.get(unit);
                    return _get_1.getNodeSelector(null);
                }
                IASTTranslationUnit _aST = unit.getAST(this.index, 32);
                ast = _aST;
                boolean bl3 = _notEquals_2 = !Objects.equal((Object)ast, null);
                if (_notEquals_2) {
                    this.translationUnitToASTTranslationUnitMap.put(unit, ast);
                    return ast.getNodeSelector(null);
                }
            }
            return null;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void createMethod(IMethodDeclaration method, Class classifier) {
        boolean _notEquals;
        IASTFunctionDeclarator declarator = this.getDeclarator(method);
        boolean bl = _notEquals = !Objects.equal((Object)declarator, null);
        if (_notEquals) {
            String _elementName = method.getElementName();
            Operation op = classifier.createOwnedOperation(_elementName, null, null);
            this.updateMethod(classifier, op, method);
        }
    }

    private IASTNode findEnclosingNode(ISourceReference source) {
        try {
            IASTNode _xblockexpression = null;
            ITranslationUnit _translationUnit = source.getTranslationUnit();
            IASTNodeSelector selector = this.getSelector(_translationUnit);
            ISourceRange range = source.getSourceRange();
            int _startPos = range.getStartPos();
            int _length = range.getLength();
            _xblockexpression = selector.findEnclosingNode(_startPos, _length);
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private IASTFunctionDeclarator getDeclarator(IMethodDeclaration method) {
        IASTFunctionDeclarator declarator = null;
        IASTNode node = this.findEnclosingNode((ISourceReference)method);
        if (node instanceof ICPPASTFunctionDefinition) {
            IASTFunctionDeclarator _declarator;
            declarator = _declarator = ((ICPPASTFunctionDefinition)node).getDeclarator();
        } else if (node instanceof IASTSimpleDeclaration) {
            IASTFunctionDeclarator _head;
            IASTSimpleDeclaration declaration = (IASTSimpleDeclaration)node;
            IASTDeclarator[] _declarators = declaration.getDeclarators();
            Iterable _filter = Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_declarators)), IASTFunctionDeclarator.class);
            declarator = _head = (IASTFunctionDeclarator)IterableExtensions.head((Iterable)_filter);
        } else if (node instanceof ICPPASTTemplateDeclaration) {
            IASTNode[] chidren;
            ICPPASTTemplateDeclaration declaration_1 = (ICPPASTTemplateDeclaration)node;
            IASTNode[] iASTNodeArray = chidren = declaration_1.getChildren();
            int n = chidren.length;
            int n2 = 0;
            while (n2 < n) {
                IASTNode child = iASTNodeArray[n2];
                if (child instanceof IASTSimpleDeclaration) {
                    IASTFunctionDeclarator _head_1;
                    IASTDeclarator[] _declarators_1 = ((IASTSimpleDeclaration)child).getDeclarators();
                    Iterable _filter_1 = Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_declarators_1)), IASTFunctionDeclarator.class);
                    declarator = _head_1 = (IASTFunctionDeclarator)IterableExtensions.head((Iterable)_filter_1);
                }
                ++n2;
            }
        }
        return declarator;
    }

    private List<String> getKeywords(IMethodDeclaration method) {
        try {
            IASTNode node = this.findEnclosingNode((ISourceReference)method);
            ArrayList<String> keywords = new ArrayList<String>();
            if (node instanceof ICPPASTTemplateDeclaration) {
                IASTNode[] chidren;
                ICPPASTTemplateDeclaration declaration = (ICPPASTTemplateDeclaration)node;
                IASTNode[] iASTNodeArray = chidren = declaration.getChildren();
                int n = chidren.length;
                int n2 = 0;
                while (n2 < n) {
                    IASTNode child = iASTNodeArray[n2];
                    if (child instanceof ICPPASTTemplateParameter) {
                        IToken token = ((ICPPASTTemplateParameter)child).getSyntax();
                        String keyword = "class";
                        while (!Objects.equal((Object)token, null)) {
                            IToken _next;
                            boolean _equals;
                            int _type = token.getType();
                            boolean bl = _equals = _type == 118;
                            if (_equals) {
                                keyword = "typename";
                            }
                            token = _next = token.getNext();
                        }
                        keywords.add(keyword);
                    }
                    ++n2;
                }
            }
            return keywords;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private String getBody(IMethodDeclaration method) {
        IASTFunctionDeclarator declarator = null;
        IASTNode node = this.findEnclosingNode((ISourceReference)method);
        String body = null;
        if (node instanceof ICPPASTFunctionDefinition) {
            String _body;
            IASTFunctionDeclarator _declarator;
            declarator = _declarator = ((ICPPASTFunctionDefinition)node).getDeclarator();
            ITranslationUnit _translationUnit = method.getTranslationUnit();
            body = _body = BatchReverseFunctionBody.getBody(_translationUnit, (IASTFunctionDefinition)((ICPPASTFunctionDefinition)node));
        } else {
            boolean cfr_ignored_0 = node instanceof IASTFunctionDeclarator;
        }
        return body;
    }

    private IASTNode getRootNode(IASTNode fromNode) {
        IASTNode _parent = fromNode.getParent();
        boolean _equals = Objects.equal((Object)_parent, null);
        if (_equals) {
            return fromNode;
        }
        IASTNode _parent_1 = fromNode.getParent();
        return this.getRootNode(_parent_1);
    }

    private String getMemberInit(IMethodDeclaration method) {
        IASTNode _findEnclosingNode = this.findEnclosingNode((ISourceReference)method);
        return ReverseCpp2Uml.getMemberInit(_findEnclosingNode);
    }

    public static String getMemberInit(IASTNode methodNode) {
        String ret = "";
        if (methodNode instanceof ICPPASTFunctionDefinition) {
            boolean _notEquals;
            ICPPASTConstructorChainInitializer[] inits = ((ICPPASTFunctionDefinition)methodNode).getMemberInitializers();
            boolean bl = _notEquals = !Objects.equal((Object)inits, null);
            if (_notEquals) {
                StringConcatenation _builder = new StringConcatenation();
                boolean _hasElements = false;
                ICPPASTConstructorChainInitializer[] iCPPASTConstructorChainInitializerArray = inits;
                int n = inits.length;
                int n2 = 0;
                while (n2 < n) {
                    ICPPASTConstructorChainInitializer i = iCPPASTConstructorChainInitializerArray[n2];
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "");
                    }
                    IASTName _memberInitializerId = i.getMemberInitializerId();
                    _builder.append((Object)_memberInitializerId, "");
                    IASTInitializer _initializer = i.getInitializer();
                    String _rawSignature = _initializer.getRawSignature();
                    _builder.append(_rawSignature, "");
                    ++n2;
                }
                ret = _builder.toString();
            }
        }
        return ret.toString();
    }

    private void updateMethod(Class classifier, Operation op, IMethodDeclaration method) {
        try {
            boolean _notEquals_2;
            boolean _equals_2;
            boolean _isDestructor_1;
            boolean _not_1;
            boolean _not;
            String _elementName = method.getElementName();
            op.setName(_elementName);
            StereotypeUtil.unapply((Element)op, Inline.class);
            StereotypeUtil.unapply((Element)op, Friend.class);
            StereotypeUtil.unapply((Element)op, Virtual.class);
            StereotypeUtil.unapply((Element)op, Volatile.class);
            StereotypeUtil.unapply((Element)op, Create.class);
            StereotypeUtil.unapply((Element)op, Destroy.class);
            StereotypeUtil.unapply((Element)op, Const.class);
            EList _ownedParameters = op.getOwnedParameters();
            _ownedParameters.clear();
            IASTFunctionDeclarator declarator = this.getDeclarator(method);
            List<String> keywords = this.getKeywords(method);
            String body = this.getBody(method);
            ASTAccessVisibility _visibility = method.getVisibility();
            VisibilityKind _convertVisibility = this.convertVisibility(_visibility);
            op.setVisibility(_convertVisibility);
            boolean _isStatic = method.isStatic();
            op.setIsStatic(_isStatic);
            boolean _isInline = method.isInline();
            this.reverse_utils.applyStereotype((Element)op, _isInline, ReverseUtils.StereotypeType.INLINE, "");
            boolean _isFriend = method.isFriend();
            this.reverse_utils.applyStereotype((Element)op, _isFriend, ReverseUtils.StereotypeType.FRIENDLINE, "");
            boolean _isVirtual = method.isVirtual();
            this.reverse_utils.applyStereotype((Element)op, _isVirtual, ReverseUtils.StereotypeType.VIRTUAL, "");
            boolean _isVolatile = method.isVolatile();
            this.reverse_utils.applyStereotype((Element)op, _isVolatile, ReverseUtils.StereotypeType.VOLATILE, "");
            boolean _isConst = method.isConst();
            this.reverse_utils.applyStereotype((Element)op, _isConst, ReverseUtils.StereotypeType.CONST, "");
            boolean _isVirtual_1 = method.isVirtual();
            if (_isVirtual_1) {
                boolean _isVirtual_2 = method.isVirtual();
                this.reverse_utils.applyStereotype((Element)op, _isVirtual_2, ReverseUtils.StereotypeType.VIRTUAL, "");
                boolean _isPureVirtual = method.isPureVirtual();
                if (_isPureVirtual) {
                    op.setIsAbstract(true);
                }
            }
            boolean _isConstructor = method.isConstructor();
            this.reverse_utils.applyStereotype((Element)op, _isConstructor, ReverseUtils.StereotypeType.CREATE, "");
            boolean _isDestructor = method.isDestructor();
            this.reverse_utils.applyStereotype((Element)op, _isDestructor, ReverseUtils.StereotypeType.DESTROY, "");
            try {
                String signature = method.getSignature();
                Pattern pattern = Pattern.compile("([\\s]*)(\\.\\.\\.)([\\s]*)(\\))");
                Matcher matcher = pattern.matcher(signature);
                boolean _find = matcher.find();
                this.reverse_utils.applyStereotype((Element)op, _find, ReverseUtils.StereotypeType.VARIADIC, "");
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    e.printStackTrace();
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            if (method instanceof IMethodTemplateDeclaration) {
                int i = 0;
                while (i < ((List)Conversions.doWrapArray((Object)((IMethodTemplateDeclaration)method).getTemplateParameterTypes())).size()) {
                    String[] _templateParameterTypes = ((IMethodTemplateDeclaration)method).getTemplateParameterTypes();
                    String _get = _templateParameterTypes[i];
                    String _get_1 = keywords.get(i);
                    this.createOrgetTemplateParameter((NamedElement)op, _get, _get_1);
                    ++i;
                }
            }
            boolean _and = false;
            boolean _isConstructor_1 = method.isConstructor();
            boolean bl = _not = !_isConstructor_1;
            _and = !_not ? false : (_not_1 = !(_isDestructor_1 = method.isDestructor()));
            if (_and) {
                boolean _notEquals;
                String _returnType = method.getReturnType();
                boolean bl2 = _notEquals = !Objects.equal((Object)_returnType, null);
                if (_notEquals) {
                    String _returnType_1 = method.getReturnType();
                    String _cppTypeName = this.getCppTypeName(_returnType_1);
                    Type parameterType = this.getParameterTemplateType(op, method, _cppTypeName);
                    boolean _equals = Objects.equal((Object)parameterType, null);
                    if (_equals) {
                        Type _uMLType;
                        String _returnType_2 = method.getReturnType();
                        String _cppTypeName_1 = this.getCppTypeName(_returnType_2);
                        ITranslationUnit _translationUnit = method.getTranslationUnit();
                        List<String> _contextNamespaces = this.getContextNamespaces((ICElement)method);
                        parameterType = _uMLType = this.getUMLType(_cppTypeName_1, _translationUnit, _contextNamespaces);
                    }
                    Parameter ret = op.createOwnedParameter("ret", parameterType);
                    ret.setDirection(ParameterDirectionKind.RETURN_LITERAL);
                    Type _type = ret.getType();
                    this.reverse_utils.analyzeDeclaration((IASTDeclarator)declarator, _type, (TypedElement)ret, this.langID);
                    boolean _and_1 = false;
                    String _name = parameterType.getName();
                    boolean _equals_1 = _name.equals("void");
                    if (!_equals_1) {
                        _and_1 = false;
                    } else {
                        boolean _isEmpty;
                        EList _appliedStereotypes = ret.getAppliedStereotypes();
                        _and_1 = _isEmpty = _appliedStereotypes.isEmpty();
                    }
                    if (_and_1) {
                        ret.destroy();
                    }
                    String _returnType_3 = method.getReturnType();
                    boolean _contains = _returnType_3.contains("const ");
                    this.reverse_utils.applyStereotype((Element)ret, _contains, ReverseUtils.StereotypeType.CONST, "");
                    String _returnType_4 = method.getReturnType();
                    boolean _contains_1 = _returnType_4.contains("volatile ");
                    this.reverse_utils.applyStereotype((Element)ret, _contains_1, ReverseUtils.StereotypeType.VOLATILE, "");
                } else {
                    ITranslationUnit _translationUnit_1 = method.getTranslationUnit();
                    List<String> _contextNamespaces_1 = this.getContextNamespaces((ICElement)method);
                    Type _uMLType_1 = this.getUMLType("void", _translationUnit_1, _contextNamespaces_1);
                    Parameter ret_1 = op.createOwnedParameter("ret", _uMLType_1);
                    ret_1.setDirection(ParameterDirectionKind.RETURN_LITERAL);
                    Type _type_1 = ret_1.getType();
                    this.reverse_utils.analyzeDeclaration((IASTDeclarator)declarator, _type_1, (TypedElement)ret_1, this.langID);
                    EList _appliedStereotypes_1 = ret_1.getAppliedStereotypes();
                    boolean _isEmpty_1 = _appliedStereotypes_1.isEmpty();
                    if (_isEmpty_1) {
                        ret_1.destroy();
                    }
                }
            }
            boolean noArguments = false;
            IASTNode[] _children = declarator.getChildren();
            Iterable _filter = Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_children)), IASTParameterDeclaration.class);
            int _size = IterableExtensions.size((Iterable)_filter);
            boolean bl3 = _equals_2 = _size == 1;
            if (_equals_2) {
                boolean _notEquals_1;
                IASTNode[] _children_1 = declarator.getChildren();
                Iterable _filter_1 = Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_children_1)), IASTParameterDeclaration.class);
                IASTParameterDeclaration parameterNode = ((IASTParameterDeclaration[])Conversions.unwrapArray((Object)_filter_1, IASTParameterDeclaration.class))[0];
                IASTDeclSpecifier _declSpecifier = parameterNode.getDeclSpecifier();
                boolean bl4 = _notEquals_1 = !Objects.equal((Object)_declSpecifier, null);
                if (_notEquals_1) {
                    String type = "";
                    IASTDeclSpecifier _declSpecifier_1 = parameterNode.getDeclSpecifier();
                    IToken tokens = _declSpecifier_1.getSyntax();
                    while (!Objects.equal((Object)tokens, null)) {
                        IToken _next;
                        String _type_2 = type;
                        String _string = tokens.toString();
                        type = String.valueOf(_type_2) + _string;
                        tokens = _next = tokens.getNext();
                    }
                    String _trim = type.trim();
                    boolean _equals_3 = _trim.equals("void");
                    if (_equals_3) {
                        noArguments = true;
                    }
                }
            }
            if (!noArguments) {
                IASTNode[] _children_2 = declarator.getChildren();
                Iterable _filter_2 = Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_children_2)), IASTParameterDeclaration.class);
                for (IASTParameterDeclaration param : _filter_2) {
                    this.excludeIncludFromTranslationUnit(param, method, op);
                    IASTDeclSpecifier _declSpecifier_2 = param.getDeclSpecifier();
                    String _cppTypeName_2 = this.reverse_utils.getCppTypeName(_declSpecifier_2);
                    Type parameterType_1 = this.getParameterTemplateType(op, method, _cppTypeName_2);
                    boolean _equals_4 = Objects.equal((Object)parameterType_1, null);
                    if (_equals_4) {
                        Type _uMLType_2;
                        IASTDeclSpecifier _declSpecifier_3 = param.getDeclSpecifier();
                        ITranslationUnit _translationUnit_2 = method.getTranslationUnit();
                        List<String> _contextNamespaces_2 = this.getContextNamespaces((ICElement)method);
                        parameterType_1 = _uMLType_2 = this.getUMLType(_declSpecifier_3, _translationUnit_2, _contextNamespaces_2);
                    }
                    IASTDeclarator _declarator = param.getDeclarator();
                    IASTName _name_1 = _declarator.getName();
                    String _string = _name_1.toString();
                    Parameter opParam = op.createOwnedParameter(_string, parameterType_1);
                    IASTDeclSpecifier _declSpecifier_4 = param.getDeclSpecifier();
                    boolean _isConst_1 = _declSpecifier_4.isConst();
                    this.reverse_utils.applyStereotype((Element)opParam, _isConst_1, ReverseUtils.StereotypeType.CONST, "");
                    IASTDeclarator _declarator_1 = param.getDeclarator();
                    Type _type_2 = opParam.getType();
                    this.reverse_utils.analyzeDeclaration(_declarator_1, _type_2, (TypedElement)opParam, this.langID);
                    IASTDeclSpecifier _declSpecifier_5 = param.getDeclSpecifier();
                    boolean _isVolatile_1 = _declSpecifier_5.isVolatile();
                    this.reverse_utils.applyStereotype((Element)opParam, _isVolatile_1, ReverseUtils.StereotypeType.VOLATILE, "");
                }
            }
            boolean bl5 = _notEquals_2 = !Objects.equal((Object)body, null);
            if (_notEquals_2) {
                boolean _equals_6;
                boolean _equals_4;
                boolean _isConstructor_2 = method.isConstructor();
                if (_isConstructor_2) {
                    boolean _not_2;
                    String initStr = this.getMemberInit(method);
                    boolean _isEmpty_2 = initStr.isEmpty();
                    boolean bl6 = _not_2 = !_isEmpty_2;
                    if (_not_2) {
                        StereotypeUtil.apply((Element)op, ConstInit.class);
                        ConstInit _stereotypeApplication = (ConstInit)UMLUtil.getStereotypeApplication((Element)op, ConstInit.class);
                        _stereotypeApplication.setInitialisation(initStr);
                    }
                }
                OpaqueBehavior ob = null;
                EList _methods = op.getMethods();
                int _size_1 = _methods.size();
                boolean bl7 = _equals_4 = _size_1 == 0;
                if (_equals_4) {
                    String _name_1 = op.getName();
                    Behavior _createOwnedBehavior = classifier.createOwnedBehavior(_name_1, UMLPackage.Literals.OPAQUE_BEHAVIOR);
                    ob = (OpaqueBehavior)_createOwnedBehavior;
                    ob.setSpecification((BehavioralFeature)op);
                    ob.setIsReentrant(false);
                } else {
                    boolean _not_3;
                    String _name_3;
                    EList _methods_1 = op.getMethods();
                    Behavior _get = (Behavior)_methods_1.get(0);
                    ob = (OpaqueBehavior)_get;
                    String _name_2 = ob.getName();
                    boolean _equals_5 = _name_2.equals(_name_3 = op.getName());
                    boolean bl8 = _not_3 = !_equals_5;
                    if (_not_3) {
                        String _name_4 = op.getName();
                        ob.setName(_name_4);
                    }
                }
                EList _bodies = ob.getBodies();
                int _size_2 = _bodies.size();
                boolean bl9 = _equals_6 = _size_2 == 0;
                if (_equals_6) {
                    EList _languages = ob.getLanguages();
                    _languages.add((Object)this.langID);
                    EList _bodies_1 = ob.getBodies();
                    _bodies_1.add((Object)"");
                }
                int i = 0;
                while (i < ob.getLanguages().size()) {
                    EList _languages_1 = ob.getLanguages();
                    String _get_1 = (String)_languages_1.get(i);
                    boolean _equals_7 = _get_1.equals(this.langID);
                    if (_equals_7) {
                        boolean _lessThan;
                        EList _bodies_2 = ob.getBodies();
                        int _size_3 = _bodies_2.size();
                        boolean bl10 = _lessThan = i < _size_3;
                        if (_lessThan) {
                            EList _bodies_3 = ob.getBodies();
                            _bodies_3.set(i, (Object)body);
                        }
                    }
                    ++i;
                }
                IASTNode node = this.findEnclosingNode((ISourceReference)method);
                if (node instanceof IASTFunctionDefinition) {
                    ITranslationUnit _translationUnit_2 = method.getTranslationUnit();
                    DependencyAnalysis _dependencyAnalysis = new DependencyAnalysis(op, (IASTFunctionDefinition)node, _translationUnit_2, this);
                    _dependencyAnalysis.analyzeDependencies();
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private Type getParameterTemplateType(Operation op, IMethodDeclaration imethod, final String typeName) {
        Classifier ret = null;
        if (imethod instanceof IMethodTemplateDeclaration) {
            boolean _not;
            String[] _templateParameterTypes = ((IMethodTemplateDeclaration)imethod).getTemplateParameterTypes();
            Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

                public Boolean apply(String it) {
                    return it.equals(typeName);
                }
            };
            Iterable _filter = IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_templateParameterTypes)), (Functions.Function1)_function);
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)_filter);
            boolean bl = _not = !_isEmpty;
            if (_not) {
                Classifier _createOrgetTemplateParameter;
                ret = _createOrgetTemplateParameter = this.createOrgetTemplateParameter((NamedElement)op, typeName, "class");
            }
        }
        return ret;
    }

    private Object isCollectionType(IField field, Property prop) {
        return null;
    }

    private boolean isSimpleAssociation(Property prop) {
        boolean _isApplied_2;
        boolean _not;
        boolean _isApplied_1;
        boolean _and = false;
        boolean _or = false;
        boolean _isApplied = StereotypeUtil.isApplied((Element)prop, Ptr.class);
        _or = _isApplied ? true : (_isApplied_1 = StereotypeUtil.isApplied((Element)prop, Ref.class));
        _and = !_or ? false : (_not = !(_isApplied_2 = StereotypeUtil.isApplied((Element)prop, Array.class)));
        return _and;
    }

    private boolean isAggregation(Property prop) {
        boolean _isApplied_2;
        boolean _isApplied_1;
        boolean _and = false;
        boolean _or = false;
        boolean _isApplied = StereotypeUtil.isApplied((Element)prop, Ptr.class);
        _or = _isApplied ? true : (_isApplied_1 = StereotypeUtil.isApplied((Element)prop, Ref.class));
        _and = !_or ? false : (_isApplied_2 = StereotypeUtil.isApplied((Element)prop, Array.class));
        return _and;
    }

    private boolean isComposition(Property prop) {
        boolean _isApplied_1;
        boolean _not_1;
        boolean _not;
        boolean _and = false;
        boolean _isApplied = StereotypeUtil.isApplied((Element)prop, Ptr.class);
        boolean bl = _not = !_isApplied;
        _and = !_not ? false : (_not_1 = !(_isApplied_1 = StereotypeUtil.isApplied((Element)prop, Ref.class)));
        return _and;
    }

    private void createProperty(final IField field, Classifier classifier) {
        Property _createProperty = UMLFactory.eINSTANCE.createProperty();
        Procedures.Procedure1<Property> _function = new Procedures.Procedure1<Property>(){

            public void apply(Property it) {
                String _elementName = field.getElementName();
                it.setName(_elementName);
            }
        };
        Property prop = (Property)ObjectExtensions.operator_doubleArrow((Object)_createProperty, (Procedures.Procedure1)_function);
        if (classifier instanceof DataType) {
            EList _ownedAttributes = ((DataType)classifier).getOwnedAttributes();
            _ownedAttributes.add((Object)prop);
        } else if (classifier instanceof Class) {
            EList _ownedAttributes_1 = ((Class)classifier).getOwnedAttributes();
            _ownedAttributes_1.add((Object)prop);
        }
        this.updateProperty(field, prop);
    }

    private void updateProperty(final IField field, Property prop) {
        try {
            ISourceRange _sourceRange_1;
            int _length;
            ISourceRange _sourceRange;
            int _startPos;
            ITranslationUnit _translationUnit;
            IASTNodeSelector _selector;
            IASTNode node;
            this.reverse_utils.unapplyAllStereotypes((Element)prop);
            Type type = null;
            boolean doNotAnalyzeDeclaration = false;
            try {
                boolean _equals;
                boolean _notEquals;
                IASTNode fieldNode = this.findEnclosingNode((ISourceReference)field);
                boolean bl = _notEquals = !Objects.equal((Object)fieldNode, null);
                if (_notEquals) {
                    String _rawSignature = fieldNode.getRawSignature();
                    String _replaceAll = _rawSignature.replaceAll("\\n", "");
                    String _replaceAll_1 = _replaceAll.replaceAll("\\r", "");
                    String _replaceAll_2 = _replaceAll_1.replaceAll(";", "");
                    String _replaceAll_3 = _replaceAll_2.replaceAll("\\s+", " ");
                    String rawSignature = _replaceAll_3.trim();
                    Pattern pattern = Pattern.compile("(\\()(\\s*)(\\*)(.*)(\\))(\\s*)(\\()(.*)(\\))");
                    Matcher matcher = pattern.matcher(rawSignature);
                    boolean _find = matcher.find();
                    if (_find) {
                        String _elementName = field.getElementName();
                        String _quote = Pattern.quote(_elementName);
                        String _replaceFirst = rawSignature.replaceFirst(_quote, "typeName");
                        String typeName = _replaceFirst.replaceFirst("typedef", "");
                        Package packageable = null;
                        Element _owner = prop.getOwner();
                        if (_owner instanceof Class) {
                            Element _owner_1 = prop.getOwner();
                            packageable = (Class)_owner_1;
                        } else {
                            Package _nearestPackage;
                            packageable = _nearestPackage = prop.getNearestPackage();
                        }
                        final String ownerName = packageable.getName();
                        PrimitiveType _createPrimitiveType = UMLFactory.eINSTANCE.createPrimitiveType();
                        Procedures.Procedure1<PrimitiveType> _function = new Procedures.Procedure1<PrimitiveType>(){

                            public void apply(PrimitiveType it) {
                                String _elementName = field.getElementName();
                                String _plus = String.valueOf(ownerName) + "_" + _elementName;
                                String _plus_1 = String.valueOf(_plus) + "_funcptr";
                                it.setName(_plus_1);
                            }
                        };
                        PrimitiveType primitiveType = (PrimitiveType)ObjectExtensions.operator_doubleArrow((Object)_createPrimitiveType, (Procedures.Procedure1)_function);
                        if (packageable instanceof Package) {
                            EList _ownedTypes = packageable.getOwnedTypes();
                            _ownedTypes.add((Object)primitiveType);
                        } else {
                            EList _nestedClassifiers = ((Class)packageable).getNestedClassifiers();
                            _nestedClassifiers.add((Object)primitiveType);
                        }
                        StereotypeUtil.apply((Element)primitiveType, Typedef.class);
                        Typedef _stereotypeApplication = (Typedef)UMLUtil.getStereotypeApplication((Element)primitiveType, Typedef.class);
                        _stereotypeApplication.setDefinition(typeName);
                        type = primitiveType;
                        doNotAnalyzeDeclaration = true;
                    }
                }
                if (_equals = Objects.equal(type, null)) {
                    boolean _or = false;
                    boolean _or_1 = false;
                    String _typeName = field.getTypeName();
                    boolean _equals_1 = _typeName.equals("enum");
                    if (_equals_1) {
                        _or_1 = true;
                    } else {
                        boolean _equals_2;
                        String _typeName_1 = field.getTypeName();
                        _or_1 = _equals_2 = _typeName_1.equals("struct");
                    }
                    if (_or_1) {
                        _or = true;
                    } else {
                        boolean _equals_3;
                        String _typeName_2 = field.getTypeName();
                        _or = _equals_3 = _typeName_2.equals("class");
                    }
                    if (_or) {
                        String rawSignature_1 = fieldNode.getRawSignature();
                        String _replaceAll_4 = rawSignature_1.replaceAll("\\n", "");
                        String _replaceAll_5 = _replaceAll_4.replaceAll("\\r", "");
                        String _replaceAll_6 = _replaceAll_5.replaceAll(";", "");
                        String _replaceAll_7 = _replaceAll_6.replaceAll("\\s+", " ");
                        String trimmedRawSignature = _replaceAll_7.trim();
                        Pattern pattern_1 = Pattern.compile("(\\{)(.*)(\\})");
                        Matcher matcher_1 = pattern_1.matcher(trimmedRawSignature);
                        boolean _find_1 = matcher_1.find();
                        if (_find_1) {
                            boolean _greaterThan;
                            String[] tokens = rawSignature_1.split("}");
                            String[] _converted_tokens = tokens;
                            int _size = ((List)Conversions.doWrapArray((Object)_converted_tokens)).size();
                            boolean bl2 = _greaterThan = _size > 0;
                            if (_greaterThan) {
                                String _elementName_1;
                                String[] _converted_tokens_1 = tokens;
                                int _size_1 = ((List)Conversions.doWrapArray((Object)_converted_tokens_1)).size();
                                int _minus = _size_1 - 1;
                                String lastToken = tokens[_minus];
                                boolean _contains = lastToken.contains(_elementName_1 = field.getElementName());
                                if (_contains) {
                                    String _replaceFirst_1;
                                    String _elementName_2 = field.getElementName();
                                    String _quote_1 = Pattern.quote(_elementName_2);
                                    lastToken = _replaceFirst_1 = lastToken.replaceFirst(_quote_1, "typeName");
                                }
                                String typeName_1 = "";
                                String[] _converted_tokens_2 = tokens;
                                int _size_2 = ((List)Conversions.doWrapArray((Object)_converted_tokens_2)).size();
                                int _minus_1 = _size_2 - 1;
                                ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _minus_1, true);
                                for (Integer i : _doubleDotLessThan) {
                                    String _typeName_3 = typeName_1;
                                    String _get = tokens[i];
                                    typeName_1 = String.valueOf(_typeName_3) + _get;
                                }
                                String _typeName_4 = typeName_1;
                                typeName_1 = String.valueOf(_typeName_4) + lastToken;
                                Package packageable_1 = null;
                                Element _owner_2 = prop.getOwner();
                                if (_owner_2 instanceof Class) {
                                    Element _owner_3 = prop.getOwner();
                                    packageable_1 = (Class)_owner_3;
                                } else {
                                    Package _nearestPackage_1;
                                    packageable_1 = _nearestPackage_1 = prop.getNearestPackage();
                                }
                                final String ownerName_1 = packageable_1.getName();
                                PrimitiveType _createPrimitiveType_1 = UMLFactory.eINSTANCE.createPrimitiveType();
                                Procedures.Procedure1<PrimitiveType> _function_1 = new Procedures.Procedure1<PrimitiveType>(){

                                    public void apply(PrimitiveType it) {
                                        try {
                                            String _elementName = field.getElementName();
                                            String _plus = String.valueOf(ownerName_1) + "_" + _elementName;
                                            String _plus_1 = String.valueOf(_plus) + "_anon_";
                                            String _typeName = field.getTypeName();
                                            String _plus_2 = String.valueOf(_plus_1) + _typeName;
                                            it.setName(_plus_2);
                                        }
                                        catch (Throwable _e) {
                                            throw Exceptions.sneakyThrow((Throwable)_e);
                                        }
                                    }
                                };
                                PrimitiveType primitiveType_1 = (PrimitiveType)ObjectExtensions.operator_doubleArrow((Object)_createPrimitiveType_1, (Procedures.Procedure1)_function_1);
                                if (packageable_1 instanceof Package) {
                                    EList _ownedTypes_1 = packageable_1.getOwnedTypes();
                                    _ownedTypes_1.add((Object)primitiveType_1);
                                } else {
                                    EList _nestedClassifiers_1 = ((Class)packageable_1).getNestedClassifiers();
                                    _nestedClassifiers_1.add((Object)primitiveType_1);
                                }
                                StereotypeUtil.apply((Element)primitiveType_1, Typedef.class);
                                Typedef _stereotypeApplication_1 = (Typedef)UMLUtil.getStereotypeApplication((Element)primitiveType_1, Typedef.class);
                                _stereotypeApplication_1.setDefinition(typeName_1);
                                type = primitiveType_1;
                                doNotAnalyzeDeclaration = true;
                            }
                        }
                    }
                }
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    e.printStackTrace();
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            this.excludeIncludFromTranslationUnit(field, prop);
            boolean _equals_4 = Objects.equal(type, null);
            if (_equals_4) {
                Type _uMLType;
                List<String> _contextNamespaces = this.reverse_utils.getContextNamespaces((ICElement)field);
                type = _uMLType = this.getUMLType((IVariableDeclaration)field, _contextNamespaces);
            }
            prop.setType(type);
            String _elementName_3 = field.getElementName();
            prop.setName(_elementName_3);
            if (!doNotAnalyzeDeclaration && (node = (_selector = this.getSelector(_translationUnit = field.getTranslationUnit())).findEnclosingNode(_startPos = (_sourceRange = field.getSourceRange()).getStartPos(), _length = (_sourceRange_1 = field.getSourceRange()).getLength())) instanceof IASTSimpleDeclaration) {
                IASTDeclarator[] _declarators = ((IASTSimpleDeclaration)node).getDeclarators();
                Type _type = prop.getType();
                this.reverse_utils.analyzeDeclaration((List)Conversions.doWrapArray((Object)_declarators), _type, (TypedElement)prop, this.langID);
            }
            boolean _isStatic = field.isStatic();
            prop.setIsStatic(_isStatic);
            ASTAccessVisibility _visibility = field.getVisibility();
            VisibilityKind _convertVisibility = this.convertVisibility(_visibility);
            prop.setVisibility(_convertVisibility);
            boolean _isConst = field.isConst();
            this.reverse_utils.applyStereotype((Element)prop, _isConst, ReverseUtils.StereotypeType.CONST, "");
            boolean _isVolatile = field.isVolatile();
            this.reverse_utils.applyStereotype((Element)prop, _isVolatile, ReverseUtils.StereotypeType.VOLATILE, "");
            boolean _isMutable = field.isMutable();
            this.reverse_utils.applyStereotype((Element)prop, _isMutable, ReverseUtils.StereotypeType.MUTABLE, "");
            EObject _eContainer = prop.eContainer();
            String _name = ((Classifier)_eContainer).getName();
            String _firstLower = StringExtensions.toFirstLower((String)_name);
            Association asso = TypeOperationsEnhanced.createAssociationFromProperty(prop, true, AggregationKind.NONE_LITERAL, false, AggregationKind.NONE_LITERAL, _firstLower, 1, 1);
            String _name_1 = prop.getName();
            String _plus = "A_" + _name_1;
            String _plus_1 = String.valueOf(_plus) + "_";
            EObject _eContainer_1 = prop.eContainer();
            String _name_2 = ((Classifier)_eContainer_1).getName();
            String _firstLower_1 = StringExtensions.toFirstLower((String)_name_2);
            String _plus_2 = String.valueOf(_plus_1) + _firstLower_1;
            asso.setName(_plus_2);
            boolean _isSimpleAssociation = this.isSimpleAssociation(prop);
            if (_isSimpleAssociation) {
                prop.setAggregation(AggregationKind.NONE_LITERAL);
            } else {
                boolean _isAggregation = this.isAggregation(prop);
                if (_isAggregation) {
                    prop.setAggregation(AggregationKind.SHARED_LITERAL);
                } else {
                    boolean _isComposition = this.isComposition(prop);
                    if (_isComposition) {
                        prop.setAggregation(AggregationKind.COMPOSITE_LITERAL);
                    }
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private VisibilityKind convertVisibility(ASTAccessVisibility visibility) {
        boolean _equals = Objects.equal((Object)visibility, (Object)ASTAccessVisibility.PRIVATE);
        if (_equals) {
            return VisibilityKind.PRIVATE_LITERAL;
        }
        boolean _equals_1 = Objects.equal((Object)visibility, (Object)ASTAccessVisibility.PUBLIC);
        if (_equals_1) {
            return VisibilityKind.PUBLIC_LITERAL;
        }
        boolean _equals_2 = Objects.equal((Object)visibility, (Object)ASTAccessVisibility.PROTECTED);
        if (_equals_2) {
            return VisibilityKind.PROTECTED_LITERAL;
        }
        return VisibilityKind.PUBLIC_LITERAL;
    }

    public List<String> getContextNamespaces(ICElement element) {
        return this.reverse_utils.getContextNamespaces(element);
    }

    private Type getUMLType(IVariableDeclaration varDecl, List<String> contextNamespaces) {
        try {
            Type _uMLType;
            Type ret = null;
            String _typeName = varDecl.getTypeName();
            String _cppTypeName = this.getCppTypeName(_typeName);
            ITranslationUnit _translationUnit = varDecl.getTranslationUnit();
            ret = _uMLType = this.getUMLType(_cppTypeName, _translationUnit, contextNamespaces);
            return ret;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private String getCppTypeName(String name) {
        String _trim;
        String _replace_7;
        String _replace_6;
        String _replace_5;
        String _replace_4;
        String _replace_3;
        String _replace_2;
        String _replace_1;
        String _replace;
        String trimName = name.trim();
        trimName = _replace = trimName.replace("*", "");
        trimName = _replace_1 = trimName.replace("&", "");
        trimName = _replace_2 = trimName.replace("[", "");
        trimName = _replace_3 = trimName.replace("]", "");
        trimName = _replace_4 = trimName.replace("const ", "");
        trimName = _replace_5 = trimName.replace(" const", "");
        trimName = _replace_6 = trimName.replace("volatile", "");
        trimName = _replace_7 = trimName.replace(" volatile", "");
        trimName = _trim = trimName.trim();
        return trimName;
    }

    private Type getUMLType(IASTDeclSpecifier declarator, ITranslationUnit itu, List<String> contextNamespaces) {
        Type _uMLType;
        Type ret = null;
        String _cppTypeName = this.reverse_utils.getCppTypeName(declarator);
        ret = _uMLType = this.getUMLType(_cppTypeName, itu, contextNamespaces);
        return ret;
    }

    private List<Map.Entry<ICElement, EObject>> getElementsSameName(final String name) {
        Set<Map.Entry<ICElement, EObject>> _entrySet = this.map.entrySet();
        Functions.Function1<Map.Entry<ICElement, EObject>, Boolean> _function = new Functions.Function1<Map.Entry<ICElement, EObject>, Boolean>(){

            public Boolean apply(Map.Entry<ICElement, EObject> it) {
                ICElement _key = it.getKey();
                String _elementName = _key.getElementName();
                return _elementName.equals(name);
            }
        };
        Iterable _filter = IterableExtensions.filter(_entrySet, (Functions.Function1)_function);
        return IterableExtensions.toList((Iterable)_filter);
    }

    private ICElement lookTypeInContainer(ICContainer container, final String typeName) {
        try {
            ICElement[] _children;
            ICElement ret = null;
            ICElement[] iCElementArray = _children = container.getChildren();
            int n = _children.length;
            int n2 = 0;
            while (n2 < n) {
                boolean _notEquals;
                ICElement child = iCElementArray[n2];
                if (child instanceof ITranslationUnit) {
                    ICElement _head;
                    List<ICElement> nesteds = this.reverse_utils.getAllIStructures((IParent)child, false, true, this.m_project);
                    Functions.Function1<ICElement, Boolean> _function = new Functions.Function1<ICElement, Boolean>(){

                        public Boolean apply(ICElement it) {
                            boolean _or = false;
                            _or = it instanceof IStructure || it instanceof IEnumeration ? true : it instanceof ITypeDef;
                            return _or;
                        }
                    };
                    Iterable _filter = IterableExtensions.filter(nesteds, (Functions.Function1)_function);
                    Functions.Function1<ICElement, Boolean> _function_1 = new Functions.Function1<ICElement, Boolean>(){

                        public Boolean apply(ICElement it) {
                            String _elementName = it.getElementName();
                            return _elementName.equals(typeName);
                        }
                    };
                    Iterable _filter_1 = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function_1);
                    ret = _head = (ICElement)IterableExtensions.head((Iterable)_filter_1);
                } else if (child instanceof ICContainer) {
                    ICElement _lookTypeInContainer;
                    ret = _lookTypeInContainer = this.lookTypeInContainer((ICContainer)child, typeName);
                }
                boolean bl = _notEquals = !Objects.equal(ret, null);
                if (_notEquals) {
                    return ret;
                }
                ++n2;
            }
            return ret;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private Type lookForATypeByName(String typeName) {
        try {
            boolean _notEquals;
            Type ret = null;
            ICElement cType = null;
            for (ICContainer container : this.containers) {
                ICElement _lookTypeInContainer;
                boolean _equals = Objects.equal(cType, null);
                if (!_equals) continue;
                cType = _lookTypeInContainer = this.lookTypeInContainer(container, typeName);
            }
            boolean bl = _notEquals = !Objects.equal(cType, null);
            if (_notEquals) {
                boolean _notEquals_1;
                ITranslationUnit itu = this.reverse_utils.getTranslationUnitFromElement(cType);
                boolean bl2 = _notEquals_1 = !Objects.equal((Object)itu, null);
                if (_notEquals_1) {
                    Type _classifier;
                    Model _correspondingModel = this.getCorrespondingModel(itu);
                    String _elementName = cType.getElementName();
                    ret = _classifier = this.getClassifier(_correspondingModel, cType, _elementName, itu);
                }
            }
            return ret;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Type getUMLType(String typeName, ITranslationUnit itu, List<String> contextNamespaces) {
        try {
            boolean _equals_5;
            boolean _equals_2;
            String _trim;
            NamedElement _ownedMember;
            boolean _notEquals_2;
            boolean _notEquals_1;
            Functions.Function1<ICElement, Boolean> _function_1;
            Iterable _filter_1;
            ICElement sameNameType;
            boolean _equals_1;
            boolean _greaterThan;
            boolean _equals;
            Type ret = null;
            boolean _isPrimitiveCppType = RoundtripCppUtils.isPrimitiveCppType(typeName);
            if (_isPrimitiveCppType) {
                Model _correspondingModel = this.getCorrespondingModel(itu);
                return RoundtripCppUtils.getPrimitiveType(typeName, _correspondingModel);
            }
            String[] token = typeName.split("::");
            int _length = token.length;
            int _minus = _length - 1;
            String _get = token[_minus];
            final String simpleTypeName = _get.trim();
            ArrayList<String> iUsings = new ArrayList<String>();
            iUsings.addAll(contextNamespaces);
            ICElement[] _children = itu.getChildren();
            Iterable _filter = Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_children)), IUsing.class);
            Functions.Function1<IUsing, String> _function = new Functions.Function1<IUsing, String>(){

                public String apply(IUsing it) {
                    return it.getElementName();
                }
            };
            Iterable _map = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function);
            Iterables.addAll(iUsings, (Iterable)_map);
            List<Map.Entry<ICElement, EObject>> sameNames = this.getElementsSameName(simpleTypeName);
            boolean _and = false;
            int _size = sameNames.size();
            boolean bl = _equals = _size == 1;
            if (!_equals) {
                _and = false;
            } else {
                Map.Entry _head = (Map.Entry)IterableExtensions.head(sameNames);
                EObject _value = (EObject)_head.getValue();
                _and = _value instanceof Type;
            }
            if (_and) {
                Map.Entry _head_1 = (Map.Entry)IterableExtensions.head(sameNames);
                EObject _value_1 = (EObject)_head_1.getValue();
                return (Type)_value_1;
            }
            List<ICElement> nestedStructures = this.reverse_utils.getAllIStructures((IParent)itu, false, true, this.m_project);
            int _size_1 = sameNames.size();
            boolean bl2 = _greaterThan = _size_1 > 1;
            if (_greaterThan) {
                for (final Map.Entry<ICElement, EObject> sameName : sameNames) {
                    boolean _greaterThan_1;
                    Functions.Function1<ICElement, Boolean> _function_12 = new Functions.Function1<ICElement, Boolean>(){

                        public Boolean apply(ICElement it) {
                            String _elementName = it.getElementName();
                            ICElement _key = (ICElement)sameName.getKey();
                            String _elementName_1 = _key.getElementName();
                            return _elementName.equals(_elementName_1);
                        }
                    };
                    Iterable withinITU = IterableExtensions.filter(nestedStructures, (Functions.Function1)_function_12);
                    int _size_2 = IterableExtensions.size((Iterable)withinITU);
                    boolean bl3 = _greaterThan_1 = _size_2 > 0;
                    if (_greaterThan_1) {
                        EObject _value_2 = sameName.getValue();
                        return (Type)_value_2;
                    }
                    ICElement _key = sameName.getKey();
                    boolean _isSatisfyNamespace = this.reverse_utils.isSatisfyNamespace(iUsings, _key);
                    if (!_isSatisfyNamespace) continue;
                    EObject _value_3 = sameName.getValue();
                    return (Type)_value_3;
                }
            }
            if (_equals_1 = Objects.equal((Object)(sameNameType = (ICElement)IterableExtensions.head((Iterable)(_filter_1 = IterableExtensions.filter(nestedStructures, (Functions.Function1)(_function_1 = new Functions.Function1<ICElement, Boolean>(){

                public Boolean apply(ICElement it) {
                    String _elementName = it.getElementName();
                    String _trim = _elementName.trim();
                    String _trim_1 = simpleTypeName.trim();
                    return _trim.equals(_trim_1);
                }
            }))))), null)) {
                boolean _notEquals;
                Functions.Function1<IStructureTemplate, Boolean> _function_2;
                Iterable structureTemplates = Iterables.filter(nestedStructures, IStructureTemplate.class);
                Iterable _filter_2 = IterableExtensions.filter((Iterable)structureTemplates, (Functions.Function1)(_function_2 = new Functions.Function1<IStructureTemplate, Boolean>(){

                    public Boolean apply(IStructureTemplate it) {
                        String[] _templateParameterTypes = it.getTemplateParameterTypes();
                        Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

                            public Boolean apply(String it) {
                                return it.equals(simpleTypeName);
                            }
                        };
                        Iterable _filter = IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_templateParameterTypes)), (Functions.Function1)_function);
                        int _size = IterableExtensions.size((Iterable)_filter);
                        return _size > 0;
                    }
                }));
                final IStructureTemplate match = (IStructureTemplate)IterableExtensions.head((Iterable)_filter_2);
                boolean bl4 = _notEquals = !Objects.equal((Object)match, null);
                if (_notEquals) {
                    Model _correspondingModel_1 = this.getCorrespondingModel(itu);
                    ICElement _parent = match.getParent();
                    List<Type> _orCreateClassifier = this.getOrCreateClassifier(_correspondingModel_1, (IParent)_parent);
                    Functions.Function1<Type, Boolean> _function_3 = new Functions.Function1<Type, Boolean>(){

                        public Boolean apply(Type it) {
                            String _name = it.getName();
                            String _elementName = match.getElementName();
                            return _name.equals(_elementName);
                        }
                    };
                    Iterable _filter_3 = IterableExtensions.filter(_orCreateClassifier, (Functions.Function1)_function_3);
                    Type templatClassifier = (Type)IterableExtensions.head((Iterable)_filter_3);
                    Classifier _createOrgetTemplateParameter = this.createOrgetTemplateParameter((NamedElement)((Classifier)templatClassifier), simpleTypeName, "class");
                    ret = _createOrgetTemplateParameter;
                }
            } else {
                boolean _and_1 = false;
                if (!(sameNameType instanceof IStructureDeclaration)) {
                    _and_1 = false;
                } else {
                    boolean bl5 = _and_1 = !(sameNameType instanceof IStructure);
                }
                if (_and_1) {
                    Type _lookForATypeByName;
                    String _elementName = sameNameType.getElementName();
                    ret = _lookForATypeByName = this.lookForATypeByName(_elementName);
                } else {
                    Type _classifier;
                    Model _correspondingModel_2 = this.getCorrespondingModel(itu);
                    String _elementName_1 = sameNameType.getElementName();
                    ret = _classifier = this.getClassifier(_correspondingModel_2, sameNameType, _elementName_1, itu);
                }
            }
            Model _correspondingModel_3 = this.getCorrespondingModel(itu);
            Package externalPackage = RoundtripCppUtils.getOrcreateExternalPackage((Package)_correspondingModel_3, false);
            boolean _and_2 = false;
            boolean _and_3 = false;
            boolean bl6 = _notEquals_1 = !Objects.equal((Object)externalPackage, null);
            _and_3 = !_notEquals_1 ? false : (_notEquals_2 = !Objects.equal((Object)(_ownedMember = externalPackage.getOwnedMember(_trim = simpleTypeName.trim())), null));
            if (!_and_3) {
                _and_2 = false;
            } else {
                String _trim_1 = simpleTypeName.trim();
                NamedElement _ownedMember_1 = externalPackage.getOwnedMember(_trim_1);
                _and_2 = _ownedMember_1 instanceof Type;
            }
            if (_and_2) {
                String _trim_2 = simpleTypeName.trim();
                NamedElement _ownedMember_2 = externalPackage.getOwnedMember(_trim_2);
                ret = (Type)_ownedMember_2;
            }
            if (_equals_2 = Objects.equal((Object)ret, null)) {
                boolean _greaterThan_1;
                String[] _converted_token = token;
                int _size_2 = ((List)Conversions.doWrapArray((Object)_converted_token)).size();
                boolean bl7 = _greaterThan_1 = _size_2 > 1;
                if (_greaterThan_1) {
                    int i = 0;
                    while (i < ((List)Conversions.doWrapArray((Object)token)).size() - 1) {
                        String _get_1 = token[i];
                        String _trim_3 = _get_1.trim();
                        iUsings.add(_trim_3);
                        if (i > 0) {
                            String[] _converted_token_1 = token;
                            String _head_2 = (String)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)_converted_token_1)));
                            Object n = _head_2.trim();
                            int j = 1;
                            while (j <= i) {
                                Object _plus;
                                String _get_2 = token[j];
                                String _trim_4 = _get_2.trim();
                                n = _plus = String.valueOf(n) + "::" + _trim_4;
                                ++j;
                            }
                            iUsings.add((String)n);
                        }
                        ++i;
                    }
                }
                UniqueEList includes = new UniqueEList();
                final UniqueEList istructures = new UniqueEList();
                ICElement _parent_1 = itu.getParent();
                if (_parent_1 instanceof ICContainer) {
                    ICElement _parent_2 = itu.getParent();
                    ICContainer container = (ICContainer)_parent_2;
                    ICElement[] _children_1 = container.getChildren();
                    Iterable _filter_4 = Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_children_1)), ITranslationUnit.class);
                    Consumer<ITranslationUnit> _function_4 = new Consumer<ITranslationUnit>((List)includes){
                        private final /* synthetic */ List val$includes;
                        {
                            this.val$includes = list;
                        }

                        @Override
                        public void accept(ITranslationUnit it) {
                            try {
                                List<ICElement> _allIStructures = ReverseCpp2Uml.this.reverse_utils.getAllIStructures((IParent)it, false, true, ReverseCpp2Uml.this.m_project);
                                Functions.Function1<ICElement, Boolean> _function = new Functions.Function1<ICElement, Boolean>(){

                                    public Boolean apply(ICElement it) {
                                        String _elementName = it.getElementName();
                                        String _trim = _elementName.trim();
                                        String _trim_1 = simpleTypeName.trim();
                                        return _trim.equals(_trim_1);
                                    }
                                };
                                Iterable _filter = IterableExtensions.filter(_allIStructures, (Functions.Function1)_function);
                                Iterables.addAll((Collection)istructures, (Iterable)_filter);
                                ICElement[] _children = it.getChildren();
                                Iterable includesOfItu = Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_children)), IInclude.class);
                                Consumer<IInclude> _function_1 = new Consumer<IInclude>(){

                                    @Override
                                    public void accept(IInclude it) {
                                        final String nameOfIncludeItu = it.getElementName();
                                        Functions.Function1<IInclude, Boolean> _function = new Functions.Function1<IInclude, Boolean>(){

                                            public Boolean apply(IInclude it) {
                                                String _elementName = it.getElementName();
                                                return Objects.equal((Object)_elementName, (Object)nameOfIncludeItu);
                                            }
                                        };
                                        Iterable _filter = IterableExtensions.filter((Iterable)val$includes, (Functions.Function1)_function);
                                        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)_filter);
                                        if (_isEmpty) {
                                            val$includes.add(it);
                                        }
                                    }
                                };
                                includesOfItu.forEach(_function_1);
                            }
                            catch (Throwable _e) {
                                throw Exceptions.sneakyThrow((Throwable)_e);
                            }
                        }
                    };
                    _filter_4.forEach(_function_4);
                    for (ICElement structure : istructures) {
                        boolean _equals_4;
                        Functions.Function1<Type, Boolean> _function_5;
                        ITranslationUnit _translationUnitFromElement_1;
                        boolean _isSatisfyNamespace;
                        boolean _equals_3 = Objects.equal((Object)ret, null);
                        if (!_equals_3 || !(_isSatisfyNamespace = this.reverse_utils.isSatisfyNamespace(iUsings, structure))) continue;
                        ITranslationUnit _translationUnitFromElement = this.reverse_utils.getTranslationUnitFromElement(structure);
                        Model _correspondingModel_4 = this.getCorrespondingModel(_translationUnitFromElement);
                        List<Type> tmp = this.getOrCreateClassifier(_correspondingModel_4, (IParent)(_translationUnitFromElement_1 = this.reverse_utils.getTranslationUnitFromElement(structure)));
                        Iterable sames = IterableExtensions.filter(tmp, (Functions.Function1)(_function_5 = new Functions.Function1<Type, Boolean>(){

                            public Boolean apply(Type it) {
                                boolean _notEquals;
                                boolean _and = false;
                                boolean bl = _notEquals = !Objects.equal((Object)it, null);
                                if (!_notEquals) {
                                    _and = false;
                                } else {
                                    boolean _equals;
                                    String _name = it.getName();
                                    String _trim = _name.trim();
                                    _and = _equals = _trim.equals(simpleTypeName);
                                }
                                return _and;
                            }
                        }));
                        int _size_3 = IterableExtensions.size((Iterable)sames);
                        boolean bl8 = _equals_4 = _size_3 == 1;
                        if (_equals_4) {
                            Type _head_2;
                            ret = _head_2 = (Type)IterableExtensions.head((Iterable)sames);
                            continue;
                        }
                        boolean bl9 = this.reverse_utils.isSatisfyNamespace(iUsings, structure);
                    }
                }
                ICElement[] _children_2 = itu.getChildren();
                Iterable _filter_5 = Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_children_2)), IInclude.class);
                Iterables.addAll((Collection)includes, (Iterable)_filter_5);
                UniqueEList includes_level2 = new UniqueEList();
                while (Objects.equal((Object)ret, null) && !includes.isEmpty()) {
                    for (IInclude include : includes) {
                        boolean _notEquals_3;
                        boolean _equals_52 = Objects.equal((Object)ret, null);
                        if (_equals_52) {
                            Type _lookupTypeInInclude;
                            String _elementName_2;
                            String _fullFileName = include.getFullFileName();
                            boolean _contains = _fullFileName.contains(_elementName_2 = this.m_project.getElementName());
                            if (!_contains) continue;
                            ret = _lookupTypeInInclude = this.lookupTypeInInclude(simpleTypeName, include, iUsings);
                            continue;
                        }
                        ITranslationUnit translationUnit = this.reverse_utils.getTranslationUnitFromInclude(include, this.m_project);
                        boolean bl10 = _notEquals_3 = !Objects.equal((Object)translationUnit, null);
                        if (!_notEquals_3) continue;
                        ICElement[] _children_3 = translationUnit.getChildren();
                        Iterable _filter_6 = Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_children_3)), IInclude.class);
                        Iterables.addAll((Collection)includes_level2, (Iterable)_filter_6);
                    }
                    boolean _equals_6 = Objects.equal((Object)ret, null);
                    if (!_equals_6) continue;
                    includes.clear();
                    includes.addAll(includes_level2);
                    includes_level2.clear();
                }
            }
            if (_equals_5 = Objects.equal((Object)ret, null)) {
                Type _ownedType;
                Package _orcreateExternalPackage;
                LOGGER.log(Level.WARNING, String.valueOf(typeName) + " is not found, it will be created dynamically");
                Model _correspondingModel_5 = this.getCorrespondingModel(itu);
                externalPackage = _orcreateExternalPackage = RoundtripCppUtils.getOrcreateExternalPackage((Package)_correspondingModel_5, true);
                String _trim_3 = typeName.trim();
                ret = _ownedType = externalPackage.getOwnedType(_trim_3);
                boolean _equals_6 = Objects.equal((Object)ret, null);
                if (_equals_6) {
                    Type _createOwnedType;
                    String _trim_4 = typeName.trim();
                    ret = _createOwnedType = externalPackage.createOwnedType(_trim_4, UMLPackage.Literals.DATA_TYPE);
                    StereotypeUtil.apply((Element)ret, External.class);
                }
            }
            return ret;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void excludeIncludFromTranslationUnit(IField field, Property property) {
        try {
            boolean _notEquals;
            boolean bl = _notEquals = !Objects.equal((Object)field, null);
            if (_notEquals) {
                String type = field.getTypeName();
                List<String> context = this.reverse_utils.getContextNamespaces((ICElement)field);
                ITranslationUnit translationUnit = field.getTranslationUnit();
                Classifier structure = null;
                Element owner = property.getOwner();
                while (!Objects.equal((Object)owner, null) && !(owner instanceof Classifier)) {
                    Element _owner;
                    owner = _owner = owner.getOwner();
                }
                if (owner instanceof Classifier) {
                    structure = (Classifier)owner;
                }
                this.excludeIncludFromTranslationUnit(type, (Element)structure, translationUnit, context);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void excludeIncludFromTranslationUnit(IASTParameterDeclaration param, IMethodDeclaration method, Operation operation) {
        boolean _notEquals_1;
        boolean _notEquals;
        boolean _and = false;
        boolean bl = _notEquals = !Objects.equal((Object)param, null);
        _and = !_notEquals ? false : (_notEquals_1 = !Objects.equal((Object)method, null));
        if (_and) {
            ITranslationUnit translationUnit = method.getTranslationUnit();
            IASTDeclSpecifier _declSpecifier = param.getDeclSpecifier();
            String type = this.reverse_utils.getCppTypeName(_declSpecifier);
            List<String> context = this.reverse_utils.getContextNamespaces((ICElement)method);
            Classifier structure = null;
            Element owner = operation.getOwner();
            while (!Objects.equal((Object)owner, null) && !(owner instanceof Classifier)) {
                Element _owner;
                owner = _owner = owner.getOwner();
            }
            if (owner instanceof Classifier) {
                structure = (Classifier)owner;
            }
            this.excludeIncludFromTranslationUnit(type, (Element)structure, translationUnit, context);
        }
    }

    private void excludeIncludFromTranslationUnit(String excludedType, Element fromStructure, ITranslationUnit translationUnit, List<String> context) {
        boolean _notEquals_3;
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        boolean _and = false;
        boolean _and_1 = false;
        boolean _and_2 = false;
        boolean bl = _notEquals = !Objects.equal((Object)excludedType, null);
        _and_2 = !_notEquals ? false : (_notEquals_1 = !Objects.equal((Object)fromStructure, null));
        _and_1 = !_and_2 ? false : (_notEquals_2 = !Objects.equal((Object)translationUnit, null));
        _and = !_and_1 ? false : (_notEquals_3 = !Objects.equal(context, null));
        if (_and) {
            boolean _isEmpty;
            boolean _not;
            boolean _notEquals_4;
            List<IInclude> includes = this.getIncludesFromType(excludedType, translationUnit, context);
            boolean _and_3 = false;
            boolean bl2 = _notEquals_4 = !Objects.equal(includes, null);
            _and_3 = !_notEquals_4 ? false : (_not = !(_isEmpty = includes.isEmpty()));
            if (_and_3) {
                String key = this.getExcludedIncludesMapKey(translationUnit, fromStructure);
                UniqueEList includesInTranslationUnit = this.excludedIncludesMap.get(key);
                boolean _equals = Objects.equal(includesInTranslationUnit, null);
                if (_equals) {
                    UniqueEList _uniqueEList;
                    includesInTranslationUnit = _uniqueEList = new UniqueEList();
                    this.excludedIncludesMap.put(key, (List<IInclude>)includesInTranslationUnit);
                }
                includesInTranslationUnit.addAll(includes);
            }
        }
    }

    private String getExcludedIncludesMapKey(ITranslationUnit translationUnit, Element umlElement) {
        int _hashCode = translationUnit.hashCode();
        String _plus = "" + Integer.valueOf(_hashCode);
        int _hashCode_1 = umlElement.hashCode();
        return String.valueOf(_plus) + Integer.valueOf(_hashCode_1);
    }

    private List<IInclude> getIncludesFromType(String typeName, ITranslationUnit itu, List<String> iUsings) {
        try {
            boolean _equals_2;
            boolean _equals_1;
            UniqueEList includes = new UniqueEList();
            boolean _or = false;
            boolean _or_1 = false;
            boolean _equals = Objects.equal((Object)typeName, null);
            _or_1 = _equals ? true : (_equals_1 = Objects.equal((Object)itu, null));
            _or = _or_1 ? true : (_equals_2 = Objects.equal(iUsings, null));
            if (_or) {
                return includes;
            }
            boolean _contains = ((List)Conversions.doWrapArray((Object)BatchReverseFunctionBody.ansiTypes)).contains(typeName);
            if (_contains) {
                return includes;
            }
            String[] token = typeName.split("::");
            int _length = token.length;
            int _minus = _length - 1;
            String _get = token[_minus];
            String simpleTypeName = _get.trim();
            ICElement[] _children = itu.getChildren();
            Iterable _filter = Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_children)), IInclude.class);
            for (IInclude include : _filter) {
                String _elementName;
                String _fullFileName = include.getFullFileName();
                boolean _contains_1 = _fullFileName.contains(_elementName = this.m_project.getElementName());
                if (!_contains_1) continue;
                includes.add(include);
            }
            return includes;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Type lookupTypeInInclude(final String simpleTypeName, IInclude include, List<String> iUsings) {
        ITranslationUnit unit;
        UniqueEList istructures;
        Type ret;
        block7: {
            block6: {
                String _fullFileName = include.getFullFileName();
                String _elementName = this.m_project.getElementName();
                boolean _contains = _fullFileName.contains(_elementName);
                if (!_contains) return null;
                boolean bl = false;
                boolean _not = bl;
                if (!_not) break block6;
                return null;
            }
            ret = null;
            istructures = new UniqueEList();
            boolean _equals = Objects.equal(ret, null);
            if (!_equals) return ret;
            istructures.clear();
            unit = this.reverse_utils.getTranslationUnitFromInclude(include, this.m_project);
            boolean _equals_1 = Objects.equal((Object)unit, null);
            if (!_equals_1) break block7;
            return null;
        }
        try {
            List<ICElement> _allIStructures = this.reverse_utils.getAllIStructures((IParent)unit, false, true, this.m_project);
            Functions.Function1<ICElement, Boolean> _function = new Functions.Function1<ICElement, Boolean>(){

                public Boolean apply(ICElement it) {
                    String _elementName = it.getElementName();
                    String _trim = _elementName.trim();
                    String _trim_1 = simpleTypeName.trim();
                    return _trim.equals(_trim_1);
                }
            };
            Iterable _filter = IterableExtensions.filter(_allIStructures, (Functions.Function1)_function);
            Iterables.addAll((Collection)istructures, (Iterable)_filter);
            for (ICElement structure : istructures) {
                boolean _equals_3;
                Functions.Function1<Type, Boolean> _function_1;
                ITranslationUnit _translationUnitFromElement_1;
                boolean _equals_2 = Objects.equal(ret, null);
                if (!_equals_2) continue;
                ITranslationUnit _translationUnitFromElement = this.reverse_utils.getTranslationUnitFromElement(structure);
                Model _correspondingModel = this.getCorrespondingModel(_translationUnitFromElement);
                List<Type> tmp = this.getOrCreateClassifier(_correspondingModel, (IParent)(_translationUnitFromElement_1 = this.reverse_utils.getTranslationUnitFromElement(structure)));
                Iterable sameNames = IterableExtensions.filter(tmp, (Functions.Function1)(_function_1 = new Functions.Function1<Type, Boolean>(){

                    public Boolean apply(Type it) {
                        boolean _notEquals;
                        boolean _and = false;
                        boolean bl = _notEquals = !Objects.equal((Object)it, null);
                        if (!_notEquals) {
                            _and = false;
                        } else {
                            boolean _equals;
                            String _name = it.getName();
                            String _trim = _name.trim();
                            _and = _equals = _trim.equals(simpleTypeName);
                        }
                        return _and;
                    }
                }));
                int _size = IterableExtensions.size((Iterable)sameNames);
                boolean bl = _equals_3 = _size == 1;
                if (_equals_3) {
                    Type _head;
                    ret = _head = (Type)IterableExtensions.head((Iterable)sameNames);
                    continue;
                }
                boolean bl2 = this.reverse_utils.isSatisfyNamespace(iUsings, structure);
            }
            return ret;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private UniqueEList<Classifier> getTypeByQualifiedName(ICElement element, ITranslationUnit translationUnit, List<String> contextNames) {
        String _elementName;
        boolean _contains;
        UniqueEList results = new UniqueEList();
        boolean _or = false;
        _or = element instanceof IVariableDeclaration ? true : element instanceof IMethod;
        if (_or && (_contains = (_elementName = element.getElementName()).contains("::"))) {
            Type typeRet;
            boolean _greaterThan;
            String _elementName_1 = element.getElementName();
            String[] classifierNameTokens = _elementName_1.split("::");
            String classifierName = "";
            int _length = classifierNameTokens.length;
            boolean bl = _greaterThan = _length > 1;
            if (_greaterThan) {
                String _get;
                int _length_1 = classifierNameTokens.length;
                int _minus = _length_1 - 2;
                classifierName = _get = classifierNameTokens[_minus];
            } else {
                String _get_1;
                classifierName = _get_1 = classifierNameTokens[0];
            }
            boolean isFound = false;
            int i = 0;
            while (i < results.size() && !isFound) {
                String _name;
                boolean _equals;
                boolean _notEquals;
                Classifier classifier = (Classifier)results.get(i);
                boolean bl2 = _notEquals = !Objects.equal((Object)classifier, null);
                if (_notEquals && (_equals = (_name = classifier.getName()).equals(classifierName))) {
                    isFound = true;
                }
                ++i;
            }
            if (!isFound && (typeRet = this.getUMLType(classifierName, translationUnit, contextNames)) instanceof Classifier) {
                results.add((Object)((Classifier)typeRet));
            }
        }
        return results;
    }

    public static enum ConflictResolutionMode {
        FROM_MODEL,
        FROM_CODE,
        UI_INTERACTION;

    }

    public static enum ReverseMode {
        BATCH,
        INCREMENTAL;

    }
}

