/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.common.extensionpoints;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.GeneratorSelectionDialog;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.ILangCodegen;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.ILangCodegen2;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.Messages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;

public class LanguageCodegen {
    private static final String CLASS = "class";
    private static final String LANGUAGE = "language";
    private static final String ID = "id";
    public static final String ILANG_SUPPORT_ID = "org.eclipse.papyrus.designer.languages.common.extensionpoints.languageCodegen";
    static Map<ILangCodegen, String> generatorIDs = new HashMap<ILangCodegen, String>();

    public static ILangCodegen chooseGenerator(Pattern languagePattern, Classifier classifier) {
        List<ILangCodegen> eligibleGenerators = LanguageCodegen.getEligibleGeneratorList(languagePattern, classifier);
        if (eligibleGenerators.size() == 1) {
            return eligibleGenerators.get(0);
        }
        Shell shell = Display.getDefault().getActiveShell();
        if (eligibleGenerators.size() > 1) {
            GeneratorSelectionDialog dialog = new GeneratorSelectionDialog(shell, eligibleGenerators);
            if (dialog.open() == 0) {
                return (ILangCodegen)dialog.getResult()[0];
            }
        } else {
            String pattern = languagePattern.pattern().replace("\\", "");
            MessageDialog.openError((Shell)shell, (String)Messages.LanguageCodegen_NoGeneratorsFound, (String)String.format(Messages.LanguageCodegen_NoGeneratorsFoundLong, pattern));
        }
        return null;
    }

    public static ILangCodegen getGenerator(String language) {
        return LanguageCodegen.getGenerator(Pattern.compile(language.replace("+", "\\+")), null);
    }

    public static ILangCodegen getGenerator(String language, String id) {
        return LanguageCodegen.getGenerator(Pattern.compile(language), id);
    }

    public static ILangCodegen getGenerator(Pattern languagePattern, String id) {
        List<ILangCodegen> generators = LanguageCodegen.getCodegenList(languagePattern);
        for (ILangCodegen generator : generators) {
            if (id != null && !generatorIDs.get(generator).equals(id)) continue;
            return generator;
        }
        throw new RuntimeException(String.format(Messages.LanguageSupport_LanguageNotSupported, languagePattern));
    }

    public static List<ILangCodegen> getEligibleGeneratorList(Pattern languagePattern, Classifier classifier) {
        ArrayList<ILangCodegen> eligibleGenerators = new ArrayList<ILangCodegen>();
        for (ILangCodegen generator : LanguageCodegen.getCodegenList(languagePattern)) {
            if (generator instanceof ILangCodegen2) {
                if (!((ILangCodegen2)generator).isEligible((Element)classifier)) continue;
                eligibleGenerators.add(generator);
                continue;
            }
            eligibleGenerators.add(generator);
        }
        return eligibleGenerators;
    }

    public static List<ILangCodegen> getCodegenList(Pattern languagePattern) {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] configElements = reg.getConfigurationElementsFor(ILANG_SUPPORT_ID);
        ArrayList<ILangCodegen> generators = new ArrayList<ILangCodegen>();
        IConfigurationElement[] iConfigurationElementArray = configElements;
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            try {
                Object obj;
                String id = configElement.getAttribute(ID);
                String extLanguage = configElement.getAttribute(LANGUAGE);
                Matcher m = languagePattern.matcher(extLanguage);
                if (m.matches() && (obj = configElement.createExecutableExtension(CLASS)) instanceof ILangCodegen) {
                    ILangCodegen generator = (ILangCodegen)obj;
                    if (!generatorIDs.containsKey(generator)) {
                        generatorIDs.put(generator, id);
                    }
                    generators.add((ILangCodegen)obj);
                }
            }
            catch (CoreException exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
        return generators;
    }

    @Deprecated
    public static ILangCodegen getCodegen(String language) {
        IConfigurationElement[] configElements;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = configElements = reg.getConfigurationElementsFor(ILANG_SUPPORT_ID);
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            try {
                Object obj;
                String extLanguage = configElement.getAttribute(LANGUAGE);
                if (extLanguage.equals(language) && (obj = configElement.createExecutableExtension(CLASS)) instanceof ILangCodegen) {
                    return (ILangCodegen)obj;
                }
            }
            catch (CoreException exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
        throw new RuntimeException(String.format(Messages.LanguageSupport_LanguageNotSupported, language));
    }

    public static String getID(ILangCodegen generator) {
        return generatorIDs.get(generator);
    }
}

