/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.components.transformation.ui.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.papyrus.designer.components.FCM.Connector;
import org.eclipse.papyrus.designer.components.FCM.InteractionComponent;
import org.eclipse.papyrus.designer.components.transformation.ui.dialogs.ConnectorSelectionDialog;
import org.eclipse.papyrus.designer.transformation.base.utils.CommandSupport;
import org.eclipse.papyrus.uml.diagram.common.handlers.CmdHandler;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.util.UMLUtil;

public class SelectConnectorHandler
extends CmdHandler {
    public boolean isEnabled() {
        this.updateSelectedEObject();
        return this.selectedEObject instanceof org.eclipse.uml2.uml.Connector || this.selectedEObject instanceof Property;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object[] result;
        if (!(this.selectedEObject instanceof Feature)) {
            return null;
        }
        final Feature selectedFeature = (Feature)this.selectedEObject;
        Shell shell = Display.getCurrent().getActiveShell();
        Model model = selectedFeature.getModel();
        ConnectorSelectionDialog elementSelector = new ConnectorSelectionDialog(shell, (Package)model, selectedFeature);
        elementSelector.setTitle("Select connector");
        elementSelector.setMessage("Select an implementation for connector " + selectedFeature.getName());
        elementSelector.open();
        if (elementSelector.getReturnCode() == 0 && (result = elementSelector.getResult()).length == 1 && result[0] instanceof Class) {
            CommandSupport.exec((String)"Select connector", (ExecutionEvent)event, (Runnable)new Runnable(){

                @Override
                public void run() {
                    Connector fcmSelectedConnector = (Connector)StereotypeUtil.applyApp((Element)selectedFeature, Connector.class);
                    InteractionComponent newConnType = (InteractionComponent)UMLUtil.getStereotypeApplication((Element)((Class)result[0]), InteractionComponent.class);
                    fcmSelectedConnector.setIc(newConnType);
                }
            });
        }
        return null;
    }
}

