/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.ucm.core.types.advice;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.commands.Activator;
import org.eclipse.papyrus.designer.ucm.core.utils.CreateUtils;
import org.eclipse.papyrus.designer.ucm.profile.UCMProfile.ucm_components.ComponentModule;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;

public class ComponentTypeEditHelperAdvice
extends AbstractEditHelperAdvice {
    public boolean approveRequest(IEditCommandRequest request) {
        GetEditContextRequest context;
        if (request instanceof GetEditContextRequest && (context = (GetEditContextRequest)request).getEditCommandRequest() instanceof CreateElementRequest) {
            return this.approveCreateElementRequest((CreateElementRequest)context.getEditCommandRequest());
        }
        return super.approveRequest(request);
    }

    public void configureRequest(IEditCommandRequest request) {
        super.configureRequest(request);
    }

    protected boolean approveCreateElementRequest(CreateElementRequest request) {
        IElementType type = request.getElementType();
        EObject container = request.getContainer();
        return type != null && container instanceof Package && CreateUtils.nearestPackageWithStereo((Element)container, ComponentModule.class) != null;
    }

    protected boolean approveCreateRelationshipRequest(IEditCommandRequest request) {
        return super.approveRequest(request);
    }

    protected ICommand getBeforeConfigureCommand(ConfigureRequest request) {
        final Class capsule = (Class)request.getElementToConfigure();
        return new ConfigureElementCommand(request){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                capsule.setIsActive(true);
                this.createCompositeDiagram();
                return CommandResult.newOKCommandResult((Object)capsule);
            }

            protected Diagram createCompositeDiagram() {
                ServicesRegistry registry;
                try {
                    registry = ServiceUtilsForEObject.getInstance().getServiceRegistry((EObject)capsule);
                }
                catch (ServiceException ex) {
                    Activator.log.error((Throwable)ex);
                    return null;
                }
                try {
                    ModelSet modelSet = (ModelSet)registry.getService(ModelSet.class);
                }
                catch (ServiceException ex) {
                    Activator.log.error((Throwable)ex);
                    return null;
                }
                return null;
            }
        };
    }
}

