/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.tracing.barectf.library.flatten;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Ptr;
import org.eclipse.papyrus.designer.transformation.tracing.barectf.library.flatten.NameType;
import org.eclipse.papyrus.designer.transformation.tracing.library.utils.TraceUtils;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;

public class Flattener {
    public static <T extends TypedElement> List<NameType> flattenDecl(List<T> teList) {
        ArrayList<NameType> ntList = new ArrayList<NameType>();
        for (TypedElement te : teList) {
            if (!(te instanceof MultiplicityElement) || ((MultiplicityElement)te).getUpper() != 1) continue;
            ntList.addAll(Flattener.flattenDecl(te));
        }
        return ntList;
    }

    public static <T extends TypedElement> List<NameType> flattenParams(List<T> teList) {
        ArrayList<NameType> ntList = new ArrayList<NameType>();
        for (TypedElement te : teList) {
            if (!(te instanceof MultiplicityElement) || ((MultiplicityElement)te).getUpper() != 1) continue;
            ntList.addAll(Flattener.flattenParams(te));
        }
        return ntList;
    }

    public static List<NameType> flattenDecl(TypedElement te) {
        return Flattener.flatten(TMode.DECLARATION, "", te);
    }

    public static List<NameType> flattenParams(TypedElement te) {
        return Flattener.flatten(TMode.PARAMS, "", te);
    }

    public static List<NameType> flatten(TMode mode, String prefix, TypedElement te) {
        ArrayList<NameType> ntList = new ArrayList<NameType>();
        if (!StereotypeUtil.isApplied((Element)te, Ptr.class)) {
            String sepChar = mode == TMode.DECLARATION ? "_" : ".";
            Type type = te.getType();
            if (type instanceof PrimitiveType || type instanceof Enumeration) {
                String postfix = "";
                if (mode == TMode.PARAMS && TraceUtils.isSTLstring((Type)type)) {
                    postfix = ".c_str()";
                }
                String deref = "";
                if (mode == TMode.PARAMS && te instanceof Parameter && ((Parameter)te).getDirection() == ParameterDirectionKind.INOUT_LITERAL) {
                    deref = "*";
                }
                NameType nt = new NameType(String.valueOf(prefix) + deref + te.getName() + postfix, type);
                ntList.add(nt);
            } else if (type instanceof DataType) {
                for (Property attribute : ((DataType)type).getOwnedAttributes()) {
                    if (attribute.getUpper() != 1) continue;
                    List<NameType> subNtList = Flattener.flatten(mode, String.valueOf(prefix) + te.getName() + sepChar, (TypedElement)attribute);
                    ntList.addAll(subNtList);
                }
            }
        }
        return ntList;
    }

    public static enum TMode {
        DECLARATION,
        PARAMS;

    }
}

