/**
 * Copyright (c) 2015 CEA LIST.
 * 
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *  Ansgar Radermacher  ansgar.radermacher@cea.fr
 */
package org.eclipse.papyrus.designer.components.transformation.java.xtend;

import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.components.modellibs.core.transformations.AbstractCompToOO;
import org.eclipse.papyrus.designer.components.transformation.extensions.IOOTrafo;
import org.eclipse.papyrus.designer.transformation.base.utils.PartsUtil;
import org.eclipse.papyrus.designer.transformation.core.transformations.LazyCopier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.xtend2.lib.StringConcatenation;

/**
 * This class realizes the transformation from component-based to object-oriented
 * models for Java. It refines the abstract component to OO transformation
 */
@SuppressWarnings("all")
public class JavaToOO extends AbstractCompToOO implements IOOTrafo {
  @Override
  public void init(final LazyCopier copier, final org.eclipse.uml2.uml.Class bootloader) {
    super.init(copier, bootloader);
    this.progLang = "JAVA";
  }
  
  /**
   * always dot
   */
  @Override
  public String nameRef(final Property attribute) {
    StringConcatenation _builder = new StringConcatenation();
    String _name = attribute.getName();
    _builder.append(_name);
    _builder.append(".");
    _builder.newLineIfNotEmpty();
    return _builder.toString();
  }
  
  @Override
  public void applyRef(final Element element) {
  }
  
  @Override
  public String getRef(final Property attribute) {
    StringConcatenation _builder = new StringConcatenation();
    String _name = attribute.getName();
    _builder.append(_name);
    _builder.newLineIfNotEmpty();
    return _builder.toString();
  }
  
  /**
   * If the bootloader is responsible for creating an instance (if it is a
   * abstract type), do nothing since the part is already a reference in Java.
   * If the composite is responsible, add a default value that creates the sub-instances.
   * 
   * @param compositeImplementation
   *            a (composite) component
   */
  @Override
  public void transformParts(final org.eclipse.uml2.uml.Class compositeImplementation) {
    EList<Property> _parts = PartsUtil.getParts(compositeImplementation);
    for (final Property attribute : _parts) {
      {
        final Type type = attribute.getType();
        if ((type instanceof org.eclipse.uml2.uml.Class)) {
          boolean _instantiateViaBootloader = AbstractCompToOO.instantiateViaBootloader(((org.eclipse.uml2.uml.Class)type));
          boolean _not = (!_instantiateViaBootloader);
          if (_not) {
            final OpaqueExpression oe = UMLFactory.eINSTANCE.createOpaqueExpression();
            oe.getLanguages().add(this.progLang);
            EList<String> _bodies = oe.getBodies();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("new ");
            String _replace = ((org.eclipse.uml2.uml.Class)type).getQualifiedName().replace(NamedElement.SEPARATOR, ".");
            _builder.append(_replace);
            _builder.append("()");
            _bodies.add(_builder.toString());
            attribute.setDefaultValue(oe);
          }
        }
      }
    }
  }
}
