/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.serializer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.utilities.TracingOption;

public class SerializationBuilder {
    public static final @NonNull String HALF_NEW_LINE = new String("half-new-line");
    public static final @NonNull String NEW_LINE = new String("new-line");
    public static final @NonNull String NO_SPACE = new String("no-space");
    public static final @NonNull String POP = new String("pop");
    public static final @NonNull String POST_COMMENT = new String("post-comment");
    public static final @NonNull String PRE_COMMENT = new String("pre-comment");
    public static final @NonNull String PUSH = new String("push");
    public static final @NonNull String PUSH_NEXT = new String("push-next");
    @Deprecated
    public static final @NonNull String RAW_NEW_LINE = new String("raw-new-line");
    public static final @NonNull String SOFT_NEW_LINE = new String("soft-new-line");
    public static final @NonNull String SOFT_SPACE = new String("soft-space");
    public static final @NonNull String VALUE = new String("value");
    public static final @NonNull String WRAP_BEGIN_ALL = new String("wrap-begin-all");
    public static final @NonNull String WRAP_BEGIN_SOME = new String("wrap-begin-some");
    public static final @NonNull String WRAP_END = new String("wrap-end");
    public static final @NonNull String WRAP_HERE = new String("wrap-here");
    public static final @NonNull String WRAP_ANCHOR = new String("wrap-anchor");
    public static final @NonNull TracingOption SERIALIZATION = new TracingOption("org.eclipse.ocl.xtext.base", "serialization");
    protected @NonNull String lineDelimiter;
    protected @NonNull String indentString;
    protected int lineLength;
    protected int tabWidth;
    protected @NonNull IndentingStringBuilder s;
    private @Nullable String trailingStringState = NO_SPACE;
    private boolean hasHalfNewLine = false;
    private boolean pushingNext = false;
    private @Nullable List<@NonNull String> errors = null;
    protected final boolean tracing;

    public static void reset() {
        RegionContext.counter = 0;
    }

    public SerializationBuilder() {
        this("\n", "\t", 0, 4);
    }

    public SerializationBuilder(@NonNull String lineDelimiter, @NonNull String indentString) {
        this(lineDelimiter, indentString, 0, 8);
    }

    public SerializationBuilder(@NonNull String lineDelimiter, @NonNull String indentString, int lineLength, int tabWidth) {
        this.lineDelimiter = lineDelimiter;
        this.indentString = indentString;
        this.lineLength = lineLength;
        this.tabWidth = tabWidth;
        this.s = this.resetBuilder();
        this.tracing = SERIALIZATION.isActive();
    }

    public void append(@Nullable String nextString) {
        if (this.tracing) {
            String traceString = nextString == null ? "null" : (nextString == PUSH_NEXT ? "PUSH_NEXT" : (nextString == PUSH ? "PUSH" : (nextString == POP ? "POP" : (nextString == NEW_LINE ? "NEW_LINE" : (nextString == RAW_NEW_LINE ? "RAW_NEW_LINE" : (nextString == HALF_NEW_LINE ? "HALF_NEW_LINE" : (nextString == SOFT_NEW_LINE ? "SOFT_NEW_LINE" : (nextString == SOFT_SPACE ? "SOFT_SPACE" : (nextString == NO_SPACE ? "NO_SPACE" : "'" + StringUtil.convertToOCLString((String)nextString) + "'")))))))));
            SERIALIZATION.println(traceString);
        }
        if (nextString != null) {
            if (this.pushingNext) {
                this.pushingNext = false;
                this.s.push(nextString);
            } else if (nextString == PUSH_NEXT) {
                this.pushingNext = true;
            } else if (nextString == PUSH) {
                this.s.push(this.indentString);
            } else if (nextString == POP) {
                this.s.pop();
            } else if (nextString == NEW_LINE) {
                this.s.appendNewLine(false);
                this.trailingStringState = NO_SPACE;
                this.hasHalfNewLine = false;
            } else if (nextString == RAW_NEW_LINE) {
                this.s.appendNewLine(true);
                this.trailingStringState = NO_SPACE;
                this.hasHalfNewLine = false;
            } else if (nextString == HALF_NEW_LINE) {
                if (this.hasHalfNewLine) {
                    this.s.appendNewLine(false);
                    this.hasHalfNewLine = false;
                } else {
                    this.hasHalfNewLine = true;
                }
                if (this.trailingStringState == SOFT_SPACE) {
                    this.trailingStringState = null;
                }
            } else if (nextString == SOFT_NEW_LINE) {
                this.trailingStringState = SOFT_NEW_LINE;
                this.hasHalfNewLine = false;
            } else if (nextString == SOFT_SPACE) {
                if (this.trailingStringState == NO_SPACE) {
                    this.trailingStringState = NO_SPACE;
                } else if (this.trailingStringState == NEW_LINE || this.trailingStringState == RAW_NEW_LINE || this.trailingStringState == HALF_NEW_LINE) {
                    this.trailingStringState = NO_SPACE;
                } else if (this.trailingStringState == SOFT_NEW_LINE) {
                    this.s.appendNewLine(false);
                    this.trailingStringState = NO_SPACE;
                } else {
                    this.trailingStringState = SOFT_SPACE;
                }
            } else if (nextString == NO_SPACE) {
                if (this.trailingStringState == SOFT_NEW_LINE) {
                    this.s.appendNewLine(false);
                }
                this.trailingStringState = NO_SPACE;
            } else {
                if (this.trailingStringState == SOFT_NEW_LINE) {
                    this.s.appendNewLine(false);
                } else if (this.trailingStringState == SOFT_SPACE && !nextString.startsWith("\n")) {
                    this.s.appendString(" ");
                }
                int start = 0;
                while (true) {
                    int index;
                    String line = nextString.substring(start, (index = nextString.indexOf(10, start)) >= 0 ? index : nextString.length());
                    assert (line != null);
                    if (line.length() > 0) {
                        this.s.appendString(line);
                    }
                    if (index < 0) break;
                    this.s.appendNewLine(true);
                    start = index + 1;
                }
                this.trailingStringState = null;
                this.hasHalfNewLine = false;
            }
        }
    }

    public void appendError(@NonNull String string) {
        List<@NonNull String> errors2 = this.errors;
        if (errors2 == null) {
            this.errors = errors2 = new ArrayList<String>();
        }
        errors2.add(string);
        this.append(string);
    }

    public void close() {
        this.s.close();
    }

    public @Nullable Iterable<@NonNull String> getErrors() {
        return this.errors;
    }

    public int length() {
        return this.s.length();
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public int getTabWidth() {
        return this.tabWidth;
    }

    public @NonNull IndentingStringBuilder resetBuilder() {
        WrappingStringBuilder sw = new WrappingStringBuilder(new StringBuilder(), this.lineLength, this.lineDelimiter, this.tabWidth);
        this.s = new IndentingStringBuilder(sw, this.lineDelimiter, this.indentString);
        this.trailingStringState = NO_SPACE;
        this.pushingNext = false;
        this.errors = null;
        return this.s;
    }

    public void setIndentString(@NonNull String indentString) {
        this.indentString = indentString;
    }

    public void setLineDelimiter(@NonNull String lineDelimiter) {
        this.lineDelimiter = lineDelimiter;
    }

    public void setLineLength(int lineLength) {
        this.lineLength = lineLength;
    }

    public void setTabWidth(int tabWidth) {
        this.tabWidth = tabWidth;
    }

    public @NonNull String toString() {
        return this.s.toString();
    }

    protected static abstract class AbstractContext {
        protected final int line;
        protected final int column;
        protected final int offset;

        protected AbstractContext(@NonNull WrappingStringBuilder s) {
            this.line = s.getLine();
            this.column = s.getColumn();
            this.offset = s.getOffset();
        }

        public @NonNull String toString() {
            return String.valueOf(this.line) + ":" + this.column + ":" + this.offset;
        }

        public void toString(@NonNull FinalStringBuilder s) {
            s.appendToOffset(this.offset);
        }
    }

    protected static class AnchorContext
    extends AbstractContext {
        public AnchorContext(@NonNull WrappingStringBuilder s) {
            super(s);
        }

        @Override
        public @NonNull String toString() {
            return "WrapAnchor " + super.toString();
        }
    }

    protected static class ChildContextIterator
    implements Iterator<AbstractContext> {
        protected final @NonNull RegionContext regionContext;
        protected final @NonNull List<@NonNull AbstractContext> childContexts;
        protected final int size;
        private int cursor;
        private @Nullable AbstractContext currentContext = null;
        private int currentLine;
        private int currentColumn;
        private int currentWrappedLine;
        private int currentWrappedColumn;
        private int currentPreAnchorWrappedColumn;
        private int currentPostAnchorWrappedColumn;
        private int contextLine;
        private int contextColumn;
        private int nextLine;
        private int nextColumn;
        private int nextWrappedLine;
        private int nextWrappedColumn;
        private int nextPreAnchorWrappedColumn;
        private int nextPostAnchorWrappedColumn;
        private int requiredColumns = -1;
        private int requiredLines = -1;
        private int wrappedRequiredColumns = -1;
        private int wrappedRequiredLines = -1;
        private int locallyRequiredColumns = -1;
        private int locallyRequiredLines = -1;

        private void setCurrentColumn(int currentColumn) {
            this.currentColumn = currentColumn;
        }

        private void setNextColumn(int nextColumn) {
            this.nextColumn = nextColumn;
        }

        public ChildContextIterator(@NonNull RegionContext regionContext) {
            this.regionContext = regionContext;
            this.childContexts = regionContext.childContexts;
            this.size = this.childContexts.size();
            this.cursor = 0;
            this.currentLine = this.nextLine = regionContext.line;
            this.currentColumn = this.nextColumn = regionContext.column;
            this.setCurrentColumn(this.nextColumn);
            this.setNextColumn(this.nextColumn);
            this.nextWrappedLine = 0;
            this.currentWrappedLine = 0;
            this.nextWrappedColumn = 0;
            this.currentWrappedColumn = 0;
            this.nextPreAnchorWrappedColumn = 0;
            this.currentPreAnchorWrappedColumn = 0;
            this.nextPostAnchorWrappedColumn = 0;
            this.currentPostAnchorWrappedColumn = 0;
            this.locallyRequiredColumns = 0;
            this.locallyRequiredLines = 0;
            this.requiredColumns = 0;
            this.requiredLines = 0;
            this.wrappedRequiredColumns = 0;
            this.wrappedRequiredLines = 0;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.size;
        }

        @Override
        public @NonNull AbstractContext next() {
            int moreColumns;
            int unwrappedColumns;
            AbstractContext currentContext;
            if (this.cursor >= this.size) {
                throw new NoSuchElementException();
            }
            this.currentLine = this.nextLine;
            this.setCurrentColumn(this.nextColumn);
            this.currentWrappedLine = this.nextWrappedLine;
            this.currentWrappedColumn = this.nextWrappedColumn;
            this.currentPreAnchorWrappedColumn = this.nextPreAnchorWrappedColumn;
            this.currentPostAnchorWrappedColumn = this.nextPostAnchorWrappedColumn;
            this.currentContext = currentContext = this.childContexts.get(this.cursor++);
            this.contextLine = currentContext.line;
            this.contextColumn = currentContext.column;
            this.nextLine = this.contextLine;
            this.nextColumn = this.contextColumn;
            this.setNextColumn(this.contextColumn);
            this.nextWrappedLine = this.currentWrappedLine;
            this.nextWrappedColumn = this.currentWrappedColumn;
            if (this.contextLine != this.currentLine) {
                assert (this.contextLine > this.currentLine);
                this.setNextColumn(this.regionContext.column + this.currentPreAnchorWrappedColumn);
                this.currentWrappedColumn = this.currentPreAnchorWrappedColumn;
            }
            if ((unwrappedColumns = this.contextColumn - this.regionContext.column) > 0 && unwrappedColumns > this.requiredColumns) {
                this.requiredColumns = unwrappedColumns;
            }
            if ((moreColumns = this.contextColumn - this.currentColumn) > 0) {
                this.currentWrappedColumn += moreColumns;
                this.currentPostAnchorWrappedColumn += moreColumns;
                int wrappedColumns = this.currentPreAnchorWrappedColumn + this.currentPostAnchorWrappedColumn;
                if (wrappedColumns > this.wrappedRequiredColumns) {
                    this.wrappedRequiredColumns = wrappedColumns;
                }
            }
            this.nextWrappedColumn = this.currentWrappedColumn;
            this.nextPreAnchorWrappedColumn = this.currentPreAnchorWrappedColumn;
            this.nextPostAnchorWrappedColumn = this.currentPostAnchorWrappedColumn;
            if (currentContext instanceof HereContext) {
                this.nextPreAnchorWrappedColumn = this.currentPreAnchorWrappedColumn;
                this.nextPostAnchorWrappedColumn = 0;
                this.nextWrappedLine = this.currentWrappedLine + 1;
                this.nextWrappedColumn = this.currentPreAnchorWrappedColumn;
            } else if (currentContext instanceof AnchorContext) {
                this.nextPreAnchorWrappedColumn = this.currentWrappedColumn;
                this.nextPostAnchorWrappedColumn = 0;
            }
            if (!(currentContext instanceof IndentedContext)) {
                if (currentContext instanceof NewLineContext) {
                    this.nextLine = this.currentLine + 1;
                    this.setNextColumn(0);
                    this.nextWrappedLine = this.currentWrappedLine + 1;
                    this.nextWrappedColumn = 0;
                    this.nextPreAnchorWrappedColumn = 0;
                    this.nextPostAnchorWrappedColumn = 0;
                } else if (currentContext instanceof RegionContext) {
                    RegionContext nestedRegionContext = (RegionContext)currentContext;
                    this.nextLine = this.currentLine + nestedRegionContext.getRequiredLines();
                    int nestedRequiredColumns = nestedRegionContext.getRequiredColumns();
                    this.setNextColumn(this.currentColumn + nestedRequiredColumns);
                    this.nextWrappedLine = this.currentWrappedLine + nestedRegionContext.getWrappedRequiredLines();
                    this.nextWrappedColumn = this.currentWrappedColumn + nestedRegionContext.getWrappedLastLineColumns();
                    this.getClass();
                    int moreRequiredColumns = nestedRegionContext.column - this.regionContext.column + nestedRequiredColumns;
                    if (moreRequiredColumns > this.requiredColumns) {
                        this.requiredColumns = moreRequiredColumns;
                    }
                    if (this.nextWrappedColumn > this.wrappedRequiredColumns) {
                        this.wrappedRequiredColumns = this.nextWrappedColumn;
                    }
                }
            }
            this.requiredLines = this.nextLine - this.regionContext.line;
            this.wrappedRequiredLines = this.nextWrappedLine - 0;
            return currentContext;
        }

        public String toHeaderString() {
            StringBuilder s = new StringBuilder();
            String format0 = "%25.25s --------unwrapped----------   --------------------wrapped--------------------   --local-\n";
            s.append(String.format(format0, ""));
            String format1 = "%25.25s current   next    required    current  next     required    old-anchor-new      required\n";
            s.append(String.format(format1, ""));
            String format2 = "%25.25s Line:Col Line:Col Line:Col    Line:Col Line:Col Line:Col   Pre,Post Pre,Post    Line:Col \n";
            s.append(String.format(format2, ""));
            return s.toString();
        }

        public String toString() {
            String format = "R%03d %18.18s   %04d:%03d %04d:%03d +%03d:+%03d   +%02d:+%03d +%02d:+%03d +%02d:+%03d  +%03d,+%03d +%03d,+%03d   +%02d:+%03d\n";
            AbstractContext context = this.currentContext != null ? this.currentContext : this.regionContext;
            return String.format(format, this.regionContext.count, context.toString(), this.contextLine, this.contextColumn, this.nextLine, this.nextColumn, this.requiredLines, this.requiredColumns, this.currentWrappedLine, this.currentWrappedColumn, this.nextWrappedLine, this.nextWrappedColumn, this.wrappedRequiredLines, this.wrappedRequiredColumns, this.currentPreAnchorWrappedColumn, this.currentPostAnchorWrappedColumn, this.nextPreAnchorWrappedColumn, this.nextPostAnchorWrappedColumn, this.locallyRequiredLines, this.locallyRequiredColumns);
        }

        static /* synthetic */ int access$6(ChildContextIterator childContextIterator) {
            return childContextIterator.currentPreAnchorWrappedColumn;
        }

        static /* synthetic */ int access$7(ChildContextIterator childContextIterator) {
            return childContextIterator.currentPostAnchorWrappedColumn;
        }
    }

    protected static class EndContext
    extends AbstractContext {
        public EndContext(@NonNull WrappingStringBuilder s) {
            super(s);
        }

        @Override
        public @NonNull String toString() {
            return "WrapEnd " + super.toString();
        }
    }

    protected static class FinalStringBuilder {
        private final @NonNull StringBuilder sIn;
        protected final @NonNull String newLineString;
        protected final int tabWidth;
        private final @NonNull StringBuilder sOut = new StringBuilder();
        private int currentInputOffset = 0;
        private int startOfOutputLineOffset = 0;
        private int currentOutputColumn = 0;

        protected FinalStringBuilder(@NonNull StringBuilder sIn, @NonNull String newLineString, int tabWidth) {
            this.sIn = sIn;
            this.newLineString = newLineString;
            this.tabWidth = tabWidth;
            assert (tabWidth > 0);
        }

        private void appendChar(char c) {
            this.sOut.append(c);
            if (c == '\n') {
                this.currentOutputColumn = 0;
                this.startOfOutputLineOffset = this.sOut.length();
            } else if (c == '\t') {
                this.currentOutputColumn = (this.currentOutputColumn / this.tabWidth + 1) * this.tabWidth;
            } else if (c == '\r') {
                if (this.currentOutputColumn == 0) {
                    this.startOfOutputLineOffset = this.sOut.length();
                }
            } else {
                ++this.currentOutputColumn;
            }
        }

        public void appendString(@NonNull String string) {
            int length = string.length();
            int i = 0;
            while (i < length) {
                char c = string.charAt(i);
                this.appendChar(c);
                ++i;
            }
        }

        public void appendToColumn(int anchorColumn) {
            assert (anchorColumn <= this.currentOutputColumn);
            int outputOffset = this.startOfOutputLineOffset;
            this.appendString(this.newLineString);
            while (this.currentOutputColumn < anchorColumn) {
                char c = this.sOut.charAt(outputOffset++);
                assert (c != '\n');
                assert (c != '\r' || this.currentOutputColumn == 0);
                this.appendChar(Character.isWhitespace(c) ? c : (char)' ');
            }
            assert (this.currentOutputColumn == anchorColumn);
        }

        public void appendToOffset(int newInputOffset) {
            if (newInputOffset > this.currentInputOffset) {
                String substring = this.sIn.substring(this.currentInputOffset, newInputOffset);
                assert (substring != null);
                this.appendString(substring);
                this.currentInputOffset = newInputOffset;
            }
        }

        public String toString() {
            return this.sOut.toString();
        }
    }

    protected static class HereContext
    extends AbstractContext {
        private int wrapColumn = -1;

        public HereContext(@NonNull WrappingStringBuilder s) {
            super(s);
        }

        @Override
        public @NonNull String toString() {
            return "WrapHere " + super.toString();
        }

        @Override
        public void toString(@NonNull FinalStringBuilder s) {
            super.toString(s);
            if (this.wrapColumn >= 0) {
                s.appendToColumn(this.wrapColumn);
            }
        }

        public void setWrapColumn(int wrapColumn) {
            this.wrapColumn = wrapColumn;
        }
    }

    protected static class IndentedContext
    extends AbstractContext {
        public IndentedContext(@NonNull WrappingStringBuilder s) {
            super(s);
        }

        @Override
        public @NonNull String toString() {
            return "Indented " + super.toString();
        }
    }

    protected static class IndentingStringBuilder {
        protected final @NonNull String lineDelimiter;
        protected final @NonNull String indentString;
        private @NonNull Stack<@NonNull String> indents = new Stack();
        private boolean atStartOfLine = true;
        private final @NonNull WrappingStringBuilder s;

        public IndentingStringBuilder(@NonNull WrappingStringBuilder s, @NonNull String lineDelimiter, @NonNull String indentString) {
            this.s = s;
            this.lineDelimiter = lineDelimiter;
            this.indentString = indentString;
        }

        public void append(@NonNull String string) {
            this.s.append(string);
            if (this.atStartOfLine && !string.isEmpty()) {
                this.atStartOfLine = false;
            }
        }

        protected void appendNewLine(boolean isRaw) {
            if (this.atStartOfLine && !this.indents.isEmpty()) {
                @Nullable String indent = this.indents.peek();
                assert (indent != null);
                int length = indent.length();
                if (length > 0) {
                    int i = length;
                    while (--i >= 0) {
                        char c = indent.charAt(i);
                        if (Character.isWhitespace(c)) continue;
                        this.s.appendIndent(indent.substring(0, i + 1));
                        break;
                    }
                }
            }
            this.s.appendNewLine(this.lineDelimiter.length());
            this.append(this.lineDelimiter);
            this.atStartOfLine = !isRaw;
        }

        protected String appendString(@NonNull String string) {
            if (this.atStartOfLine && !string.isEmpty() && !this.indents.isEmpty()) {
                this.s.appendIndent(this.indents.peek());
            }
            this.append(string);
            return null;
        }

        public void close() {
            if (!this.atStartOfLine) {
                this.appendNewLine(false);
            }
            this.s.close();
        }

        public int length() {
            return this.s.length();
        }

        public void pop() {
            this.indents.pop();
        }

        public void push(@NonNull String indentString) {
            if (this.indents.isEmpty()) {
                this.indents.push(indentString);
            } else {
                this.indents.push(String.valueOf(this.indents.peek()) + indentString);
            }
        }

        public @NonNull String toString() {
            return String.valueOf(this.s);
        }
    }

    protected static class NewLineContext
    extends AbstractContext {
        protected final int newLineSize;

        public NewLineContext(@NonNull WrappingStringBuilder s, int newLineSize) {
            super(s);
            this.newLineSize = newLineSize;
        }

        @Override
        public @NonNull String toString() {
            return "NewLine " + super.toString();
        }

        @Override
        public void toString(@NonNull FinalStringBuilder s) {
            s.appendToOffset(this.offset + this.newLineSize);
        }
    }

    protected static abstract class RegionContext
    extends AbstractContext {
        private static int counter = 0;
        private final int count;
        private @NonNull List<@NonNull AbstractContext> childContexts = new ArrayList<AbstractContext>();
        private int wrappedLastLineColumns = -1;
        private @Nullable ChildContextIterator contextAnalysis = null;

        protected RegionContext(@NonNull WrappingStringBuilder s) {
            super(s);
            this.count = counter++;
        }

        public void addContext(@NonNull AbstractContext childContext) {
            this.childContexts.add(childContext);
        }

        protected @NonNull ChildContextIterator analyzeWrapping() {
            @NonNull ChildContextIterator contextAnalysis = new ChildContextIterator(this);
            this.wrappedLastLineColumns = contextAnalysis.currentWrappedColumn;
            return contextAnalysis;
        }

        protected @NonNull ChildContextIterator getContextAnalysis() {
            ChildContextIterator contextAnalysis2 = this.contextAnalysis;
            if (contextAnalysis2 == null) {
                this.contextAnalysis = contextAnalysis2 = this.analyzeWrapping();
            }
            return contextAnalysis2;
        }

        public abstract @NonNull RegionContext getParentContext();

        public int getRequiredColumns() {
            return this.getContextAnalysis().requiredColumns;
        }

        public int getRequiredLines() {
            return this.getContextAnalysis().requiredLines;
        }

        protected abstract int getWrapColumn();

        private int getWrappedLastLineColumns() {
            return this.wrappedLastLineColumns;
        }

        public int getWrappedRequiredColumns() {
            return this.getContextAnalysis().wrappedRequiredColumns;
        }

        public int getWrappedRequiredLines() {
            return this.getContextAnalysis().wrappedRequiredLines;
        }

        /*
         * Unable to fully structure code
         */
        protected void setWrapColumn(int wrapColumn) {
            contextAnalysis2 = this.contextAnalysis;
            if (RegionContext.$assertionsDisabled || contextAnalysis2 != null) ** GOTO lbl11
            throw new AssertionError();
lbl-1000:
            // 1 sources

            {
                childContext = contextAnalysis2.next();
                if (wrapColumn < 0) continue;
                if (childContext instanceof WrappingContext) {
                    ((WrappingContext)childContext).setWrapColumn(wrapColumn + ChildContextIterator.access$6(contextAnalysis2) + ChildContextIterator.access$7(contextAnalysis2));
                    continue;
                }
                if (!(childContext instanceof HereContext)) continue;
                ((HereContext)childContext).setWrapColumn(wrapColumn + ChildContextIterator.access$6(contextAnalysis2));
lbl11:
                // 5 sources

                ** while (contextAnalysis2.hasNext())
            }
lbl12:
            // 1 sources

        }

        @Override
        public void toString(@NonNull FinalStringBuilder s) {
            super.toString(s);
            int anchorWrappedColumns = 0;
            @NonNull ChildContextIterator contextIterator = new ChildContextIterator(this);
            while (contextIterator.hasNext()) {
                @NonNull AbstractContext childContext = contextIterator.next();
                if (childContext instanceof AnchorContext) {
                    AnchorContext anchorContext = (AnchorContext)childContext;
                    anchorWrappedColumns = anchorContext.column - contextIterator.nextColumn;
                    assert (anchorWrappedColumns >= 0);
                    continue;
                }
                childContext.toString(s);
            }
        }

        static /* synthetic */ int access$3() {
            return counter;
        }
    }

    protected static class RootContext
    extends RegionContext {
        public RootContext(@NonNull WrappingStringBuilder s) {
            super(s);
        }

        @Override
        protected @NonNull ChildContextIterator getContextAnalysis() {
            ChildContextIterator contextAnalysis = super.getContextAnalysis();
            this.setWrapColumn(0);
            return contextAnalysis;
        }

        @Override
        public @NonNull RegionContext getParentContext() {
            throw new IllegalStateException();
        }

        @Override
        protected int getWrapColumn() {
            return 0;
        }

        @Override
        public void setWrapColumn(int wrapColumn) {
            assert (wrapColumn == 0);
            super.setWrapColumn(wrapColumn);
        }

        @Override
        public @NonNull String toString() {
            return "WrapRoot " + super.toString();
        }
    }

    protected static class WrappingContext
    extends RegionContext {
        protected final boolean isAllOrNone;
        private final @NonNull RegionContext parentContext;
        private int wrapColumn = -1;

        protected WrappingContext(@NonNull RegionContext parentContext, @NonNull WrappingStringBuilder s, boolean isAllOrNone) {
            super(s);
            this.isAllOrNone = isAllOrNone;
            this.parentContext = parentContext;
        }

        @Override
        public @NonNull RegionContext getParentContext() {
            return this.parentContext;
        }

        @Override
        protected int getWrapColumn() {
            return this.wrapColumn;
        }

        @Override
        public void setWrapColumn(int wrapColumn) {
            this.wrapColumn = wrapColumn;
            super.setWrapColumn(wrapColumn);
        }

        @Override
        public @NonNull String toString() {
            return "WrapBegin " + super.toString();
        }
    }

    protected static class WrappingStringBuilder {
        private final @NonNull StringBuilder s;
        protected final int lineLength;
        protected final @NonNull String newLineString;
        protected final int tabWidth;
        private int nextLine = 0;
        private int nextColumn = 0;
        private final @NonNull RootContext rootContext;
        private @NonNull RegionContext currentContext;

        public WrappingStringBuilder(@NonNull StringBuilder s, int lineLength, @NonNull String newLineString, int tabWidth) {
            this.s = s;
            this.lineLength = lineLength;
            this.newLineString = newLineString;
            this.tabWidth = tabWidth;
            this.rootContext = new RootContext(this);
            this.currentContext = this.rootContext;
        }

        public void append(@Nullable String string) {
            if (string != null) {
                if (WRAP_ANCHOR == string) {
                    this.currentContext.addContext(new AnchorContext(this));
                } else if (WRAP_BEGIN_ALL == string) {
                    WrappingContext childContext = new WrappingContext(this.currentContext, this, true);
                    this.currentContext.addContext(childContext);
                    this.currentContext = childContext;
                } else if (WRAP_BEGIN_SOME == string) {
                    WrappingContext childContext = new WrappingContext(this.currentContext, this, false);
                    this.currentContext.addContext(childContext);
                    this.currentContext = childContext;
                } else if (WRAP_END == string) {
                    this.currentContext.addContext(new EndContext(this));
                    this.currentContext = this.currentContext.getParentContext();
                } else if (WRAP_HERE == string) {
                    this.currentContext.addContext(new HereContext(this));
                } else {
                    int i = 0;
                    while (i < string.length()) {
                        char c = string.charAt(i);
                        this.s.append(c);
                        if (c == '\n') {
                            this.nextColumn = 0;
                            ++this.nextLine;
                        } else if (c != '\r') {
                            this.nextColumn = c == '\t' ? (this.nextColumn / this.tabWidth + 1) * this.tabWidth : ++this.nextColumn;
                        }
                        ++i;
                    }
                }
            }
        }

        public void appendIndent(@NonNull String indents) {
            int size = indents.length();
            assert (size > 0);
            this.append(indents);
            this.currentContext.addContext(new IndentedContext(this));
        }

        public void appendNewLine(int newLineSize) {
            this.currentContext.addContext(new NewLineContext(this, newLineSize));
        }

        public void close() {
        }

        public int getColumn() {
            return this.nextColumn;
        }

        public int getLine() {
            return this.nextLine;
        }

        public int getOffset() {
            return this.s.length();
        }

        public int length() {
            return this.s.length();
        }

        public @NonNull String toString() {
            int maximumRequiredColumns = this.rootContext.getRequiredColumns();
            if (this.lineLength > 0 && maximumRequiredColumns > this.lineLength) {
                FinalStringBuilder sOut = new FinalStringBuilder(this.s, this.newLineString, this.tabWidth);
                this.rootContext.toString(sOut);
                return String.valueOf(sOut);
            }
            return String.valueOf(this.s);
        }
    }
}

