/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.uml.tests;

import java.util.HashSet;
import java.util.List;
import junit.framework.AssertionFailedError;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.ocl.AmbiguousLookupException;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.LookupException;
import org.eclipse.ocl.OCLInput;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.expressions.AssociationClassCallExp;
import org.eclipse.ocl.expressions.FeatureCallExp;
import org.eclipse.ocl.expressions.LoopExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.helper.ChoiceKind;
import org.eclipse.ocl.helper.ConstraintKind;
import org.eclipse.ocl.lpg.BasicEnvironment;
import org.eclipse.ocl.lpg.ProblemHandler;
import org.eclipse.ocl.options.Option;
import org.eclipse.ocl.options.ParsingOptions;
import org.eclipse.ocl.options.ProblemOption;
import org.eclipse.ocl.uml.CollectionType;
import org.eclipse.ocl.uml.options.UMLParsingOptions;
import org.eclipse.ocl.uml.tests.AbstractTestSuite;
import org.eclipse.ocl.uml.tests.LocationInformationTest;
import org.eclipse.ocl.util.OCLUtil;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.AssociationClass;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.LiteralNull;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class AssociationTest
extends AbstractTestSuite {
    Resource instanceResource;
    Package instancePackage;

    public void test_qualifiers_associationEnd_RATLC00538077() {
        InstanceSpecification aForest = this.instantiate(this.instancePackage, (Classifier)this.forest);
        InstanceSpecification aTree = this.instantiate(this.instancePackage, (Classifier)this.tree);
        InstanceSpecification anotherTree = this.instantiate(this.instancePackage, (Classifier)this.tree);
        HashSet<InstanceSpecification> trees = new HashSet<InstanceSpecification>();
        trees.add(aTree);
        trees.add(anotherTree);
        this.link(this.instancePackage, aForest, this.forest_trees, new Object[]{"foo", 3}, aTree, this.a_forest_tree_forest, this.a_forest_tree);
        this.link(this.instancePackage, aForest, this.forest_trees, new Object[]{"bar", 2}, anotherTree, this.a_forest_tree_forest, this.a_forest_tree);
        OCLExpression expr = this.parse("package ocltest context Forest inv: self.trees->asSet() endpackage");
        Object result = this.evaluate(expr, aForest);
        AssociationTest.assertEquals(trees, (Object)result);
        expr = this.parse("package ocltest context Forest inv: self.trees['bar', 2] endpackage");
        result = this.evaluate(expr, aForest);
        AssociationTest.assertSame((Object)anotherTree, (Object)result);
        AssertionFailedError err = null;
        try {
            this.parse("package ocltest context Forest inv: not self.trees['foo'].apples->isEmpty() endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            AssociationTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        AssociationTest.assertNotNull((String)"Parse should have failed", (Object)((Object)err));
        try {
            this.parse("package ocltest context Forest inv: not self.trees[3, 'foo'].apples->isEmpty() endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            AssociationTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        AssociationTest.assertNotNull((String)"Parse should have failed", (Object)((Object)err));
        try {
            this.parse("package ocltest context Forest inv: not self.trees['foo', 3, 'bar'].apples->isEmpty() endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            AssociationTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        AssociationTest.assertNotNull((String)"Parse should have failed", (Object)((Object)err));
    }

    public void test_associationClass_RATLC00538077() {
        InstanceSpecification aTree = this.instantiate(this.instancePackage, (Classifier)this.tree);
        InstanceSpecification anApple = this.instantiate(this.instancePackage, (Classifier)this.apple);
        this.setValue(anApple, this.fruit_color, this.color_red);
        InstanceSpecification anotherApple = this.instantiate(this.instancePackage, (Classifier)this.apple);
        this.setValue(anotherApple, this.fruit_color, this.color_green);
        InstanceSpecification aStem = this.link(this.instancePackage, aTree, this.tree_apples, anApple, this.apple_tree, (Association)this.stem);
        this.setValue(aStem, this.stem_length, 3);
        InstanceSpecification anotherStem = this.link(this.instancePackage, aTree, this.tree_apples, anotherApple, this.apple_tree, (Association)this.stem);
        this.setValue(anotherStem, this.stem_length, 2);
        OCLExpression expr = this.parse("package ocltest context Tree inv: self.apples->forAll(a : Apple | a.color <> Color::black) endpackage");
        AssociationTest.assertTrue((boolean)this.check(expr, aTree));
        this.setValue(anotherApple, this.fruit_color, this.color_black);
        AssociationTest.assertFalse((boolean)this.check(expr, aTree));
        expr = this.parse("package ocltest context Tree inv: self.stem->forAll(s : Stem | s.length > 0) endpackage");
        AssociationTest.assertTrue((boolean)this.check(expr, aTree));
        this.setValue(anotherStem, this.stem_length, 0);
        AssociationTest.assertFalse((boolean)this.check(expr, aTree));
    }

    public void test_associationClass_scalar_182193() {
        InstanceSpecification aTree = this.instantiate(this.instancePackage, (Classifier)this.tree);
        this.setValue(aTree, this.tree_height, 30);
        InstanceSpecification anApple = this.instantiate(this.instancePackage, (Classifier)this.apple);
        this.setValue(anApple, this.fruit_color, this.color_red);
        InstanceSpecification anotherApple = this.instantiate(this.instancePackage, (Classifier)this.apple);
        this.setValue(anotherApple, this.fruit_color, this.color_green);
        InstanceSpecification aStem = this.link(this.instancePackage, aTree, this.tree_apples, anApple, this.apple_tree, (Association)this.stem);
        this.setValue(aStem, this.stem_length, 3);
        InstanceSpecification anotherStem = this.link(this.instancePackage, aTree, this.tree_apples, anotherApple, this.apple_tree, (Association)this.stem);
        this.setValue(anotherStem, this.stem_length, 2);
        OCLExpression expr = this.parse("package ocltest context Apple inv: self.tree.height > 20 endpackage");
        AssociationTest.assertTrue((boolean)this.check(expr, anApple));
        this.setValue(aTree, this.tree_height, 20);
        AssociationTest.assertFalse((boolean)this.check(expr, anApple));
        expr = this.parse("package ocltest context Apple inv: self.stem.length > 0 endpackage");
        AssociationTest.assertTrue((boolean)this.check(expr, anApple));
        this.setValue(anotherStem, this.stem_length, 0);
        AssociationTest.assertFalse((boolean)this.check(expr, anotherApple));
    }

    public void test_associationClass_qualifiers_RATLC00538077() {
        InstanceSpecification aTree = this.instantiate(this.instancePackage, (Classifier)this.tree);
        InstanceSpecification anApple = this.instantiate(this.instancePackage, (Classifier)this.apple);
        this.setValue(anApple, this.fruit_color, this.color_red);
        InstanceSpecification anotherApple = this.instantiate(this.instancePackage, (Classifier)this.apple);
        this.setValue(anotherApple, this.fruit_color, this.color_green);
        InstanceSpecification aStem = this.link(this.instancePackage, aTree, this.tree_apples, anApple, this.apple_tree, (Association)this.stem);
        this.setValue(aStem, this.stem_length, 3);
        InstanceSpecification anotherStem = this.link(this.instancePackage, aTree, this.tree_apples, anotherApple, this.apple_tree, (Association)this.stem);
        this.setValue(anotherStem, this.stem_length, 2);
        OCLExpression expr = this.parse("package ocltest context Tree inv: self.stem[apples]->forAll(s : Stem | s.length > 0) endpackage");
        AssociationTest.assertTrue((boolean)this.check(expr, aTree));
        AssertionFailedError err = null;
        try {
            this.parse("package ocltest context Tree inv: self.stem[tree]->forAll(s : Stem | s.length > 0) endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            AssociationTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        AssociationTest.assertNotNull((String)"Parse should have failed", (Object)((Object)err));
        try {
            this.parse("package ocltest context Tree inv: self.stem[3]->forAll(s : Stem | s.length > 0) endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            AssociationTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        AssociationTest.assertNotNull((String)"Parse should have failed", (Object)((Object)err));
        try {
            this.parse("package ocltest context Tree inv: self.stem[apples, apples]->forAll(s : Stem | s.length > 0) endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            AssociationTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        AssociationTest.assertNotNull((String)"Parse should have failed", (Object)((Object)err));
    }

    public void test_associationClass_reflexive_RATLC00538077() {
        this.expectModified = true;
        AssociationClass ac = (AssociationClass)((Package)this.fruitPackage).createOwnedType("AC", uml.getAssociationClass());
        Property x = ac.createOwnedAttribute("x", (Type)this.getUMLInteger());
        Property parent = this.tree.createOwnedAttribute("parent", (Type)this.tree);
        parent.setLower(0);
        parent.setIsUnique(true);
        parent.setIsOrdered(false);
        Property children = this.tree.createOwnedAttribute("children", (Type)this.tree);
        children.setLower(0);
        children.setUpper(-1);
        children.setIsUnique(true);
        children.setIsOrdered(false);
        parent.setAssociation((Association)ac);
        children.setAssociation((Association)ac);
        InstanceSpecification aTree = this.instantiate(this.instancePackage, (Classifier)this.tree);
        InstanceSpecification aChild = this.instantiate(this.instancePackage, (Classifier)this.tree);
        InstanceSpecification anotherChild = this.instantiate(this.instancePackage, (Classifier)this.tree);
        InstanceSpecification aLink = this.link(this.instancePackage, aTree, children, aChild, parent, (Association)ac);
        this.setValue(aLink, x, 3);
        InstanceSpecification anotherLink = this.link(this.instancePackage, aTree, children, anotherChild, parent, (Association)ac);
        this.setValue(anotherLink, x, 2);
        OCLExpression expr = this.parse("package ocltest context Tree inv: self.children->forAll(t : Tree | t.apples->isEmpty()) endpackage");
        AssociationTest.assertTrue((boolean)this.check(expr, aTree));
        this.link(this.instancePackage, anotherChild, this.tree_apples, this.instantiate(this.instancePackage, (Classifier)this.apple), this.apple_tree, null);
        AssociationTest.assertFalse((boolean)this.check(expr, aTree));
        expr = this.parse("package ocltest context Tree inv: self.aC[children]->forAll(ac : AC | ac.x > 0) endpackage");
        AssociationTest.assertTrue((boolean)this.check(expr, aTree));
        this.setValue(anotherLink, x, 0);
        AssociationTest.assertFalse((boolean)this.check(expr, aTree));
        expr = this.parse("package ocltest context Tree inv: self.aC[parent].x > 0 endpackage");
        AssociationTest.assertTrue((boolean)this.check(expr, aChild));
        AssociationTest.assertFalse((boolean)this.check(expr, anotherChild));
        AssertionFailedError err = null;
        try {
            this.parse("package ocltest context Tree inv: self.aC->forAll(ac : AC | ac.x > 0) endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            AssociationTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        AssociationTest.assertNotNull((String)"Parse should have failed", (Object)((Object)err));
    }

    public void test_navigateFromAssociationClass_RATLC00538077() {
        InstanceSpecification aTree = this.instantiate(this.instancePackage, (Classifier)this.tree);
        this.setValue(aTree, this.tree_height, 20);
        InstanceSpecification anApple = this.instantiate(this.instancePackage, (Classifier)this.apple);
        this.setValue(anApple, this.fruit_color, this.color_red);
        InstanceSpecification anotherApple = this.instantiate(this.instancePackage, (Classifier)this.apple);
        this.setValue(anotherApple, this.fruit_color, this.color_black);
        InstanceSpecification aStem = this.link(this.instancePackage, aTree, this.tree_apples, anApple, this.apple_tree, (Association)this.stem);
        this.setValue(aStem, this.stem_length, 3);
        InstanceSpecification anotherStem = this.link(this.instancePackage, aTree, this.tree_apples, anotherApple, this.apple_tree, (Association)this.stem);
        this.setValue(anotherStem, this.stem_length, 0);
        OCLExpression expr = this.parse("package ocltest context Stem inv: self.apples.color <> Color::black endpackage");
        AssociationTest.assertTrue((boolean)this.check(expr, aStem));
        AssociationTest.assertFalse((boolean)this.check(expr, anotherStem));
        expr = this.parse("package ocltest context Stem inv: self.tree.height > 20 endpackage");
        AssociationTest.assertFalse((boolean)this.check(expr, aStem));
        AssociationTest.assertFalse((boolean)this.check(expr, anotherStem));
        this.setValue(aTree, this.tree_height, 30);
        AssociationTest.assertTrue((boolean)this.check(expr, aStem));
        AssociationTest.assertTrue((boolean)this.check(expr, anotherStem));
        expr = this.parse("package ocltest context Stem inv: self.length > 0 endpackage");
        AssociationTest.assertTrue((boolean)this.check(expr, aStem));
        AssociationTest.assertFalse((boolean)this.check(expr, anotherStem));
    }

    public void test_associationClass_contentAssist_RATLC00538077() {
        this.helper.setContext((Object)this.tree);
        try {
            List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.");
            AssociationTest.assertNotNull((Object)choices);
            this.assertChoice(choices, ChoiceKind.PROPERTY, "apples");
            this.assertChoice(choices, ChoiceKind.ASSOCIATION_CLASS, "stem");
        }
        catch (Exception e) {
            AssociationTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_propertyPositions_associationClassEndCall() {
        String exprString = "self.apples->notEmpty()";
        OCLExpression constraint = this.createQuery((EObject)this.tree, "self.apples->notEmpty()");
        OperationCallExp<Classifier, Operation> notEmptyExp = LocationInformationTest.asOperationCall(constraint);
        FeatureCallExp<Classifier> mpcExp = LocationInformationTest.asFeatureCall(notEmptyExp.getSource());
        LocationInformationTest.assertPropertyLocation(mpcExp, "self.apples->notEmpty()".indexOf("apples"), "self.apples->notEmpty()".indexOf("->"));
    }

    public void test_propertyPositions_associationClassCall() {
        String exprString = "self.stem[apples]->notEmpty()";
        OCLExpression constraint = this.createQuery((EObject)this.tree, "self.stem[apples]->notEmpty()");
        OperationCallExp<Classifier, Operation> notEmptyExp = LocationInformationTest.asOperationCall(constraint);
        FeatureCallExp<Classifier> mpcExp = LocationInformationTest.asFeatureCall(notEmptyExp.getSource());
        LocationInformationTest.assertPropertyLocation(mpcExp, "self.stem[apples]->notEmpty()".indexOf("stem"), "self.stem[apples]->notEmpty()".indexOf("["));
    }

    public void test_propertyPositions_associationClassCall_implicitCollect() {
        String exprString = "Tree.allInstances().stem[apples]->notEmpty()";
        OCLExpression constraint = this.createQuery((EObject)this.tree, "Tree.allInstances().stem[apples]->notEmpty()");
        OperationCallExp<Classifier, Operation> notEmptyExp = LocationInformationTest.asOperationCall(constraint);
        LoopExp<Classifier, Parameter> loopExp = LocationInformationTest.asLoop(notEmptyExp.getSource());
        FeatureCallExp<Classifier> mpcExp = LocationInformationTest.asFeatureCall(loopExp.getBody());
        LocationInformationTest.assertPropertyLocation(mpcExp, "Tree.allInstances().stem[apples]->notEmpty()".indexOf("stem"), "Tree.allInstances().stem[apples]->notEmpty()".indexOf("["));
    }

    public void test_propertyPositions_associationClassQualified() {
        String exprString = "self.stem[apples]->notEmpty()";
        OCLExpression constraint = this.createQuery((EObject)this.tree, "self.stem[apples]->notEmpty()");
        OperationCallExp<Classifier, Operation> notEmptyExp = LocationInformationTest.asOperationCall(constraint);
        AssociationClassCallExp<Classifier, Property> accExp = LocationInformationTest.asAssociationClassCall(notEmptyExp.getSource());
        EList qualifiers = accExp.getQualifier();
        AssociationTest.assertEquals((int)1, (int)qualifiers.size());
        OCLExpression qualifier = (OCLExpression)qualifiers.get(0);
        LocationInformationTest.assertLocation((ASTNode)qualifier, "self.stem[apples]->notEmpty()".indexOf("apples"), "self.stem[apples]->notEmpty()".indexOf("]->"));
    }

    public void test_propertyPositions_associationClassQualified_implicitCollect() {
        String exprString = "Tree.allInstances().stem[apples]->notEmpty()";
        OCLExpression constraint = this.createQuery((EObject)this.tree, "Tree.allInstances().stem[apples]->notEmpty()");
        OperationCallExp<Classifier, Operation> notEmptyExp = LocationInformationTest.asOperationCall(constraint);
        LoopExp<Classifier, Parameter> loopExp = LocationInformationTest.asLoop(notEmptyExp.getSource());
        AssociationClassCallExp<Classifier, Property> accExp = LocationInformationTest.asAssociationClassCall(loopExp.getBody());
        EList qualifiers = accExp.getQualifier();
        AssociationTest.assertEquals((int)1, (int)qualifiers.size());
        OCLExpression qualifier = (OCLExpression)qualifiers.get(0);
        LocationInformationTest.assertLocation((ASTNode)qualifier, "Tree.allInstances().stem[apples]->notEmpty()".indexOf("apples"), "Tree.allInstances().stem[apples]->notEmpty()".indexOf("]->"));
    }

    public void test_associationNullContext_bugzilla121614() {
        Class employee = this.instancePackage.createOwnedClass("Employee", false);
        employee.createOwnedAttribute("manager", (Type)employee);
        InstanceSpecification emp1 = this.instantiate(this.instancePackage, (Classifier)employee);
        OCLExpression expr = this.parse("package instances context Employee inv: self.manager.manager endpackage");
        Object result = this.evaluate(expr, emp1);
        this.assertInvalid(result);
    }

    public void test_qualifiedAssociation_scalar_133435() {
        OCLExpression expr = this.parse("package ocltest context Forest inv: self.trees endpackage");
        AssociationTest.assertTrue((boolean)(expr.getType() instanceof CollectionType));
        CollectionType collType = (CollectionType)expr.getType();
        AssociationTest.assertSame((Object)this.tree, (Object)collType.getElementType());
        expr = this.parse("package ocltest context Forest inv: self.trees['foo', 3] endpackage");
        AssociationTest.assertSame((Object)this.tree, (Object)expr.getType());
    }

    public void test_nonNavigableAttribute() {
        OCLExpression expr = this.parseConstraint("package ocltest context Tree inv: forest.trees->includes(self) endpackage");
        EPackage epackage = (EPackage)UMLUtil.convertToEcore((Package)((Package)this.fruitPackage), null).iterator().next();
        EFactory factory = epackage.getEFactoryInstance();
        ResourceImpl res = new ResourceImpl(URI.createURI((String)"test://foo"));
        res.eAdapters().add((Object)new ECrossReferenceAdapter());
        resourceSet.getPackageRegistry().put((Object)epackage.getNsURI(), (Object)epackage);
        try {
            EClass eTree = (EClass)epackage.getEClassifier("Tree");
            EClass eForest = (EClass)epackage.getEClassifier("Forest");
            EStructuralFeature eTrees = eForest.getEStructuralFeature("trees");
            EObject aForest = factory.create(eForest);
            res.getContents().add((Object)aForest);
            EList trees = (EList)aForest.eGet(eTrees);
            EObject aTree = factory.create(eTree);
            res.getContents().add((Object)aTree);
            trees.add((Object)aTree);
            EObject anotherTree = factory.create(eTree);
            res.getContents().add((Object)anotherTree);
            trees.add((Object)anotherTree);
            aTree = factory.create(eTree);
            res.getContents().add((Object)aTree);
            trees.add((Object)aTree);
            AssociationTest.assertTrue((boolean)this.check(expr, anotherTree));
        }
        finally {
            res.unload();
        }
    }

    public void test_nonNavigableAttribute_instanceSpecification() {
        OCLExpression expr = this.parseConstraint("package ocltest context Tree inv: forest.trees->includes(self) endpackage");
        InstanceSpecification aForest = this.instantiate(this.instancePackage, (Classifier)this.forest);
        InstanceSpecification aTree = this.instantiate(this.instancePackage, (Classifier)this.tree);
        this.addValue(aForest, this.forest_trees, aTree);
        InstanceSpecification anotherTree = this.instantiate(this.instancePackage, (Classifier)this.tree);
        this.addValue(aForest, this.forest_trees, anotherTree);
        aTree = this.instantiate(this.instancePackage, (Classifier)this.tree);
        this.addValue(aForest, this.forest_trees, aTree);
        AssociationTest.assertTrue((boolean)this.check(expr, anotherTree));
    }

    public void test_unnamedAttribute_194245() {
        this.expectModified = true;
        Property tree_forest = this.forest_trees.getOtherEnd();
        AssociationTest.assertNotNull((Object)tree_forest);
        AssociationTest.assertNotNull((Object)tree_forest.getName());
        tree_forest.setName(null);
        ResourceImpl res = new ResourceImpl(URI.createURI((String)"test://foo"));
        res.eAdapters().add((Object)new ECrossReferenceAdapter());
        OCLExpression expr = this.parseConstraint("package ocltest context Tree inv: forest.trees->includes(self) endpackage");
        EPackage epackage = (EPackage)UMLUtil.convertToEcore((Package)((Package)this.fruitPackage), null).iterator().next();
        EFactory factory = epackage.getEFactoryInstance();
        resourceSet.getPackageRegistry().put((Object)epackage.getNsURI(), (Object)epackage);
        EClass eTree = (EClass)epackage.getEClassifier("Tree");
        EClass eForest = (EClass)epackage.getEClassifier("Forest");
        EStructuralFeature eTrees = eForest.getEStructuralFeature("trees");
        EObject aForest = factory.create(eForest);
        res.getContents().add((Object)aForest);
        EList trees = (EList)aForest.eGet(eTrees);
        EObject aTree = factory.create(eTree);
        res.getContents().add((Object)aTree);
        trees.add((Object)aTree);
        EObject anotherTree = factory.create(eTree);
        res.getContents().add((Object)anotherTree);
        trees.add((Object)anotherTree);
        aTree = factory.create(eTree);
        res.getContents().add((Object)aTree);
        trees.add((Object)aTree);
        AssociationTest.assertTrue((boolean)this.check(expr, anotherTree));
    }

    public void test_unnamedAttribute_instanceSpecification_194245() {
        this.expectModified = true;
        Property tree_forest = this.forest_trees.getOtherEnd();
        AssociationTest.assertNotNull((Object)tree_forest);
        AssociationTest.assertNotNull((Object)tree_forest.getName());
        tree_forest.setName(null);
        OCLExpression expr = this.parseConstraint("package ocltest context Tree inv: forest.trees->includes(self) endpackage");
        InstanceSpecification aForest = this.instantiate(this.instancePackage, (Classifier)this.forest);
        InstanceSpecification aTree = this.instantiate(this.instancePackage, (Classifier)this.tree);
        this.addValue(aForest, this.forest_trees, aTree);
        InstanceSpecification anotherTree = this.instantiate(this.instancePackage, (Classifier)this.tree);
        this.addValue(aForest, this.forest_trees, anotherTree);
        aTree = this.instantiate(this.instancePackage, (Classifier)this.tree);
        this.addValue(aForest, this.forest_trees, aTree);
        AssociationTest.assertTrue((boolean)this.check(expr, anotherTree));
    }

    public void test_associationEndAmbiguity_nonNavigable_194245() {
        this.expectModified = true;
        this.forest.createAssociation(true, AggregationKind.SHARED_LITERAL, "someTrees", 0, -1, (Type)this.tree, false, AggregationKind.SHARED_LITERAL, "forest", 0, 1);
        BasicEnvironment benv = (BasicEnvironment)OCLUtil.getAdapter((Environment)this.ocl.getEnvironment(), BasicEnvironment.class);
        benv.setOption((Option)ProblemOption.AMBIGUOUS_ASSOCIATION_ENDS, (Object)ProblemHandler.Severity.WARNING);
        this.parseConstraint("package ocltest context Tree inv: forest.trees->includes(self) endpackage");
        Diagnostic diag = this.ocl.getProblems();
        AssociationTest.assertNotNull((Object)diag);
        AssociationTest.assertEquals((int)2, (int)diag.getSeverity());
        AssociationTest.debugPrintln((String)("Got expected warning: " + diag.getMessage()));
    }

    public void test_associationEndAmbiguity_unnamed_194245() {
        this.expectModified = true;
        Property tree_forest = this.forest_trees.getOtherEnd();
        AssociationTest.assertNotNull((Object)tree_forest);
        AssociationTest.assertNotNull((Object)tree_forest.getName());
        tree_forest.setName(null);
        this.forest.createAssociation(true, AggregationKind.SHARED_LITERAL, "someTrees", 0, -1, (Type)this.tree, false, AggregationKind.SHARED_LITERAL, null, 0, 1);
        BasicEnvironment benv = (BasicEnvironment)OCLUtil.getAdapter((Environment)this.ocl.getEnvironment(), BasicEnvironment.class);
        benv.setOption((Option)ProblemOption.AMBIGUOUS_ASSOCIATION_ENDS, (Object)ProblemHandler.Severity.WARNING);
        this.parseConstraint("package ocltest context Tree inv: forest.trees->includes(self) endpackage");
        Diagnostic diag = this.ocl.getProblems();
        AssociationTest.assertNotNull((Object)diag);
        AssociationTest.assertEquals((int)2, (int)diag.getSeverity());
        AssociationTest.debugPrintln((String)("Got expected warning: " + diag.getMessage()));
    }

    public void test_associationEndAmbiguity_errorSeverity_194245() {
        this.expectModified = true;
        this.forest.createAssociation(true, AggregationKind.SHARED_LITERAL, "someTrees", 0, -1, (Type)this.tree, false, AggregationKind.SHARED_LITERAL, "forest", 0, 1);
        try {
            this.ocl.parse(new OCLInput("package ocltest context Tree inv: forest.trees->includes(self) endpackage"));
            AssociationTest.fail((String)"Should not have parsed");
        }
        catch (ParserException e) {
            AssociationTest.debugPrintln((String)("Got expected exception: " + e.getLocalizedMessage()));
        }
    }

    public void test_nonNavigableAttribute_inheritedAssociation_194245() {
        OCLExpression expr = this.parseConstraint("package UML context LiteralNull inv: not owningProperty.type.oclIsUndefined() endpackage");
        Package pkg = UMLFactory.eINSTANCE.createPackage();
        pkg.setName("pkg");
        Class a = pkg.createOwnedClass("A", false);
        Property foo = a.createOwnedAttribute("foo", null);
        LiteralNull nullVal = (LiteralNull)foo.createDefaultValue(null, null, UMLPackage.Literals.LITERAL_NULL);
        AssociationTest.assertFalse((boolean)this.check(expr, nullVal));
        foo.setType((Type)a);
        AssociationTest.assertTrue((boolean)this.check(expr, nullVal));
    }

    public void test_unnamedAttribute_inheritedAssociation_194245() {
        OCLExpression expr = this.parseConstraint("package UML context Class inv: instanceSpecification.classifier->excluding(self)->isEmpty() endpackage");
        Package pkg = UMLFactory.eINSTANCE.createPackage();
        pkg.setName("pkg");
        Class a = pkg.createOwnedClass("A", false);
        Class b = pkg.createOwnedClass("B", false);
        InstanceSpecification instance = (InstanceSpecification)pkg.createPackagedElement("anA", UMLPackage.Literals.INSTANCE_SPECIFICATION);
        instance.getClassifiers().add((Object)a);
        AssociationTest.assertTrue((boolean)this.check(expr, a));
        instance = (InstanceSpecification)pkg.createPackagedElement("anotherA", UMLPackage.Literals.INSTANCE_SPECIFICATION);
        instance.getClassifiers().add((Object)a);
        AssociationTest.assertTrue((boolean)this.check(expr, a));
        instance.getClassifiers().add((Object)b);
        AssociationTest.assertFalse((boolean)this.check(expr, a));
    }

    public void test_navigateFromAssociation() {
        ParsingOptions.setOption((Environment)this.ocl.getEnvironment(), (Option)UMLParsingOptions.ASSOCIATION_CLASS_TYPE, Association.class);
        InstanceSpecification aForest = this.instantiate(this.instancePackage, (Classifier)this.forest);
        this.setValue(aForest, this.forest_area, 1000);
        InstanceSpecification aTree = this.instantiate(this.instancePackage, (Classifier)this.tree);
        this.setValue(aTree, this.tree_height, 2);
        InstanceSpecification anotherTree = this.instantiate(this.instancePackage, (Classifier)this.tree);
        this.setValue(anotherTree, this.tree_height, 0);
        InstanceSpecification aLink = this.link(this.instancePackage, aForest, this.forest_trees, aTree, this.forest_trees.getOtherEnd(), this.forest_trees.getAssociation());
        InstanceSpecification anotherLink = this.link(this.instancePackage, aForest, this.forest_trees, anotherTree, this.forest_trees.getOtherEnd(), this.forest_trees.getAssociation());
        OCLExpression expr = this.parse("package ocltest context A_Forest_Tree inv: self.trees.height > 0 endpackage");
        AssociationTest.assertTrue((boolean)this.check(expr, aLink));
        AssociationTest.assertFalse((boolean)this.check(expr, anotherLink));
        expr = this.parse("package ocltest context A_Forest_Tree inv: self.forest.area > 1000 endpackage");
        AssociationTest.assertFalse((boolean)this.check(expr, aLink));
        AssociationTest.assertFalse((boolean)this.check(expr, anotherLink));
        this.setValue(aForest, this.forest_area, 1050);
        AssociationTest.assertTrue((boolean)this.check(expr, aLink));
        AssociationTest.assertTrue((boolean)this.check(expr, anotherLink));
    }

    public void test_classGeneralResolvesToNothing_251808() {
        try {
            AssociationTest.assertNull((String)"Should not find redefined property Classifier::general", (Object)((Environment.Lookup)OCLUtil.getAdapter((Environment)this.ocl.getEnvironment(), Environment.Lookup.class)).tryLookupProperty((Object)this.getMetaclass("Class"), "general"));
        }
        catch (AmbiguousLookupException e) {
            AssociationTest.fail((String)"Should not be an ambiguous look-up");
        }
        catch (LookupException e) {
            AssociationTest.fail((String)"Should not be a look-up exception");
        }
        this.parseConstraint("package UML context Class inv: self.oclAsType(Classifier).general->isEmpty() endpackage");
    }

    protected void setUp() {
        super.setUp();
        this.instanceResource = resourceSet.createResource(URI.createFileURI((String)"/tmp/instances.uml"));
        this.instancePackage = umlf.createPackage();
        this.instancePackage.setName("instances");
        this.instanceResource.getContents().add((Object)this.instancePackage);
    }
}

