/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.tests;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.ecore.tests.AbstractTestSuite;
import org.eclipse.ocl.ecore.tests.StatesTest;
import org.eclipse.ocl.expressions.AssociationClassCallExp;
import org.eclipse.ocl.expressions.BooleanLiteralExp;
import org.eclipse.ocl.expressions.CollectionItem;
import org.eclipse.ocl.expressions.CollectionLiteralExp;
import org.eclipse.ocl.expressions.CollectionLiteralPart;
import org.eclipse.ocl.expressions.EnumLiteralExp;
import org.eclipse.ocl.expressions.FeatureCallExp;
import org.eclipse.ocl.expressions.IfExp;
import org.eclipse.ocl.expressions.IntegerLiteralExp;
import org.eclipse.ocl.expressions.InvalidLiteralExp;
import org.eclipse.ocl.expressions.IterateExp;
import org.eclipse.ocl.expressions.IteratorExp;
import org.eclipse.ocl.expressions.LetExp;
import org.eclipse.ocl.expressions.LoopExp;
import org.eclipse.ocl.expressions.MessageExp;
import org.eclipse.ocl.expressions.NullLiteralExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.expressions.PropertyCallExp;
import org.eclipse.ocl.expressions.RealLiteralExp;
import org.eclipse.ocl.expressions.StateExp;
import org.eclipse.ocl.expressions.StringLiteralExp;
import org.eclipse.ocl.expressions.TupleLiteralExp;
import org.eclipse.ocl.expressions.TupleLiteralPart;
import org.eclipse.ocl.expressions.TypeExp;
import org.eclipse.ocl.expressions.UnspecifiedValueExp;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.expressions.VariableExp;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.lpg.AbstractParser;
import org.eclipse.ocl.lpg.ProblemHandler;
import org.eclipse.ocl.lpg.StringProblemHandler;
import org.eclipse.ocl.parser.OCLAnalyzer;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.ocl.utilities.AbstractVisitor;
import org.eclipse.ocl.utilities.CallingASTNode;
import org.eclipse.ocl.utilities.TypedASTNode;
import org.eclipse.ocl.utilities.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationInformationTest
extends AbstractTestSuite {
    public void test_invariant() {
        String exprString = "true implies self.color <> Color::black";
        OCLExpression<EClassifier> constraint = this.createQuery(this.apple, "true implies self.color <> Color::black");
        OperationCallExp<EClassifier, EOperation> impliesExp = LocationInformationTest.asOperationCall(constraint);
        LocationInformationTest.assertLocation(impliesExp, 0, "true implies self.color <> Color::black".length());
        BooleanLiteralExp<EClassifier> bl = LocationInformationTest.asBooleanLiteral(impliesExp.getSource());
        LocationInformationTest.assertLocation(bl, 0, "true".length());
        int selfPos = "true implies self.color <> Color::black".indexOf("self");
        OperationCallExp<EClassifier, EOperation> notEqualsExp = LocationInformationTest.asOperationCall(impliesExp.getArgument().get(0));
        LocationInformationTest.assertLocation(notEqualsExp, selfPos, "true implies self.color <> Color::black".length());
        PropertyCallExp<EClassifier, EStructuralFeature> attrCall = LocationInformationTest.asPropertyCall(notEqualsExp.getSource());
        LocationInformationTest.assertLocation(attrCall, selfPos, selfPos + "self.color".length());
        VariableExp<EClassifier, EParameter> selfVar = LocationInformationTest.asVariable(attrCall.getSource());
        LocationInformationTest.assertLocation(selfVar, selfPos, selfPos + "self".length());
        EnumLiteralExp<EClassifier, EEnumLiteral> enumLiteral = LocationInformationTest.asEnumLiteral(notEqualsExp.getArgument().get(0));
        LocationInformationTest.assertLocation(enumLiteral, "true implies self.color <> Color::black".indexOf("Color"), "true implies self.color <> Color::black".length());
    }

    public void test_query() {
        String exprString = "if false then 'Spy' else Set{'Spartan', 'GrannySmith', 'Macintosh'}->any(i : String | i <> '') endif";
        OCLExpression<EClassifier> constraint = this.createQuery(this.apple, "if false then 'Spy' else Set{'Spartan', 'GrannySmith', 'Macintosh'}->any(i : String | i <> '') endif");
        IfExp<EClassifier> ifExp = LocationInformationTest.asIf(constraint);
        LocationInformationTest.assertLocation(ifExp, 0, "if false then 'Spy' else Set{'Spartan', 'GrannySmith', 'Macintosh'}->any(i : String | i <> '') endif".length());
        int falsePos = "if false then 'Spy' else Set{'Spartan', 'GrannySmith', 'Macintosh'}->any(i : String | i <> '') endif".indexOf("false");
        BooleanLiteralExp<EClassifier> bl = LocationInformationTest.asBooleanLiteral(ifExp.getCondition());
        LocationInformationTest.assertLocation(bl, falsePos, falsePos + "false".length());
        int spyPos = "if false then 'Spy' else Set{'Spartan', 'GrannySmith', 'Macintosh'}->any(i : String | i <> '') endif".indexOf("'Spy'");
        StringLiteralExp<EClassifier> stringLiteral = LocationInformationTest.asStringLiteral(ifExp.getThenExpression());
        LocationInformationTest.assertLocation(stringLiteral, spyPos, spyPos + "'Spy'".length());
        IteratorExp<EClassifier, EParameter> anyIterator = LocationInformationTest.asIterator(ifExp.getElseExpression());
        LocationInformationTest.assertLocation(anyIterator, "if false then 'Spy' else Set{'Spartan', 'GrannySmith', 'Macintosh'}->any(i : String | i <> '') endif".indexOf("Set"), "if false then 'Spy' else Set{'Spartan', 'GrannySmith', 'Macintosh'}->any(i : String | i <> '') endif".indexOf("endif") - 1);
        Variable<EClassifier, EParameter> vdecl = LocationInformationTest.asVariableDeclaration(anyIterator.getIterator().get(0));
        LocationInformationTest.assertLocation(vdecl, "if false then 'Spy' else Set{'Spartan', 'GrannySmith', 'Macintosh'}->any(i : String | i <> '') endif".indexOf("i :"), "if false then 'Spy' else Set{'Spartan', 'GrannySmith', 'Macintosh'}->any(i : String | i <> '') endif".indexOf("|") - 1);
        OCLExpression anyBody = anyIterator.getBody();
        LocationInformationTest.assertLocation((ASTNode)anyBody, "if false then 'Spy' else Set{'Spartan', 'GrannySmith', 'Macintosh'}->any(i : String | i <> '') endif".indexOf("i <>"), "if false then 'Spy' else Set{'Spartan', 'GrannySmith', 'Macintosh'}->any(i : String | i <> '') endif".indexOf(")"));
        CollectionLiteralExp<EClassifier> collLiteral = LocationInformationTest.asCollectionLiteral(anyIterator.getSource());
        LocationInformationTest.assertLocation(collLiteral, "if false then 'Spy' else Set{'Spartan', 'GrannySmith', 'Macintosh'}->any(i : String | i <> '') endif".indexOf("Set"), "if false then 'Spy' else Set{'Spartan', 'GrannySmith', 'Macintosh'}->any(i : String | i <> '') endif".indexOf("->"));
        int grannyPos = "if false then 'Spy' else Set{'Spartan', 'GrannySmith', 'Macintosh'}->any(i : String | i <> '') endif".indexOf("'GrannySmith'");
        CollectionItem<EClassifier> item = LocationInformationTest.asCollectionItem(collLiteral.getPart().get(1));
        stringLiteral = LocationInformationTest.asStringLiteral(item.getItem());
        LocationInformationTest.assertLocation(stringLiteral, grannyPos, grannyPos + "'GrannySmith'".length());
    }

    public void test_postcondition() {
        String exprString = "let oldColor : Color = self.color@pre in oldColor <> self.color";
        OCLExpression<EClassifier> constraint = this.createPostcondition(this.fruit_ripen, "let oldColor : Color = self.color@pre in oldColor <> self.color");
        LetExp<EClassifier, EParameter> letExp = LocationInformationTest.asLet(constraint);
        LocationInformationTest.assertLocation(letExp, 0, "let oldColor : Color = self.color@pre in oldColor <> self.color".length());
        Variable vdecl = letExp.getVariable();
        LocationInformationTest.assertLocation((ASTNode)vdecl, "let oldColor : Color = self.color@pre in oldColor <> self.color".indexOf("oldColor :"), "let oldColor : Color = self.color@pre in oldColor <> self.color".indexOf(" in "));
        PropertyCallExp<EClassifier, EStructuralFeature> attrExp = LocationInformationTest.asPropertyCall(vdecl.getInitExpression());
        LocationInformationTest.assertLocation(attrExp, "let oldColor : Color = self.color@pre in oldColor <> self.color".indexOf("self"), "let oldColor : Color = self.color@pre in oldColor <> self.color".indexOf(" in "));
        OperationCallExp<EClassifier, EOperation> notEqualExp = LocationInformationTest.asOperationCall(letExp.getIn());
        LocationInformationTest.assertLocation(notEqualExp, "let oldColor : Color = self.color@pre in oldColor <> self.color".indexOf("oldColor <>"), "let oldColor : Color = self.color@pre in oldColor <> self.color".length());
    }

    public void test_parentheses() {
        String exprString = "( (true) implies ( (false) or ((true)) ) )";
        OCLExpression<EClassifier> constraint = this.createQuery(this.fruit, "( (true) implies ( (false) or ((true)) ) )");
        OperationCallExp<EClassifier, EOperation> operCall = LocationInformationTest.asOperationCall(constraint);
        LocationInformationTest.assertLocation(operCall, 0, "( (true) implies ( (false) or ((true)) ) )".length());
        BooleanLiteralExp<EClassifier> literal = LocationInformationTest.asBooleanLiteral(operCall.getSource());
        LocationInformationTest.assertLocation(literal, "( (true) implies ( (false) or ((true)) ) )".indexOf("(true) imp"), "( (true) implies ( (false) or ((true)) ) )".indexOf(" imp"));
        operCall = LocationInformationTest.asOperationCall(operCall.getArgument().get(0));
        LocationInformationTest.assertLocation(operCall, "( (true) implies ( (false) or ((true)) ) )".indexOf("( (false"), "( (true) implies ( (false) or ((true)) ) )".length() - 2);
        literal = LocationInformationTest.asBooleanLiteral(operCall.getSource());
        LocationInformationTest.assertLocation(literal, "( (true) implies ( (false) or ((true)) ) )".indexOf("(false) or"), "( (true) implies ( (false) or ((true)) ) )".indexOf(" or"));
        literal = LocationInformationTest.asBooleanLiteral(operCall.getArgument().get(0));
        LocationInformationTest.assertLocation(literal, "( (true) implies ( (false) or ((true)) ) )".indexOf("((true)) )"), "( (true) implies ( (false) or ((true)) ) )".length() - 4);
    }

    public void test_typePositions() {
        String exprString = "let isApple : Boolean = self.oclIsKindOf(Apple) in isApple implies Apple.allInstances()->includes(self.oclAsType(Apple))";
        OCLExpression<EClassifier> constraint = this.createQuery(this.fruit, "let isApple : Boolean = self.oclIsKindOf(Apple) in isApple implies Apple.allInstances()->includes(self.oclAsType(Apple))");
        LetExp<EClassifier, EParameter> letExp = LocationInformationTest.asLet(constraint);
        LocationInformationTest.assertLocation(letExp, 0, "let isApple : Boolean = self.oclIsKindOf(Apple) in isApple implies Apple.allInstances()->includes(self.oclAsType(Apple))".length());
        Variable vdecl = letExp.getVariable();
        LocationInformationTest.assertTypeLocation((TypedASTNode)vdecl, "let isApple : Boolean = self.oclIsKindOf(Apple) in isApple implies Apple.allInstances()->includes(self.oclAsType(Apple))".indexOf("Boolean"), "let isApple : Boolean = self.oclIsKindOf(Apple) in isApple implies Apple.allInstances()->includes(self.oclAsType(Apple))".indexOf(" = "));
        TypeExp<EClassifier> typeExp = LocationInformationTest.asType(LocationInformationTest.asOperationCall(vdecl.getInitExpression()).getArgument().get(0));
        LocationInformationTest.assertLocation(typeExp, "let isApple : Boolean = self.oclIsKindOf(Apple) in isApple implies Apple.allInstances()->includes(self.oclAsType(Apple))".indexOf("Apple) in "), "let isApple : Boolean = self.oclIsKindOf(Apple) in isApple implies Apple.allInstances()->includes(self.oclAsType(Apple))".indexOf(") in "));
        OperationCallExp<EClassifier, EOperation> operCall = LocationInformationTest.asOperationCall(LocationInformationTest.asOperationCall(letExp.getIn()).getArgument().get(0));
        operCall = LocationInformationTest.asOperationCall(operCall.getSource());
        typeExp = LocationInformationTest.asType(operCall.getSource());
        LocationInformationTest.assertLocation(typeExp, "let isApple : Boolean = self.oclIsKindOf(Apple) in isApple implies Apple.allInstances()->includes(self.oclAsType(Apple))".indexOf("Apple.all"), "let isApple : Boolean = self.oclIsKindOf(Apple) in isApple implies Apple.allInstances()->includes(self.oclAsType(Apple))".indexOf(".all"));
    }

    public void test_elementTypePositions() {
        String exprString = "let allApples : Set(Apple) = Apple.allInstances() in allApples->includes(self)";
        OCLExpression<EClassifier> constraint = this.createQuery(this.apple, "let allApples : Set(Apple) = Apple.allInstances() in allApples->includes(self)");
        LetExp<EClassifier, EParameter> letExp = LocationInformationTest.asLet(constraint);
        LocationInformationTest.assertLocation(letExp, 0, "let allApples : Set(Apple) = Apple.allInstances() in allApples->includes(self)".length());
        Variable vdecl = letExp.getVariable();
        LocationInformationTest.assertTypeLocation((TypedASTNode)vdecl, "let allApples : Set(Apple) = Apple.allInstances() in allApples->includes(self)".indexOf("Set("), "let allApples : Set(Apple) = Apple.allInstances() in allApples->includes(self)".indexOf(" = "));
        CollectionType collType = (CollectionType)vdecl.getType();
        LocationInformationTest.assertTypeLocation((TypedASTNode)collType, "let allApples : Set(Apple) = Apple.allInstances() in allApples->includes(self)".indexOf("Apple) = "), "let allApples : Set(Apple) = Apple.allInstances() in allApples->includes(self)".indexOf(") = "));
    }

    public void test_propertyPositions_operationCall() {
        String exprString = "Apple.allInstances()->includes(self)";
        OCLExpression<EClassifier> constraint = this.createQuery(this.apple, "Apple.allInstances()->includes(self)");
        OperationCallExp<EClassifier, EOperation> includesExp = LocationInformationTest.asOperationCall(constraint);
        LocationInformationTest.assertPropertyLocation(includesExp, "Apple.allInstances()->includes(self)".indexOf("includes"), "Apple.allInstances()->includes(self)".indexOf("(self)"));
        FeatureCallExp<EClassifier> mpcExp = LocationInformationTest.asFeatureCall(includesExp.getSource());
        LocationInformationTest.assertPropertyLocation(mpcExp, "Apple.allInstances()->includes(self)".indexOf("allInst"), "Apple.allInstances()->includes(self)".indexOf("()"));
    }

    public void test_propertyPositions_attributeCall() {
        String exprString = "not ripen(self. color )";
        OCLExpression<EClassifier> constraint = this.createQuery(this.apple, "not ripen(self. color )");
        OperationCallExp<EClassifier, EOperation> notExp = LocationInformationTest.asOperationCall(constraint);
        OperationCallExp<EClassifier, EOperation> ripenExp = LocationInformationTest.asOperationCall(notExp.getSource());
        FeatureCallExp<EClassifier> mpcExp = LocationInformationTest.asFeatureCall(ripenExp.getArgument().get(0));
        LocationInformationTest.assertPropertyLocation(mpcExp, "not ripen(self. color )".indexOf("color "), "not ripen(self. color )".indexOf(" )"));
    }

    public void test_propertyPositions_associationEndCall() {
        String exprString = "self.stem->notEmpty()";
        OCLExpression<EClassifier> constraint = this.createQuery(this.apple, "self.stem->notEmpty()");
        OperationCallExp<EClassifier, EOperation> notEmptyExp = LocationInformationTest.asOperationCall(constraint);
        CollectionLiteralExp<EClassifier> setExp = LocationInformationTest.asCollectionLiteral(notEmptyExp.getSource());
        FeatureCallExp<EClassifier> mpcExp = LocationInformationTest.asFeatureCall(((CollectionItem)setExp.getPart().get(0)).getItem());
        LocationInformationTest.assertPropertyLocation(mpcExp, "self.stem->notEmpty()".indexOf("stem"), "self.stem->notEmpty()".indexOf("->"));
    }

    public void test_propertyPositions_implicitCollect() {
        String exprString = "orderedSet.color->asSet()->size() = 1";
        OCLExpression<EClassifier> constraint = this.createQuery((EClass)((EPackage)this.fruitPackage).getEClassifier("FruitUtil"), "orderedSet.color->asSet()->size() = 1");
        OperationCallExp<EClassifier, EOperation> eqExp = LocationInformationTest.asOperationCall(constraint);
        OperationCallExp<EClassifier, EOperation> sizeExp = LocationInformationTest.asOperationCall(eqExp.getSource());
        OperationCallExp<EClassifier, EOperation> asSetExp = LocationInformationTest.asOperationCall(sizeExp.getSource());
        IteratorExp<EClassifier, EParameter> iterExp = LocationInformationTest.asIterator(asSetExp.getSource());
        FeatureCallExp<EClassifier> mpcExp = LocationInformationTest.asFeatureCall(iterExp.getBody());
        LocationInformationTest.assertPropertyLocation(mpcExp, "orderedSet.color->asSet()->size() = 1".indexOf("color"), "orderedSet.color->asSet()->size() = 1".indexOf("->asSet"));
    }

    public void test_referencePositions_implicitCollect() {
        String exprString = "Apple.allInstances().stem->asSet()->size() > 1";
        OCLExpression<EClassifier> constraint = this.createQuery(this.apple, "Apple.allInstances().stem->asSet()->size() > 1");
        OperationCallExp<EClassifier, EOperation> eqExp = LocationInformationTest.asOperationCall(constraint);
        OperationCallExp<EClassifier, EOperation> sizeExp = LocationInformationTest.asOperationCall(eqExp.getSource());
        OperationCallExp<EClassifier, EOperation> asSetExp = LocationInformationTest.asOperationCall(sizeExp.getSource());
        IteratorExp<EClassifier, EParameter> iterExp = LocationInformationTest.asIterator(asSetExp.getSource());
        FeatureCallExp<EClassifier> mpcExp = LocationInformationTest.asFeatureCall(iterExp.getBody());
        LocationInformationTest.assertPropertyLocation(mpcExp, "Apple.allInstances().stem->asSet()->size() > 1".indexOf("stem"), "Apple.allInstances().stem->asSet()->size() > 1".indexOf("->asSet"));
    }

    public void test_messageExp_positions() {
        String exprString = "self^ripen(? : Color)";
        OCLExpression<EClassifier> constraint = this.createQuery(this.fruit, "self^ripen(? : Color)");
        MessageExp<EClassifier, ?, ?> msgExp = LocationInformationTest.asMessage(constraint);
        LocationInformationTest.assertLocation(msgExp, 0, "self^ripen(? : Color)".length());
        LocationInformationTest.assertPropertyLocation(msgExp, "self^ripen(? : Color)".indexOf("ripen"), "self^ripen(? : Color)".indexOf("("));
        VariableExp<EClassifier, EParameter> var = LocationInformationTest.asVariable(msgExp.getTarget());
        LocationInformationTest.assertLocation(var, 0, "self^ripen(? : Color)".indexOf("^"));
        UnspecifiedValueExp<EClassifier> unspecExp = LocationInformationTest.asUnspecifiedValue(msgExp.getArgument().get(0));
        LocationInformationTest.assertLocation(unspecExp, "self^ripen(? : Color)".indexOf("?"), "self^ripen(? : Color)".indexOf(")"));
        LocationInformationTest.assertTypeLocation(unspecExp, "self^ripen(? : Color)".indexOf("Color"), "self^ripen(? : Color)".indexOf(")"));
    }

    public void test_stateExp_positions() {
        String exprString = "self.oclIsInState(Bad::Rotten)";
        OCLExpression<EClassifier> constraint = this.createQuery((EnvironmentFactory<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject>)new StatesTest.StatefulFruitEnvironmentFactory(this), (EClassifier)this.apple, "self.oclIsInState(Bad::Rotten)");
        OperationCallExp<EClassifier, EOperation> callExp = LocationInformationTest.asOperationCall(constraint);
        LocationInformationTest.assertLocation(callExp, 0, "self.oclIsInState(Bad::Rotten)".length());
        StateExp<EClassifier, ?> state = LocationInformationTest.asState(callExp.getArgument().get(0));
        LocationInformationTest.assertLocation(state, "self.oclIsInState(Bad::Rotten)".indexOf("Bad"), "self.oclIsInState(Bad::Rotten)".indexOf(")"));
    }

    public void test_atPrePosition() {
        this.checkDocumentWithAnalyzeFailureAt("package ecore context EPackage::getEClassifier(name : String) : post: name = name@pre endpackage", OCLMessages.IllegalAtPre_ERROR_, "@pre");
    }

    protected void checkDocumentWithAnalyzeFailureAt(final String oclText, final String failure, final String subText) {
        OCLAnalyzer analyzer = this.ocl.createAnalyzer(oclText);
        StringProblemHandler problemHandler = new StringProblemHandler((AbstractParser)analyzer.getAbstractParser()){

            public void handleProblem(ProblemHandler.Severity problemSeverity, ProblemHandler.Phase processingPhase, String problemMessage, String processingContext, int startOffset, int endOffset) {
                int expectedStart = oclText.indexOf(subText);
                int expectedEnd = expectedStart + subText.length() - 1;
                LocationInformationTest.assertEquals((String)failure, (String)problemMessage);
                LocationInformationTest.assertEquals((int)expectedStart, (int)startOffset);
                LocationInformationTest.assertEquals((int)expectedEnd, (int)endOffset);
                super.handleProblem(problemSeverity, processingPhase, problemMessage, processingContext, startOffset, endOffset);
            }
        };
        analyzer.getEnvironment().setProblemHandler((ProblemHandler)problemHandler);
        try {
            ArrayList result = new ArrayList();
            analyzer.parseOCLDocument(result);
            LocationInformationTest.assertEquals((int)1, (int)problemHandler.getProblemCount());
        }
        catch (Exception e) {
            LocationInformationTest.fail((String)e.getLocalizedMessage());
        }
    }

    protected OCLExpression<EClassifier> createQuery(EClass context, String text) {
        OCLExpression result = super.createQuery((EObject)context, text);
        LocationInformationTest.assertAllPositionsSet((OCLExpression<EClassifier>)result);
        return result;
    }

    protected OCLExpression<EClassifier> createQuery(EnvironmentFactory<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> envFactory, EClassifier context, String text) {
        OCLExpression result = super.createQuery(envFactory, (EObject)context, text);
        LocationInformationTest.assertAllPositionsSet((OCLExpression<EClassifier>)result);
        return result;
    }

    protected OCLExpression<EClassifier> createInvariant(EClassifier context, String text) {
        OCLExpression result = super.createInvariant((EObject)context, text);
        LocationInformationTest.assertAllPositionsSet((OCLExpression<EClassifier>)result);
        return result;
    }

    protected OCLExpression<EClassifier> createPrecondition(EOperation context, String text) {
        OCLExpression result = super.createPrecondition((EObject)context, text);
        LocationInformationTest.assertAllPositionsSet((OCLExpression<EClassifier>)result);
        return result;
    }

    protected OCLExpression<EClassifier> createPostcondition(EOperation context, String text) {
        OCLExpression result = super.createPostcondition((EObject)context, text);
        LocationInformationTest.assertAllPositionsSet((OCLExpression<EClassifier>)result);
        return result;
    }

    protected OCLExpression<EClassifier> createBodyCondition(EOperation context, String text) {
        OCLExpression result = super.createBodyCondition((EObject)context, text);
        LocationInformationTest.assertAllPositionsSet((OCLExpression<EClassifier>)result);
        return result;
    }

    static IfExp<EClassifier> asIf(Object obj) {
        return (IfExp)LocationInformationTest.cast(obj, IfExp.class);
    }

    static EnumLiteralExp<EClassifier, EEnumLiteral> asEnumLiteral(Object obj) {
        return (EnumLiteralExp)LocationInformationTest.cast(obj, EnumLiteralExp.class);
    }

    static VariableExp<EClassifier, EParameter> asVariable(Object obj) {
        return (VariableExp)LocationInformationTest.cast(obj, VariableExp.class);
    }

    static LetExp<EClassifier, EParameter> asLet(Object obj) {
        return (LetExp)LocationInformationTest.cast(obj, LetExp.class);
    }

    static LoopExp<EClassifier, EParameter> asLoop(Object obj) {
        return (LoopExp)LocationInformationTest.cast(obj, LoopExp.class);
    }

    static IteratorExp<EClassifier, EParameter> asIterator(Object obj) {
        return (IteratorExp)LocationInformationTest.cast(obj, IteratorExp.class);
    }

    static PropertyCallExp<EClassifier, EStructuralFeature> asPropertyCall(Object obj) {
        return (PropertyCallExp)LocationInformationTest.cast(obj, PropertyCallExp.class);
    }

    static FeatureCallExp<EClassifier> asFeatureCall(Object obj) {
        return (FeatureCallExp)LocationInformationTest.cast(obj, FeatureCallExp.class);
    }

    static AssociationClassCallExp<EClassifier, EStructuralFeature> asAssociationClassCall(Object obj) {
        return (AssociationClassCallExp)LocationInformationTest.cast(obj, AssociationClassCallExp.class);
    }

    static OperationCallExp<EClassifier, EOperation> asOperationCall(Object obj) {
        return (OperationCallExp)LocationInformationTest.cast(obj, OperationCallExp.class);
    }

    static BooleanLiteralExp<EClassifier> asBooleanLiteral(Object obj) {
        return (BooleanLiteralExp)LocationInformationTest.cast(obj, BooleanLiteralExp.class);
    }

    static StringLiteralExp<EClassifier> asStringLiteral(Object obj) {
        return (StringLiteralExp)LocationInformationTest.cast(obj, StringLiteralExp.class);
    }

    static CollectionLiteralExp<EClassifier> asCollectionLiteral(Object obj) {
        return (CollectionLiteralExp)LocationInformationTest.cast(obj, CollectionLiteralExp.class);
    }

    static CollectionItem<EClassifier> asCollectionItem(Object obj) {
        return (CollectionItem)LocationInformationTest.cast(obj, CollectionItem.class);
    }

    static Variable<EClassifier, EParameter> asVariableDeclaration(Object obj) {
        return (Variable)LocationInformationTest.cast(obj, Variable.class);
    }

    static StateExp<EClassifier, ?> asState(Object obj) {
        return (StateExp)LocationInformationTest.cast(obj, StateExp.class);
    }

    static TypeExp<EClassifier> asType(Object obj) {
        return (TypeExp)LocationInformationTest.cast(obj, TypeExp.class);
    }

    static MessageExp<EClassifier, ?, ?> asMessage(Object obj) {
        return (MessageExp)LocationInformationTest.cast(obj, MessageExp.class);
    }

    static UnspecifiedValueExp<EClassifier> asUnspecifiedValue(Object obj) {
        return (UnspecifiedValueExp)LocationInformationTest.cast(obj, UnspecifiedValueExp.class);
    }

    static <T> T cast(Object obj, Class<?> expectedClass) {
        LocationInformationTest.assertTrue((String)("Expected type: " + expectedClass + ", got: " + obj.getClass()), (boolean)expectedClass.isInstance(obj));
        return (T)obj;
    }

    static void assertAllPositionsSet(OCLExpression<EClassifier> expr) {
        LocationInformationTest.assertNotNull(expr);
        expr.accept((Visitor)LocationVerifier.INSTANCE);
    }

    static void assertLocation(ASTNode node, int start, int end) {
        LocationInformationTest.assertEquals((String)"Wrong start position", (int)start, (int)node.getStartPosition());
        LocationInformationTest.assertEquals((String)"Wrong end position", (int)end, (int)node.getEndPosition());
    }

    static void assertTypeLocation(TypedASTNode node, int start, int end) {
        LocationInformationTest.assertEquals((String)"Wrong type start position", (int)start, (int)node.getTypeStartPosition());
        LocationInformationTest.assertEquals((String)"Wrong type end position", (int)end, (int)node.getTypeEndPosition());
    }

    static void assertPropertyLocation(CallingASTNode node, int start, int end) {
        LocationInformationTest.assertEquals((String)"Wrong property start position", (int)start, (int)node.getPropertyStartPosition());
        LocationInformationTest.assertEquals((String)"Wrong property end position", (int)end, (int)node.getPropertyEndPosition());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocationVerifier
    extends AbstractVisitor<Object, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint> {
        static LocationVerifier INSTANCE = new LocationVerifier();

        private LocationVerifier() {
        }

        private boolean isExempt(OCLExpression<EClassifier> expr) {
            if (expr instanceof VariableExp) {
                return this.isImplicit((Variable<EClassifier, EParameter>)((VariableExp)expr).getReferredVariable());
            }
            return expr instanceof CollectionLiteralExp || expr instanceof CollectionLiteralPart;
        }

        private boolean isImplicit(Variable<EClassifier, EParameter> vdecl) {
            String name = vdecl.getName();
            return name == null || name.equals("self") || name.startsWith("temp");
        }

        private void assertPositions(OCLExpression<EClassifier> expr) {
            if (!this.isExempt(expr)) {
                LocationInformationTest.assertFalse((String)("Start not set: " + expr), (expr.getStartPosition() < 0 ? 1 : 0) != 0);
                LocationInformationTest.assertFalse((String)("End not set: " + expr), (expr.getEndPosition() < 0 ? 1 : 0) != 0);
                LocationInformationTest.assertTrue((String)("End not after start: " + expr), (expr.getEndPosition() > expr.getStartPosition() ? 1 : 0) != 0);
            }
        }

        private void assertPositions(Variable<EClassifier, EParameter> vdecl) {
            if (!this.isImplicit(vdecl)) {
                LocationInformationTest.assertFalse((String)("Start not set: " + vdecl), (vdecl.getStartPosition() < 0 ? 1 : 0) != 0);
                LocationInformationTest.assertFalse((String)("End not set: " + vdecl), (vdecl.getEndPosition() < 0 ? 1 : 0) != 0);
                LocationInformationTest.assertTrue((String)("End not after start: " + vdecl), (vdecl.getEndPosition() > vdecl.getStartPosition() ? 1 : 0) != 0);
            }
        }

        private void assertPositions(TupleLiteralPart<EClassifier, EStructuralFeature> tp) {
            LocationInformationTest.assertFalse((String)("Start not set: " + tp), (tp.getStartPosition() < 0 ? 1 : 0) != 0);
            LocationInformationTest.assertFalse((String)("End not set: " + tp), (tp.getEndPosition() < 0 ? 1 : 0) != 0);
            LocationInformationTest.assertTrue((String)("End not after start: " + tp), (tp.getEndPosition() > tp.getStartPosition() ? 1 : 0) != 0);
        }

        public Object visitOperationCallExp(OperationCallExp<EClassifier, EOperation> oc) {
            this.assertPositions((OCLExpression<EClassifier>)oc);
            return super.visitOperationCallExp(oc);
        }

        public Object visitVariableExp(VariableExp<EClassifier, EParameter> v) {
            this.assertPositions((OCLExpression<EClassifier>)v);
            return super.visitVariableExp(v);
        }

        public Object visitPropertyCallExp(PropertyCallExp<EClassifier, EStructuralFeature> pc) {
            this.assertPositions((OCLExpression<EClassifier>)pc);
            return super.visitPropertyCallExp(pc);
        }

        public Object visitAssociationClassCallExp(AssociationClassCallExp<EClassifier, EStructuralFeature> ac) {
            this.assertPositions((OCLExpression<EClassifier>)ac);
            return super.visitAssociationClassCallExp(ac);
        }

        public Object visitVariable(Variable<EClassifier, EParameter> vd) {
            if (!"self".equals(vd.getName())) {
                this.assertPositions(vd);
            }
            return super.visitVariable(vd);
        }

        public Object visitIfExp(IfExp<EClassifier> i) {
            this.assertPositions((OCLExpression<EClassifier>)i);
            return super.visitIfExp(i);
        }

        public Object visitTypeExp(TypeExp<EClassifier> t) {
            this.assertPositions((OCLExpression<EClassifier>)t);
            return null;
        }

        public Object visitUnspecifiedValueExp(UnspecifiedValueExp<EClassifier> uv) {
            this.assertPositions((OCLExpression<EClassifier>)uv);
            return null;
        }

        public Object visitStateExp(StateExp<EClassifier, EObject> s) {
            this.assertPositions((OCLExpression<EClassifier>)s);
            return null;
        }

        public Object visitMessageExp(MessageExp<EClassifier, CallOperationAction, SendSignalAction> m) {
            this.assertPositions((OCLExpression<EClassifier>)m);
            return super.visitMessageExp(m);
        }

        public Object visitIntegerLiteralExp(IntegerLiteralExp<EClassifier> il) {
            this.assertPositions((OCLExpression<EClassifier>)il);
            return null;
        }

        public Object visitRealLiteralExp(RealLiteralExp<EClassifier> rl) {
            this.assertPositions((OCLExpression<EClassifier>)rl);
            return null;
        }

        public Object visitStringLiteralExp(StringLiteralExp<EClassifier> sl) {
            this.assertPositions((OCLExpression<EClassifier>)sl);
            return null;
        }

        public Object visitBooleanLiteralExp(BooleanLiteralExp<EClassifier> bl) {
            this.assertPositions((OCLExpression<EClassifier>)bl);
            return null;
        }

        public Object visitTupleLiteralExp(TupleLiteralExp<EClassifier, EStructuralFeature> tl) {
            this.assertPositions((OCLExpression<EClassifier>)tl);
            return super.visitTupleLiteralExp(tl);
        }

        public Object visitTupleLiteralPart(TupleLiteralPart<EClassifier, EStructuralFeature> tp) {
            this.assertPositions(tp);
            return super.visitTupleLiteralPart(tp);
        }

        public Object visitLetExp(LetExp<EClassifier, EParameter> l) {
            this.assertPositions((OCLExpression<EClassifier>)l);
            return super.visitLetExp(l);
        }

        public Object visitEnumLiteralExp(EnumLiteralExp<EClassifier, EEnumLiteral> el) {
            this.assertPositions((OCLExpression<EClassifier>)el);
            return null;
        }

        public Object visitCollectionLiteralExp(CollectionLiteralExp<EClassifier> cl) {
            this.assertPositions((OCLExpression<EClassifier>)cl);
            return super.visitCollectionLiteralExp(cl);
        }

        public Object visitIteratorExp(IteratorExp<EClassifier, EParameter> ie) {
            this.assertPositions((OCLExpression<EClassifier>)ie);
            return super.visitIteratorExp(ie);
        }

        public Object visitIterateExp(IterateExp<EClassifier, EParameter> ie) {
            this.assertPositions((OCLExpression<EClassifier>)ie);
            return super.visitIterateExp(ie);
        }

        public Object visitInvalidLiteralExp(InvalidLiteralExp<EClassifier> il) {
            this.assertPositions((OCLExpression<EClassifier>)il);
            return null;
        }

        public Object visitNullLiteralExp(NullLiteralExp<EClassifier> il) {
            this.assertPositions((OCLExpression<EClassifier>)il);
            return null;
        }
    }
}

