/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.build.analysis;

import java.util.Comparator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.build.analysis.GrammarAnalysis;
import org.eclipse.ocl.examples.xtext.serializer.GrammarRuleValue;
import org.eclipse.ocl.examples.xtext.serializer.Indexed;
import org.eclipse.ocl.examples.xtext.serializer.Nameable;
import org.eclipse.ocl.examples.xtext.serializer.SerializationUtils;
import org.eclipse.ocl.examples.xtext.serializer.ToDebugString;
import org.eclipse.xtext.AbstractRule;

public abstract class AbstractRuleAnalysis
implements Indexed,
Nameable,
ToDebugString.ToDebugStringable {
    protected final @NonNull GrammarAnalysis grammarAnalysis;
    protected final int index;
    protected final @NonNull AbstractRule abstractRule;
    protected final @NonNull String qualifiedName;
    private final @NonNull ToDebugString toDebugSring = new ToDebugString(this){};

    public AbstractRuleAnalysis(@NonNull GrammarAnalysis grammarAnalysis, int index, @NonNull AbstractRule abstractRule) {
        this.grammarAnalysis = grammarAnalysis;
        this.index = index;
        this.abstractRule = abstractRule;
        String grammarName = SerializationUtils.getEContainingGrammar((EObject)abstractRule).getName();
        int dotIndex = grammarName.lastIndexOf(46);
        if (dotIndex >= 0) {
            grammarName = grammarName.substring(dotIndex + 1);
        }
        this.qualifiedName = String.valueOf(grammarName) + "::" + SerializationUtils.getName((AbstractRule)abstractRule);
    }

    public abstract @Nullable GrammarRuleValue basicGetRuleValue();

    public @NonNull GrammarAnalysis getGrammarAnalysis() {
        return this.grammarAnalysis;
    }

    public int getIndex() {
        return this.index;
    }

    public @NonNull String getName() {
        return SerializationUtils.getName((AbstractRule)this.abstractRule);
    }

    public @NonNull String getQualifiedName() {
        return this.qualifiedName;
    }

    public @NonNull AbstractRule getRule() {
        return this.abstractRule;
    }

    public abstract @NonNull GrammarRuleValue getRuleValue();

    public void toDebugString(@NonNull StringBuilder s, int depth) {
        s.append(this.toString());
    }

    public @NonNull String toString() {
        return this.getName();
    }

    public static final class QualifiedNameableComparator
    implements Comparator<AbstractRuleAnalysis> {
        public static final @NonNull QualifiedNameableComparator INSTANCE = new QualifiedNameableComparator();

        @Override
        public int compare(@NonNull AbstractRuleAnalysis o1, @NonNull AbstractRuleAnalysis o2) {
            String n1 = o1.getQualifiedName();
            String n2 = o2.getQualifiedName();
            return SerializationUtils.safeCompareTo((Comparable)((Object)n1), (Comparable)((Object)n2));
        }
    }
}

