/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.tests;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.EvaluationVisitor;
import org.eclipse.ocl.LookupException;
import org.eclipse.ocl.OCLInput;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.SemanticException;
import org.eclipse.ocl.TypeResolver;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.EnvironmentWithHiddenOpposites;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.ecore.tests.AbstractTestSuite;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.helper.OCLSyntaxHelper;
import org.eclipse.ocl.parser.AbstractOCLParser;
import org.eclipse.ocl.parser.OCLAnalyzer;
import org.eclipse.ocl.parser.OCLFactoryWithHistory;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.utilities.OCLFactory;
import org.eclipse.ocl.utilities.TypedElement;
import org.eclipse.ocl.utilities.UMLReflection;
import org.eclipse.ocl.utilities.Visitor;

public class ExtensibilityTest
extends AbstractTestSuite {
    public void test_noAdapters_parseSuccessfully() {
        this.helper.setContext((Object)EcorePackage.Literals.EPACKAGE);
        try {
            this.helper.createInvariant("not self.eClassifiers->isEmpty()");
        }
        catch (ParserException e) {
            ExtensibilityTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
        try {
            this.ocl.parse(new OCLInput("context ecore::EPackage\ninv: not self.eClassifiers->isEmpty()"));
        }
        catch (ParserException e) {
            ExtensibilityTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
    }

    public void test_noAdapters_parseWithWarning() {
        Diagnostic diag;
        this.helper.setContext((Object)EcorePackage.Literals.EPACKAGE);
        try {
            this.helper.createInvariant("not self.\"eClassifiers\"->isEmpty()");
            diag = this.helper.getProblems();
            ExtensibilityTest.assertNotNull((Object)diag);
            ExtensibilityTest.assertEquals((int)2, (int)diag.getSeverity());
            ExtensibilityTest.debugPrintln((String)("Got expected warning: " + diag.getMessage()));
        }
        catch (ParserException e) {
            ExtensibilityTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
        try {
            this.ocl.parse(new OCLInput("context ecore::EPackage\ninv: not self.\"eClassifiers\"->isEmpty()"));
            diag = this.ocl.getProblems();
            ExtensibilityTest.assertNotNull((Object)diag);
            ExtensibilityTest.assertEquals((int)2, (int)diag.getSeverity());
            ExtensibilityTest.debugPrintln((String)("Got expected warning: " + diag.getMessage()));
        }
        catch (ParserException e) {
            ExtensibilityTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
    }

    public void test_noAdapters_parseWithError() {
        this.helper.setContext((Object)EcorePackage.Literals.EPACKAGE);
        try {
            this.helper.createInvariant("not self.classifiers->isEmpty()");
            ExtensibilityTest.fail((String)"Should not have parsed");
        }
        catch (ParserException e) {
            ExtensibilityTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        try {
            this.ocl.parse(new OCLInput("context ecore::EPackage\ninv: not self.classifiers->isEmpty()"));
            ExtensibilityTest.fail((String)"Should not have parsed");
        }
        catch (ParserException e) {
            ExtensibilityTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
    }

    public void test_noAdapters_parseWithTokenError() {
        this.helper.setContext((Object)EcorePackage.Literals.EPACKAGE);
        try {
            this.helper.createInvariant("not self.;->isEmpty()");
            ExtensibilityTest.fail((String)"Should not have parsed");
        }
        catch (ParserException e) {
            ExtensibilityTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        try {
            this.ocl.parse(new OCLInput("context ecore::EPackage\ninv: not self.;->isEmpty()"));
            ExtensibilityTest.fail((String)"Should not have parsed");
        }
        catch (ParserException e) {
            ExtensibilityTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
    }

    protected OCL createOCL() {
        return OCL.newInstance((EnvironmentFactory)new WrapperEnvironmentFactory());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WrapperEnvironment
    implements EnvironmentWithHiddenOpposites {
        private final EnvironmentWithHiddenOpposites delegate;
        private final EnvironmentWithHiddenOpposites parent;
        private final WrapperEnvironmentFactory factory;

        WrapperEnvironment(WrapperEnvironmentFactory factory, Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> delegate) {
            this(factory, delegate, null);
        }

        WrapperEnvironment(WrapperEnvironmentFactory factory, Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> delegate, Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> parent) {
            this.factory = factory;
            this.delegate = (EnvironmentWithHiddenOpposites)delegate;
            this.parent = (EnvironmentWithHiddenOpposites)parent;
        }

        public Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> getParent() {
            return this.parent;
        }

        public EnvironmentFactory<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> getFactory() {
            return this.factory;
        }

        public boolean addElement(String name, Variable<EClassifier, EParameter> elem, boolean explicit) {
            return this.delegate.addElement(name, elem, explicit);
        }

        public EStructuralFeature defineAttribute(EClassifier owner, Variable<EClassifier, EParameter> variable, Constraint constraint) {
            return (EStructuralFeature)this.delegate.defineAttribute((Object)owner, variable, (Object)constraint);
        }

        public EOperation defineOperation(EClassifier owner, String name, EClassifier type, List<Variable<EClassifier, EParameter>> params, Constraint constraint) {
            return (EOperation)this.delegate.defineOperation((Object)owner, name, (Object)type, params, (Object)constraint);
        }

        public void deleteElement(String name) {
            this.delegate.deleteElement(name);
        }

        public List<EStructuralFeature> getAdditionalAttributes(EClassifier classifier) {
            return this.delegate.getAdditionalAttributes((Object)classifier);
        }

        public List<EOperation> getAdditionalOperations(EClassifier classifier) {
            return this.delegate.getAdditionalOperations((Object)classifier);
        }

        public Constraint getBodyCondition(EOperation operation) {
            return (Constraint)this.delegate.getBodyCondition((Object)operation);
        }

        public EClassifier getContextClassifier() {
            return (EClassifier)this.delegate.getContextClassifier();
        }

        public EOperation getContextOperation() {
            return (EOperation)this.delegate.getContextOperation();
        }

        public EPackage getContextPackage() {
            return (EPackage)this.delegate.getContextPackage();
        }

        public EStructuralFeature getContextProperty() {
            return (EStructuralFeature)this.delegate.getContextProperty();
        }

        public Constraint getDefinition(Object feature) {
            return (Constraint)this.delegate.getDefinition(feature);
        }

        public Constraint getDeriveConstraint(EStructuralFeature property) {
            return (Constraint)this.delegate.getDeriveConstraint((Object)property);
        }

        public Constraint getInitConstraint(EStructuralFeature property) {
            return (Constraint)this.delegate.getInitConstraint((Object)property);
        }

        public OCLFactory getOCLFactory() {
            return this.delegate.getOCLFactory();
        }

        public OCLStandardLibrary<EClassifier> getOCLStandardLibrary() {
            return this.delegate.getOCLStandardLibrary();
        }

        public Variable<EClassifier, EParameter> getSelfVariable() {
            return this.delegate.getSelfVariable();
        }

        public List<EObject> getStates(EClassifier owner, List<String> pathPrefix) {
            return this.delegate.getStates((Object)owner, pathPrefix);
        }

        public TypeResolver<EClassifier, EOperation, EStructuralFeature> getTypeResolver() {
            return this.delegate.getTypeResolver();
        }

        public UMLReflection<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint> getUMLReflection() {
            return this.delegate.getUMLReflection();
        }

        public Collection<Variable<EClassifier, EParameter>> getVariables() {
            return this.delegate.getVariables();
        }

        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        public boolean isInPostcondition(OCLExpression<EClassifier> exp) {
            return this.delegate.isInPostcondition(exp);
        }

        public Variable<EClassifier, EParameter> lookup(String name) {
            return this.delegate.lookup(name);
        }

        public EClassifier lookupAssociationClassReference(EClassifier owner, String name) {
            return (EClassifier)this.delegate.lookupAssociationClassReference((Object)owner, name);
        }

        public EClassifier lookupClassifier(List<String> names) {
            return (EClassifier)this.delegate.lookupClassifier(names);
        }

        public Variable<EClassifier, EParameter> lookupImplicitSourceForAssociationClass(String name) {
            return this.delegate.lookupImplicitSourceForAssociationClass(name);
        }

        public Variable<EClassifier, EParameter> lookupImplicitSourceForOperation(String name, List<? extends TypedElement<EClassifier>> args) {
            return this.delegate.lookupImplicitSourceForOperation(name, args);
        }

        public Variable<EClassifier, EParameter> lookupImplicitSourceForProperty(String name) {
            return this.delegate.lookupImplicitSourceForProperty(name);
        }

        public Variable<EClassifier, EParameter> lookupImplicitSourceForSignal(String name, List<? extends TypedElement<EClassifier>> args) {
            return this.delegate.lookupImplicitSourceForSignal(name, args);
        }

        public Variable<EClassifier, EParameter> lookupImplicitSourceForState(List<String> path) throws LookupException, SemanticException {
            return this.delegate.lookupImplicitSourceForState(path);
        }

        public Variable<EClassifier, EParameter> lookupLocal(String name) {
            return this.delegate.lookupLocal(name);
        }

        public EOperation lookupOperation(EClassifier owner, String name, List<? extends TypedElement<EClassifier>> args) {
            return (EOperation)this.delegate.lookupOperation((Object)owner, name, args);
        }

        public EPackage lookupPackage(List<String> names) {
            return (EPackage)this.delegate.lookupPackage(names);
        }

        public EStructuralFeature lookupProperty(EClassifier owner, String name) {
            return (EStructuralFeature)this.delegate.lookupProperty((Object)owner, name);
        }

        public EReference lookupOppositeProperty(EClassifier owner, String name) throws LookupException {
            return this.delegate.lookupOppositeProperty(owner, name);
        }

        public EClassifier getOppositePropertyType(EClassifier owner, EReference property) {
            return this.delegate.getOppositePropertyType(owner, property);
        }

        public EClassifier lookupSignal(EClassifier owner, String name, List<? extends TypedElement<EClassifier>> args) {
            return (EClassifier)this.delegate.lookupSignal((Object)owner, name, args);
        }

        public EObject lookupState(EClassifier owner, List<String> path) throws LookupException, SemanticException {
            return (EObject)this.delegate.lookupState((Object)owner, path);
        }

        public void setBodyCondition(EOperation operation, Constraint constraint) {
            this.delegate.setBodyCondition((Object)operation, (Object)constraint);
        }

        public void setDeriveConstraint(EStructuralFeature property, Constraint constraint) {
            this.delegate.setDeriveConstraint((Object)property, (Object)constraint);
        }

        public void setInitConstraint(EStructuralFeature property, Constraint constraint) {
            this.delegate.setInitConstraint((Object)property, (Object)constraint);
        }

        public void setParent(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> env) {
            this.delegate.setParent(env);
        }

        public void setSelfVariable(Variable<EClassifier, EParameter> var) {
            this.delegate.setSelfVariable(var);
        }

        public void undefine(Object feature) {
            this.delegate.undefine(feature);
        }

        public Map<String, EReference> getHiddenOppositeProperties(EClassifier classifier) {
            return this.delegate.getHiddenOppositeProperties(classifier);
        }

        public Variable<EClassifier, EParameter> lookupImplicitSourceForOppositeProperty(String name) {
            return this.delegate.lookupImplicitSourceForOppositeProperty(name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WrapperEnvironmentFactory
    implements EnvironmentFactory<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> {
        private final EnvironmentFactory<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> delegate;

        WrapperEnvironmentFactory(EnvironmentFactory<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> delegate) {
            this.delegate = delegate;
        }

        WrapperEnvironmentFactory() {
            this((EnvironmentFactory<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject>)new EcoreEnvironmentFactory());
        }

        private Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> getWrappedEnvironment(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> env) {
            if (env instanceof WrapperEnvironment) {
                return ((WrapperEnvironment)env).delegate;
            }
            return env;
        }

        public Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> createAttributeContext(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> parent, EStructuralFeature property) {
            return new WrapperEnvironment(this, (Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject>)this.delegate.createAttributeContext(this.getWrappedEnvironment(parent), (Object)property), parent);
        }

        public Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> createClassifierContext(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> parent, EClassifier context) {
            return new WrapperEnvironment(this, (Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject>)this.delegate.createClassifierContext(this.getWrappedEnvironment(parent), (Object)context), parent);
        }

        public Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> createEnvironment() {
            return new WrapperEnvironment(this, (Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject>)this.delegate.createEnvironment());
        }

        public Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> createEnvironment(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> parent) {
            return new WrapperEnvironment(this, (Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject>)this.delegate.createEnvironment(this.getWrappedEnvironment(parent)), parent);
        }

        public EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject> createEvaluationEnvironment() {
            return this.delegate.createEvaluationEnvironment();
        }

        public EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject> createEvaluationEnvironment(EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject> parent) {
            return this.delegate.createEvaluationEnvironment(parent);
        }

        public EvaluationVisitor<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> createEvaluationVisitor(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> env, EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject> evalEnv, Map<? extends EClass, ? extends Set<? extends EObject>> extentMap) {
            return this.delegate.createEvaluationVisitor(env, evalEnv, extentMap);
        }

        public Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> createInstanceContext(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> parent, Object context) {
            return new WrapperEnvironment(this, (Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject>)this.delegate.createInstanceContext(this.getWrappedEnvironment(parent), context), parent);
        }

        public Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> createOperationContext(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> parent, EOperation operation) {
            return new WrapperEnvironment(this, (Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject>)this.delegate.createOperationContext(this.getWrappedEnvironment(parent), (Object)operation), parent);
        }

        public Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> createPackageContext(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> parent, List<String> pathname) {
            return new WrapperEnvironment(this, (Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject>)this.delegate.createPackageContext(this.getWrappedEnvironment(parent), pathname), parent);
        }

        public Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> loadEnvironment(Resource resource) {
            return new WrapperEnvironment(this, (Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject>)this.delegate.loadEnvironment(resource));
        }

        public Visitor<Boolean, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint> createValidationVisitor(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> env) {
            return this.delegate.createValidationVisitor(env);
        }

        public OCLAnalyzer<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> createOCLAnalyzer(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> env, String input) {
            return this.delegate.createOCLAnalyzer(env, input);
        }

        public OCLAnalyzer<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> createOCLAnalyzer(AbstractOCLParser parser) {
            return this.delegate.createOCLAnalyzer(parser);
        }

        public OCLFactoryWithHistory createOCLFactoryWithHistory(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> env) {
            return this.delegate.createOCLFactoryWithHistory(env);
        }

        public OCLSyntaxHelper createOCLSyntaxHelper(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> env) {
            return this.delegate.createOCLSyntaxHelper(env);
        }
    }
}

