/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.evaluator;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.vm.IVMDebuggerShell;
import org.eclipse.ocl.examples.debug.vm.UnitLocation;
import org.eclipse.ocl.examples.debug.vm.VMBreakpoint;
import org.eclipse.ocl.examples.debug.vm.VMBreakpointManager;
import org.eclipse.ocl.examples.debug.vm.VMVirtualMachine;
import org.eclipse.ocl.examples.debug.vm.data.VMStackFrameData;
import org.eclipse.ocl.examples.debug.vm.data.VMSuspension;
import org.eclipse.ocl.examples.debug.vm.evaluator.IStepper;
import org.eclipse.ocl.examples.debug.vm.evaluator.IStepperVisitor;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMContext;
import org.eclipse.ocl.examples.debug.vm.evaluator.IterateBreakpointHelper;
import org.eclipse.ocl.examples.debug.vm.evaluator.VMEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.vm.evaluator.VMEvaluationStepper;
import org.eclipse.ocl.examples.debug.vm.evaluator.VMExecutor;
import org.eclipse.ocl.examples.debug.vm.event.VMResumeEvent;
import org.eclipse.ocl.examples.debug.vm.event.VMStartEvent;
import org.eclipse.ocl.examples.debug.vm.event.VMSuspendEvent;
import org.eclipse.ocl.examples.debug.vm.request.VMRequest;
import org.eclipse.ocl.examples.debug.vm.request.VMResumeRequest;
import org.eclipse.ocl.examples.debug.vm.request.VMSuspendRequest;
import org.eclipse.ocl.examples.debug.vm.request.VMTerminateRequest;
import org.eclipse.ocl.examples.debug.vm.utils.ASTBindingHelper;
import org.eclipse.ocl.examples.debug.vm.utils.CompiledUnit;
import org.eclipse.ocl.examples.debug.vm.utils.DebugOptions;
import org.eclipse.ocl.examples.debug.vm.utils.VMInterruptedExecutionException;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.LoopExp;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public abstract class AbstractVMEvaluationStepper
implements VMEvaluationStepper {
    protected final @NonNull EvaluationVisitor evaluationVisitor;
    protected final @NonNull VMExecutor vmExecutor;
    protected final @NonNull IStepperVisitor stepperVisitor;
    protected final @NonNull IVMDebuggerShell fDebugShell;
    protected final @NonNull VMBreakpointManager fBPM;
    protected final @NonNull IterateBreakpointHelper fIterateBPHelper;
    private @NonNull UnitLocation fCurrentLocation;
    protected @NonNull VMSuspension fCurrentStepMode;
    private final @NonNull Variable invalidVariable;

    protected AbstractVMEvaluationStepper(@NonNull EvaluationVisitor evaluationVisitor, @NonNull IVMContext vmContext, @NonNull IStepperVisitor stepperVisitor) {
        this.evaluationVisitor = evaluationVisitor;
        this.vmExecutor = (VMExecutor)((EvaluationVisitor.EvaluationVisitorExtension)evaluationVisitor).getExecutor();
        this.stepperVisitor = stepperVisitor;
        this.fDebugShell = vmContext.getShell();
        this.fBPM = this.fDebugShell.getBreakPointManager();
        this.fIterateBPHelper = new IterateBreakpointHelper(this.fBPM);
        this.fCurrentLocation = this.getCurrentLocation();
        this.fCurrentStepMode = VMSuspension.UNSPECIFIED;
        this.invalidVariable = (Variable)ClassUtil.nonNullEMF((Object)PivotFactory.eINSTANCE.createVariable());
        this.invalidVariable.setName("$invalid");
        String typeName = (String)ClassUtil.nonNullEMF((Object)PivotPackage.Literals.OCL_EXPRESSION.getName());
        this.invalidVariable.setType((Type)((EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)this.vmExecutor.getEnvironmentFactory()).getASClass(typeName));
    }

    protected abstract @NonNull VMStackFrameData @NonNull [] createStackFrame();

    protected @NonNull VMSuspendEvent createVMSuspendEvent(@NonNull VMSuspension suspension) {
        @NonNull VMStackFrameData @NonNull [] vmStack = this.createStackFrame();
        assert (vmStack.length > 0);
        return new VMSuspendEvent(vmStack, suspension);
    }

    protected void doProcessRequest(@NonNull UnitLocation location, @NonNull VMRequest request) {
        if (VMVirtualMachine.VM_REQUEST.isActive()) {
            VMVirtualMachine.VM_REQUEST.println(">[" + Thread.currentThread().getName() + "] " + location.toString() + " " + request);
        }
        if (request instanceof VMResumeRequest) {
            VMResumeRequest resumeRequest = (VMResumeRequest)request;
            this.fCurrentStepMode = resumeRequest.suspension;
            if (this.fCurrentStepMode == VMSuspension.UNSPECIFIED) {
                this.fIterateBPHelper.removeAllIterateBreakpoints();
            }
        } else if (request instanceof VMSuspendRequest) {
            VMSuspendRequest suspendRequest = (VMSuspendRequest)request;
            this.suspendAndWaitForResume(location, suspendRequest.suspension);
        } else if (request instanceof VMTerminateRequest) {
            this.terminate();
        } else {
            throw new IllegalArgumentException("Unsupported debug request: " + request);
        }
    }

    @Override
    public @NonNull UnitLocation getCurrentLocation() {
        VMEvaluationEnvironment evaluationEnvironment = this.getVMEvaluationEnvironment();
        return evaluationEnvironment.getCurrentLocation();
    }

    @Override
    public @NonNull EvaluationVisitor getEvaluationVisitor() {
        return this.evaluationVisitor;
    }

    @Override
    public @NonNull List<UnitLocation> getLocationStack() {
        VMEvaluationEnvironment leafEvaluationEnvironment;
        ArrayList<UnitLocation> fLocationStack = new ArrayList<UnitLocation>();
        VMEvaluationEnvironment evaluationEnvironment = leafEvaluationEnvironment = this.getVMEvaluationEnvironment();
        while (evaluationEnvironment != null) {
            Element element = evaluationEnvironment.getCurrentIP();
            IStepper stepper = this.stepperVisitor.getStepper(element);
            UnitLocation unitLocation = stepper.createUnitLocation(evaluationEnvironment, element);
            fLocationStack.add(unitLocation);
            evaluationEnvironment = evaluationEnvironment.getVMParentEvaluationEnvironment();
        }
        return fLocationStack;
    }

    protected @NonNull String getMainModuleName() {
        CompiledUnit mainUnit = this.fBPM.getUnitManager().getMainUnit();
        List<NamedElement> modules = mainUnit.getModules();
        if (modules.isEmpty()) {
            return "<null>";
        }
        String name = modules.get(0).getName();
        if (name == null) {
            return "<null>";
        }
        return (String)ClassUtil.nonNullState((Object)name);
    }

    @Override
    public @NonNull IStepperVisitor getStepperVisitor() {
        return this.stepperVisitor;
    }

    @Override
    public @NonNull VMEvaluationEnvironment getVMEvaluationEnvironment() {
        return (VMEvaluationEnvironment)this.vmExecutor.getEvaluationEnvironment();
    }

    @Override
    public @NonNull VMExecutor getVMExecutor() {
        return this.vmExecutor;
    }

    protected void handleLocationChanged(@NonNull Element element, @NonNull UnitLocation location, boolean isElementEnd) {
        if (VMVirtualMachine.LOCATION.isActive()) {
            VMVirtualMachine.LOCATION.println("[" + Thread.currentThread().getName() + "] " + element.eClass().getName() + ": " + element.toString() + " @ " + location + " " + (isElementEnd ? "start" : "end"));
        }
        boolean doSuspendAndResume = false;
        if (this.fCurrentStepMode == VMSuspension.STEP_INTO) {
            doSuspendAndResume = true;
        } else if (this.fCurrentStepMode == VMSuspension.STEP_OVER) {
            if (this.isSmallerStackDepth(location) || this.isNewLine(location)) {
                doSuspendAndResume = true;
            }
        } else if (this.fCurrentStepMode == VMSuspension.STEP_RETURN && this.isSmallerStackDepth(location)) {
            doSuspendAndResume = true;
        }
        if (doSuspendAndResume) {
            this.suspendAndWaitForResume(location, this.fCurrentStepMode);
            return;
        }
        for (VMBreakpoint breakpoint : this.fBPM.getBreakpoints(element)) {
            if (breakpoint.getLineNumber() != location.getLineNum()) continue;
            Boolean isTriggered = null;
            try {
                isTriggered = breakpoint.hitAndCheckIfTriggered(this);
            }
            catch (CoreException e) {
                IStatus status = e.getStatus();
                String reason = null;
                if (status.getCode() == 100) {
                    reason = "Breakpoint condition compilation failed";
                } else if (status.getCode() == 110) {
                    reason = "Breakpoint condition evaluation failed";
                }
                if (reason != null) {
                    VMSuspendEvent suspendOnBpConditionErrr = this.createVMSuspendEvent(VMSuspension.BREAKPOINT_CONDITION_ERR);
                    suspendOnBpConditionErrr.setBreakpointID(breakpoint.getID());
                    suspendOnBpConditionErrr.setReason(reason, status.getMessage());
                    this.suspendAndWaitForResume(location, suspendOnBpConditionErrr);
                    continue;
                }
                this.log(e.getStatus());
                continue;
            }
            if (!Boolean.TRUE.equals(isTriggered)) continue;
            boolean isIterateBp = this.fIterateBPHelper.isIterateBreakpoint(breakpoint);
            VMSuspension vmSuspension = isIterateBp ? this.fCurrentStepMode : VMSuspension.BREAKPOINT;
            this.suspendAndWaitForResume(location, vmSuspension);
            if (!isIterateBp) continue;
            this.fBPM.removeBreakpoint(breakpoint);
        }
    }

    protected boolean isLargerStackDepth(@NonNull UnitLocation location) {
        return location.getStackDepth() > this.fCurrentLocation.getStackDepth();
    }

    protected boolean isNewLine(@NonNull UnitLocation location) {
        return !location.isTheSameLine(this.fCurrentLocation);
    }

    protected boolean isNewLocation(@NonNull UnitLocation location) {
        return !location.isTheSameLocation(this.fCurrentLocation);
    }

    protected boolean isSmallerStackDepth(@NonNull UnitLocation location) {
        return location.getStackDepth() < this.fCurrentLocation.getStackDepth();
    }

    protected abstract void log(IStatus var1);

    private @NonNull UnitLocation newLocalLocation(@NonNull VMEvaluationEnvironment evalEnv, @NonNull Element node, int startPosition, int endPosition) {
        return new UnitLocation(startPosition, endPosition, evalEnv, node);
    }

    @Override
    public void postIterate(@NonNull LoopExp loopExp) {
    }

    @Override
    public void preIterate(@NonNull LoopExp loopExp) {
        boolean skipIterate;
        UnitLocation topLocation = this.getCurrentLocation();
        boolean bl = skipIterate = this.fCurrentStepMode == VMSuspension.UNSPECIFIED || this.fCurrentStepMode == VMSuspension.STEP_OVER && this.isLargerStackDepth(topLocation);
        if (!skipIterate) {
            this.fIterateBPHelper.stepIterateElement(loopExp, topLocation);
        }
    }

    protected void processDebugRequest(@NonNull UnitLocation location) {
        VMRequest event = this.fDebugShell.popRequest();
        if (event == null) {
            return;
        }
        this.doProcessRequest(location, event);
    }

    protected void processDeferredTasks() {
    }

    protected Element setCurrentEnvInstructionPointer(Element element) {
        VMEvaluationEnvironment evalEnv = this.getVMEvaluationEnvironment();
        if (element != null) {
            return evalEnv.setCurrentIP(element);
        }
        return evalEnv.getCurrentIP();
    }

    private void setCurrentLocation(@NonNull Element element, UnitLocation newLocation, boolean atEnd) {
        if (newLocation.getStartPosition() < 0) {
            return;
        }
        this.handleLocationChanged(element, newLocation, atEnd);
    }

    @Override
    public void start(boolean suspendOnStartup) {
        this.fDebugShell.sessionStarted(this);
        VMRequest request = null;
        try {
            this.trace(DebugOptions.EVALUATOR, "Debug evaluator going to initial SUSPEND state");
            request = this.fDebugShell.waitAndPopRequest(new VMStartEvent(this.getMainModuleName(), suspendOnStartup));
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            this.terminate();
        }
        if (request instanceof VMResumeRequest) {
            this.fCurrentStepMode = ((VMResumeRequest)request).suspension;
        } else {
            this.terminate();
        }
    }

    protected void superProcessDeferredTasks() {
        VMEvaluationEnvironment evalEnv = this.getVMEvaluationEnvironment();
        evalEnv.processDeferredTasks();
    }

    protected void suspendAndWaitForResume(@NonNull UnitLocation location, @NonNull VMSuspension vmSuspension) {
        this.suspendAndWaitForResume(location, this.createVMSuspendEvent(vmSuspension));
    }

    protected void suspendAndWaitForResume(@NonNull UnitLocation location, @NonNull VMSuspendEvent suspendEvent) {
        this.fCurrentLocation = location;
        try {
            VMSuspendEvent vmSuspend = suspendEvent;
            VMRequest nextRequest = this.fDebugShell.waitAndPopRequest(vmSuspend);
            assert (nextRequest != null);
            if (nextRequest instanceof VMResumeRequest) {
                this.fDebugShell.handleVMEvent(new VMResumeEvent());
            }
            this.doProcessRequest(location, nextRequest);
        }
        catch (InterruptedException e) {
            this.terminate();
        }
    }

    protected void terminate() throws VMInterruptedExecutionException {
        VMEvaluationEnvironment evalEnv = this.getVMEvaluationEnvironment();
        evalEnv.throwVMException(new VMInterruptedExecutionException("User termination request"));
    }

    protected abstract void trace(String var1, String var2);

    @Override
    public @Nullable Object visiting(@NonNull Element element) {
        if (VMVirtualMachine.PRE_VISIT.isActive()) {
            VMVirtualMachine.PRE_VISIT.println("[" + Thread.currentThread().getName() + "] " + element.eClass().getName() + ": " + element.toString());
        }
        Element previousIP = this.setCurrentEnvInstructionPointer(null);
        VMEvaluationEnvironment evalEnv = this.getVMEvaluationEnvironment();
        Stack<VMEvaluationEnvironment.StepperEntry> stepperStack = evalEnv.getStepperStack();
        IStepper stepper = this.stepperVisitor.getStepper(element);
        stepperStack.push(new VMEvaluationEnvironment.StepperEntry(stepper, element));
        if (stepper.isPreStoppable(this, element)) {
            Element stepElement = element;
            Element firstElement = stepper.getFirstElement(this, element);
            if (firstElement != null) {
                stepElement = firstElement;
            }
            evalEnv.setCurrentIP(stepElement);
            evalEnv.replace((TypedElement)evalEnv.getPCVariable(), stepElement);
            evalEnv.remove((TypedElement)this.invalidVariable);
            UnitLocation unitLocation = stepper.createUnitLocation(evalEnv, stepElement);
            this.setCurrentLocation(stepElement, unitLocation, false);
            this.processDebugRequest(unitLocation);
        }
        try {
            Object result = element.accept((Visitor)this.evaluationVisitor);
            if (VMVirtualMachine.POST_VISIT.isActive()) {
                VMVirtualMachine.POST_VISIT.println("[" + Thread.currentThread().getName() + "] " + element.eClass().getName() + ": " + element.toString() + " => " + result);
            }
            if (!(stepperStack = (evalEnv = this.getVMEvaluationEnvironment()).getStepperStack()).isEmpty()) {
                Element postElement;
                IStepper parentStepper = null;
                EObject eContainer = element.eContainer();
                Element parentElement = eContainer instanceof Element ? (Element)eContainer : null;
                VMEvaluationEnvironment.StepperEntry childStepperEntry = stepperStack.pop();
                childStepperEntry.popFrom(evalEnv);
                if (!stepperStack.isEmpty()) {
                    VMEvaluationEnvironment.StepperEntry parentStepperEntry = stepperStack.peek();
                    if (element instanceof OCLExpression) {
                        parentStepperEntry.pushTo(evalEnv, (TypedElement)element, result);
                    }
                    parentStepper = parentStepperEntry.stepper;
                } else if (evalEnv != this.getVMEvaluationEnvironment() && parentElement != null) {
                    parentStepper = this.stepperVisitor.getStepper(parentElement);
                }
                if (parentStepper != null && (postElement = parentStepper.isPostStoppable(this, element, result)) != null) {
                    evalEnv.setCurrentIP(postElement);
                    evalEnv.replace((TypedElement)evalEnv.getPCVariable(), postElement);
                    evalEnv.remove((TypedElement)this.invalidVariable);
                    UnitLocation unitLocation = parentStepper.createUnitLocation(evalEnv, postElement);
                    this.setCurrentLocation(postElement, unitLocation, false);
                    this.processDebugRequest(unitLocation);
                }
            }
            return result;
        }
        catch (Throwable e) {
            if (e instanceof VMInterruptedExecutionException) {
                throw (VMInterruptedExecutionException)((Object)e);
            }
            evalEnv = this.getVMEvaluationEnvironment();
            stepperStack = evalEnv.getStepperStack();
            if (!stepperStack.isEmpty()) {
                stepperStack.pop();
            }
            evalEnv.add((TypedElement)this.invalidVariable, e);
            int endPosition = ASTBindingHelper.getEndPosition(element);
            UnitLocation endLocation = this.newLocalLocation(evalEnv, element, endPosition, endPosition);
            this.setCurrentLocation(element, endLocation, true);
            this.suspendAndWaitForResume(endLocation, VMSuspension.BREAKPOINT);
            if (VMVirtualMachine.POST_VISIT.isActive()) {
                VMVirtualMachine.POST_VISIT.println("[" + Thread.currentThread().getName() + "] " + element.eClass().getName() + ": " + element.toString());
            }
            if (e instanceof Exception) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }
}

