/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.tests;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.ocl.ecore.OperationCallExp;
import org.eclipse.ocl.ecore.tests.AbstractTestSuite;
import org.eclipse.ocl.expressions.ExpressionsFactory;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.Variable;

public class TypeConformanceTests
extends AbstractTestSuite {
    EDataType dt;
    EClass cl;
    EOperation op3;
    EPackage p;

    protected void setUp() {
        super.setUp();
        EcoreFactory f = EcoreFactory.eINSTANCE;
        this.p = f.createEPackage();
        this.dt = f.createEDataType();
        this.dt.setName("OwnInteger");
        this.dt.setInstanceClassName("java.lang.Integer");
        this.p.getEClassifiers().add((Object)this.dt);
        EEnum e = f.createEEnum();
        e.setName("TestEnum");
        EEnumLiteral lit1 = f.createEEnumLiteral();
        lit1.setName("EnumLiteral");
        e.getELiterals().add((Object)lit1);
        this.p.getEClassifiers().add((Object)e);
        this.cl = f.createEClass();
        this.cl.setName("ClassName");
        this.p.getEClassifiers().add((Object)this.cl);
        EOperation op1 = f.createEOperation();
        this.cl.getEOperations().add((Object)op1);
        op1.setName("fooOwnInteger");
        EParameter param = f.createEParameter();
        param.setName("p");
        param.setEType((EClassifier)this.dt);
        op1.getEParameters().add((Object)param);
        EOperation op2 = f.createEOperation();
        this.cl.getEOperations().add((Object)op2);
        op2.setName("fooInteger");
        param = f.createEParameter();
        param.setName("p");
        param.setEType((EClassifier)this.ocl.getEnvironment().getOCLStandardLibrary().getInteger());
        op2.getEParameters().add((Object)param);
        this.op3 = f.createEOperation();
        this.cl.getEOperations().add((Object)this.op3);
        this.op3.setName("enumMethod");
        param = f.createEParameter();
        param.setName("p");
        param.setEType((EClassifier)e);
        this.op3.getEParameters().add((Object)param);
        this.helper.setContext((Object)this.cl);
    }

    public void testLetVariableTypeConformance() throws Exception {
        OCLExpression expr = this.helper.createQuery("let i:OwnInteger=5 in i");
        Object result = this.ocl.evaluate(null, expr);
        TypeConformanceTests.assertEquals((Object)5, (Object)result);
    }

    public void testIterateVariableTypeConformance() throws Exception {
        OCLExpression expr = this.helper.createQuery("Set{1,2}->iterate(i:Integer; acc:OwnInteger=5 | acc)");
        Object result = this.ocl.evaluate(null, expr);
        TypeConformanceTests.assertEquals((Object)5, (Object)result);
    }

    public void testOperationMatchOwnerTypeConformance() throws Exception {
        this.defineVariable("i", (EClassifier)this.dt, 1);
        this.helper.createQuery("i+2");
        this.helper.createQuery("2+2");
    }

    public void testOperationMatchParameterTypeConformance1() throws Exception {
        this.defineVariable("i", (EClassifier)this.dt, 1);
        this.helper.createQuery("2+2");
        this.helper.createQuery("2+i");
    }

    public void testOperationMatchParameterTypeConformance2() throws Exception {
        this.defineVariable("i", (EClassifier)this.dt, 1);
        this.helper.setContext((Object)this.cl);
        this.helper.createQuery("self.fooOwnInteger(2)");
        this.helper.createQuery("self.fooInteger(i)");
    }

    public void testEnumMethod() throws Exception {
        this.helper.setContext((Object)this.cl);
        OCLExpression query = this.helper.createQuery("self.enumMethod(TestEnum::EnumLiteral)");
        TypeConformanceTests.assertSame((Object)this.op3, (Object)((OperationCallExp)query).getReferredOperation());
        EObject eo = this.p.getEFactoryInstance().create(this.cl);
        this.helper.getOCL().evaluate((Object)eo, query);
    }

    public void testEcoreAccess_358712() throws Exception {
        this.helper.setContext((Object)this.cl);
        this.helper.createQuery("let a : ecore::EByte = 1 in a + 1");
    }

    private void defineVariable(String name, EClassifier type, Object value) {
        Variable contextVar = ExpressionsFactory.eINSTANCE.createVariable();
        contextVar.setName(name);
        contextVar.setType((Object)type);
        this.ocl.getEnvironment().addElement(name, contextVar, true);
        this.ocl.getEvaluationEnvironment().add(name, value);
    }
}

