/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.essentialocl.attributes;

import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.IterateExp;
import org.eclipse.ocl.pivot.LoopExp;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.scoping.AbstractAttribution;
import org.eclipse.ocl.pivot.internal.scoping.EnvironmentView;
import org.eclipse.ocl.pivot.internal.scoping.ScopeView;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.Pivotable;
import org.eclipse.ocl.xtext.essentialocl.attributes.NavigationUtil;
import org.eclipse.ocl.xtext.essentialoclcs.AbstractNameExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.ExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.InfixExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.NavigatingArgCS;
import org.eclipse.ocl.xtext.essentialoclcs.NavigationRole;
import org.eclipse.ocl.xtext.essentialoclcs.RoundBracketedClauseCS;

public class NavigatingArgCSAttribution
extends AbstractAttribution {
    public static final @NonNull NavigatingArgCSAttribution INSTANCE = new NavigatingArgCSAttribution();

    public ScopeView computeLookup(@NonNull EObject target, @NonNull EnvironmentView environmentView, @NonNull ScopeView scopeView) {
        ExpCS csSource;
        OCLExpression source;
        NavigatingArgCS fromArgument = (NavigatingArgCS)target;
        NavigationRole role = fromArgument.getRole();
        RoundBracketedClauseCS csRoundBracketedClause = fromArgument.getOwningRoundBracketedClause();
        AbstractNameExpCS targetElement = csRoundBracketedClause.getOwningNameExp();
        assert (targetElement != null);
        InfixExpCS csNavigationOperator = NavigationUtil.getNavigationInfixExp(targetElement);
        OCLExpression pivot = (OCLExpression)PivotUtil.getPivot(OCLExpression.class, (Pivotable)targetElement);
        if (pivot instanceof LoopExp) {
            Variable result;
            if (role == NavigationRole.EXPRESSION) {
                for (Variable iterator : ((LoopExp)pivot).getOwnedIterators()) {
                    if (iterator.isIsImplicit()) {
                        environmentView.addElementsOfScope((Element)iterator.getType(), scopeView);
                    } else {
                        environmentView.addNamedElement((NamedElement)iterator);
                    }
                    if (!environmentView.hasFinalResult()) continue;
                    return null;
                }
                for (Variable iterator : ((LoopExp)pivot).getOwnedCoIterators()) {
                    if (iterator.isIsImplicit()) {
                        environmentView.addElementsOfScope((Element)iterator.getType(), scopeView);
                    } else {
                        environmentView.addNamedElement((NamedElement)iterator);
                    }
                    if (!environmentView.hasFinalResult()) continue;
                    return null;
                }
                if (pivot instanceof IterateExp) {
                    Variable result2 = ((IterateExp)pivot).getOwnedResult();
                    if (result2.isIsImplicit()) {
                        environmentView.addElementsOfScope((Element)result2.getType(), scopeView);
                    } else {
                        environmentView.addNamedElement((NamedElement)result2);
                    }
                    if (environmentView.hasFinalResult()) {
                        return null;
                    }
                }
            } else if (role == NavigationRole.ITERATOR) {
                List iterators = ((LoopExp)pivot).getOwnedIterators();
                assert (iterators != null);
                environmentView.addNamedElements((Iterable)iterators);
            } else if (role == NavigationRole.ACCUMULATOR && (result = ((IterateExp)pivot).getOwnedResult()) != null) {
                environmentView.addNamedElement((NamedElement)result);
            }
        } else if (pivot == null && role == NavigationRole.EXPRESSION && csNavigationOperator != null && PivotUtil.isAggregateNavigationOperator((String)csNavigationOperator.getName()) && (source = (OCLExpression)PivotUtil.getPivot(OCLExpression.class, (Pivotable)(csSource = csNavigationOperator.getSource()))) != null) {
            Type elementType;
            CollectionType collectionType;
            Type type = source.getType();
            PivotMetamodelManager metamodelManager = environmentView.getEnvironmentFactory().getMetamodelManager();
            if (type instanceof CollectionType) {
                collectionType = (CollectionType)type;
                elementType = collectionType.getElementType();
                ExpCS csArgument = csNavigationOperator.getArgument();
                assert (csArgument == targetElement);
            } else {
                elementType = type;
                collectionType = metamodelManager.getStandardLibrary().getSetType();
            }
            if (NavigationUtil.isIteration(metamodelManager, csRoundBracketedClause, collectionType)) {
                if (environmentView.accepts(PivotPackage.Literals.TYPE)) {
                    EClassifier requiredType = environmentView.getRequiredType();
                    try {
                        environmentView.setRequiredType((EClassifier)PivotPackage.Literals.TYPE);
                        environmentView.computeLookups(scopeView.getParent().getParent().getParent());
                    }
                    finally {
                        environmentView.setRequiredType(requiredType);
                    }
                }
                environmentView.addElementsOfScope((Element)elementType, scopeView);
                if (environmentView.hasFinalResult()) {
                    return null;
                }
            }
        }
        if (csNavigationOperator != null) {
            return scopeView.getParent().getParent().getParent().getParent();
        }
        return scopeView.getParent().getParent().getParent();
    }
}

