/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.tests;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.examples.pivot.tests.PivotTestCase;
import org.eclipse.ocl.examples.pivot.tests.PivotTestCaseWithAutoTearDown;
import org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain;
import org.eclipse.ocl.pivot.uml.UMLStandaloneSetup;
import org.eclipse.ocl.pivot.uml.internal.es2as.UML2AS;
import org.eclipse.ocl.pivot.utilities.AbstractEnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.ThreadLocalExecutor;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class LeakTests
extends PivotTestCaseWithAutoTearDown {
    @Override
    protected void setUp() throws Exception {
        UMLStandaloneSetup.init();
        super.setUp();
    }

    public void testValidateProfileLeak() throws Throwable {
        LeakTestRunnable leakTestRunnable = new LeakTestRunnable(){

            @Override
            public void runWithThrowable() throws Exception {
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                LeakTests.getProjectMap().initializeResourceSet((ResourceSet)resourceSet);
                UML2AS.initializeUML((ResourceSet)resourceSet);
                URI testModelURI = LeakTests.getTestModelURI("models/uml/Bug459276.uml");
                EClass package1 = UMLPackage.Literals.PACKAGE;
                Package umlModel = (Package)UML2Util.load((ResourceSet)resourceSet, (URI)testModelURI, (EClass)package1);
                EcoreUtil.resolveAll((ResourceSet)resourceSet);
                Profile umlProfile = umlModel.getAppliedProfile("j2ee");
                LeakTests.assertNotNull((String)"No UML Profile for leak test", (Object)umlProfile);
                MyDiagnostician diagnostician = new MyDiagnostician();
                diagnostician.validate((EObject)umlModel);
                AbstractEnvironmentFactory environmentFactory = (AbstractEnvironmentFactory)ThreadLocalExecutor.basicGetEnvironmentFactory();
                if (!$assertionsDisabled && environmentFactory == null) {
                    throw new AssertionError();
                }
                org.eclipse.ocl.pivot.Profile asProfile = (org.eclipse.ocl.pivot.Profile)environmentFactory.getASOf(org.eclipse.ocl.pivot.Profile.class, (EObject)umlProfile);
                LeakTests.assertNotNull((String)"No AS Profile for leak", (Object)asProfile);
                this.umlProfileRef = new WeakReference<Profile>(umlProfile);
                this.asProfileRef = new WeakReference<org.eclipse.ocl.pivot.Profile>(asProfile);
                LeakTests.assertNotNull((String)"No UML Profile for leak test", this.umlProfileRef.get());
                LeakTests.assertNotNull((String)"No AS Profile for leak", this.asProfileRef.get());
                LeakTests.getProjectMap().unload((ResourceSet)resourceSet);
                LeakTests.disposeResourceSet((ResourceSet)resourceSet);
                ThreadLocalExecutor.detachEnvironmentFactory((EnvironmentFactory)environmentFactory);
            }
        };
        this.doTestRunnable(leakTestRunnable);
        int i = 0;
        while (i < 100) {
            if (leakTestRunnable.umlProfileRef.get() == null && leakTestRunnable.asProfileRef.get() == null) break;
            System.gc();
            Thread.sleep(10L);
            ++i;
        }
        LeakTests.assertNull((String)"UML Profile has leaked", leakTestRunnable.umlProfileRef.get());
        LeakTests.assertNull((String)"AS Profile has leaked", leakTestRunnable.asProfileRef.get());
    }

    public static abstract class LeakTestRunnable
    extends PivotTestCase.TestRunnable {
        WeakReference<Profile> umlProfileRef = null;
        WeakReference<org.eclipse.ocl.pivot.Profile> asProfileRef = null;
    }

    static class MyDiagnostician
    extends Diagnostician {
        private boolean validatingStereotype;

        MyDiagnostician() {
        }

        public Map<Object, Object> createDefaultContext() {
            Map context = super.createDefaultContext();
            if (context != null) {
                OCLDelegateDomain.initializePivotOnlyDiagnosticianContext((Map)context);
            }
            return context;
        }

        public BasicDiagnostic createDefaultDiagnostic(EObject eObject) {
            ResourceSet resourceSet = eObject.eResource().getResourceSet();
            if (resourceSet != null) {
                OCLDelegateDomain.initializePivotOnlyDiagnosticianResourceSet((ResourceSet)resourceSet);
            }
            return super.createDefaultDiagnostic(eObject);
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected boolean doValidateStereotypeApplications(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
            if (this.validatingStereotype) {
                return true;
            }
            EList stereotypeApplications = eObject instanceof Element ? ((Element)eObject).getStereotypeApplications() : Collections.emptyList();
            if (stereotypeApplications.isEmpty()) return true;
            Iterator i = stereotypeApplications.iterator();
            this.validatingStereotype = true;
            try {
                boolean result;
                block7: {
                    block6: {
                        result = this.validate((EObject)i.next(), diagnostics, context);
                        if (!true) break block6;
                        if (!i.hasNext()) return result;
                        if (!result && diagnostics == null) break block7;
                    }
                    do {
                        result &= this.validate((EObject)i.next(), diagnostics, context);
                        if (!i.hasNext()) return result;
                    } while (result || diagnostics != null);
                }
                return result;
            }
            finally {
                this.validatingStereotype = false;
            }
        }

        protected boolean doValidateContents(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
            boolean result = this.doValidateStereotypeApplications(eObject, diagnostics, context);
            if (result || diagnostics != null) {
                result &= super.doValidateContents(eObject, diagnostics, context);
            }
            return result;
        }

        public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
            if (!context.containsKey((Object)this)) {
                context.put((Object)this, null);
                BasicDiagnostic newDiagChain = this.createDefaultDiagnostic(eObject);
                boolean ok = super.validate(eObject, (DiagnosticChain)newDiagChain, context);
                for (Diagnostic d : newDiagChain.getChildren()) {
                    Element base;
                    Object target;
                    Object[] data = d.getData().toArray();
                    if (data.length > 0 && (target = data[0]) instanceof EObject && (base = UMLUtil.getBaseElement((EObject)((EObject)target))) != null) {
                        data[0] = base;
                    }
                    diagnostics.add((Diagnostic)new BasicDiagnostic(d.getSeverity(), d.getSource(), d.getCode(), d.getMessage(), data));
                }
                return ok;
            }
            return super.validate(eObject, diagnostics, context);
        }
    }
}

