/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.tests;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.ocl.ecore.OperationCallExp;
import org.eclipse.ocl.ecore.PropertyCallExp;
import org.eclipse.ocl.ecore.tests.AbstractTestSuite;
import org.eclipse.ocl.expressions.OCLExpression;

public class FeatureRedefinitionTest
extends AbstractTestSuite {
    EClass c3;
    EOperation op3;
    EAttribute attr3;
    EClass c2;
    EAttribute attr2;
    EOperation op2;
    EClass c1;
    EAttribute attr1;
    EOperation op1;

    public void testCallOverridingMethod() throws Exception {
        this.helper.setContext((Object)this.c3);
        OCLExpression expr = this.helper.createQuery("self.foo()");
        OperationCallExp callExpr = (OperationCallExp)expr;
        EOperation eop = (EOperation)callExpr.getReferredOperation();
        FeatureRedefinitionTest.assertSame((Object)this.op3, (Object)eop);
    }

    public void testCallOverriddenMethod1() throws Exception {
        this.helper.setContext((Object)this.c3);
        OCLExpression expr = this.helper.createQuery("self.oclAsType(C2).foo()");
        OperationCallExp callExpr = (OperationCallExp)expr;
        EOperation eop = (EOperation)callExpr.getReferredOperation();
        FeatureRedefinitionTest.assertSame((Object)this.op2, (Object)eop);
    }

    public void testCallOverriddenMethod2() throws Exception {
        this.helper.setContext((Object)this.c3);
        OCLExpression expr = this.helper.createQuery("self.oclAsType(C1).foo()");
        OperationCallExp callExpr = (OperationCallExp)expr;
        EOperation eop = (EOperation)callExpr.getReferredOperation();
        FeatureRedefinitionTest.assertSame((Object)this.op1, (Object)eop);
    }

    public void testAccessOverridingProperty() throws Exception {
        this.helper.setContext((Object)this.c3);
        OCLExpression expr = this.helper.createQuery("self.a");
        PropertyCallExp callExpr = (PropertyCallExp)expr;
        EStructuralFeature esf = (EStructuralFeature)callExpr.getReferredProperty();
        FeatureRedefinitionTest.assertSame((Object)this.attr3, (Object)esf);
    }

    public void testAccessOverriddenProperty1() throws Exception {
        this.helper.setContext((Object)this.c3);
        OCLExpression expr = this.helper.createQuery("self.oclAsType(C2).a");
        PropertyCallExp callExpr = (PropertyCallExp)expr;
        EStructuralFeature esf = (EStructuralFeature)callExpr.getReferredProperty();
        FeatureRedefinitionTest.assertSame((Object)this.attr2, (Object)esf);
    }

    public void testAccessOverriddenProperty2() throws Exception {
        this.helper.setContext((Object)this.c3);
        OCLExpression expr = this.helper.createQuery("self.oclAsType(C1).a");
        PropertyCallExp callExpr = (PropertyCallExp)expr;
        EStructuralFeature esf = (EStructuralFeature)callExpr.getReferredProperty();
        FeatureRedefinitionTest.assertSame((Object)this.attr1, (Object)esf);
    }

    protected void setUp() {
        super.setUp();
        EcoreFactory f = EcoreFactory.eINSTANCE;
        EPackage p = f.createEPackage();
        p.setName("TestPackage");
        this.c1 = f.createEClass();
        p.getEClassifiers().add((Object)this.c1);
        this.c1.setName("C1");
        this.attr1 = f.createEAttribute();
        this.attr1.setName("a");
        this.attr1.setEType((EClassifier)EcorePackage.Literals.EINT);
        this.c1.getEStructuralFeatures().add((Object)this.attr1);
        this.op1 = f.createEOperation();
        this.c1.getEOperations().add((Object)this.op1);
        this.op1.setName("foo");
        this.op1.setEType((EClassifier)EcorePackage.Literals.EINT);
        this.c2 = f.createEClass();
        p.getEClassifiers().add((Object)this.c2);
        this.c2.setName("C2");
        this.c2.getESuperTypes().add((Object)this.c1);
        this.attr2 = f.createEAttribute();
        this.attr2.setName("a");
        this.attr2.setEType((EClassifier)EcorePackage.Literals.EINT);
        this.c2.getEStructuralFeatures().add((Object)this.attr2);
        this.op2 = f.createEOperation();
        this.c2.getEOperations().add((Object)this.op2);
        this.op2.setName("foo");
        this.op2.setEType((EClassifier)EcorePackage.Literals.EINT);
        this.c3 = f.createEClass();
        p.getEClassifiers().add((Object)this.c3);
        this.c3.setName("C3");
        this.c3.getESuperTypes().add((Object)this.c2);
        this.attr3 = f.createEAttribute();
        this.attr3.setName("a");
        this.attr3.setEType((EClassifier)EcorePackage.Literals.EINT);
        this.c3.getEStructuralFeatures().add((Object)this.attr3);
        this.op3 = f.createEOperation();
        this.c3.getEOperations().add((Object)this.op3);
        this.op3.setName("foo");
        this.op3.setEType((EClassifier)EcorePackage.Literals.EINT);
    }
}

